/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IWritable;
import org.eclipse.pde.internal.ui.IPDEUIConstants;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.FormOutlinePage;
import org.eclipse.pde.internal.ui.editor.IModelUndoManager;
import org.eclipse.pde.internal.ui.editor.ModelDataTransfer;
import org.eclipse.pde.internal.ui.editor.PDEFormEditorContributor;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDEMultiPageContentOutline;
import org.eclipse.pde.internal.ui.editor.PDEMultiPagePropertySheet;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.SystemFileEditorInput;
import org.eclipse.pde.internal.ui.editor.context.IInputContextListener;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.pde.internal.ui.preferences.EditorPreferencePage;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public abstract class PDEFormEditor
extends FormEditor
implements IInputContextListener,
IGotoMarker {
    private Clipboard clipboard;
    private Menu contextMenu;
    protected InputContextManager inputContextManager;
    private IContentOutlinePage formOutline;
    private PDEMultiPagePropertySheet propertySheet;
    private PDEMultiPageContentOutline contentOutline;
    private String lastActivePageId;
    private boolean lastDirtyState;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$org$eclipse$ui$views$contentoutline$IContentOutlinePage;
    static /* synthetic */ Class class$org$eclipse$ui$views$properties$IPropertySheetPage;
    static /* synthetic */ Class class$org$eclipse$ui$ide$IGotoMarker;

    public PDEFormEditor() {
        PDEPlugin.getDefault().getLabelProvider().connect(this);
        this.inputContextManager = this.createInputContextManager();
    }

    protected IEditorSite createSite(IEditorPart editor) {
        return new PDEMultiPageEditorSite((MultiPageEditorPart)this, editor);
    }

    public IProject getCommonProject() {
        return this.inputContextManager.getCommonProject();
    }

    public IBaseModel getAggregateModel() {
        if (this.inputContextManager != null) {
            return this.inputContextManager.getAggregateModel();
        }
        return null;
    }

    protected abstract InputContextManager createInputContextManager();

    public boolean hasInputContext(String contextId) {
        return this.inputContextManager.hasContext(contextId);
    }

    public InputContextManager getContextManager() {
        return this.inputContextManager;
    }

    protected void createInputContexts(InputContextManager contextManager) {
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            this.createResourceContexts(contextManager, (IFileEditorInput)input);
        } else if (input instanceof SystemFileEditorInput) {
            this.createSystemFileContexts(contextManager, (SystemFileEditorInput)input);
        } else if (input instanceof IStorageEditorInput) {
            this.createStorageContexts(contextManager, (IStorageEditorInput)input);
        } else if (input instanceof ILocationProvider) {
            IPath path = ((ILocationProvider)input).getPath((Object)input);
            File file = path.toFile();
            SystemFileEditorInput sinput = new SystemFileEditorInput(file);
            this.createSystemFileContexts(contextManager, sinput);
        }
    }

    protected abstract void createResourceContexts(InputContextManager var1, IFileEditorInput var2);

    protected abstract void createSystemFileContexts(InputContextManager var1, SystemFileEditorInput var2);

    protected abstract void createStorageContexts(InputContextManager var1, IStorageEditorInput var2);

    protected FormToolkit createToolkit(Display display) {
        return new FormToolkit(PDEPlugin.getDefault().getFormColors(display));
    }

    protected void createPages() {
        this.clipboard = new Clipboard(this.getContainer().getDisplay());
        MenuManager manager = new MenuManager();
        IMenuListener listener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                PDEFormEditor.this.contextMenuAboutToShow(manager);
            }
        };
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(listener);
        this.contextMenu = manager.createContextMenu((Control)this.getContainer());
        this.getContainer().setMenu(this.contextMenu);
        this.createInputContexts(this.inputContextManager);
        super.createPages();
        this.inputContextManager.addInputContextListener(this);
        String pageToShow = this.computeInitialPageId();
        if (pageToShow != null) {
            this.setActivePage(pageToShow);
        }
        this.updateTitle();
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        IFormPage page = this.getActivePageInstance();
        this.updateContentOutline(page);
        this.updatePropertySheet(page);
        if (page != null) {
            this.lastActivePageId = page.getId();
        }
    }

    public Clipboard getClipboard() {
        return this.clipboard;
    }

    protected void contextMenuAboutToShow(IMenuManager manager) {
        PDEFormEditorContributor contributor = this.getContributor();
        IFormPage page = this.getActivePageInstance();
        if (page instanceof PDEFormPage) {
            ((PDEFormPage)page).contextMenuAboutToShow(manager);
        }
        if (contributor != null) {
            contributor.contextMenuAboutToShow(manager);
        }
    }

    public PDEFormEditorContributor getContributor() {
        return (PDEFormEditorContributor)this.getEditorSite().getActionBarContributor();
    }

    protected String computeInitialPageId() {
        String firstPageId = null;
        String storedFirstPageId = this.loadDefaultPage();
        if (storedFirstPageId != null) {
            firstPageId = storedFirstPageId;
        } else if (EditorPreferencePage.getUseSourcePage()) {
            firstPageId = this.getSourcePageId();
        }
        String invalidContextId = this.getFirstInvalidContextId();
        if (invalidContextId != null) {
            return invalidContextId;
        }
        return firstPageId;
    }

    private String getSourcePageId() {
        InputContext context = this.inputContextManager.getPrimaryContext();
        if (context != null) {
            return context.getId();
        }
        return null;
    }

    private String getFirstInvalidContextId() {
        InputContext[] invalidContexts = this.inputContextManager.getInvalidContexts();
        if (invalidContexts.length == 0) {
            return null;
        }
        for (int i = 0; i < invalidContexts.length; ++i) {
            if (!invalidContexts[i].isPrimary()) continue;
            return invalidContexts[i].getId();
        }
        return invalidContexts[0].getId();
    }

    public String getTitle() {
        if (this.inputContextManager == null) {
            return super.getTitle();
        }
        InputContext context = this.inputContextManager.getPrimaryContext();
        if (context == null) {
            return super.getTitle();
        }
        return context.getInput().getName();
    }

    public void updateTitle() {
        this.firePropertyChange(1);
    }

    public String getTitleProperty() {
        return "";
    }

    public void doSave(IProgressMonitor monitor) {
        this.commitFormPages(true);
        this.inputContextManager.save(monitor);
        this.editorDirtyStateChanged();
    }

    public void doRevert() {
        IFormPage currentPage = this.getActivePageInstance();
        if (currentPage != null && currentPage instanceof PDEFormPage) {
            ((PDEFormPage)currentPage).cancelEdit();
        }
        IFormPage[] pages = this.getPages();
        for (int i = 0; i < pages.length; ++i) {
            if (!(pages[i] instanceof PDESourcePage)) continue;
            PDESourcePage page = (PDESourcePage)pages[i];
            InputContext context = this.inputContextManager.findContext(page.getId());
            page.doRevertToSaved();
        }
        this.editorDirtyStateChanged();
    }

    public void doRevert(IEditorInput input) {
        InputContext context;
        IFormPage page;
        IFormPage currentPage = this.getActivePageInstance();
        if (currentPage != null && currentPage instanceof PDEFormPage) {
            ((PDEFormPage)currentPage).cancelEdit();
        }
        if ((page = this.findPage((context = this.inputContextManager.getContext(input)).getId())) != null && page instanceof PDESourcePage) {
            PDESourcePage spage = (PDESourcePage)page;
            spage.doRevertToSaved();
        }
        this.editorDirtyStateChanged();
    }

    private void commitFormPages(boolean onSave) {
        IFormPage[] pages = this.getPages();
        for (int i = 0; i < pages.length; ++i) {
            IFormPage page = pages[i];
            IManagedForm mform = page.getManagedForm();
            if (mform == null || !mform.isDirty()) continue;
            mform.commit(true);
        }
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    private void storeDefaultPage() {
        IEditorInput input = this.getEditorInput();
        String pageId = this.lastActivePageId;
        if (pageId == null) {
            return;
        }
        if (input instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)input).getFile();
            if (file != null) {
                try {
                    file.setPersistentProperty(IPDEUIConstants.DEFAULT_EDITOR_PAGE_KEY_NEW, pageId);
                }
                catch (CoreException e) {}
            }
        } else if (input instanceof SystemFileEditorInput) {
            File file = (File)((SystemFileEditorInput)input).getAdapter(class$java$io$File == null ? (class$java$io$File = PDEFormEditor.class$("java.io.File")) : class$java$io$File);
            if (file == null) {
                return;
            }
            IDialogSettings section = this.getSettingsSection();
            section.put(file.getPath(), pageId);
        }
    }

    private String loadDefaultPage() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)input).getFile();
            try {
                return file.getPersistentProperty(IPDEUIConstants.DEFAULT_EDITOR_PAGE_KEY_NEW);
            }
            catch (CoreException e) {
                return null;
            }
        }
        if (input instanceof SystemFileEditorInput) {
            File file = (File)((SystemFileEditorInput)input).getAdapter(class$java$io$File == null ? (class$java$io$File = PDEFormEditor.class$("java.io.File")) : class$java$io$File);
            if (file == null) {
                return null;
            }
            IDialogSettings section = this.getSettingsSection();
            String key = file.getPath();
            return section.get(key);
        }
        return null;
    }

    public void dispose() {
        this.storeDefaultPage();
        PDEPlugin.getDefault().getLabelProvider().disconnect(this);
        if (this.clipboard != null) {
            this.clipboard.dispose();
            this.clipboard = null;
        }
        super.dispose();
        this.inputContextManager.dispose();
        this.inputContextManager = null;
    }

    public boolean isDirty() {
        this.lastDirtyState = this.computeDirtyState();
        return this.lastDirtyState;
    }

    private boolean computeDirtyState() {
        IFormPage page = this.getActivePageInstance();
        if (page != null && page.isDirty() || this.inputContextManager != null && this.inputContextManager.isDirty()) {
            return true;
        }
        return super.isDirty();
    }

    public boolean getLastDirtyState() {
        return this.lastDirtyState;
    }

    public void fireSaveNeeded(String contextId, boolean notify) {
        if (contextId == null) {
            return;
        }
        InputContext context = this.inputContextManager.findContext(contextId);
        if (context != null) {
            this.fireSaveNeeded(context.getInput(), notify);
        }
    }

    public void fireSaveNeeded(IEditorInput input, boolean notify) {
        if (notify) {
            this.editorDirtyStateChanged();
        }
        if (this.isDirty()) {
            this.validateEdit(input);
        }
    }

    public void editorDirtyStateChanged() {
        super.editorDirtyStateChanged();
        PDEFormEditorContributor contributor = this.getContributor();
        if (contributor != null) {
            contributor.updateActions();
        }
    }

    private void validateEdit(IEditorInput input) {
        final InputContext context = this.inputContextManager.getContext(input);
        if (!context.validateEdit()) {
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    PDEFormEditor.this.doRevert(context.getInput());
                    context.setValidated(false);
                }
            });
        }
    }

    private IDialogSettings getSettingsSection() {
        IDialogSettings root = PDEPlugin.getDefault().getDialogSettings();
        IDialogSettings section = root.getSection("multi-page-editor");
        if (section == null) {
            section = root.addNewSection("multi-page-editor");
        }
        return section;
    }

    public void gotoMarker(IMarker marker) {
        IResource resource = marker.getResource();
        InputContext context = this.inputContextManager.findContext(resource);
        if (context == null) {
            return;
        }
        IFormPage page = this.setActivePage(context.getId());
        IDE.gotoMarker((IEditorPart)page, (IMarker)marker);
    }

    public void openTo(Object obj, IMarker marker) {
        PDESourcePage sourcePage = (PDESourcePage)this.setActivePage("plugin-context");
        if (sourcePage != null) {
            sourcePage.selectReveal(marker);
        }
    }

    public void setSelection(ISelection selection) {
        this.getSite().getSelectionProvider().setSelection(selection);
        this.getContributor().updateSelectableActions(selection);
    }

    public ISelection getSelection() {
        return this.getSite().getSelectionProvider().getSelection();
    }

    public Object getAdapter(Class key) {
        if (key.equals(class$org$eclipse$ui$views$contentoutline$IContentOutlinePage == null ? (class$org$eclipse$ui$views$contentoutline$IContentOutlinePage = PDEFormEditor.class$("org.eclipse.ui.views.contentoutline.IContentOutlinePage")) : class$org$eclipse$ui$views$contentoutline$IContentOutlinePage)) {
            return this.getContentOutline();
        }
        if (key.equals(class$org$eclipse$ui$views$properties$IPropertySheetPage == null ? (class$org$eclipse$ui$views$properties$IPropertySheetPage = PDEFormEditor.class$("org.eclipse.ui.views.properties.IPropertySheetPage")) : class$org$eclipse$ui$views$properties$IPropertySheetPage)) {
            return this.getPropertySheet();
        }
        if (key.equals(class$org$eclipse$ui$ide$IGotoMarker == null ? (class$org$eclipse$ui$ide$IGotoMarker = PDEFormEditor.class$("org.eclipse.ui.ide.IGotoMarker")) : class$org$eclipse$ui$ide$IGotoMarker)) {
            return this;
        }
        return super.getAdapter(key);
    }

    public Menu getContextMenu() {
        return this.contextMenu;
    }

    public PDEMultiPageContentOutline getContentOutline() {
        if (this.contentOutline == null || this.contentOutline.isDisposed()) {
            this.contentOutline = new PDEMultiPageContentOutline();
            this.updateContentOutline(this.getActivePageInstance());
        }
        return this.contentOutline;
    }

    public PDEMultiPagePropertySheet getPropertySheet() {
        if (this.propertySheet == null || this.propertySheet.isDisposed()) {
            this.propertySheet = new PDEMultiPagePropertySheet();
            this.updatePropertySheet(this.getActivePageInstance());
        }
        return this.propertySheet;
    }

    protected IContentOutlinePage getFormOutline() {
        if (this.formOutline == null) {
            this.formOutline = this.createContentOutline();
        }
        return this.formOutline;
    }

    protected IContentOutlinePage createContentOutline() {
        return new FormOutlinePage(this);
    }

    private void updateContentOutline(IFormPage page) {
        if (this.contentOutline == null) {
            return;
        }
        IContentOutlinePage outline = null;
        if (page instanceof PDESourcePage) {
            outline = ((PDESourcePage)page).getContentOutline();
        } else {
            outline = this.getFormOutline();
            if (outline instanceof FormOutlinePage) {
                ((FormOutlinePage)outline).refresh();
            }
        }
        this.contentOutline.setPageActive(outline);
    }

    protected IPropertySheetPage getPropertySheet(PDEFormPage page) {
        return page.getPropertySheetPage();
    }

    void updatePropertySheet(IFormPage page) {
        if (this.propertySheet == null) {
            return;
        }
        if (page instanceof PDEFormPage) {
            IPropertySheetPage propertySheetPage = this.getPropertySheet((PDEFormPage)page);
            if (propertySheetPage != null) {
                this.propertySheet.setPageActive(propertySheetPage);
            }
        } else {
            this.propertySheet.setDefaultPageActive();
        }
    }

    IFormPage[] getPages() {
        ArrayList formPages = new ArrayList();
        for (int i = 0; i < this.pages.size(); ++i) {
            Object page = this.pages.get(i);
            if (!(page instanceof IFormPage)) continue;
            formPages.add(page);
        }
        return formPages.toArray(new IFormPage[formPages.size()]);
    }

    protected void performGlobalAction(String id) {
        IFormPage page;
        ISelection selection = this.getSelection();
        boolean handled = ((PDEFormPage)this.getActivePageInstance()).performGlobalAction(id);
        if (!handled && (page = this.getActivePageInstance()) instanceof PDEFormPage) {
            if (id.equals(ActionFactory.UNDO.getId())) {
                this.inputContextManager.undo();
                return;
            }
            if (id.equals(ActionFactory.REDO.getId())) {
                this.inputContextManager.redo();
                return;
            }
            if (id.equals(ActionFactory.CUT.getId()) || id.equals(ActionFactory.COPY.getId())) {
                this.copyToClipboard(selection);
                return;
            }
        }
    }

    private void copyToClipboard(ISelection selection) {
        Object[] objects = null;
        String textVersion = null;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            if (ssel == null || ssel.size() == 0) {
                return;
            }
            objects = ssel.toArray();
            StringWriter writer = new StringWriter();
            PrintWriter pwriter = new PrintWriter(writer);
            Class<?> objClass = null;
            for (int i = 0; i < objects.length; ++i) {
                Object obj = objects[i];
                if (objClass == null) {
                    objClass = obj.getClass();
                } else if (!objClass.equals(obj.getClass())) {
                    return;
                }
                if (!(obj instanceof IWritable)) continue;
                ((IWritable)obj).write("", pwriter);
            }
            pwriter.flush();
            textVersion = writer.toString();
            try {
                pwriter.close();
                writer.close();
            }
            catch (IOException e) {}
        } else if (selection instanceof ITextSelection) {
            textVersion = ((ITextSelection)selection).getText();
        }
        if ((textVersion == null || textVersion.length() == 0) && objects == null) {
            return;
        }
        Object[] o = null;
        Transfer[] t = null;
        if (objects == null) {
            o = new Object[]{textVersion};
            t = new Transfer[]{TextTransfer.getInstance()};
        } else if (textVersion == null || textVersion.length() == 0) {
            o = new Object[]{objects};
            t = new Transfer[]{ModelDataTransfer.getInstance()};
        } else {
            o = new Object[]{objects, textVersion};
            t = new Transfer[]{ModelDataTransfer.getInstance(), TextTransfer.getInstance()};
        }
        this.clipboard.setContents(o, t);
    }

    public boolean canPasteFromClipboard() {
        IFormPage page = this.getActivePageInstance();
        if (page instanceof PDEFormPage) {
            return ((PDEFormPage)page).canPaste(this.getClipboard());
        }
        return false;
    }

    public boolean canCopy(ISelection selection) {
        if (selection == null) {
            return false;
        }
        if (selection instanceof IStructuredSelection) {
            return !selection.isEmpty();
        }
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            return textSelection.getLength() > 0;
        }
        return false;
    }

    void updateUndo(IAction undoAction, IAction redoAction) {
        IModelUndoManager undoManager = this.inputContextManager.getUndoManager();
        if (undoManager != null) {
            undoManager.setActions(undoAction, redoAction);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class PDEMultiPageEditorSite
    extends MultiPageEditorSite {
        public PDEMultiPageEditorSite(MultiPageEditorPart multiPageEditor, IEditorPart editor) {
            super(multiPageEditor, editor);
        }

        public IEditorActionBarContributor getActionBarContributor() {
            PDEFormEditor editor = (PDEFormEditor)this.getMultiPageEditor();
            PDEFormEditorContributor contributor = editor.getContributor();
            return contributor.getSourceContributor();
        }
    }
}

