/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class ContainerGenerator {
    private IPath containerFullPath;
    private IContainer container;

    public ContainerGenerator(IPath containerPath) {
        this.containerFullPath = containerPath;
    }

    private IFolder createFolder(IFolder folderHandle, IProgressMonitor monitor) throws CoreException {
        folderHandle.create(false, true, monitor);
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        return folderHandle;
    }

    private IFolder createFolderHandle(IContainer container, String folderName) {
        return container.getFolder((IPath)new Path(folderName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IProject createProject(IProject projectHandle, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("", 2000);
            projectHandle.create((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            projectHandle.open((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
        }
        finally {
            monitor.done();
        }
        return projectHandle;
    }

    private IProject createProjectHandle(IWorkspaceRoot root, String projectName) {
        return root.getProject(projectName);
    }

    public IContainer generateContainer(IProgressMonitor monitor) throws CoreException {
        IDEWorkbenchPlugin.getPluginWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask(IDEWorkbenchMessages.getString("ContainerGenerator.progressMessage"), 1000 * ContainerGenerator.this.containerFullPath.segmentCount());
                if (ContainerGenerator.this.container != null) {
                    return;
                }
                IWorkspaceRoot root = ContainerGenerator.this.getWorkspaceRoot();
                ContainerGenerator.this.container = (IContainer)root.findMember(ContainerGenerator.this.containerFullPath);
                if (ContainerGenerator.this.container != null) {
                    return;
                }
                ContainerGenerator.this.container = (IContainer)root;
                for (int i = 0; i < ContainerGenerator.this.containerFullPath.segmentCount(); ++i) {
                    String currentSegment = ContainerGenerator.this.containerFullPath.segment(i);
                    IResource resource = ContainerGenerator.this.container.findMember(currentSegment);
                    if (resource != null) {
                        ContainerGenerator.this.container = (IContainer)resource;
                        monitor.worked(1000);
                        continue;
                    }
                    if (i == 0) {
                        IProject projectHandle = ContainerGenerator.this.createProjectHandle(root, currentSegment);
                        ContainerGenerator.this.container = (IContainer)ContainerGenerator.this.createProject(projectHandle, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                        continue;
                    }
                    IFolder folderHandle = ContainerGenerator.this.createFolderHandle(ContainerGenerator.this.container, currentSegment);
                    ContainerGenerator.this.container = (IContainer)ContainerGenerator.this.createFolder(folderHandle, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                }
            }
        }, monitor);
        return this.container;
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return IDEWorkbenchPlugin.getPluginWorkspace().getRoot();
    }
}

