/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences.formatter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.jdt.internal.ui.preferences.formatter.BlankLinesTabPage;
import org.eclipse.jdt.internal.ui.preferences.formatter.BracesTabPage;
import org.eclipse.jdt.internal.ui.preferences.formatter.CommentsTabPage;
import org.eclipse.jdt.internal.ui.preferences.formatter.ControlStatementsTabPage;
import org.eclipse.jdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.jdt.internal.ui.preferences.formatter.IndentationTabPage;
import org.eclipse.jdt.internal.ui.preferences.formatter.LineWrappingTabPage;
import org.eclipse.jdt.internal.ui.preferences.formatter.ModifyDialogTabPage;
import org.eclipse.jdt.internal.ui.preferences.formatter.NewLinesTabPage;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileManager;
import org.eclipse.jdt.internal.ui.preferences.formatter.RenameProfileDialog;
import org.eclipse.jdt.internal.ui.preferences.formatter.WhiteSpaceTabPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class ModifyDialog
extends StatusDialog {
    private static final String DS_KEY_PREFERRED_WIDTH = "org.eclipse.jdt.uiformatter_page.modify_dialog.preferred_width";
    private static final String DS_KEY_PREFERRED_HEIGHT = "org.eclipse.jdt.uiformatter_page.modify_dialog.preferred_height";
    private static final String DS_KEY_PREFERRED_X = "org.eclipse.jdt.uiformatter_page.modify_dialog.preferred_x";
    private static final String DS_KEY_PREFERRED_Y = "org.eclipse.jdt.uiformatter_page.modify_dialog.preferred_y";
    private static final String DS_KEY_LAST_FOCUS = "org.eclipse.jdt.uiformatter_page.modify_dialog.last_focus";
    private final String fTitle;
    private final boolean fNewProfile;
    private final ProfileManager.Profile fProfile;
    private final Map fWorkingValues;
    private final IStatus fStandardStatus;
    protected final List fTabPages;
    final IDialogSettings fDialogSettings;
    private TabFolder fTabFolder;
    private ProfileManager fProfileManager;

    protected ModifyDialog(Shell parentShell, ProfileManager.Profile profile, ProfileManager profileManager, boolean newProfile) {
        super(parentShell);
        this.fProfileManager = profileManager;
        this.fNewProfile = newProfile;
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.fProfile = profile;
        if (this.fProfile instanceof ProfileManager.BuiltInProfile) {
            this.fStandardStatus = new Status(1, JavaPlugin.getPluginId(), 0, FormatterMessages.getString("ModifyDialog.dialog.show.warning.builtin"), null);
            this.fTitle = FormatterMessages.getFormattedString("ModifyDialog.dialog.show.title", profile.getName());
        } else {
            this.fStandardStatus = new Status(0, JavaPlugin.getPluginId(), 0, "", null);
            this.fTitle = FormatterMessages.getFormattedString("ModifyDialog.dialog.title", profile.getName());
        }
        this.fWorkingValues = new HashMap(this.fProfile.getSettings());
        this.updateStatus(this.fStandardStatus);
        this.setStatusLineAboveButtons(false);
        this.fTabPages = new ArrayList();
        this.fDialogSettings = JavaPlugin.getDefault().getDialogSettings();
    }

    public void create() {
        super.create();
        int lastFocusNr = 0;
        try {
            lastFocusNr = this.fDialogSettings.getInt(DS_KEY_LAST_FOCUS);
            if (lastFocusNr < 0) {
                lastFocusNr = 0;
            }
            if (lastFocusNr > this.fTabPages.size() - 1) {
                lastFocusNr = this.fTabPages.size() - 1;
            }
        }
        catch (NumberFormatException x) {
            lastFocusNr = 0;
        }
        if (!this.fNewProfile) {
            this.fTabFolder.setSelection(lastFocusNr);
            ((ModifyDialogTabPage)this.fTabFolder.getSelection()[0].getData()).setInitialFocus();
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.fTitle);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.fTabFolder = new TabFolder(composite, 0);
        this.fTabFolder.setLayoutData((Object)new GridData(1808));
        this.addTabPage(this.fTabFolder, FormatterMessages.getString("ModifyDialog.tabpage.indentation.title"), new IndentationTabPage(this, this.fWorkingValues));
        this.addTabPage(this.fTabFolder, FormatterMessages.getString("ModifyDialog.tabpage.braces.title"), new BracesTabPage(this, this.fWorkingValues));
        this.addTabPage(this.fTabFolder, FormatterMessages.getString("ModifyDialog.tabpage.whitespace.title"), new WhiteSpaceTabPage(this, this.fWorkingValues));
        this.addTabPage(this.fTabFolder, FormatterMessages.getString("ModifyDialog.tabpage.blank_lines.title"), new BlankLinesTabPage(this, this.fWorkingValues));
        this.addTabPage(this.fTabFolder, FormatterMessages.getString("ModifyDialog.tabpage.new_lines.title"), new NewLinesTabPage(this, this.fWorkingValues));
        this.addTabPage(this.fTabFolder, FormatterMessages.getString("ModifyDialog.tabpage.control_statements.title"), new ControlStatementsTabPage(this, this.fWorkingValues));
        this.addTabPage(this.fTabFolder, FormatterMessages.getString("ModifyDialog.tabpage.line_wrapping.title"), new LineWrappingTabPage(this, this.fWorkingValues));
        this.addTabPage(this.fTabFolder, FormatterMessages.getString("ModifyDialog.tabpage.comments.title"), new CommentsTabPage(this, this.fWorkingValues));
        ModifyDialog.applyDialogFont((Control)composite);
        this.fTabFolder.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TabItem tabItem = (TabItem)e.item;
                ModifyDialogTabPage page = (ModifyDialogTabPage)tabItem.getData();
                ModifyDialog.this.fDialogSettings.put(ModifyDialog.DS_KEY_LAST_FOCUS, ModifyDialog.this.fTabPages.indexOf(page));
                page.makeVisible();
            }
        });
        return composite;
    }

    public void updateStatus(IStatus status) {
        super.updateStatus(status != null ? status : this.fStandardStatus);
    }

    protected void constrainShellSize() {
        Shell shell = this.getShell();
        try {
            int x = this.fDialogSettings.getInt(DS_KEY_PREFERRED_X);
            int y = this.fDialogSettings.getInt(DS_KEY_PREFERRED_Y);
            int width = this.fDialogSettings.getInt(DS_KEY_PREFERRED_WIDTH);
            int height = this.fDialogSettings.getInt(DS_KEY_PREFERRED_HEIGHT);
            shell.setLocation(x, y);
            shell.setSize(width, height);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        super.constrainShellSize();
    }

    public boolean close() {
        Rectangle shell = this.getShell().getBounds();
        this.fDialogSettings.put(DS_KEY_PREFERRED_WIDTH, shell.width);
        this.fDialogSettings.put(DS_KEY_PREFERRED_HEIGHT, shell.height);
        this.fDialogSettings.put(DS_KEY_PREFERRED_X, shell.x);
        this.fDialogSettings.put(DS_KEY_PREFERRED_Y, shell.y);
        return super.close();
    }

    protected void okPressed() {
        if (this.fProfile instanceof ProfileManager.BuiltInProfile) {
            ProfileManager.CustomProfile newProfile = new ProfileManager.CustomProfile("", this.fWorkingValues, 6);
            RenameProfileDialog dialog = new RenameProfileDialog(this.getShell(), newProfile, this.fProfileManager);
            if (dialog.open() != 0) {
                return;
            }
            this.fProfileManager.addProfile(newProfile);
        } else {
            this.fProfile.setSettings(this.fWorkingValues);
        }
        super.okPressed();
    }

    private final void addTabPage(TabFolder tabFolder, String title, ModifyDialogTabPage tabPage) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        ModifyDialog.applyDialogFont((Control)tabItem.getControl());
        tabItem.setText(title);
        tabItem.setData((Object)tabPage);
        tabItem.setControl((Control)tabPage.createContents((Composite)tabFolder));
        this.fTabPages.add(tabPage);
    }
}

