/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.callhierarchy;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.callhierarchy.CallHierarchyVisitor;
import org.eclipse.jdt.internal.corext.callhierarchy.MethodCall;

public abstract class MethodWrapper
implements IAdaptable {
    private Map fElements = null;
    private Map fMethodCache;
    private MethodCall fMethodCall;
    private MethodWrapper fParent;
    private int fLevel;
    static /* synthetic */ Class class$org$eclipse$jdt$core$IJavaElement;

    public MethodWrapper(MethodWrapper parent, MethodCall methodCall) {
        Assert.isNotNull(methodCall);
        if (parent == null) {
            this.setMethodCache(new HashMap());
            this.fLevel = 1;
        } else {
            this.setMethodCache(parent.getMethodCache());
            this.fLevel = parent.getLevel() + 1;
        }
        this.fMethodCall = methodCall;
        this.fParent = parent;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == (class$org$eclipse$jdt$core$IJavaElement == null ? (class$org$eclipse$jdt$core$IJavaElement = MethodWrapper.class$("org.eclipse.jdt.core.IJavaElement")) : class$org$eclipse$jdt$core$IJavaElement)) {
            return this.getMember();
        }
        return null;
    }

    public MethodWrapper[] getCalls(IProgressMonitor progressMonitor) {
        if (this.fElements == null) {
            this.doFindChildren(progressMonitor);
        }
        MethodWrapper[] result = new MethodWrapper[this.fElements.size()];
        int i = 0;
        Iterator iter = this.fElements.keySet().iterator();
        while (iter.hasNext()) {
            MethodCall methodCall = this.getMethodCallFromMap(this.fElements, iter.next());
            result[i++] = this.createMethodWrapper(methodCall);
        }
        return result;
    }

    public int getLevel() {
        return this.fLevel;
    }

    public IMember getMember() {
        return this.getMethodCall().getMember();
    }

    public MethodCall getMethodCall() {
        return this.fMethodCall;
    }

    public String getName() {
        if (this.getMethodCall() != null) {
            return this.getMethodCall().getMember().getElementName();
        }
        return "";
    }

    public MethodWrapper getParent() {
        return this.fParent;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth == null) {
            return false;
        }
        if (oth.getClass() != this.getClass()) {
            return false;
        }
        MethodWrapper other = (MethodWrapper)oth;
        if (this.fParent == null ? other.fParent != null : !this.fParent.equals(other.fParent)) {
            return false;
        }
        return !(this.getMethodCall() == null ? other.getMethodCall() != null : !this.getMethodCall().equals(other.getMethodCall()));
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.fParent != null) {
            result = 1000003 * result + this.fParent.hashCode();
        }
        if (this.getMethodCall() != null) {
            result = 1000003 * result + this.getMethodCall().getMember().hashCode();
        }
        return result;
    }

    private void setMethodCache(Map methodCache) {
        this.fMethodCache = methodCache;
    }

    protected abstract String getTaskName();

    private void addCallToCache(MethodCall methodCall) {
        Map cachedCalls = this.lookupMethod(this.getMethodCall());
        cachedCalls.put(methodCall.getKey(), methodCall);
    }

    protected abstract MethodWrapper createMethodWrapper(MethodCall var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFindChildren(IProgressMonitor progressMonitor) {
        Map existingResults = this.lookupMethod(this.getMethodCall());
        if (existingResults != null) {
            this.fElements = new HashMap();
            this.fElements.putAll(existingResults);
        } else {
            this.initCalls();
            if (progressMonitor != null) {
                progressMonitor.beginTask(this.getTaskName(), 100);
            }
            try {
                this.performSearch(progressMonitor);
            }
            finally {
                if (progressMonitor != null) {
                    progressMonitor.done();
                }
            }
        }
    }

    public boolean isRecursive() {
        for (MethodWrapper current = this.getParent(); current != null; current = current.getParent()) {
            if (!this.getMember().getHandleIdentifier().equals(current.getMember().getHandleIdentifier())) continue;
            return true;
        }
        return false;
    }

    protected abstract Map findChildren(IProgressMonitor var1);

    private Map getMethodCache() {
        return this.fMethodCache;
    }

    private void initCalls() {
        this.fElements = new HashMap();
        this.initCacheForMethod();
    }

    private Map lookupMethod(MethodCall methodCall) {
        return (Map)this.getMethodCache().get(methodCall.getKey());
    }

    private void performSearch(IProgressMonitor progressMonitor) {
        this.fElements = this.findChildren(progressMonitor);
        Iterator iter = this.fElements.keySet().iterator();
        while (iter.hasNext()) {
            this.checkCanceled(progressMonitor);
            MethodCall methodCall = this.getMethodCallFromMap(this.fElements, iter.next());
            this.addCallToCache(methodCall);
        }
    }

    private MethodCall getMethodCallFromMap(Map elements, Object key) {
        return (MethodCall)elements.get(key);
    }

    private void initCacheForMethod() {
        HashMap cachedCalls = new HashMap();
        this.getMethodCache().put(this.getMethodCall().getKey(), cachedCalls);
    }

    protected void checkCanceled(IProgressMonitor progressMonitor) {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public void accept(CallHierarchyVisitor visitor, IProgressMonitor progressMonitor) {
        if (this.getParent() != null && this.getParent().isRecursive()) {
            return;
        }
        this.checkCanceled(progressMonitor);
        visitor.preVisit(this);
        if (visitor.visit(this)) {
            MethodWrapper[] methodWrappers = this.getCalls(progressMonitor);
            for (int i = 0; i < methodWrappers.length; ++i) {
                methodWrappers[i].accept(visitor, progressMonitor);
            }
        }
        visitor.postVisit(this);
        if (progressMonitor != null) {
            progressMonitor.worked(1);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

