/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.variables;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILogicalStructureType;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IIndexedValue;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.IDebugExceptionHandler;
import org.eclipse.debug.internal.ui.views.variables.IndexedVariablePartition;
import org.eclipse.debug.internal.ui.views.variables.VariablesView;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class VariablesViewContentProvider
implements ITreeContentProvider {
    private IDebugView fDebugView;
    private HashMap fParentCache = new HashMap(10);
    private IDebugExceptionHandler fExceptionHandler = null;
    private boolean fUseObjectBrowsers;

    public VariablesViewContentProvider(IDebugView view) {
        this.setDebugView(view);
    }

    public Object[] getElements(Object parent) {
        return this.getChildren(parent);
    }

    public Object[] getChildren(Object parent) {
        Object[] children = null;
        try {
            if (parent instanceof IStackFrame) {
                children = ((IStackFrame)parent).getVariables();
            } else if (parent instanceof IVariable) {
                IVariable variable = (IVariable)parent;
                IValue value = variable.getValue();
                children = this.getModelSpecificChildren((IDebugElement)variable, value);
            }
            if (children != null) {
                this.cache(parent, children);
                return children;
            }
        }
        catch (DebugException de) {
            if (this.getExceptionHandler() != null) {
                this.getExceptionHandler().handleException(de);
            }
            DebugUIPlugin.log(de);
        }
        return new Object[0];
    }

    protected IVariable[] getModelSpecificChildren(IDebugElement parent, IValue value) throws DebugException {
        if (value == null) {
            return new IVariable[0];
        }
        return this.getValueChildren(parent, value);
    }

    protected IVariable[] getValueChildren(IDebugElement parent, IValue value) throws DebugException {
        IIndexedValue indexedValue;
        int partitionSize;
        if (value == null) {
            return null;
        }
        IValue logicalValue = this.getLogicalValue(value);
        if (logicalValue instanceof IIndexedValue && (partitionSize = this.computeParitionSize(indexedValue = (IIndexedValue)logicalValue)) > 1) {
            int offset = indexedValue.getInitialOffset();
            int length = indexedValue.getSize();
            int numPartitions = length / partitionSize;
            int remainder = length % partitionSize;
            if (remainder > 0) {
                ++numPartitions;
            }
            IVariable[] partitions = new IVariable[numPartitions];
            for (int i = 0; i < numPartitions - 1; ++i) {
                partitions[i] = new IndexedVariablePartition(parent, indexedValue, offset, partitionSize);
                offset += partitionSize;
            }
            if (remainder == 0) {
                remainder = partitionSize;
            }
            partitions[numPartitions - 1] = new IndexedVariablePartition(parent, indexedValue, offset, remainder);
            return partitions;
        }
        if (logicalValue == null) {
            logicalValue = value;
        }
        return logicalValue.getVariables();
    }

    private int computeParitionSize(IIndexedValue value) {
        int partitionSize = 1;
        try {
            int length = value.getSize();
            int partitionDepth = 0;
            int preferredSize = this.getArrayPartitionSize();
            int remainder = length % preferredSize;
            length /= preferredSize;
            while (length > 0 && (remainder != 0 || length != 1)) {
                ++partitionDepth;
                remainder = length % preferredSize;
                length /= preferredSize;
            }
            for (int i = 0; i < partitionDepth; ++i) {
                partitionSize *= preferredSize;
            }
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        return partitionSize;
    }

    private IValue getLogicalValue(IValue value) {
        ILogicalStructureType[] types;
        if (this.isShowLogicalStructure() && (types = DebugPlugin.getLogicalStructureTypes((IValue)value)).length > 0) {
            IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
            ILogicalStructureType type = null;
            boolean exist = false;
            for (int i = 0; i < types.length; ++i) {
                String key = "VAR_LS_" + types[i].getId();
                int setting = store.getInt(key);
                if (setting != 0) {
                    exist = true;
                    if (setting != 1) continue;
                    type = types[i];
                    break;
                }
                store.setValue(types[i].getId(), -1);
            }
            if (type == null && !exist) {
                type = types[0];
                store.setValue("VAR_LS_" + type.getId(), 1);
            }
            if (type != null) {
                try {
                    return type.getLogicalStructure(value);
                }
                catch (CoreException e) {
                    // empty catch block
                }
            }
        }
        return value;
    }

    protected void cache(Object parent, Object[] children) {
        for (int i = 0; i < children.length; ++i) {
            Object child = children[i];
            if (this.fParentCache.containsKey(child)) continue;
            this.fParentCache.put(child, parent);
        }
    }

    public Object getParent(Object item) {
        return this.fParentCache.get(item);
    }

    public void dispose() {
        this.fParentCache = null;
        this.setExceptionHandler(null);
    }

    protected void clearCache() {
        if (this.fParentCache != null) {
            this.fParentCache.clear();
        }
    }

    public void removeCache(Object[] children) {
        if (this.fParentCache == null) {
            return;
        }
        for (int i = 0; i < children.length; ++i) {
            this.fParentCache.remove(children[i]);
        }
    }

    public boolean hasChildren(Object element) {
        try {
            if (element instanceof IVariable) {
                if (element instanceof IndexedVariablePartition) {
                    return true;
                }
                element = ((IVariable)element).getValue();
            }
            if (element instanceof IValue) {
                return ((IValue)element).hasVariables();
            }
            if (element instanceof IStackFrame) {
                return ((IStackFrame)element).hasVariables();
            }
        }
        catch (DebugException de) {
            DebugUIPlugin.log(de);
            return false;
        }
        return false;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.clearCache();
    }

    public List getCachedDecendants(Object parent) {
        Iterator children = this.fParentCache.keySet().iterator();
        ArrayList cachedChildren = new ArrayList(10);
        while (children.hasNext()) {
            Object child = children.next();
            if (!this.isCachedDecendant(child, parent)) continue;
            cachedChildren.add(child);
        }
        return cachedChildren;
    }

    protected boolean isCachedDecendant(Object child, Object parent) {
        Object p = this.getParent(child);
        while (p != null) {
            if (p.equals(parent)) {
                return true;
            }
            p = this.getParent(p);
        }
        return false;
    }

    protected String getDebugModelId(IDebugElement debugElement) {
        return debugElement.getModelIdentifier();
    }

    protected void setExceptionHandler(IDebugExceptionHandler handler) {
        this.fExceptionHandler = handler;
    }

    protected IDebugExceptionHandler getExceptionHandler() {
        return this.fExceptionHandler;
    }

    public void setShowLogicalStructure(boolean flag) {
        this.fUseObjectBrowsers = flag;
    }

    public boolean isShowLogicalStructure() {
        return this.fUseObjectBrowsers;
    }

    private void setDebugView(IDebugView view) {
        this.fDebugView = view;
    }

    protected IDebugView getDebugView() {
        return this.fDebugView;
    }

    protected int getArrayPartitionSize() {
        if (this.getDebugView() == null) {
            return 100;
        }
        return ((VariablesView)this.getDebugView()).getArrayPartitionSize();
    }
}

