/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.osgi.framework.Bundle;

public class AddMarkerAction
extends TextEditorAction {
    private static final int MAX_LABEL_LENGTH = 80;
    private String fMarkerType;
    private boolean fAskForLabel;
    private ResourceBundle fBundle;
    private String fPrefix;
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;

    public AddMarkerAction(ResourceBundle bundle, String prefix, ITextEditor textEditor, String markerType, boolean askForLabel) {
        super(bundle, prefix, textEditor);
        this.fBundle = bundle;
        this.fPrefix = prefix;
        this.fMarkerType = markerType;
        this.fAskForLabel = askForLabel;
    }

    protected ResourceBundle getResourceBundle() {
        return this.fBundle;
    }

    protected String getResourceKeyPrefix() {
        return this.fPrefix;
    }

    public void run() {
        IResource resource = this.getResource();
        if (resource == null) {
            return;
        }
        Map attributes = this.getInitialAttributes();
        if (this.fAskForLabel && !this.askForLabel(attributes)) {
            return;
        }
        try {
            MarkerUtilities.createMarker(resource, attributes, this.fMarkerType);
        }
        catch (CoreException x) {
            Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
            ILog log = Platform.getLog((Bundle)bundle);
            log.log(x.getStatus());
            Shell shell = this.getTextEditor().getSite().getShell();
            String title = AddMarkerAction.getString((ResourceBundle)this.fBundle, (String)(this.fPrefix + "error.dialog.title"), (String)(this.fPrefix + "error.dialog.title"));
            String msg = AddMarkerAction.getString((ResourceBundle)this.fBundle, (String)(this.fPrefix + "error.dialog.message"), (String)(this.fPrefix + "error.dialog.message"));
            ErrorDialog.openError((Shell)shell, (String)title, (String)msg, (IStatus)x.getStatus());
        }
    }

    public void update() {
        this.setEnabled(this.getResource() != null);
    }

    protected boolean askForLabel(Map attributes) {
        String proposal;
        Object o = attributes.get("message");
        String string = proposal = o instanceof String ? (String)o : "";
        if (proposal == null) {
            proposal = "";
        }
        String title = AddMarkerAction.getString((ResourceBundle)this.fBundle, (String)(this.fPrefix + "dialog.title"), (String)(this.fPrefix + "dialog.title"));
        String message = AddMarkerAction.getString((ResourceBundle)this.fBundle, (String)(this.fPrefix + "dialog.message"), (String)(this.fPrefix + "dialog.message"));
        IInputValidator inputValidator = new IInputValidator(){

            public String isValid(String newText) {
                return newText == null || newText.trim().length() == 0 ? " " : null;
            }
        };
        InputDialog dialog = new InputDialog(this.getTextEditor().getSite().getShell(), title, message, proposal, inputValidator);
        String label = null;
        if (dialog.open() != 1) {
            label = dialog.getValue();
        }
        if (label == null) {
            return false;
        }
        if ((label = label.trim()).length() == 0) {
            return false;
        }
        attributes.put("message", label);
        return true;
    }

    protected Map getInitialAttributes() {
        HashMap attributes = new HashMap(11);
        ITextSelection selection = (ITextSelection)this.getTextEditor().getSelectionProvider().getSelection();
        if (!selection.isEmpty()) {
            int start = selection.getOffset();
            int length = selection.getLength();
            if (length < 0) {
                length = -length;
                start -= length;
            }
            MarkerUtilities.setCharStart(attributes, start);
            MarkerUtilities.setCharEnd(attributes, start + length);
            int line = selection.getStartLine();
            MarkerUtilities.setLineNumber(attributes, line == -1 ? -1 : line + 1);
            IDocument document = this.getTextEditor().getDocumentProvider().getDocument((Object)this.getTextEditor().getEditorInput());
            MarkerUtilities.setMessage(attributes, this.getLabelProposal(document, start, length));
        }
        return attributes;
    }

    protected String getLabelProposal(IDocument document, int offset, int length) {
        try {
            int right;
            char ch;
            int left;
            if (length > 0) {
                int i;
                boolean skip = true;
                for (i = 0; i < length; ++i) {
                    boolean isWhitespace = Character.isWhitespace(document.getChar(offset + i));
                    if (!skip && isWhitespace) break;
                    if (!skip || isWhitespace) continue;
                    skip = false;
                }
                String label = document.get(offset, i);
                return label.trim();
            }
            int line = document.getLineOfOffset(offset);
            int limit = document.getLineOffset(line);
            for (left = offset; left > limit && !Character.isWhitespace(ch = document.getChar(left)); --left) {
            }
            limit += document.getLineLength(line);
            while (left <= limit && Character.isWhitespace(ch = document.getChar(left))) {
                ++left;
            }
            if (left > limit) {
                return null;
            }
            int n = right = offset + length > (limit = Math.min(limit, left + 80)) ? limit : offset + length;
            while (right < limit && !Character.isWhitespace(ch = document.getChar(right))) {
                ++right;
            }
            if (left != right) {
                String label = document.get(left, right - left);
                return label.trim();
            }
        }
        catch (BadLocationException x) {
            // empty catch block
        }
        return null;
    }

    protected IResource getResource() {
        ITextEditor editor = this.getTextEditor();
        if (editor != null) {
            IEditorInput input = editor.getEditorInput();
            return (IResource)input.getAdapter(class$org$eclipse$core$resources$IResource == null ? (class$org$eclipse$core$resources$IResource = AddMarkerAction.class$("org.eclipse.core.resources.IResource")) : class$org$eclipse$core$resources$IResource);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

