/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class FormColors {
    public static final String TITLE = "org.eclipse.ui.forms.TITLE";
    public static final String BORDER = "org.eclipse.ui.forms.BORDER";
    public static final String SEPARATOR = "org.eclipse.ui.forms.SEPARATOR";
    public static final String TB_BG = "org.eclipse.ui.forms.TB_BG";
    public static final String TB_FG = "org.eclipse.ui.forms.TB_FG";
    public static final String TB_GBG = "org.eclipse.ui.forms.TB_GBG";
    public static final String TB_BORDER = "org.eclipse.ui.forms.TB_BORDER";
    public static final String TB_TOGGLE = "org.eclipse.ui.forms.TB_TOGGLE";
    protected Map colorRegistry = new HashMap(10);
    protected Color background;
    protected Color foreground;
    private boolean shared;
    protected Display display;
    protected Color border;

    public FormColors(Display display) {
        this.display = display;
        this.initialize();
    }

    public Display getDisplay() {
        return this.display;
    }

    protected void initialize() {
        this.background = this.display.getSystemColor(25);
        this.foreground = this.display.getSystemColor(24);
        this.initializeColorTable();
        this.updateBorderColor();
    }

    protected void initializeColorTable() {
        this.createColor(SEPARATOR, 152, 170, 203);
        String osname = System.getProperty("os.name").toLowerCase();
        if (osname.startsWith("mac os")) {
            this.createColor(TITLE, this.getSystemColor(24));
        } else {
            this.createColor(TITLE, this.getSystemColor(26));
        }
        RGB border = this.getSystemColor(35);
        RGB black = new RGB(0, 0, 0);
        this.createColor(BORDER, this.blend(border, black, 80));
    }

    public void initializeSectionToolBarColors() {
        if (this.getColor(TB_BG) != null) {
            return;
        }
        RGB tbBg = this.getSystemColor(32);
        RGB formBackground = this.getBackground().getRGB();
        tbBg = this.blend(formBackground, tbBg, 77);
        this.createColor(TB_BG, tbBg);
        RGB tbGbg = this.blend(formBackground, tbBg, 50);
        this.createColor(TB_GBG, tbGbg);
        RGB tbFg = this.getSystemColor(26);
        this.createColor(TB_FG, tbFg);
        RGB tbBorder = this.getSystemColor(35);
        this.createColor(TB_BORDER, tbBorder);
        RGB toggle = this.getSystemColor(18);
        this.createColor(TB_TOGGLE, toggle);
    }

    public RGB getSystemColor(int code) {
        return this.getDisplay().getSystemColor(code).getRGB();
    }

    public Color createColor(String key, RGB rgb) {
        return this.createColor(key, rgb.red, rgb.green, rgb.blue);
    }

    public Color createColor(String key, int r, int g, int b) {
        Color c = new Color((Device)this.display, r, g, b);
        this.colorRegistry.put(key, c);
        return c;
    }

    protected void updateBorderColor() {
        if (this.isWhiteBackground()) {
            this.border = this.getColor(BORDER);
        } else {
            this.border = this.display.getSystemColor(22);
            if (this.border.getRed() == this.background.getRed() && this.border.getGreen() == this.background.getGreen() && this.border.getBlue() == this.background.getBlue()) {
                this.border = this.display.getSystemColor(17);
            }
        }
    }

    public void setBackground(Color bg) {
        this.background = bg;
        this.updateBorderColor();
    }

    public void setForeground(Color fg) {
        this.foreground = fg;
    }

    public Color getBackground() {
        return this.background;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public Color getBorderColor() {
        return this.border;
    }

    public boolean isWhiteBackground() {
        return this.background.getRed() == 255 && this.background.getGreen() == 255 && this.background.getBlue() == 255;
    }

    public Color getColor(String key) {
        return (Color)this.colorRegistry.get(key);
    }

    public void dispose() {
        Iterator e = this.colorRegistry.values().iterator();
        while (e.hasNext()) {
            ((Color)e.next()).dispose();
        }
        this.colorRegistry = null;
    }

    public void markShared() {
        this.shared = true;
    }

    public boolean isShared() {
        return this.shared;
    }

    private RGB blend(RGB c1, RGB c2, int ratio) {
        int r = this.blend(c1.red, c2.red, ratio);
        int g = this.blend(c1.green, c2.green, ratio);
        int b = this.blend(c1.blue, c2.blue, ratio);
        return new RGB(r, g, b);
    }

    private int blend(int v1, int v2, int ratio) {
        return (ratio * v1 + (100 - ratio) * v2) / 100;
    }
}

