/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.adaptor;

import java.util.Date;
import org.eclipse.osgi.framework.msg.MessageFormat;
import org.eclipse.osgi.framework.util.FrameworkMessageFormat;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.PackageSpecification;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.service.resolver.VersionRange;

public class EclipseAdaptorMsg {
    public static final String NEW_LINE = System.getProperty("line.separator", "\n");
    public static MessageFormat formatter = FrameworkMessageFormat.getMessageFormat((String)"org.eclipse.core.runtime.adaptor.EclipseAdaptorMessages");

    public static String getResolutionFailureMessage(VersionConstraint unsatisfied) {
        if (unsatisfied.isResolved()) {
            throw new IllegalArgumentException();
        }
        if (unsatisfied instanceof PackageSpecification) {
            return formatter.getString("ECLIPSE_MISSING_IMPORTED_PACKAGE", (Object)EclipseAdaptorMsg.toString(unsatisfied));
        }
        if (unsatisfied instanceof BundleSpecification) {
            if (((BundleSpecification)unsatisfied).isOptional()) {
                return formatter.getString("ECLIPSE_MISSING_OPTIONAL_REQUIRED_BUNDLE", (Object)EclipseAdaptorMsg.toString(unsatisfied));
            }
            return formatter.getString("ECLIPSE_MISSING_REQUIRED_BUNDLE", (Object)EclipseAdaptorMsg.toString(unsatisfied));
        }
        return formatter.getString("ECLIPSE_MISSING_HOST", (Object)EclipseAdaptorMsg.toString(unsatisfied));
    }

    public static void debug(String message) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(new Date(System.currentTimeMillis()));
        buffer.append(" - [");
        buffer.append(Thread.currentThread().getName());
        buffer.append("] ");
        buffer.append(message);
        System.out.println(buffer.toString());
    }

    private static String toString(VersionConstraint constraint) {
        VersionRange versionRange = constraint.getVersionRange();
        if (versionRange == null) {
            return constraint.getName();
        }
        return constraint.getName() + '_' + versionRange;
    }
}

