/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.preference;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.util.Assert;

public class PreferenceManager {
    public static final int PRE_ORDER = 0;
    public static final int POST_ORDER = 1;
    PreferenceNode root = new PreferenceNode("");
    String separator;

    public PreferenceManager() {
        this('.');
    }

    public PreferenceManager(char separatorChar) {
        this.separator = new String(new char[]{separatorChar});
    }

    public boolean addTo(String path, IPreferenceNode node) {
        IPreferenceNode target = this.find(path);
        if (target == null) {
            return false;
        }
        target.add(node);
        return true;
    }

    public void addToRoot(IPreferenceNode node) {
        Assert.isNotNull(node);
        this.root.add(node);
    }

    protected void buildSequence(IPreferenceNode node, List sequence, int order) {
        if (order == 0) {
            sequence.add(node);
        }
        IPreferenceNode[] subnodes = node.getSubNodes();
        for (int i = 0; i < subnodes.length; ++i) {
            this.buildSequence(subnodes[i], sequence, order);
        }
        if (order == 1) {
            sequence.add(node);
        }
    }

    public IPreferenceNode find(String path) {
        Assert.isNotNull(path);
        StringTokenizer stok = new StringTokenizer(path, this.separator);
        IPreferenceNode node = this.root;
        while (stok.hasMoreTokens()) {
            String id = stok.nextToken();
            if ((node = node.findSubNode(id)) != null) continue;
            return null;
        }
        if (node == this.root) {
            return null;
        }
        return node;
    }

    public List getElements(int order) {
        Assert.isTrue(order == 0 || order == 1, "invalid traversal order");
        ArrayList sequence = new ArrayList();
        IPreferenceNode[] subnodes = this.getRoot().getSubNodes();
        for (int i = 0; i < subnodes.length; ++i) {
            this.buildSequence(subnodes[i], sequence, order);
        }
        return sequence;
    }

    protected IPreferenceNode getRoot() {
        return this.root;
    }

    public IPreferenceNode remove(String path) {
        Assert.isNotNull(path);
        int index = path.lastIndexOf(this.separator);
        if (index == -1) {
            return this.root.remove(path);
        }
        Assert.isTrue(index < path.length() - 1, "Path can not end with a dot");
        String parentPath = path.substring(0, index);
        String id = path.substring(index + 1);
        IPreferenceNode parentNode = this.find(parentPath);
        if (parentNode == null) {
            return null;
        }
        return parentNode.remove(id);
    }

    public boolean remove(IPreferenceNode node) {
        Assert.isNotNull(node);
        return this.root.remove(node);
    }

    public void removeAll() {
        this.root = new PreferenceNode("");
    }
}

