/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.projection;

import java.util.ArrayList;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.projection.Fragment;
import org.eclipse.jface.text.projection.FragmentUpdater;
import org.eclipse.jface.text.projection.ProjectionDocumentEvent;
import org.eclipse.jface.text.projection.ProjectionMapping;
import org.eclipse.jface.text.projection.ProjectionTextStore;
import org.eclipse.jface.text.projection.Segment;
import org.eclipse.jface.text.projection.SegmentUpdater;

public class ProjectionDocument
extends AbstractDocument {
    private static final String FRAGMENTS_CATEGORY_PREFIX = "__fragmentsCategory";
    private static final String SEGMENTS_CATEGORY = "__segmentsCategory";
    private IDocument fMasterDocument;
    private IDocumentExtension fMasterDocumentExtension;
    private String fFragmentsCategory;
    private String fSegmentsCategory;
    private DocumentEvent fMasterEvent;
    private ProjectionDocumentEvent fSlaveEvent;
    private DocumentEvent fOriginalEvent;
    private boolean fIsUpdating = false;
    private boolean fIsAutoExpanding = false;
    private SegmentUpdater fSegmentUpdater;
    private FragmentUpdater fFragmentsUpdater;
    private ProjectionMapping fMapping;

    public ProjectionDocument(IDocument masterDocument) {
        this.fMasterDocument = masterDocument;
        if (this.fMasterDocument instanceof IDocumentExtension) {
            this.fMasterDocumentExtension = (IDocumentExtension)((Object)this.fMasterDocument);
        }
        this.fSegmentsCategory = SEGMENTS_CATEGORY;
        this.fFragmentsCategory = FRAGMENTS_CATEGORY_PREFIX + this.hashCode();
        this.fMasterDocument.addPositionCategory(this.fFragmentsCategory);
        this.fFragmentsUpdater = new FragmentUpdater(this.fFragmentsCategory);
        this.fMasterDocument.addPositionUpdater(this.fFragmentsUpdater);
        this.fMapping = new ProjectionMapping(masterDocument, this.fFragmentsCategory, this, this.fSegmentsCategory);
        ProjectionTextStore s = new ProjectionTextStore(masterDocument, this.fMapping);
        DefaultLineTracker tracker = new DefaultLineTracker();
        this.setTextStore(s);
        this.setLineTracker(tracker);
        this.completeInitialization();
        this.initializeProjection();
        tracker.set(s.get(0, s.getLength()));
    }

    public void dispose() {
        this.fMasterDocument.removePositionUpdater(this.fFragmentsUpdater);
        try {
            this.fMasterDocument.removePositionCategory(this.fFragmentsCategory);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            // empty catch block
        }
    }

    private void internalError() {
        throw new IllegalStateException();
    }

    protected final Position[] getFragments() {
        try {
            return this.fMasterDocument.getPositions(this.fFragmentsCategory);
        }
        catch (BadPositionCategoryException e) {
            this.internalError();
            return null;
        }
    }

    protected final Position[] getSegments() {
        try {
            return this.getPositions(this.fSegmentsCategory);
        }
        catch (BadPositionCategoryException e) {
            this.internalError();
            return null;
        }
    }

    public ProjectionMapping getProjectionMapping() {
        return this.fMapping;
    }

    public IDocument getMasterDocument() {
        return this.fMasterDocument;
    }

    private void initializeProjection() {
        try {
            this.addPositionCategory(this.fSegmentsCategory);
            this.fSegmentUpdater = new SegmentUpdater(this.fSegmentsCategory);
            this.addPositionUpdater(this.fSegmentUpdater);
            int offset = 0;
            Position[] fragments = this.getFragments();
            for (int i = 0; i < fragments.length; ++i) {
                Fragment fragment = (Fragment)fragments[i];
                Segment segment = new Segment(offset, fragment.getLength());
                segment.fragment = fragment;
                this.addPosition(this.fSegmentsCategory, segment);
                offset += fragment.length;
            }
        }
        catch (BadPositionCategoryException x) {
            this.internalError();
        }
        catch (BadLocationException x) {
            this.internalError();
        }
    }

    private Segment createSegmentFor(Fragment fragment, int index) throws BadLocationException, BadPositionCategoryException {
        int offset = 0;
        if (index > 0) {
            Position[] segments = this.getSegments();
            Segment segment = (Segment)segments[index - 1];
            offset = segment.getOffset() + segment.getLength();
        }
        Segment segment = new Segment(offset, 0);
        segment.fragment = fragment;
        fragment.segment = segment;
        this.addPosition(this.fSegmentsCategory, segment);
        return segment;
    }

    private void internalAddMasterDocumentRange(int offsetInMaster, int lengthInMaster, DocumentEvent masterDocumentEvent) throws BadLocationException {
        if (lengthInMaster == 0) {
            return;
        }
        try {
            Position[] fragments = this.getFragments();
            int index = this.fMasterDocument.computeIndexInCategory(this.fFragmentsCategory, offsetInMaster);
            Fragment left = null;
            Fragment right = null;
            if (index < fragments.length) {
                if (offsetInMaster == fragments[index].offset) {
                    throw new IllegalArgumentException("overlaps with existing fragment");
                }
                if (offsetInMaster + lengthInMaster == fragments[index].offset) {
                    right = (Fragment)fragments[index];
                }
            }
            if (0 < index && index <= fragments.length) {
                Fragment fragment = (Fragment)fragments[index - 1];
                if (fragment.includes(offsetInMaster)) {
                    throw new IllegalArgumentException("overlaps with existing fragment");
                }
                if (fragment.getOffset() + fragment.getLength() == offsetInMaster) {
                    left = fragment;
                }
            }
            int offsetInSlave = 0;
            if (index > 0) {
                Fragment fragment = (Fragment)fragments[index - 1];
                Segment segment = fragment.segment;
                offsetInSlave = segment.getOffset() + segment.getLength();
            }
            ProjectionDocumentEvent event = new ProjectionDocumentEvent(this, offsetInSlave, 0, this.fMasterDocument.get(offsetInMaster, lengthInMaster), offsetInMaster, lengthInMaster, masterDocumentEvent);
            super.fireDocumentAboutToBeChanged(event);
            if (left != null && right != null) {
                int endOffset = right.getOffset() + right.getLength();
                left.setLength(endOffset - left.getOffset());
                left.segment.setLength(left.segment.getLength() + right.segment.getLength());
                this.removePosition(this.fSegmentsCategory, right.segment);
                this.fMasterDocument.removePosition(this.fFragmentsCategory, right);
            } else if (left != null) {
                int endOffset = offsetInMaster + lengthInMaster;
                left.setLength(endOffset - left.getOffset());
                left.segment.markForStretch();
            } else if (right != null) {
                right.setOffset(right.getOffset() - lengthInMaster);
                right.setLength(right.getLength() + lengthInMaster);
                right.segment.markForStretch();
            } else {
                Fragment fragment = new Fragment(offsetInMaster, lengthInMaster);
                this.fMasterDocument.addPosition(this.fFragmentsCategory, fragment);
                Segment segment = this.createSegmentFor(fragment, index);
                segment.markForStretch();
            }
            this.getTracker().replace(event.getOffset(), event.getLength(), event.getText());
            super.fireDocumentChanged(event);
        }
        catch (BadPositionCategoryException x) {
            this.internalError();
        }
    }

    private Fragment findFragment(int offsetInMaster, int lengthInMaster) {
        Position[] fragments = this.getFragments();
        for (int i = 0; i < fragments.length; ++i) {
            Fragment f = (Fragment)fragments[i];
            if (f.getOffset() > offsetInMaster || offsetInMaster + lengthInMaster > f.getOffset() + f.getLength()) continue;
            return f;
        }
        return null;
    }

    private void internalRemoveMasterDocumentRange(int offsetInMaster, int lengthInMaster) throws BadLocationException {
        try {
            IRegion imageRegion = this.fMapping.toExactImageRegion(new Region(offsetInMaster, lengthInMaster));
            if (imageRegion == null) {
                throw new IllegalArgumentException();
            }
            Fragment fragment = this.findFragment(offsetInMaster, lengthInMaster);
            if (fragment == null) {
                throw new IllegalArgumentException();
            }
            ProjectionDocumentEvent event = new ProjectionDocumentEvent(this, imageRegion.getOffset(), imageRegion.getLength(), null, offsetInMaster, lengthInMaster);
            super.fireDocumentAboutToBeChanged(event);
            if (fragment.getOffset() == offsetInMaster) {
                fragment.setOffset(offsetInMaster + lengthInMaster);
                fragment.setLength(fragment.getLength() - lengthInMaster);
            } else if (fragment.getOffset() + fragment.getLength() == offsetInMaster + lengthInMaster) {
                fragment.setLength(fragment.getLength() - lengthInMaster);
            } else {
                Segment segment;
                Fragment newFragment = new Fragment(offsetInMaster, lengthInMaster);
                newFragment.segment = segment = new Segment(imageRegion.getOffset(), imageRegion.getLength());
                segment.fragment = newFragment;
                this.fMasterDocument.addPosition(this.fFragmentsCategory, newFragment);
                this.addPosition(this.fSegmentsCategory, segment);
                int offset = offsetInMaster + lengthInMaster;
                newFragment = new Fragment(offset, fragment.getOffset() + fragment.getLength() - offset);
                offset = imageRegion.getOffset() + imageRegion.getLength();
                newFragment.segment = segment = new Segment(offset, fragment.segment.getOffset() + fragment.segment.getLength() - offset);
                segment.fragment = newFragment;
                this.fMasterDocument.addPosition(this.fFragmentsCategory, newFragment);
                this.addPosition(this.fSegmentsCategory, segment);
                fragment.setLength(offsetInMaster - fragment.getOffset());
                fragment.segment.setLength(imageRegion.getOffset() - fragment.segment.getOffset());
            }
            this.getTracker().replace(event.getOffset(), event.getLength(), event.getText());
            super.fireDocumentChanged(event);
        }
        catch (BadPositionCategoryException x) {
            this.internalError();
        }
    }

    public final IRegion[] computeUnprojectedMasterRegions(int offsetInMaster, int lengthInMaster) throws BadLocationException {
        int rightEnd;
        IRegion[] fragments = null;
        IRegion imageRegion = this.fMapping.toImageRegion(new Region(offsetInMaster, lengthInMaster));
        if (imageRegion != null) {
            fragments = this.fMapping.toExactOriginRegions(imageRegion);
        }
        if (fragments == null || fragments.length == 0) {
            return new IRegion[]{new Region(offsetInMaster, lengthInMaster)};
        }
        ArrayList<Region> gaps = new ArrayList<Region>();
        IRegion region = fragments[0];
        if (offsetInMaster < region.getOffset()) {
            gaps.add(new Region(offsetInMaster, region.getOffset() - offsetInMaster));
        }
        for (int i = 0; i < fragments.length - 1; ++i) {
            IRegion left = fragments[i];
            IRegion right = fragments[i + 1];
            int leftEnd = left.getOffset() + left.getLength();
            if (leftEnd >= right.getOffset()) continue;
            gaps.add(new Region(leftEnd, right.getOffset() - leftEnd));
        }
        region = fragments[fragments.length - 1];
        int leftEnd = region.getOffset() + region.getLength();
        if (leftEnd < (rightEnd = offsetInMaster + lengthInMaster)) {
            gaps.add(new Region(leftEnd, rightEnd - leftEnd));
        }
        IRegion[] result = new IRegion[gaps.size()];
        gaps.toArray(result);
        return result;
    }

    public void addMasterDocumentRange(int offsetInMaster, int lengthInMaster) throws BadLocationException {
        this.addMasterDocumentRange(offsetInMaster, lengthInMaster, null);
    }

    private void addMasterDocumentRange(int offsetInMaster, int lengthInMaster, DocumentEvent masterDocumentEvent) throws BadLocationException {
        IRegion[] gaps = this.computeUnprojectedMasterRegions(offsetInMaster, lengthInMaster);
        if (gaps == null) {
            return;
        }
        for (int i = 0; i < gaps.length; ++i) {
            IRegion gap = gaps[i];
            this.internalAddMasterDocumentRange(gap.getOffset(), gap.getLength(), masterDocumentEvent);
        }
    }

    public void removeMasterDocumentRange(int offsetInMaster, int lengthInMaster) throws BadLocationException {
        IRegion[] fragments = this.computeProjectedMasterRegions(offsetInMaster, lengthInMaster);
        if (fragments == null || fragments.length == 0) {
            return;
        }
        for (int i = 0; i < fragments.length; ++i) {
            IRegion fragment = fragments[i];
            this.internalRemoveMasterDocumentRange(fragment.getOffset(), fragment.getLength());
        }
    }

    public final IRegion[] computeProjectedMasterRegions(int offsetInMaster, int lengthInMaster) throws BadLocationException {
        IRegion imageRegion = this.fMapping.toImageRegion(new Region(offsetInMaster, lengthInMaster));
        if (imageRegion != null) {
            return this.fMapping.toExactOriginRegions(imageRegion);
        }
        return null;
    }

    protected boolean isUpdating() {
        return this.fIsUpdating;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(int offset, int length, String text) throws BadLocationException {
        try {
            this.fIsUpdating = true;
            if (this.fMasterDocumentExtension != null) {
                this.fMasterDocumentExtension.stopPostNotificationProcessing();
            }
            super.replace(offset, length, text);
            Object var5_4 = null;
            this.fIsUpdating = false;
            if (this.fMasterDocumentExtension != null) {
                this.fMasterDocumentExtension.resumePostNotificationProcessing();
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.fIsUpdating = false;
            if (this.fMasterDocumentExtension != null) {
                this.fMasterDocumentExtension.resumePostNotificationProcessing();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String text) {
        try {
            this.fIsUpdating = true;
            if (this.fMasterDocumentExtension != null) {
                this.fMasterDocumentExtension.stopPostNotificationProcessing();
            }
            super.set(text);
            Object var3_2 = null;
            this.fIsUpdating = false;
            if (this.fMasterDocumentExtension != null) {
                this.fMasterDocumentExtension.resumePostNotificationProcessing();
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.fIsUpdating = false;
            if (this.fMasterDocumentExtension != null) {
                this.fMasterDocumentExtension.resumePostNotificationProcessing();
            }
            throw throwable;
        }
    }

    private ProjectionDocumentEvent normalize(DocumentEvent masterEvent) throws BadLocationException {
        if (!this.isUpdating()) {
            IRegion imageRegion = this.fMapping.toExactImageRegion(new Region(masterEvent.getOffset(), masterEvent.getLength()));
            if (imageRegion != null) {
                return new ProjectionDocumentEvent(this, imageRegion.getOffset(), imageRegion.getLength(), masterEvent.getText(), masterEvent);
            }
            return null;
        }
        ProjectionDocumentEvent event = new ProjectionDocumentEvent(this, this.fOriginalEvent.getOffset(), this.fOriginalEvent.getLength(), this.fOriginalEvent.getText(), masterEvent);
        this.fOriginalEvent = null;
        return event;
    }

    private boolean includes(IRegion region, int offset) {
        if (region == null) {
            return false;
        }
        return region.getOffset() <= offset && offset <= region.getOffset() + region.getLength();
    }

    private boolean includes(IRegion region1, int offset, int length) {
        if (region1 == null) {
            return false;
        }
        return region1.getOffset() <= offset && offset + length <= region1.getOffset() + region1.getLength();
    }

    private IRegion[] computeCoverageGap(DocumentEvent event) {
        Region left = null;
        ArrayList<Region> gaps = new ArrayList<Region>();
        try {
            int index;
            int inclusiveOriginEndOffset;
            int inclusiveImageEndOffset;
            int imageOffset = this.fMapping.toImageOffset(event.getOffset());
            if (imageOffset == -1) {
                Position[] fragments = this.getFragments();
                int index2 = this.fMasterDocument.computeIndexInCategory(this.fFragmentsCategory, event.getOffset());
                if (index2 < fragments.length) {
                    Fragment fragment = (Fragment)fragments[index2];
                    left = new Region(event.getOffset(), fragment.getOffset() - event.getOffset());
                    gaps.add(left);
                }
            }
            if (!this.includes(left, event.getOffset(), event.getLength())) {
                gaps.add(new Region(event.getOffset(), event.getLength()));
            }
            if ((inclusiveImageEndOffset = this.fMapping.toImageOffset(inclusiveOriginEndOffset = event.getOffset() + Math.max(0, event.getLength() - 1))) == -1 && !this.includes(left, inclusiveOriginEndOffset) && 0 < (index = this.fMasterDocument.computeIndexInCategory(this.fFragmentsCategory, inclusiveOriginEndOffset))) {
                Position[] fragments = this.getFragments();
                Fragment fragment = (Fragment)fragments[index - 1];
                gaps.add(new Region(fragment.getOffset(), inclusiveOriginEndOffset + 1 - fragment.getOffset()));
            }
        }
        catch (BadLocationException e) {
            this.internalError();
        }
        catch (BadPositionCategoryException e) {
            this.internalError();
        }
        IRegion[] result = new IRegion[gaps.size()];
        gaps.toArray(result);
        return result;
    }

    protected final boolean adaptProjectionToMasterChange(DocumentEvent masterEvent) throws BadLocationException {
        Position[] fragments;
        if (!this.isUpdating() && this.fFragmentsUpdater.affectsPositions(masterEvent) || this.fIsAutoExpanding) {
            IRegion[] gaps = this.computeCoverageGap(masterEvent);
            for (int i = 0; i < gaps.length; ++i) {
                IRegion gap = gaps[i];
                this.addMasterDocumentRange(gap.getOffset(), gap.getLength(), masterEvent);
            }
            return true;
        }
        if (this.fMapping.getImageLength() == 0 && masterEvent.getLength() == 0 && (fragments = this.getFragments()).length == 0) {
            try {
                Fragment fragment = new Fragment(0, 0);
                this.fMasterDocument.addPosition(this.fFragmentsCategory, fragment);
                this.createSegmentFor(fragment, 0);
            }
            catch (BadPositionCategoryException x) {
                this.internalError();
            }
        }
        return this.isUpdating();
    }

    public void masterDocumentAboutToBeChanged(DocumentEvent masterEvent) {
        try {
            boolean assertNotNull = this.adaptProjectionToMasterChange(masterEvent);
            this.fSlaveEvent = this.normalize(masterEvent);
            if (assertNotNull && this.fSlaveEvent == null) {
                this.internalError();
            }
            this.fMasterEvent = masterEvent;
            if (this.fSlaveEvent != null) {
                this.delayedFireDocumentAboutToBeChanged();
            }
        }
        catch (BadLocationException e) {
            this.internalError();
        }
    }

    public void masterDocumentChanged(DocumentEvent masterEvent) {
        if (!this.isUpdating() && masterEvent == this.fMasterEvent) {
            if (this.fSlaveEvent != null) {
                try {
                    this.getTracker().replace(this.fSlaveEvent.getOffset(), this.fSlaveEvent.getLength(), this.fSlaveEvent.getText());
                    this.fireDocumentChanged(this.fSlaveEvent);
                }
                catch (BadLocationException e) {
                    this.internalError();
                }
            } else if (this.ensureWellFormedSegmentation(masterEvent.getOffset())) {
                this.fMapping.projectionChanged();
            }
        }
    }

    protected void fireDocumentAboutToBeChanged(DocumentEvent event) {
        this.fOriginalEvent = event;
    }

    private void delayedFireDocumentAboutToBeChanged() {
        super.fireDocumentAboutToBeChanged(this.fSlaveEvent);
    }

    protected void fireDocumentChanged(DocumentEvent event) {
        super.fireDocumentChanged(this.fSlaveEvent);
    }

    protected void updateDocumentStructures(DocumentEvent event) {
        super.updateDocumentStructures(event);
        this.ensureWellFormedSegmentation(this.computeAnchor(event));
        this.fMapping.projectionChanged();
    }

    private int computeAnchor(DocumentEvent event) {
        DocumentEvent master;
        ProjectionDocumentEvent slave;
        if (event instanceof ProjectionDocumentEvent && ProjectionDocumentEvent.CONTENT_CHANGE == (slave = (ProjectionDocumentEvent)event).getChangeType() && (master = slave.getMasterEvent()) != null) {
            return master.getOffset();
        }
        return -1;
    }

    private boolean ensureWellFormedSegmentation(int anchorOffset) {
        Position[] changedSegments;
        boolean changed = false;
        Position[] segments = this.getSegments();
        for (int i = 0; i < segments.length; ++i) {
            Fragment fragment;
            Segment next;
            Segment segment = (Segment)segments[i];
            if (segment.isDeleted() || segment.getLength() == 0) {
                try {
                    this.removePosition(this.fSegmentsCategory, segment);
                    this.fMasterDocument.removePosition(this.fFragmentsCategory, segment.fragment);
                    changed = true;
                }
                catch (BadPositionCategoryException e) {
                    this.internalError();
                }
                continue;
            }
            if (i >= segments.length - 1 || (next = (Segment)segments[i + 1]).isDeleted() || next.getLength() == 0 || (fragment = segment.fragment).getOffset() + fragment.getLength() != next.fragment.getOffset()) continue;
            segment.setLength(segment.getLength() + next.getLength());
            fragment.setLength(fragment.getLength() + next.fragment.getLength());
            next.delete();
        }
        if (changed && anchorOffset != -1 && ((changedSegments = this.getSegments()) == null || changedSegments.length == 0)) {
            Fragment fragment = new Fragment(anchorOffset, 0);
            try {
                this.fMasterDocument.addPosition(this.fFragmentsCategory, fragment);
                this.createSegmentFor(fragment, 0);
            }
            catch (BadLocationException e) {
                this.internalError();
            }
            catch (BadPositionCategoryException e) {
                this.internalError();
            }
        }
        return changed;
    }

    public void registerPostNotificationReplace(IDocumentListener owner, IDocumentExtension.IReplace replace) {
        if (!this.isUpdating()) {
            throw new UnsupportedOperationException();
        }
        super.registerPostNotificationReplace(owner, replace);
    }

    public void setAutoExpandMode(boolean autoExpandMode) {
        this.fIsAutoExpanding = autoExpandMode;
    }

    public void replaceMasterDocumentRanges(int offsetInMaster, int lengthInMaster) throws BadLocationException {
        try {
            ProjectionDocumentEvent event = new ProjectionDocumentEvent(this, 0, this.fMapping.getImageLength(), this.fMasterDocument.get(offsetInMaster, lengthInMaster), offsetInMaster, lengthInMaster);
            super.fireDocumentAboutToBeChanged(event);
            Position[] fragments = this.getFragments();
            for (int i = 0; i < fragments.length; ++i) {
                Fragment fragment = (Fragment)fragments[i];
                this.fMasterDocument.removePosition(this.fFragmentsCategory, fragment);
                this.removePosition(this.fSegmentsCategory, fragment.segment);
            }
            Fragment fragment = new Fragment(offsetInMaster, lengthInMaster);
            Segment segment = new Segment(0, 0);
            segment.fragment = fragment;
            fragment.segment = segment;
            this.fMasterDocument.addPosition(this.fFragmentsCategory, fragment);
            this.addPosition(this.fSegmentsCategory, segment);
            this.getTracker().set(this.fMasterDocument.get(offsetInMaster, lengthInMaster));
            super.fireDocumentChanged(event);
        }
        catch (BadPositionCategoryException x) {
            this.internalError();
        }
    }
}

