/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.display;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ICompletionRequestor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.display.DisplayMessages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposalComparator;
import org.eclipse.jdt.internal.ui.text.java.JavaParameterListValidator;
import org.eclipse.jdt.internal.ui.text.java.ResultCollector;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateEngine;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateProposal;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.swt.widgets.Shell;

public class DisplayCompletionProcessor
implements IContentAssistProcessor {
    private ResultCollector fCollector = new ResultCollector();
    private IContextInformationValidator fValidator;
    private TemplateEngine fTemplateEngine;
    private char[] fProposalAutoActivationSet;
    private JavaCompletionProposalComparator fComparator;
    static /* synthetic */ Class class$org$eclipse$jdt$debug$core$IJavaStackFrame;

    public DisplayCompletionProcessor() {
        TemplateContextType contextType = JavaPlugin.getDefault().getTemplateContextRegistry().getContextType("java");
        if (contextType != null) {
            this.fTemplateEngine = new TemplateEngine(contextType);
        }
        this.fComparator = new JavaCompletionProposalComparator();
    }

    public String getErrorMessage() {
        return this.fCollector.getErrorMessage();
    }

    public IContextInformationValidator getContextInformationValidator() {
        if (this.fValidator == null) {
            this.fValidator = new JavaParameterListValidator();
        }
        return this.fValidator;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        IAdaptable context = DebugUITools.getDebugContext();
        if (context == null) {
            return new ICompletionProposal[0];
        }
        IJavaStackFrame stackFrame = (IJavaStackFrame)context.getAdapter(class$org$eclipse$jdt$debug$core$IJavaStackFrame == null ? (class$org$eclipse$jdt$debug$core$IJavaStackFrame = DisplayCompletionProcessor.class$("org.eclipse.jdt.debug.core.IJavaStackFrame")) : class$org$eclipse$jdt$debug$core$IJavaStackFrame);
        if (stackFrame == null) {
            return new ICompletionProposal[0];
        }
        return this.computeCompletionProposals(stackFrame, viewer, documentOffset);
    }

    protected ICompletionProposal[] computeCompletionProposals(IJavaStackFrame stackFrame, ITextViewer viewer, int documentOffset) {
        try {
            IJavaProject project = this.getJavaProject((IStackFrame)stackFrame);
            if (project != null) {
                IType receivingType = this.getReceivingType(project, stackFrame);
                if (receivingType == null) {
                    return new ICompletionProposal[0];
                }
                IJavaVariable[] variables = stackFrame.getLocalVariables();
                char[][] localVariableNames = new char[variables.length][];
                char[][] localVariableTypeNames = new char[variables.length][];
                this.resolveLocalVariables((IVariable[])variables, localVariableNames, localVariableTypeNames);
                ITextSelection selection = (ITextSelection)viewer.getSelectionProvider().getSelection();
                this.configureResultCollector(project, selection);
                int[] localModifiers = new int[localVariableNames.length];
                Arrays.fill(localModifiers, 0);
                int insertionPosition = this.computeInsertionPosition(receivingType, stackFrame);
                receivingType.codeComplete(viewer.getDocument().get().toCharArray(), insertionPosition, documentOffset, (char[][])localVariableTypeNames, (char[][])localVariableNames, localModifiers, stackFrame.isStatic(), (ICompletionRequestor)this.fCollector);
                JavaCompletionProposal[] results = this.fCollector.getResults();
                if (this.fTemplateEngine != null) {
                    this.fTemplateEngine.reset();
                    this.fTemplateEngine.complete(viewer, documentOffset, null);
                    TemplateProposal[] templateResults = this.fTemplateEngine.getResults();
                    IJavaCompletionProposal[] total = new IJavaCompletionProposal[results.length + templateResults.length];
                    System.arraycopy(templateResults, 0, total, 0, templateResults.length);
                    System.arraycopy(results, 0, total, templateResults.length, results.length);
                    results = total;
                }
                return this.order((IJavaCompletionProposal[])results);
            }
        }
        catch (JavaModelException x) {
            this.handle(viewer, (CoreException)((Object)x));
        }
        catch (DebugException de) {
            this.handle(viewer, (CoreException)((Object)de));
        }
        return null;
    }

    protected int computeInsertionPosition(IType receivingType, IJavaStackFrame stackFrame) throws JavaModelException, DebugException {
        int insertion = -1;
        if (!receivingType.isBinary() && receivingType.getDeclaringType() == null) {
            ICompilationUnit stackCU = this.getCompilationUnit(stackFrame);
            ICompilationUnit typeCU = receivingType.getCompilationUnit();
            if (typeCU != null && typeCU.equals(stackCU) && stackCU != null) {
                Document doc = new Document(stackCU.getSource());
                try {
                    insertion = doc.getLineOffset(stackFrame.getLineNumber() - 1);
                }
                catch (BadLocationException e) {
                    JDIDebugUIPlugin.log(e);
                }
            }
        }
        return insertion;
    }

    protected ICompilationUnit getCompilationUnit(IJavaStackFrame stackFrame) {
        ILaunch launch = stackFrame.getLaunch();
        if (launch == null) {
            return null;
        }
        ISourceLocator locator = launch.getSourceLocator();
        if (locator == null) {
            return null;
        }
        Object sourceElement = locator.getSourceElement((IStackFrame)stackFrame);
        if (sourceElement instanceof IType) {
            return ((IType)sourceElement).getCompilationUnit();
        }
        if (sourceElement instanceof ICompilationUnit) {
            return (ICompilationUnit)sourceElement;
        }
        return null;
    }

    protected void handle(ITextViewer viewer, CoreException x) {
        Shell shell = viewer.getTextWidget().getShell();
        ErrorDialog.openError((Shell)shell, (String)DisplayMessages.getString("DisplayCompletionProcessor.Problems_during_completion_1"), (String)DisplayMessages.getString("DisplayCompletionProcessor.An_exception_occurred_during_code_completion_2"), (IStatus)x.getStatus());
        JDIDebugUIPlugin.log(x);
    }

    protected void resolveLocalVariables(IVariable[] variables, char[][] localVariableNames, char[][] localVariableTypeNames) throws DebugException {
        for (int i = 0; i < variables.length; ++i) {
            IVariable variable = variables[i];
            localVariableNames[i] = variable.getName().toCharArray();
            localVariableTypeNames[i] = this.getTranslatedTypeName(variable.getReferenceTypeName()).toCharArray();
        }
    }

    protected IJavaProject getJavaProject(IStackFrame stackFrame) {
        IJavaProject project;
        ILaunch launch = stackFrame.getLaunch();
        if (launch == null) {
            return null;
        }
        ISourceLocator locator = launch.getSourceLocator();
        if (locator == null) {
            return null;
        }
        Object sourceElement = locator.getSourceElement(stackFrame);
        if (sourceElement instanceof IJavaElement) {
            return ((IJavaElement)sourceElement).getJavaProject();
        }
        if (sourceElement instanceof IResource && (project = JavaCore.create((IProject)((IResource)sourceElement).getProject())).exists()) {
            return project;
        }
        return null;
    }

    protected IJavaCompletionProposal[] order(IJavaCompletionProposal[] proposals) {
        Arrays.sort(proposals, this.fComparator);
        return proposals;
    }

    protected void configureResultCollector(IJavaProject project, ITextSelection selection) {
        this.fCollector.reset(selection.getOffset(), project, null);
        if (selection.getLength() != 0) {
            this.fCollector.setReplacementLength(selection.getLength());
        }
    }

    protected String[] getNestedTypeNames(String typeName) {
        int index = typeName.lastIndexOf(46);
        if (index >= 0) {
            typeName = typeName.substring(index + 1);
        }
        index = typeName.indexOf(36);
        ArrayList<String> list = new ArrayList<String>(1);
        while (index >= 0) {
            list.add(typeName.substring(0, index));
            typeName = typeName.substring(index + 1);
            index = typeName.indexOf(36);
        }
        list.add(typeName);
        return list.toArray(new String[list.size()]);
    }

    protected String getTranslatedTypeName(String typeName) {
        int index = typeName.lastIndexOf(36);
        if (index == -1) {
            return typeName;
        }
        if (index + 1 > typeName.length()) {
            return typeName;
        }
        String last = typeName.substring(index + 1);
        try {
            Integer.parseInt(last);
            return null;
        }
        catch (NumberFormatException e) {
            return typeName.replace('$', '.');
        }
    }

    private IType getReceivingType(IJavaProject project, IJavaStackFrame frame) throws DebugException {
        String typeName = frame.getReceivingTypeName();
        String sourceName = frame.getSourceName();
        if (sourceName == null || !typeName.equals(frame.getDeclaringTypeName())) {
            int dollarIndex = typeName.indexOf(36);
            if (dollarIndex >= 0) {
                typeName = typeName.substring(0, dollarIndex);
            }
            typeName = typeName.replace('.', '/');
            typeName = typeName + ".java";
        } else {
            int index = typeName.lastIndexOf(46);
            if (index >= 0) {
                typeName = typeName.substring(0, index + 1);
                typeName = typeName.replace('.', '/');
            } else {
                typeName = "";
            }
            typeName = typeName + sourceName;
        }
        return this.getType(project, frame.getReceivingTypeName(), typeName);
    }

    public void orderProposalsAlphabetically(boolean order) {
        this.fComparator.setOrderAlphabetically(order);
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.fProposalAutoActivationSet;
    }

    public void setCompletionProposalAutoActivationCharacters(char[] activationSet) {
        this.fProposalAutoActivationSet = activationSet;
    }

    protected ResultCollector getCollector() {
        return this.fCollector;
    }

    protected void setCollector(ResultCollector collector) {
        this.fCollector = collector;
    }

    protected IType getType(IJavaProject project, String originalTypeName, String typeName) throws DebugException {
        int dollarIndex = typeName.indexOf(36);
        if (dollarIndex > 0) {
            typeName = typeName.substring(0, dollarIndex);
        }
        Path sourcePath = new Path(typeName);
        IType type = null;
        try {
            IJavaElement result = project.findElement((IPath)sourcePath);
            String[] typeNames = this.getNestedTypeNames(originalTypeName);
            if (result != null) {
                if (result instanceof IClassFile) {
                    type = ((IClassFile)result).getType();
                } else if (result instanceof ICompilationUnit) {
                    type = ((ICompilationUnit)result).getType(typeNames[0]);
                } else if (result instanceof IType) {
                    type = (IType)result;
                }
            }
            for (int i = 1; i < typeNames.length; ++i) {
                String innerTypeName = typeNames[i];
                try {
                    Integer.parseInt(innerTypeName);
                    return type;
                }
                catch (NumberFormatException e) {
                    type = type.getType(innerTypeName);
                    continue;
                }
            }
        }
        catch (JavaModelException e) {
            throw new DebugException(e.getStatus());
        }
        return type;
    }

    public TemplateEngine getTemplateEngine() {
        return this.fTemplateEngine;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

