/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import org.eclipse.debug.internal.ui.views.expression.PopupInformationControl;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.DisplayAction;
import org.eclipse.jdt.internal.debug.ui.display.DisplayView;
import org.eclipse.jdt.internal.debug.ui.display.IDataDisplay;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class PopupDisplayAction
extends DisplayAction
implements IInformationProvider {
    public static final String ACTION_DEFINITION_ID = "org.eclipse.jdt.debug.ui.commands.Display";
    private ITextViewer viewer;
    private String snippet;
    private String resultString;
    static /* synthetic */ Class class$org$eclipse$jface$text$ITextViewer;

    public String getInformation(ITextViewer textViewer, IRegion subject) {
        return this.resultString;
    }

    public IRegion getSubject(ITextViewer textViewer, int offset) {
        return this.getRegion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showPopup() {
        InformationPresenter infoPresenter = new InformationPresenter(new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DisplayInformationControl(parent, ActionMessages.getString("PopupDisplayAction.2"), PopupDisplayAction.ACTION_DEFINITION_ID);
            }
        });
        Point p = this.viewer.getSelectedRange();
        IDocument doc = this.viewer.getDocument();
        try {
            String contentType = doc.getContentType(p.x);
            infoPresenter.setInformationProvider((IInformationProvider)this, contentType);
            infoPresenter.install(this.viewer);
            infoPresenter.showInformation();
        }
        catch (BadLocationException e) {
            return;
        }
        finally {
            this.viewer = null;
            this.evaluationCleanup();
        }
    }

    protected void displayStringResult(String currentSnippet, String currentResultString) {
        IWorkbenchPart part = this.getTargetPart();
        if (part instanceof DisplayView) {
            super.displayStringResult(currentSnippet, currentResultString);
            return;
        }
        this.viewer = (ITextViewer)part.getAdapter(class$org$eclipse$jface$text$ITextViewer == null ? (class$org$eclipse$jface$text$ITextViewer = PopupDisplayAction.class$("org.eclipse.jface.text.ITextViewer")) : class$org$eclipse$jface$text$ITextViewer);
        if (this.viewer == null && part instanceof JavaEditor) {
            this.viewer = ((JavaEditor)part).getViewer();
        }
        if (this.viewer == null) {
            super.displayStringResult(currentSnippet, currentResultString);
        } else {
            this.snippet = currentSnippet;
            this.resultString = currentResultString;
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    PopupDisplayAction.this.showPopup();
                }
            });
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DisplayInformationControl
    extends PopupInformationControl {
        private StyledText text;

        DisplayInformationControl(Shell shell, String label, String actionDefinitionId) {
            super(shell, label, actionDefinitionId);
        }

        public Control createControl(Composite parent) {
            GridData gd = new GridData(1808);
            this.text = new StyledText(parent, 842);
            this.text.setLayoutData((Object)gd);
            this.text.setForeground(parent.getDisplay().getSystemColor(28));
            this.text.setBackground(parent.getDisplay().getSystemColor(29));
            return this.text;
        }

        protected IDialogSettings getDialogSettings() {
            return JDIDebugUIPlugin.getDefault().getDialogSettings();
        }

        protected void performCommand() {
            IDataDisplay dataDisplay;
            IDataDisplay directDisplay = PopupDisplayAction.this.getDirectDataDisplay();
            Display display = JDIDebugUIPlugin.getStandardDisplay();
            if (!display.isDisposed() && (dataDisplay = PopupDisplayAction.this.getDataDisplay()) != null) {
                if (directDisplay == null) {
                    dataDisplay.displayExpression(PopupDisplayAction.this.snippet);
                }
                dataDisplay.displayExpressionValue(PopupDisplayAction.this.resultString);
            }
        }

        public boolean hasContents() {
            return this.text != null && this.text.getCharCount() > 0;
        }

        public void setInformation(String information) {
            if (information != null) {
                this.text.setFont(PopupDisplayAction.this.viewer.getTextWidget().getFont());
                this.text.setText(information);
            }
        }
    }
}

