/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.RectangleAnimation;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;
import org.eclipse.ui.internal.util.BundleUtility;

public class ProgressManagerUtil {
    public static long SHORT_OPERATION_TIME = 250L;
    private static String ellipsis = ProgressMessages.getString("ProgressFloatingWindow.EllipsisValue");

    static IStatus exceptionStatus(Throwable exception) {
        return StatusUtil.newStatus(4, exception.getMessage() == null ? "" : exception.getMessage(), exception);
    }

    static void logException(Throwable exception) {
        BundleUtility.log("org.eclipse.ui", exception);
    }

    static ViewerSorter getProgressViewerSorter() {
        return new ViewerSorter(){

            public int compare(Viewer testViewer, Object e1, Object e2) {
                return ((Comparable)e1).compareTo(e2);
            }
        };
    }

    static void openProgressView(WorkbenchWindow window) {
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        try {
            page.showView("org.eclipse.ui.views.ProgressView");
        }
        catch (PartInitException exception) {
            ProgressManagerUtil.logException((Throwable)((Object)exception));
        }
    }

    static boolean missingProgressView(WorkbenchWindow window) {
        return WorkbenchPlugin.getDefault().getViewRegistry().find("org.eclipse.ui.views.ProgressView") == null;
    }

    static String shortenText(String textValue, Control control) {
        int pivot;
        if (textValue == null) {
            return null;
        }
        Display display = control.getDisplay();
        GC gc = new GC((Drawable)display);
        int maxWidth = control.getBounds().width - 5;
        if (gc.textExtent((String)textValue).x < maxWidth) {
            gc.dispose();
            return textValue;
        }
        int length = textValue.length();
        int ellipsisWidth = gc.textExtent((String)ProgressManagerUtil.ellipsis).x;
        int secondWord = ProgressManagerUtil.findSecondWhitespace(textValue, gc, maxWidth);
        int start = pivot = (length - secondWord) / 2 + secondWord;
        for (int end = pivot + 1; start >= secondWord && end < length; --start, ++end) {
            String s1 = textValue.substring(0, start);
            String s2 = textValue.substring(end, length);
            int l1 = gc.textExtent((String)s1).x;
            int l2 = gc.textExtent((String)s2).x;
            if (l1 + ellipsisWidth + l2 >= maxWidth) continue;
            gc.dispose();
            return s1 + ellipsis + s2;
        }
        gc.dispose();
        return textValue;
    }

    private static int findSecondWhitespace(String textValue, GC gc, int maxWidth) {
        int firstCharacter = 0;
        char[] chars = textValue.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (!Character.isWhitespace(chars[i])) continue;
            firstCharacter = i;
            break;
        }
        if (firstCharacter == 0) {
            return 0;
        }
        int secondCharacter = firstCharacter;
        for (int i = firstCharacter; i < chars.length; ++i) {
            if (!Character.isWhitespace(chars[i])) continue;
            secondCharacter = i;
            break;
        }
        if (gc.textExtent((String)textValue.substring((int)0, (int)secondCharacter)).x > maxWidth) {
            if (gc.textExtent((String)textValue.substring((int)0, (int)firstCharacter)).x > maxWidth) {
                return 0;
            }
            return firstCharacter;
        }
        return secondCharacter;
    }

    public static boolean rescheduleIfModalShellOpen(Job openJob) {
        Shell modal = ProgressManagerUtil.getModalShell();
        if (modal == null) {
            return false;
        }
        openJob.schedule((long)PlatformUI.getWorkbench().getProgressService().getLongOperationTime());
        return true;
    }

    public static boolean safeToOpen(ProgressMonitorJobsDialog dialog) {
        Shell modal = ProgressManagerUtil.getModalShell();
        if (modal == null) {
            return true;
        }
        dialog.watchTicks();
        return false;
    }

    public static Shell getModalShell() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        Shell[] shells = workbench.getDisplay().getShells();
        int modal = 229376;
        for (int i = 0; i < shells.length; ++i) {
            int style;
            if (!shells[i].isVisible() || ((style = shells[i].getStyle()) & modal) == 0) continue;
            return shells[i];
        }
        return null;
    }

    public static Shell getDefaultParent() {
        Shell modal = ProgressManagerUtil.getModalShell();
        if (modal != null) {
            return modal;
        }
        return ProgressManagerUtil.getNonModalShell();
    }

    public static Shell getNonModalShell() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static void animateDown(Rectangle startPosition) {
        IWorkbenchWindow currentWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (currentWindow == null) {
            return;
        }
        WorkbenchWindow internalWindow = (WorkbenchWindow)currentWindow;
        Rectangle end = internalWindow.getProgressRegion().getControl().getBounds();
        Point windowLocation = internalWindow.getShell().getLocation();
        end.x += windowLocation.x;
        end.y += windowLocation.y;
        RectangleAnimation animation = new RectangleAnimation(internalWindow.getShell(), startPosition, end);
        animation.schedule();
    }

    public static void animateUp(Rectangle endPosition) {
        IWorkbenchWindow currentWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (currentWindow == null) {
            return;
        }
        WorkbenchWindow internalWindow = (WorkbenchWindow)currentWindow;
        Point windowLocation = internalWindow.getShell().getLocation();
        Rectangle region = internalWindow.getProgressRegion().getControl().getBounds();
        region.x += windowLocation.x;
        region.y += windowLocation.y;
        RectangleAnimation animation = new RectangleAnimation(internalWindow.getShell(), region, endPosition);
        animation.schedule();
    }
}

