/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.console;

import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.console.MessageConsole;

public class MessageConsoleStream {
    private MessageConsole fConsole = null;
    private Color fColor = null;

    public MessageConsoleStream(MessageConsole console) {
        this.fConsole = console;
    }

    public void print(String message) {
        this.fConsole.appendToDocument(message, this);
    }

    public void println() {
        this.print("\n");
    }

    public void println(String message) {
        this.print(message);
        this.println();
    }

    public void setColor(Color color) {
        Color old = this.fColor;
        this.fColor = color;
        this.fConsole.firePropertyChange(this, MessageConsole.P_STREAM_COLOR, old, color);
    }

    public Color getColor() {
        return this.fColor;
    }

    public MessageConsole getConsole() {
        return this.fConsole;
    }
}

