/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.AntCorePreferences;
import org.eclipse.ant.core.Type;
import org.eclipse.ant.internal.ui.preferences.AddCustomDialog;
import org.eclipse.ant.internal.ui.preferences.AntObjectLabelProvider;
import org.eclipse.ant.internal.ui.preferences.AntPage;
import org.eclipse.ant.internal.ui.preferences.AntPreferencesMessages;
import org.eclipse.ant.internal.ui.preferences.AntRuntimePreferencePage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class AntTypesPage
extends AntPage {
    private static final int ADD_TYPE_BUTTON = 1025;
    private static final int EDIT_TYPE_BUTTON = 1026;
    private static final int REMOVE_BUTTON = 1027;
    private final AntObjectLabelProvider labelProvider = new AntObjectLabelProvider();

    public AntTypesPage(AntRuntimePreferencePage preferencePage) {
        super(preferencePage);
    }

    protected void addButtonsToButtonGroup(Composite parent) {
        this.createPushButton(parent, AntPreferencesMessages.getString("AntTypesPage.2"), 1025);
        this.editButton = this.createPushButton(parent, AntPreferencesMessages.getString("AntTypesPage.3"), 1026);
        this.removeButton = this.createPushButton(parent, AntPreferencesMessages.getString("AntTypesPage.1"), 1027);
    }

    private void addType() {
        String title = AntPreferencesMessages.getString("AntTypesPage.addTypeDialogTitle");
        AddCustomDialog dialog = this.getCustomDialog(title, "org.eclipse.ant.ui.add_type_dialog_context");
        if (dialog.open() == 1) {
            return;
        }
        Type type = new Type();
        type.setTypeName(dialog.getName());
        type.setClassName(dialog.getClassName());
        type.setLibraryEntry(dialog.getLibraryEntry());
        this.addContent(type);
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1025: {
                this.addType();
                break;
            }
            case 1026: {
                this.edit(this.getSelection());
                break;
            }
            case 1027: {
                this.remove();
            }
        }
    }

    protected TabItem createTabItem(TabFolder folder) {
        TabItem item = new TabItem(folder, 0);
        item.setText(AntPreferencesMessages.getString("AntTypesPage.typesPageTitle"));
        item.setImage(this.labelProvider.getTypeImage());
        item.setData((Object)this);
        Composite top = new Composite((Composite)folder, 0);
        top.setFont(folder.getFont());
        item.setControl((Control)this.createContents(top));
        this.connectToFolder(item, folder);
        return item;
    }

    protected void edit(IStructuredSelection selection) {
        Type type = (Type)selection.getFirstElement();
        String title = AntPreferencesMessages.getString("AntTypesPage.editTypeDialogTitle");
        AddCustomDialog dialog = this.getCustomDialog(title, "org.eclipse.ant.ui.edit_type_dialog_context");
        dialog.setClassName(type.getClassName());
        dialog.setName(type.getTypeName());
        dialog.setLibraryEntry(type.getLibraryEntry());
        if (dialog.open() == 1) {
            return;
        }
        type.setTypeName(dialog.getName());
        type.setClassName(dialog.getClassName());
        type.setLibraryEntry(dialog.getLibraryEntry());
        this.updateContent(type);
    }

    private AddCustomDialog getCustomDialog(String title, String helpContext) {
        Iterator types = this.getContents(true).iterator();
        ArrayList<String> names = new ArrayList<String>();
        while (types.hasNext()) {
            Type aTask = (Type)types.next();
            names.add(aTask.getTypeName());
        }
        AddCustomDialog dialog = new AddCustomDialog(this.getShell(), this.getPreferencePage().getLibraryEntries(), names, helpContext);
        dialog.setTitle(title);
        dialog.setAlreadyExistsErrorMsg(AntPreferencesMessages.getString("AntTypesPage.8"));
        dialog.setNoNameErrorMsg(AntPreferencesMessages.getString("AntTypesPage.9"));
        return dialog;
    }

    protected ITableLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    protected void initialize() {
        AntCorePreferences prefs = AntCorePlugin.getPlugin().getPreferences();
        this.setInput(prefs.getTypes());
    }

    protected String getHelpContextId() {
        return "org.eclipse.ant.ui.ant_types_page_context";
    }
}

