/* $NetBSD$ */

/*
 * 2009 Jared D. McNeill <jmcneill@invisible.ca>
 * Public domain.
 */
/*  Modified by Don Hayford, Feb 2009
 */

#include <sys/ioctl.h>
#include <sys/videoio.h>

#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "jpeg_mangle.h"

static void
usage(void)
{
	fprintf(stderr, "usage: %s device filename time_int(secs)\n", getprogname());
	exit(EXIT_FAILURE);
}

static void
show_video_format(struct v4l2_format *fmt)
{
	printf("video format info\n\theight: %d\n", fmt->fmt.pix.height);
	printf("\twidth: %d\n",fmt->fmt.pix.width);
	printf("\tbytes per line: %d\n", fmt->fmt.pix.bytesperline);
	printf("\timage size: %d\n",fmt->fmt.pix.sizeimage);
	printf("\tpixel format: %04x\n", fmt->fmt.pix.pixelformat);
	printf("\tenum field:%d\n", fmt->fmt.pix.field);
}

int
main(int argc, char *argv[])
{
	struct v4l2_format fmt;
	uint8_t *buf;
	int ifd, ofd;
	int error;
	size_t frlen;
	ssize_t rdlen, wrlen;
	size_t huff_offset;
	uint sleep_time;

	if (argc != 4)
		usage();
		/* NOTREACHED */
	sleep_time = atoi(argv[3]);
	if(sleep_time == 0)
		sleep_time = 5;
	ifd = open(argv[1], O_RDONLY);
	if (ifd < 0) {
		perror("open camera failed");
		return EXIT_FAILURE;
	}
	ofd = open(argv[2], O_RDWR|O_CREAT, 0644);
	if (ofd < 0) {
		perror("open output failed");
		return EXIT_FAILURE;
	}
	error = ioctl(ifd, VIDIOC_G_FMT, &fmt);
	if (error) {
		perror("VIDIOC_G_FMT failed");
		return EXIT_FAILURE;
	}
	show_video_format(&fmt);
	printf("sleep time: %d\n", sleep_time);
	frlen = fmt.fmt.pix.width * fmt.fmt.pix.bytesperline;
	buf = malloc(frlen);
	if (buf == NULL) {
		perror("malloc failed");
		return EXIT_FAILURE;
	}
//	read two frames, use the second
	for(; ;) {
		rdlen = read(ifd, buf, frlen);
		if (rdlen == -1) {
			perror("read camera");
			return EXIT_FAILURE;
		}
		rdlen = read(ifd, buf, frlen);
		if (rdlen == -1) {
			perror("read camera failed");
			return EXIT_FAILURE;
		}
		if(lseek(ofd, 0, SEEK_SET) == -1) {
			perror("seek failure");
			return EXIT_FAILURE;
		}
		if(jpeg_mangle_get_huffman_offset(buf, rdlen, &huff_offset) == TRUE) {
			if(write(ofd, buf, huff_offset) != -1) {
				if(write(ofd, jpeg_mangle_get_default_huffman_tables(),
				jpeg_mangle_get_sizeof_default_huffman_tables()) != -1) {
					if(write(ofd, buf + huff_offset, rdlen - huff_offset) != -1)
						;
				}
			}
			else {
				perror("write output failed");
				return EXIT_FAILURE;
			}
		}
		else {
			perror("Couldn't get Huffman offset");
			return EXIT_FAILURE;
		}
		sleep(sleep_time);
	}
	return EXIT_SUCCESS;
}

