/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.tcp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.rmi.server.LogStream;
import java.rmi.server.RMIFailureHandler;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.UID;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import sun.rmi.runtime.Log;
import sun.rmi.runtime.NewThreadAction;
import sun.rmi.transport.Connection;
import sun.rmi.transport.DGCAckHandler;
import sun.rmi.transport.Endpoint;
import sun.rmi.transport.StreamRemoteCall;
import sun.rmi.transport.Target;
import sun.rmi.transport.Transport;
import sun.rmi.transport.proxy.HttpReceiveSocket;
import sun.rmi.transport.tcp.ConnectionMultiplexer;
import sun.rmi.transport.tcp.TCPChannel;
import sun.rmi.transport.tcp.TCPConnection;
import sun.rmi.transport.tcp.TCPEndpoint;
import sun.security.action.GetIntegerAction;
import sun.security.action.GetLongAction;
import sun.security.action.GetPropertyAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCPTransport
extends Transport {
    static final Log tcpLog = Log.getLog("sun.rmi.transport.tcp", "tcp", LogStream.parseLevel(AccessController.doPrivileged(new GetPropertyAction("sun.rmi.transport.tcp.logLevel"))));
    private static final int maxConnectionThreads = AccessController.doPrivileged(new GetIntegerAction("sun.rmi.transport.tcp.maxConnectionThreads", Integer.MAX_VALUE));
    private static final long threadKeepAliveTime = AccessController.doPrivileged(new GetLongAction("sun.rmi.transport.tcp.threadKeepAliveTime", 60000L));
    private static final ExecutorService connectionThreadPool = new ThreadPoolExecutor(0, maxConnectionThreads, threadKeepAliveTime, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){

        public Thread newThread(Runnable runnable) {
            return AccessController.doPrivileged(new NewThreadAction(runnable, "TCP Connection(idle)", true, true));
        }
    });
    private static final AtomicInteger connectionCount = new AtomicInteger(0);
    private static final ThreadLocal<ConnectionHandler> threadConnectionHandler = new ThreadLocal();
    private final LinkedList<TCPEndpoint> epList;
    private int exportCount = 0;
    private ServerSocket server = null;
    private final Map<TCPEndpoint, Reference<TCPChannel>> channelTable = new WeakHashMap<TCPEndpoint, Reference<TCPChannel>>();
    static final RMISocketFactory defaultSocketFactory = RMISocketFactory.getDefaultSocketFactory();
    private static final int connectionReadTimeout = AccessController.doPrivileged(new GetIntegerAction("sun.rmi.transport.tcp.readTimeout", 0x6DDD00));

    TCPTransport(LinkedList<TCPEndpoint> linkedList) {
        this.epList = linkedList;
        if (tcpLog.isLoggable(Log.BRIEF)) {
            tcpLog.log(Log.BRIEF, "Version = 2, ep = " + this.getEndpoint());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shedConnectionCaches() {
        ArrayList<TCPChannel> arrayList;
        Map<TCPEndpoint, Reference<TCPChannel>> map = this.channelTable;
        synchronized (map) {
            arrayList = new ArrayList<TCPChannel>(this.channelTable.values().size());
            for (Reference<TCPChannel> reference : this.channelTable.values()) {
                TCPChannel tCPChannel = reference.get();
                if (tCPChannel == null) continue;
                arrayList.add(tCPChannel);
            }
        }
        for (TCPChannel tCPChannel : arrayList) {
            tCPChannel.shedCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TCPChannel getChannel(Endpoint endpoint) {
        TCPChannel tCPChannel = null;
        if (endpoint instanceof TCPEndpoint) {
            Map<TCPEndpoint, Reference<TCPChannel>> map = this.channelTable;
            synchronized (map) {
                Reference<TCPChannel> reference = this.channelTable.get(endpoint);
                if (reference != null) {
                    tCPChannel = reference.get();
                }
                if (tCPChannel == null) {
                    TCPEndpoint tCPEndpoint = (TCPEndpoint)endpoint;
                    tCPChannel = new TCPChannel(this, tCPEndpoint);
                    this.channelTable.put(tCPEndpoint, new WeakReference<TCPChannel>(tCPChannel));
                }
            }
        }
        return tCPChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void free(Endpoint endpoint) {
        if (endpoint instanceof TCPEndpoint) {
            Map<TCPEndpoint, Reference<TCPChannel>> map = this.channelTable;
            synchronized (map) {
                TCPChannel tCPChannel;
                Reference<TCPChannel> reference = this.channelTable.remove(endpoint);
                if (reference != null && (tCPChannel = reference.get()) != null) {
                    tCPChannel.shedCache();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportObject(Target target) throws RemoteException {
        block11: {
            TCPTransport tCPTransport;
            TCPTransport tCPTransport2 = this;
            synchronized (tCPTransport2) {
                this.listen();
                ++this.exportCount;
            }
            boolean bl = false;
            try {
                super.exportObject(target);
                bl = true;
                Object var5_5 = null;
                if (bl) break block11;
                tCPTransport = this;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (!bl) {
                    TCPTransport tCPTransport3 = this;
                    synchronized (tCPTransport3) {
                        this.decrementExportCount();
                    }
                }
                throw throwable;
            }
            synchronized (tCPTransport) {
                this.decrementExportCount();
            }
        }
    }

    @Override
    protected synchronized void targetUnexported() {
        this.decrementExportCount();
    }

    private void decrementExportCount() {
        assert (Thread.holdsLock(this));
        --this.exportCount;
        if (this.exportCount == 0 && this.getEndpoint().getListenPort() != 0) {
            ServerSocket serverSocket = this.server;
            this.server = null;
            try {
                serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void checkAcceptPermission(AccessControlContext accessControlContext) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return;
        }
        ConnectionHandler connectionHandler = threadConnectionHandler.get();
        if (connectionHandler == null) {
            throw new Error("checkAcceptPermission not in ConnectionHandler thread");
        }
        connectionHandler.checkAcceptPermission(securityManager, accessControlContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TCPEndpoint getEndpoint() {
        LinkedList<TCPEndpoint> linkedList = this.epList;
        synchronized (linkedList) {
            return this.epList.getLast();
        }
    }

    private void listen() throws RemoteException {
        assert (Thread.holdsLock(this));
        TCPEndpoint tCPEndpoint = this.getEndpoint();
        int n = tCPEndpoint.getPort();
        if (this.server == null) {
            if (tcpLog.isLoggable(Log.BRIEF)) {
                tcpLog.log(Log.BRIEF, "(port " + n + ") create server socket");
            }
            try {
                this.server = tCPEndpoint.newServerSocket();
                Thread thread = AccessController.doPrivileged(new NewThreadAction(new AcceptLoop(this.server), "TCP Accept-" + n, true));
                thread.start();
            }
            catch (BindException bindException) {
                throw new ExportException("Port already in use: " + n, bindException);
            }
            catch (IOException iOException) {
                throw new ExportException("Listen failed on port: " + n, iOException);
            }
        } else {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkListen(n);
            }
        }
    }

    private static void closeSocket(Socket socket) {
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void handleMessages(Connection var1_1, boolean var2_2) {
        block20: {
            block21: {
                var3_3 = this.getEndpoint().getPort();
                try {
                    try {
                        var4_4 = new DataInputStream(var1_1.getInputStream());
                        block14: do {
                            if ((var5_6 = var4_4.read()) == -1) {
                                if (TCPTransport.tcpLog.isLoggable(Log.BRIEF)) {
                                    TCPTransport.tcpLog.log(Log.BRIEF, "(port " + var3_3 + ") connection closed");
                                }
                                break block20;
                            }
                            if (TCPTransport.tcpLog.isLoggable(Log.BRIEF)) {
                                TCPTransport.tcpLog.log(Log.BRIEF, "(port " + var3_3 + ") op = " + var5_6);
                            }
                            switch (var5_6) {
                                case 80: {
                                    var6_7 = new StreamRemoteCall(var1_1);
                                    if (this.serviceCall(var6_7)) continue block14;
                                    var9_9 = null;
                                    break block21;
                                }
                                case 82: {
                                    var7_8 = new DataOutputStream(var1_1.getOutputStream());
                                    var7_8.writeByte(83);
                                    var1_1.releaseOutputStream();
                                    break;
                                }
                                case 84: {
                                    DGCAckHandler.received(UID.read(var4_4));
                                    break;
                                }
                                default: {
                                    throw new IOException("unknown transport op " + var5_6);
                                }
                            }
                        } while (var2_2);
                        break block20;
                    }
                    catch (IOException var4_5) {
                        if (TCPTransport.tcpLog.isLoggable(Log.BRIEF)) {
                            TCPTransport.tcpLog.log(Log.BRIEF, "(port " + var3_3 + ") exception: ", var4_5);
                        }
                        var9_11 = null;
                        try {
                            var1_1.close();
                            return;
                        }
                        catch (IOException var10_15) {
                            return;
                        }
                    }
                }
                catch (Throwable var8_17) {
                    var9_12 = null;
                    ** try [egrp 2[TRYBLOCK] [6 : 340->349)] { 
lbl45:
                    // 1 sources

                    var1_1.close();
                    throw var8_17;
lbl47:
                    // 1 sources

                    catch (IOException var10_16) {
                        // empty catch block
                    }
                    throw var8_17;
                }
            }
            ** try [egrp 2[TRYBLOCK] [6 : 340->349)] { 
lbl52:
            // 1 sources

            var1_1.close();
            return;
lbl54:
            // 1 sources

            catch (IOException var10_13) {
                // empty catch block
            }
            return;
        }
        var9_10 = null;
        try {}
        catch (IOException var10_14) {}
        var1_1.close();
        return;
    }

    public static String getClientHost() throws ServerNotActiveException {
        ConnectionHandler connectionHandler = threadConnectionHandler.get();
        if (connectionHandler != null) {
            return connectionHandler.getClientHost();
        }
        throw new ServerNotActiveException("not in a remote call");
    }

    static /* synthetic */ ThreadLocal access$400() {
        return threadConnectionHandler;
    }

    static /* synthetic */ int access$500() {
        return connectionReadTimeout;
    }

    static /* synthetic */ Map access$600(TCPTransport tCPTransport) {
        return tCPTransport.channelTable;
    }

    private class ConnectionHandler
    implements Runnable {
        private static final int POST = 1347375956;
        private AccessControlContext okContext;
        private Map<AccessControlContext, Reference<AccessControlContext>> authCache;
        private SecurityManager cacheSecurityManager = null;
        private Socket socket;
        private String remoteHost;

        ConnectionHandler(Socket socket, String string) {
            this.socket = socket;
            this.remoteHost = string;
        }

        String getClientHost() {
            return this.remoteHost;
        }

        void checkAcceptPermission(SecurityManager securityManager, AccessControlContext accessControlContext) {
            if (securityManager != this.cacheSecurityManager) {
                this.okContext = null;
                this.authCache = new WeakHashMap<AccessControlContext, Reference<AccessControlContext>>();
                this.cacheSecurityManager = securityManager;
            }
            if (accessControlContext.equals(this.okContext) || this.authCache.containsKey(accessControlContext)) {
                return;
            }
            InetAddress inetAddress = this.socket.getInetAddress();
            String string = inetAddress != null ? inetAddress.getHostAddress() : "*";
            securityManager.checkAccept(string, this.socket.getPort());
            this.authCache.put(accessControlContext, new SoftReference<AccessControlContext>(accessControlContext));
            this.okContext = accessControlContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Thread thread = Thread.currentThread();
            String string = thread.getName();
            try {
                thread.setName("RMI TCP Connection(" + connectionCount.incrementAndGet() + ")-" + this.remoteHost);
                this.run0();
                Object var4_3 = null;
                thread.setName(string);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                thread.setName(string);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void run0() {
            block28: {
                block27: {
                    var1_1 = TCPTransport.access$000(TCPTransport.this);
                    var2_2 = var1_1.getPort();
                    TCPTransport.access$400().set(this);
                    try {
                        this.socket.setTcpNoDelay(true);
                    }
                    catch (Exception var3_3) {
                        // empty catch block
                    }
                    try {
                        if (TCPTransport.access$500() > 0) {
                            this.socket.setSoTimeout(TCPTransport.access$500());
                        }
                    }
                    catch (Exception var3_4) {
                        // empty catch block
                    }
                    try {
                        try {
                            var3_5 = this.socket.getInputStream();
                            var4_7 = var3_5.markSupported() != false ? var3_5 : new BufferedInputStream(var3_5);
                            var4_7.mark(4);
                            var5_8 = new DataInputStream(var4_7);
                            var6_9 = var5_8.readInt();
                            if (var6_9 == 1347375956) {
                                TCPTransport.tcpLog.log(Log.BRIEF, "decoding HTTP-wrapped call");
                                var4_7.reset();
                                try {
                                    this.socket = new HttpReceiveSocket(this.socket, var4_7, null);
                                    this.remoteHost = "0.0.0.0";
                                    var3_5 = this.socket.getInputStream();
                                    var4_7 = new BufferedInputStream(var3_5);
                                    var5_8 = new DataInputStream(var4_7);
                                    var6_9 = var5_8.readInt();
                                }
                                catch (IOException var7_10) {
                                    throw new RemoteException("Error HTTP-unwrapping call", var7_10);
                                }
                            }
                            var7_11 = var5_8.readShort();
                            if (var6_9 != 1246907721 || var7_11 != 2) {
                                TCPTransport.access$200(this.socket);
                                var22_12 = null;
                                break block27;
                            }
                            var8_16 = this.socket.getOutputStream();
                            var9_17 = new BufferedOutputStream(var8_16);
                            var10_18 = new DataOutputStream(var9_17);
                            var11_19 = this.socket.getPort();
                            if (TCPTransport.tcpLog.isLoggable(Log.BRIEF)) {
                                TCPTransport.tcpLog.log(Log.BRIEF, "accepted socket from [" + this.remoteHost + ":" + var11_19 + "]");
                            }
                            var15_20 = var5_8.readByte();
                            switch (var15_20) {
                                case 76: {
                                    var12_21 = new TCPEndpoint(this.remoteHost, this.socket.getLocalPort(), var1_1.getClientSocketFactory(), var1_1.getServerSocketFactory());
                                    var13_24 = new TCPChannel(TCPTransport.this, var12_21);
                                    var14_27 = new TCPConnection(var13_24, this.socket, var4_7, var9_17);
                                    TCPTransport.this.handleMessages(var14_27, false);
                                    ** break;
                                }
                                case 75: {
                                    var10_18.writeByte(78);
                                    if (TCPTransport.tcpLog.isLoggable(Log.VERBOSE)) {
                                        TCPTransport.tcpLog.log(Log.VERBOSE, "(port " + var2_2 + ") " + "suggesting " + this.remoteHost + ":" + var11_19);
                                    }
                                    var10_18.writeUTF(this.remoteHost);
                                    var10_18.writeInt(var11_19);
                                    var10_18.flush();
                                    var16_29 = var5_8.readUTF();
                                    var17_30 = var5_8.readInt();
                                    if (TCPTransport.tcpLog.isLoggable(Log.VERBOSE)) {
                                        TCPTransport.tcpLog.log(Log.VERBOSE, "(port " + var2_2 + ") client using " + var16_29 + ":" + var17_30);
                                    }
                                    var12_22 = new TCPEndpoint(this.remoteHost, this.socket.getLocalPort(), var1_1.getClientSocketFactory(), var1_1.getServerSocketFactory());
                                    var13_25 = new TCPChannel(TCPTransport.this, var12_22);
                                    var14_28 = new TCPConnection(var13_25, this.socket, var4_7, var9_17);
                                    TCPTransport.this.handleMessages(var14_28, true);
                                    ** break;
                                }
                                case 77: {
                                    if (TCPTransport.tcpLog.isLoggable(Log.VERBOSE)) {
                                        TCPTransport.tcpLog.log(Log.VERBOSE, "(port " + var2_2 + ") accepting multiplex protocol");
                                    }
                                    var10_18.writeByte(78);
                                    if (TCPTransport.tcpLog.isLoggable(Log.VERBOSE)) {
                                        TCPTransport.tcpLog.log(Log.VERBOSE, "(port " + var2_2 + ") suggesting " + this.remoteHost + ":" + var11_19);
                                    }
                                    var10_18.writeUTF(this.remoteHost);
                                    var10_18.writeInt(var11_19);
                                    var10_18.flush();
                                    var12_23 = new TCPEndpoint(var5_8.readUTF(), var5_8.readInt(), var1_1.getClientSocketFactory(), var1_1.getServerSocketFactory());
                                    if (TCPTransport.tcpLog.isLoggable(Log.VERBOSE)) {
                                        TCPTransport.tcpLog.log(Log.VERBOSE, "(port " + var2_2 + ") client using " + var12_23.getHost() + ":" + var12_23.getPort());
                                    }
                                    var19_31 = TCPTransport.access$600(TCPTransport.this);
                                    synchronized (var19_31) {
                                        var13_26 = TCPTransport.this.getChannel(var12_23);
                                        var18_32 = new ConnectionMultiplexer(var13_26, var4_7, var8_16, false);
                                        var13_26.useMultiplexer(var18_32);
                                    }
                                    var18_32.run();
                                    ** break;
                                }
                            }
                            var10_18.writeByte(79);
                            var10_18.flush();
                            break block28;
                        }
                        catch (IOException var3_6) {
                            TCPTransport.tcpLog.log(Log.BRIEF, "terminated with exception:", var3_6);
                            var22_14 = null;
                            TCPTransport.access$200(this.socket);
                            return;
                        }
                    }
                    catch (Throwable var21_33) {
                        var22_15 = null;
                        TCPTransport.access$200(this.socket);
                        throw var21_33;
                    }
                }
                TCPTransport.access$200(this.socket);
                return;
            }
            var22_13 = null;
            TCPTransport.access$200(this.socket);
        }
    }

    private class AcceptLoop
    implements Runnable {
        private final ServerSocket serverSocket;
        private long lastExceptionTime = 0L;
        private int recentExceptionCount;

        AcceptLoop(ServerSocket serverSocket) {
            this.serverSocket = serverSocket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.executeAcceptLoop();
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                try {
                    this.serverSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {}
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void executeAcceptLoop() {
            if (tcpLog.isLoggable(Log.BRIEF)) {
                tcpLog.log(Log.BRIEF, "listening on port " + TCPTransport.this.getEndpoint().getPort());
            }
            while (true) {
                Socket socket = null;
                try {
                    socket = this.serverSocket.accept();
                    InetAddress inetAddress = socket.getInetAddress();
                    String string = inetAddress != null ? inetAddress.getHostAddress() : "0.0.0.0";
                    try {
                        connectionThreadPool.execute(new ConnectionHandler(socket, string));
                    }
                    catch (RejectedExecutionException rejectedExecutionException) {
                        TCPTransport.closeSocket(socket);
                        tcpLog.log(Log.BRIEF, "rejected connection from " + string);
                    }
                    continue;
                }
                catch (Throwable throwable) {
                    block16: {
                        Object var6_8;
                        try {
                            if (this.serverSocket.isClosed()) {
                                var6_8 = null;
                                if (socket == null) return;
                                break block16;
                            }
                            try {
                                if (tcpLog.isLoggable(Level.WARNING)) {
                                    tcpLog.log(Level.WARNING, "accept loop for " + this.serverSocket + " throws", throwable);
                                }
                            }
                            catch (Throwable throwable2) {
                            }
                        }
                        catch (Throwable throwable3) {
                            var6_8 = null;
                            if (socket == null) throw throwable3;
                            TCPTransport.closeSocket(socket);
                            throw throwable3;
                        }
                        var6_8 = null;
                        if (socket != null) {
                            TCPTransport.closeSocket(socket);
                        }
                        if (!(throwable instanceof SecurityException)) {
                            try {
                                TCPEndpoint.shedConnectionCaches();
                            }
                            catch (Throwable throwable4) {
                                // empty catch block
                            }
                        }
                        if (!(throwable instanceof Exception) && !(throwable instanceof OutOfMemoryError) && !(throwable instanceof NoClassDefFoundError)) throw (Error)throwable;
                        if (!this.continueAfterAcceptFailure(throwable)) return;
                        continue;
                    }
                    TCPTransport.closeSocket(socket);
                    return;
                }
                break;
            }
        }

        private boolean continueAfterAcceptFailure(Throwable throwable) {
            RMIFailureHandler rMIFailureHandler = RMISocketFactory.getFailureHandler();
            if (rMIFailureHandler != null) {
                return rMIFailureHandler.failure(throwable instanceof Exception ? (Exception)throwable : new InvocationTargetException(throwable));
            }
            this.throttleLoopOnException();
            return true;
        }

        private void throttleLoopOnException() {
            long l = System.currentTimeMillis();
            if (this.lastExceptionTime == 0L || l - this.lastExceptionTime > 5000L) {
                this.lastExceptionTime = l;
                this.recentExceptionCount = 0;
            } else if (++this.recentExceptionCount >= 10) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

