/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.font.FontStrike;
import sun.font.FontStrikeDisposer;
import sun.java2d.Disposer;
import sun.java2d.pipe.BufferedContext;
import sun.java2d.pipe.RenderQueue;
import sun.java2d.pipe.hw.AccelGraphicsConfig;
import sun.misc.Unsafe;

public final class StrikeCache {
    static final Unsafe unsafe = Unsafe.getUnsafe();
    static ReferenceQueue refQueue = Disposer.getQueue();
    static int MINSTRIKES = 8;
    static int recentStrikeIndex = 0;
    static FontStrike[] recentStrikes;
    static boolean cacheRefTypeWeak;
    static int nativeAddressSize;
    static int glyphInfoSize;
    static int xAdvanceOffset;
    static int yAdvanceOffset;
    static int boundsOffset;
    static int widthOffset;
    static int heightOffset;
    static int rowBytesOffset;
    static int topLeftXOffset;
    static int topLeftYOffset;
    static int pixelDataOffset;
    static long invisibleGlyphPtr;

    static native void getGlyphCacheDescription(long[] var0);

    static void refStrike(FontStrike fontStrike) {
        int n = recentStrikeIndex;
        StrikeCache.recentStrikes[n] = fontStrike;
        if (++n == MINSTRIKES) {
            n = 0;
        }
        recentStrikeIndex = n;
    }

    private static final void doDispose(FontStrikeDisposer fontStrikeDisposer) {
        if (fontStrikeDisposer.intGlyphImages != null) {
            StrikeCache.freeIntMemory(fontStrikeDisposer.intGlyphImages, fontStrikeDisposer.pScalerContext);
        } else if (fontStrikeDisposer.longGlyphImages != null) {
            StrikeCache.freeLongMemory(fontStrikeDisposer.longGlyphImages, fontStrikeDisposer.pScalerContext);
        } else if (fontStrikeDisposer.segIntGlyphImages != null) {
            for (int i = 0; i < fontStrikeDisposer.segIntGlyphImages.length; ++i) {
                if (fontStrikeDisposer.segIntGlyphImages[i] == null) continue;
                StrikeCache.freeIntMemory(fontStrikeDisposer.segIntGlyphImages[i], fontStrikeDisposer.pScalerContext);
                fontStrikeDisposer.pScalerContext = 0L;
                fontStrikeDisposer.segIntGlyphImages[i] = null;
            }
            if (fontStrikeDisposer.pScalerContext != 0L) {
                StrikeCache.freeIntMemory(new int[0], fontStrikeDisposer.pScalerContext);
            }
        } else if (fontStrikeDisposer.segLongGlyphImages != null) {
            for (int i = 0; i < fontStrikeDisposer.segLongGlyphImages.length; ++i) {
                if (fontStrikeDisposer.segLongGlyphImages[i] == null) continue;
                StrikeCache.freeLongMemory(fontStrikeDisposer.segLongGlyphImages[i], fontStrikeDisposer.pScalerContext);
                fontStrikeDisposer.pScalerContext = 0L;
                fontStrikeDisposer.segLongGlyphImages[i] = null;
            }
            if (fontStrikeDisposer.pScalerContext != 0L) {
                StrikeCache.freeLongMemory(new long[0], fontStrikeDisposer.pScalerContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disposeStrike(final FontStrikeDisposer fontStrikeDisposer) {
        AccelGraphicsConfig accelGraphicsConfig;
        BufferedContext bufferedContext;
        GraphicsConfiguration graphicsConfiguration;
        RenderQueue renderQueue = null;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (!graphicsEnvironment.isHeadless() && (graphicsConfiguration = graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration()) instanceof AccelGraphicsConfig && (bufferedContext = (accelGraphicsConfig = (AccelGraphicsConfig)((Object)graphicsConfiguration)).getContext()) != null) {
            renderQueue = bufferedContext.getRenderQueue();
        }
        if (renderQueue != null) {
            renderQueue.lock();
            try {
                renderQueue.flushAndInvokeNow(new Runnable(){

                    public void run() {
                        StrikeCache.doDispose(fontStrikeDisposer);
                    }
                });
                Object var7_6 = null;
                renderQueue.unlock();
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                renderQueue.unlock();
                throw throwable;
            }
        } else {
            StrikeCache.doDispose(fontStrikeDisposer);
        }
    }

    static native void freeIntPointer(int var0);

    static native void freeLongPointer(long var0);

    private static native void freeIntMemory(int[] var0, long var1);

    private static native void freeLongMemory(long[] var0, long var1);

    public static Reference getStrikeRef(FontStrike fontStrike) {
        return StrikeCache.getStrikeRef(fontStrike, cacheRefTypeWeak);
    }

    public static Reference getStrikeRef(FontStrike fontStrike, boolean bl) {
        if (fontStrike.disposer == null) {
            if (bl) {
                return new WeakReference<FontStrike>(fontStrike);
            }
            return new SoftReference<FontStrike>(fontStrike);
        }
        if (bl) {
            return new WeakDisposerRef(fontStrike);
        }
        return new SoftDisposerRef(fontStrike);
    }

    static {
        long[] lArray = new long[11];
        StrikeCache.getGlyphCacheDescription(lArray);
        nativeAddressSize = (int)lArray[0];
        glyphInfoSize = (int)lArray[1];
        xAdvanceOffset = (int)lArray[2];
        yAdvanceOffset = (int)lArray[3];
        widthOffset = (int)lArray[4];
        heightOffset = (int)lArray[5];
        rowBytesOffset = (int)lArray[6];
        topLeftXOffset = (int)lArray[7];
        topLeftYOffset = (int)lArray[8];
        pixelDataOffset = (int)lArray[9];
        invisibleGlyphPtr = lArray[10];
        if (nativeAddressSize < 4) {
            throw new InternalError("Unexpected address size for font data: " + nativeAddressSize);
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = System.getProperty("sun.java2d.font.reftype", "soft");
                cacheRefTypeWeak = string.equals("weak");
                String string2 = System.getProperty("sun.java2d.font.minstrikes");
                if (string2 != null) {
                    try {
                        MINSTRIKES = Integer.parseInt(string2);
                        if (MINSTRIKES <= 0) {
                            MINSTRIKES = 1;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                recentStrikes = new FontStrike[MINSTRIKES];
                return null;
            }
        });
    }

    static class WeakDisposerRef
    extends WeakReference
    implements DisposableStrike {
        private FontStrikeDisposer disposer;

        public FontStrikeDisposer getDisposer() {
            return this.disposer;
        }

        WeakDisposerRef(FontStrike fontStrike) {
            super(fontStrike, refQueue);
            this.disposer = fontStrike.disposer;
            Disposer.addReference(this, this.disposer);
        }
    }

    static class SoftDisposerRef
    extends SoftReference
    implements DisposableStrike {
        private FontStrikeDisposer disposer;

        public FontStrikeDisposer getDisposer() {
            return this.disposer;
        }

        SoftDisposerRef(FontStrike fontStrike) {
            super(fontStrike, refQueue);
            this.disposer = fontStrike.disposer;
            Disposer.addReference(this, this.disposer);
        }
    }

    static interface DisposableStrike {
        public FontStrikeDisposer getDisposer();
    }
}

