/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import java.io.UnsupportedEncodingException;
import javax.sound.midi.Patch;

public class SoftTuning {
    private String name = null;
    private double[] tuning = new double[128];
    private Patch patch = null;

    public SoftTuning() {
        this.name = "12-TET";
        for (int i = 0; i < this.tuning.length; ++i) {
            this.tuning[i] = i * 100;
        }
    }

    public SoftTuning(byte[] byArray) {
        for (int i = 0; i < this.tuning.length; ++i) {
            this.tuning[i] = i * 100;
        }
        this.load(byArray);
    }

    public SoftTuning(Patch patch) {
        this.patch = patch;
        this.name = "12-TET";
        for (int i = 0; i < this.tuning.length; ++i) {
            this.tuning[i] = i * 100;
        }
    }

    public SoftTuning(Patch patch, byte[] byArray) {
        this.patch = patch;
        for (int i = 0; i < this.tuning.length; ++i) {
            this.tuning[i] = i * 100;
        }
        this.load(byArray);
    }

    private boolean checksumOK(byte[] byArray) {
        int n = byArray[1] & 0xFF;
        for (int i = 2; i < byArray.length - 2; ++i) {
            n ^= byArray[i] & 0xFF;
        }
        return (byArray[byArray.length - 2] & 0xFF) == (n & 0x7F);
    }

    public void load(byte[] byArray) {
        block33: {
            if ((byArray[1] & 0xFF) != 126 && (byArray[1] & 0xFF) != 127) break block33;
            int n = byArray[3] & 0xFF;
            switch (n) {
                case 8: {
                    int n2 = byArray[4] & 0xFF;
                    switch (n2) {
                        case 1: {
                            try {
                                this.name = new String(byArray, 6, 16, "ascii");
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                this.name = null;
                            }
                            int n3 = 22;
                            for (int i = 0; i < 128; ++i) {
                                int n4 = byArray[n3++] & 0xFF;
                                int n5 = byArray[n3++] & 0xFF;
                                int n6 = byArray[n3++] & 0xFF;
                                if (n4 == 127 && n5 == 127 && n6 == 127) continue;
                                this.tuning[i] = 100.0 * ((double)(n4 * 16384 + n5 * 128 + n6) / 16384.0);
                            }
                            break block33;
                        }
                        case 2: {
                            int n7 = byArray[6] & 0xFF;
                            int n8 = 7;
                            for (int i = 0; i < n7; ++i) {
                                int n9 = byArray[n8++] & 0xFF;
                                int n10 = byArray[n8++] & 0xFF;
                                int n11 = byArray[n8++] & 0xFF;
                                int n12 = byArray[n8++] & 0xFF;
                                if (n10 == 127 && n11 == 127 && n12 == 127) continue;
                                this.tuning[n9] = 100.0 * ((double)(n10 * 16384 + n11 * 128 + n12) / 16384.0);
                            }
                            break block33;
                        }
                        case 4: {
                            if (!this.checksumOK(byArray)) break block33;
                            try {
                                this.name = new String(byArray, 7, 16, "ascii");
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                this.name = null;
                            }
                            int n13 = 23;
                            for (int i = 0; i < 128; ++i) {
                                int n14 = byArray[n13++] & 0xFF;
                                int n15 = byArray[n13++] & 0xFF;
                                int n16 = byArray[n13++] & 0xFF;
                                if (n14 == 127 && n15 == 127 && n16 == 127) continue;
                                this.tuning[i] = 100.0 * ((double)(n14 * 16384 + n15 * 128 + n16) / 16384.0);
                            }
                            break block33;
                        }
                        case 5: {
                            int n17;
                            if (!this.checksumOK(byArray)) break block33;
                            try {
                                this.name = new String(byArray, 7, 16, "ascii");
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                this.name = null;
                            }
                            int[] nArray = new int[12];
                            for (n17 = 0; n17 < 12; ++n17) {
                                nArray[n17] = (byArray[n17 + 23] & 0xFF) - 64;
                            }
                            for (n17 = 0; n17 < this.tuning.length; ++n17) {
                                this.tuning[n17] = n17 * 100 + nArray[n17 % 12];
                            }
                            break block33;
                        }
                        case 6: {
                            int n18;
                            if (!this.checksumOK(byArray)) break block33;
                            try {
                                this.name = new String(byArray, 7, 16, "ascii");
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                this.name = null;
                            }
                            double[] dArray = new double[12];
                            for (n18 = 0; n18 < 12; ++n18) {
                                int n19 = (byArray[n18 * 2 + 23] & 0xFF) * 128 + (byArray[n18 * 2 + 24] & 0xFF);
                                dArray[n18] = ((double)n19 / 8192.0 - 1.0) * 100.0;
                            }
                            for (n18 = 0; n18 < this.tuning.length; ++n18) {
                                this.tuning[n18] = (double)(n18 * 100) + dArray[n18 % 12];
                            }
                            break block33;
                        }
                        case 7: {
                            int n20 = byArray[7] & 0xFF;
                            int n21 = 8;
                            for (int i = 0; i < n20; ++i) {
                                int n22 = byArray[n21++] & 0xFF;
                                int n23 = byArray[n21++] & 0xFF;
                                int n24 = byArray[n21++] & 0xFF;
                                int n25 = byArray[n21++] & 0xFF;
                                if (n23 == 127 && n24 == 127 && n25 == 127) continue;
                                this.tuning[n22] = 100.0 * ((double)(n23 * 16384 + n24 * 128 + n25) / 16384.0);
                            }
                            break block33;
                        }
                        case 8: {
                            int n26;
                            int[] nArray = new int[12];
                            for (n26 = 0; n26 < 12; ++n26) {
                                nArray[n26] = (byArray[n26 + 8] & 0xFF) - 64;
                            }
                            for (n26 = 0; n26 < this.tuning.length; ++n26) {
                                this.tuning[n26] = n26 * 100 + nArray[n26 % 12];
                            }
                            break block33;
                        }
                        case 9: {
                            int n27;
                            double[] dArray = new double[12];
                            for (n27 = 0; n27 < 12; ++n27) {
                                int n28 = (byArray[n27 * 2 + 8] & 0xFF) * 128 + (byArray[n27 * 2 + 9] & 0xFF);
                                dArray[n27] = ((double)n28 / 8192.0 - 1.0) * 100.0;
                            }
                            for (n27 = 0; n27 < this.tuning.length; ++n27) {
                                this.tuning[n27] = (double)(n27 * 100) + dArray[n27 % 12];
                            }
                        }
                    }
                }
            }
        }
    }

    public double[] getTuning() {
        return this.tuning;
    }

    public double getTuning(int n) {
        return this.tuning[n];
    }

    public Patch getPatch() {
        return this.patch;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }
}

