/*
 * Decompiled with CFR 0.152.
 */
package actual;

import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;

public class RoundButton
extends Component {
    ActionListener actionListener;
    String label;
    protected boolean pressed = false;

    public RoundButton() {
        this("");
    }

    public RoundButton(String string) {
        this.label = string;
        this.enableEvents(16L);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
        this.invalidate();
        this.repaint();
    }

    public void paint(Graphics graphics) {
        int n = Math.min(this.getSize().width - 1, this.getSize().height - 1);
        if (this.pressed) {
            graphics.setColor(this.getBackground().darker().darker());
        } else {
            graphics.setColor(this.getBackground());
        }
        graphics.fillArc(0, 0, n, n, 0, 360);
        graphics.setColor(this.getBackground().darker().darker().darker());
        graphics.drawArc(0, 0, n, n, 0, 360);
        Font font = this.getFont();
        if (font != null) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            graphics.setColor(this.getForeground());
            graphics.drawString(this.label, n / 2 - fontMetrics.stringWidth(this.label) / 2, n / 2 + fontMetrics.getMaxDescent());
        }
    }

    public Dimension getPreferredSize() {
        Font font = this.getFont();
        if (font != null) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n = Math.max(fontMetrics.stringWidth(this.label) + 40, fontMetrics.getHeight() + 40);
            return new Dimension(n, n);
        }
        return new Dimension(100, 100);
    }

    public Dimension getMinimumSize() {
        return new Dimension(100, 100);
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
        this.enableEvents(16L);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public boolean contains(int n, int n2) {
        int n3 = this.getSize().width / 2;
        int n4 = this.getSize().height / 2;
        return (n3 - n) * (n3 - n) + (n4 - n2) * (n4 - n2) <= n3 * n3;
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 501: {
                this.pressed = true;
                this.repaint();
                break;
            }
            case 502: {
                if (this.actionListener != null) {
                    this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.label));
                }
                if (!this.pressed) break;
                this.pressed = false;
                this.repaint();
                break;
            }
            case 505: {
                if (!this.pressed) break;
                this.pressed = false;
                this.repaint();
                break;
            }
        }
        super.processMouseEvent(mouseEvent);
    }
}

