/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.annotation;

import com.puppycrawl.tools.checkstyle.api.AnnotationUtility;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.JavadocTagInfo;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.api.Utils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MissingOverrideCheck
extends Check {
    private static final String OVERRIDE = "Override";
    private static final String FQ_OVERRIDE = "java.lang.Override";
    private static final Pattern MATCH_INHERITDOC = Utils.createPattern("\\{\\s*@(inheritDoc)\\s*\\}");
    private boolean mJavaFiveCompatibility;

    public void setJavaFiveCompatibility(boolean aCompatibility) {
        this.mJavaFiveCompatibility = aCompatibility;
    }

    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    public int[] getRequiredTokens() {
        return new int[]{9};
    }

    public void visitToken(DetailAST aAST) {
        DetailAST defOrNew;
        TextBlock javadoc = this.getFileContents().getJavadocBefore(aAST.getLineNo());
        boolean containsTag = this.containsJavadocTag(javadoc);
        if (containsTag && !JavadocTagInfo.INHERIT_DOC.isValidOn(aAST)) {
            this.log(aAST.getLineNo(), "tag.not.valid.on", JavadocTagInfo.INHERIT_DOC.getText());
            return;
        }
        if (this.mJavaFiveCompatibility && ((defOrNew = aAST.getParent().getParent()).branchContains(18) || defOrNew.branchContains(19) || defOrNew.getType() == 136)) {
            return;
        }
        if (containsTag && !AnnotationUtility.containsAnnotation(aAST, OVERRIDE) && !AnnotationUtility.containsAnnotation(aAST, FQ_OVERRIDE)) {
            this.log(aAST.getLineNo(), "annotation.missing.override", new Object[0]);
        }
    }

    private boolean containsJavadocTag(TextBlock aJavadoc) {
        String[] lines;
        if (aJavadoc == null) {
            return false;
        }
        for (String line : lines = aJavadoc.getText()) {
            Matcher matchInheritDoc = MATCH_INHERITDOC.matcher(line);
            if (!matchInheritDoc.find()) continue;
            return true;
        }
        return false;
    }
}

