/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentLevel;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentationCheck;
import com.puppycrawl.tools.checkstyle.checks.indentation.LineSet;
import java.util.Arrays;

public abstract class ExpressionHandler {
    private final IndentationCheck mIndentCheck;
    private final DetailAST mMainAst;
    private final String mTypeName;
    private final ExpressionHandler mParent;
    private IndentLevel mLevel;

    public ExpressionHandler(IndentationCheck aIndentCheck, String aTypeName, DetailAST aExpr, ExpressionHandler aParent) {
        this.mIndentCheck = aIndentCheck;
        this.mTypeName = aTypeName;
        this.mMainAst = aExpr;
        this.mParent = aParent;
    }

    public final IndentLevel getLevel() {
        if (this.mLevel == null) {
            this.mLevel = this.getLevelImpl();
        }
        return this.mLevel;
    }

    protected IndentLevel getLevelImpl() {
        return this.mParent.suggestedChildLevel(this);
    }

    public IndentLevel suggestedChildLevel(ExpressionHandler aChild) {
        return new IndentLevel(this.getLevel(), this.getBasicOffset());
    }

    protected final void logError(DetailAST aAst, String aSubtypeName, int aActualLevel) {
        this.logError(aAst, aSubtypeName, aActualLevel, this.getLevel());
    }

    protected final void logError(DetailAST aAst, String aSubtypeName, int aActualLevel, IndentLevel aExpectedLevel) {
        String typeStr = "".equals(aSubtypeName) ? "" : " " + aSubtypeName;
        String messageKey = "indentation.error";
        if (aExpectedLevel.isMultiLevel()) {
            messageKey = "indentation.error.multi";
        }
        this.mIndentCheck.indentationLog(aAst.getLineNo(), messageKey, this.mTypeName + typeStr, aActualLevel, aExpectedLevel);
    }

    private void logChildError(int aLine, int aActualLevel, IndentLevel aExpectedLevel) {
        String messageKey = "indentation.child.error";
        if (aExpectedLevel.isMultiLevel()) {
            messageKey = "indentation.child.error.multi";
        }
        this.mIndentCheck.indentationLog(aLine, messageKey, this.mTypeName, aActualLevel, aExpectedLevel);
    }

    protected final boolean startsLine(DetailAST aAst) {
        return this.getLineStart(aAst) == this.expandedTabsColumnNo(aAst);
    }

    static boolean areOnSameLine(DetailAST aAst1, DetailAST aAst2) {
        return aAst1 != null && aAst2 != null && aAst1.getLineNo() == aAst2.getLineNo();
    }

    static DetailAST getFirstToken(DetailAST aAST) {
        DetailAST first = aAST;
        for (DetailAST child = aAST.getFirstChild(); child != null; child = child.getNextSibling()) {
            DetailAST toTest = ExpressionHandler.getFirstToken(child);
            if (toTest.getLineNo() >= first.getLineNo() && (toTest.getLineNo() != first.getLineNo() || toTest.getColumnNo() >= first.getColumnNo())) continue;
            first = toTest;
        }
        return first;
    }

    protected final int getLineStart(DetailAST aAst) {
        String line = this.mIndentCheck.getLine(aAst.getLineNo() - 1);
        return this.getLineStart(line);
    }

    protected final void checkLinesIndent(int aStartLine, int aEndLine, IndentLevel aIndentLevel) {
        this.checkSingleLine(aStartLine, aIndentLevel);
        IndentLevel offsetLevel = new IndentLevel(aIndentLevel, this.getBasicOffset());
        for (int i = aStartLine + 1; i <= aEndLine; ++i) {
            this.checkSingleLine(i, offsetLevel);
        }
    }

    protected boolean shouldIncreaseIndent() {
        return true;
    }

    private void checkLinesIndent(LineSet aLines, IndentLevel aIndentLevel, boolean aFirstLineMatches, int aFirstLine) {
        if (aLines.isEmpty()) {
            return;
        }
        int startLine = aLines.firstLine();
        int endLine = aLines.lastLine();
        int startCol = aLines.firstLineCol();
        int realStartCol = this.getLineStart(this.mIndentCheck.getLine(startLine - 1));
        if (realStartCol == startCol) {
            this.checkSingleLine(startLine, startCol, aIndentLevel, aFirstLineMatches);
        }
        IndentLevel theLevel = aIndentLevel;
        if (aFirstLineMatches || aFirstLine > this.mMainAst.getLineNo() && this.shouldIncreaseIndent()) {
            theLevel = new IndentLevel(aIndentLevel, this.getBasicOffset());
        }
        for (int i = startLine + 1; i <= endLine; ++i) {
            Integer col = aLines.getStartColumn(i);
            if (col == null) continue;
            this.checkSingleLine(i, col, theLevel, false);
        }
    }

    private void checkSingleLine(int aLineNum, IndentLevel aIndentLevel) {
        String line = this.mIndentCheck.getLine(aLineNum - 1);
        int start = this.getLineStart(line);
        if (aIndentLevel.gt(start)) {
            this.logChildError(aLineNum, start, aIndentLevel);
        }
    }

    private void checkSingleLine(int aLineNum, int aColNum, IndentLevel aIndentLevel, boolean aMustMatch) {
        String line = this.mIndentCheck.getLine(aLineNum - 1);
        int start = this.getLineStart(line);
        if (aMustMatch ? !aIndentLevel.accept(start) : aColNum == start && aIndentLevel.gt(start)) {
            this.logChildError(aLineNum, start, aIndentLevel);
        }
    }

    protected final int getLineStart(String aLine) {
        for (int start = 0; start < aLine.length(); ++start) {
            char c = aLine.charAt(start);
            if (Character.isWhitespace(c)) continue;
            return Utils.lengthExpandedTabs(aLine, start, this.mIndentCheck.getIndentationTabWidth());
        }
        return 0;
    }

    protected final void checkChildren(DetailAST aParent, int[] aTokenTypes, IndentLevel aStartLevel, boolean aFirstLineMatches, boolean aAllowNesting) {
        Arrays.sort(aTokenTypes);
        for (DetailAST child = aParent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (Arrays.binarySearch(aTokenTypes, child.getType()) < 0) continue;
            this.checkExpressionSubtree(child, aStartLevel, aFirstLineMatches, aAllowNesting);
        }
    }

    protected final void checkExpressionSubtree(DetailAST aTree, IndentLevel aLevel, boolean aFirstLineMatches, boolean aAllowNesting) {
        LineSet subtreeLines = new LineSet();
        int firstLine = this.getFirstLine(Integer.MAX_VALUE, aTree);
        if (aFirstLineMatches && !aAllowNesting) {
            subtreeLines.addLineAndCol(firstLine, this.getLineStart(this.mIndentCheck.getLine(firstLine - 1)));
        }
        this.findSubtreeLines(subtreeLines, aTree, aAllowNesting);
        this.checkLinesIndent(subtreeLines, aLevel, aFirstLineMatches, firstLine);
    }

    protected final int getFirstLine(int aStartLine, DetailAST aTree) {
        int realStart = aStartLine;
        int currLine = aTree.getLineNo();
        if (currLine < realStart) {
            realStart = currLine;
        }
        for (DetailAST node = aTree.getFirstChild(); node != null; node = node.getNextSibling()) {
            realStart = this.getFirstLine(realStart, node);
        }
        return realStart;
    }

    protected final int expandedTabsColumnNo(DetailAST aAST) {
        String line = this.mIndentCheck.getLine(aAST.getLineNo() - 1);
        return Utils.lengthExpandedTabs(line, aAST.getColumnNo(), this.mIndentCheck.getIndentationTabWidth());
    }

    protected final void findSubtreeLines(LineSet aLines, DetailAST aTree, boolean aAllowNesting) {
        if (this.getIndentCheck().getHandlerFactory().isHandledType(aTree.getType()) || aTree.getLineNo() < 0) {
            return;
        }
        int lineNum = aTree.getLineNo();
        Integer colNum = aLines.getStartColumn(lineNum);
        int thisLineColumn = this.expandedTabsColumnNo(aTree);
        if (colNum == null || thisLineColumn < colNum) {
            aLines.addLineAndCol(lineNum, thisLineColumn);
        }
        for (DetailAST node = aTree.getFirstChild(); node != null; node = node.getNextSibling()) {
            this.findSubtreeLines(aLines, node, aAllowNesting);
        }
    }

    protected void checkModifiers() {
        DetailAST modifiers = this.mMainAst.findFirstToken(5);
        for (DetailAST modifier = modifiers.getFirstChild(); modifier != null; modifier = modifier.getNextSibling()) {
            if (!this.startsLine(modifier) || this.getLevel().accept(this.expandedTabsColumnNo(modifier))) continue;
            this.logError(modifier, "modifier", this.expandedTabsColumnNo(modifier));
        }
    }

    public abstract void checkIndentation();

    protected final IndentationCheck getIndentCheck() {
        return this.mIndentCheck;
    }

    protected final DetailAST getMainAst() {
        return this.mMainAst;
    }

    protected final ExpressionHandler getParent() {
        return this.mParent;
    }

    protected final int getBasicOffset() {
        return this.getIndentCheck().getBasicOffset();
    }

    protected final int getBraceAdjustement() {
        return this.getIndentCheck().getBraceAdjustement();
    }

    protected final void checkRParen(DetailAST aLparen, DetailAST aRparen) {
        if (aRparen == null) {
            return;
        }
        int rparenLevel = this.expandedTabsColumnNo(aRparen);
        if (this.getLevel().accept(rparenLevel) || !this.startsLine(aRparen)) {
            return;
        }
        int lparenLevel = this.expandedTabsColumnNo(aLparen);
        if (rparenLevel == lparenLevel + 1) {
            return;
        }
        this.logError(aRparen, "rparen", rparenLevel);
    }

    protected final void checkLParen(DetailAST aLparen) {
        if (aLparen == null || this.getLevel().accept(this.expandedTabsColumnNo(aLparen)) || !this.startsLine(aLparen)) {
            return;
        }
        this.logError(aLparen, "lparen", this.expandedTabsColumnNo(aLparen));
    }
}

