/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import antlr.collections.AST;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Map;
import java.util.Set;

public class EqualsHashCodeCheck
extends Check {
    private final Map<DetailAST, DetailAST> mObjBlockEquals = Maps.newHashMap();
    private final Set<DetailAST> mObjBlockWithHashCode = Sets.newHashSet();

    @Override
    public int[] getDefaultTokens() {
        return new int[]{9};
    }

    @Override
    public void beginTree(DetailAST aRootAST) {
        this.mObjBlockEquals.clear();
        this.mObjBlockWithHashCode.clear();
    }

    @Override
    public void visitToken(DetailAST aAST) {
        DetailAST modifiers = aAST.getFirstChild();
        DetailAST type = aAST.findFirstToken(13);
        DetailAST methodName = aAST.findFirstToken(59);
        DetailAST parameters = aAST.findFirstToken(20);
        if (type.getFirstChild().getType() == 51 && "equals".equals(methodName.getText()) && modifiers.branchContains(63) && parameters.getChildCount() == 1 && this.isObjectParam((AST)parameters.getFirstChild())) {
            this.mObjBlockEquals.put(aAST.getParent(), aAST);
        } else if (type.getFirstChild().getType() == 55 && "hashCode".equals(methodName.getText()) && modifiers.branchContains(63) && parameters.getFirstChild() == null) {
            this.mObjBlockWithHashCode.add(aAST.getParent());
        }
    }

    private boolean isObjectParam(AST aFirstChild) {
        AST modifiers = aFirstChild.getFirstChild();
        AST type = modifiers.getNextSibling();
        switch (type.getFirstChild().getType()) {
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                return false;
            }
        }
        return true;
    }

    @Override
    public void finishTree(DetailAST aRootAST) {
        Set<DetailAST> equalsDefs = this.mObjBlockEquals.keySet();
        for (DetailAST objBlock : equalsDefs) {
            if (this.mObjBlockWithHashCode.contains((Object)objBlock)) continue;
            DetailAST equalsAST = this.mObjBlockEquals.get((Object)objBlock);
            this.log(equalsAST.getLineNo(), equalsAST.getColumnNo(), "equals.noHashCode", new Object[0]);
        }
        this.mObjBlockEquals.clear();
        this.mObjBlockWithHashCode.clear();
    }
}

