/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.compiler;

import com.github.maven_nar.cpptasks.CCTask;
import com.github.maven_nar.cpptasks.CUtil;
import com.github.maven_nar.cpptasks.CompilerDef;
import com.github.maven_nar.cpptasks.DependencyInfo;
import com.github.maven_nar.cpptasks.ProcessorDef;
import com.github.maven_nar.cpptasks.TargetDef;
import com.github.maven_nar.cpptasks.VersionInfo;
import com.github.maven_nar.cpptasks.compiler.AbstractProcessor;
import com.github.maven_nar.cpptasks.compiler.Compiler;
import com.github.maven_nar.cpptasks.compiler.CompilerConfiguration;
import com.github.maven_nar.cpptasks.compiler.LinkType;
import com.github.maven_nar.cpptasks.compiler.ProcessorConfiguration;
import com.github.maven_nar.cpptasks.parser.Parser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

public abstract class AbstractCompiler
extends AbstractProcessor
implements Compiler {
    private static final String[] emptyIncludeArray = new String[0];
    private String outputSuffix;

    protected AbstractCompiler(String[] sourceExtensions, String[] headerExtensions, String outputSuffix) {
        super(sourceExtensions, headerExtensions);
        this.outputSuffix = outputSuffix;
    }

    protected boolean canParse(File sourceFile) {
        String ext;
        String sourceName = sourceFile.toString();
        int lastPeriod = sourceName.lastIndexOf(46);
        return lastPeriod < 0 || lastPeriod != sourceName.length() - 4 || !(ext = sourceName.substring(lastPeriod).toUpperCase()).equals(".DLL") && !ext.equals(".TLB") && !ext.equals(".RES");
    }

    protected abstract CompilerConfiguration createConfiguration(CCTask var1, LinkType var2, ProcessorDef[] var3, CompilerDef var4, TargetDef var5, VersionInfo var6);

    @Override
    public ProcessorConfiguration createConfiguration(CCTask task, LinkType linkType, ProcessorDef[] baseConfigs, ProcessorDef specificConfig, TargetDef targetPlatform, VersionInfo versionInfo) {
        if (specificConfig == null) {
            throw new NullPointerException("specificConfig");
        }
        return this.createConfiguration(task, linkType, baseConfigs, (CompilerDef)specificConfig, targetPlatform, versionInfo);
    }

    protected abstract Parser createParser(File var1);

    protected String getBaseOutputName(String inputFile) {
        int lastPeriod;
        int lastSlash = inputFile.lastIndexOf(47);
        int lastReverse = inputFile.lastIndexOf(92);
        int lastSep = inputFile.lastIndexOf(File.separatorChar);
        if (lastReverse > lastSlash) {
            lastSlash = lastReverse;
        }
        if (lastSep > lastSlash) {
            lastSlash = lastSep;
        }
        if ((lastPeriod = inputFile.lastIndexOf(46)) < 0) {
            lastPeriod = inputFile.length();
        }
        return inputFile.substring(lastSlash + 1, lastPeriod);
    }

    @Override
    public String[] getOutputFileNames(String inputFile, VersionInfo versionInfo) {
        if (this.bid(inputFile) > 1) {
            String baseName = this.getBaseOutputName(inputFile);
            return new String[]{baseName + this.outputSuffix};
        }
        return new String[0];
    }

    public final DependencyInfo parseIncludes(CCTask task, File source, File[] includePath, File[] sysIncludePath, File[] envIncludePath, File baseDir, String includePathIdentifier) {
        String relativeInclude;
        int i;
        String baseDirPath;
        long sourceLastModified = source.lastModified();
        File[] sourcePath = new File[]{new File(source.getParent())};
        Vector<String> onIncludePath = new Vector<String>();
        Vector<String> onSysIncludePath = new Vector<String>();
        try {
            baseDirPath = baseDir.getCanonicalPath();
        }
        catch (IOException ex) {
            baseDirPath = baseDir.toString();
        }
        String relativeSource = CUtil.getRelativePath(baseDirPath, source);
        String[] includes = emptyIncludeArray;
        if (this.canParse(source)) {
            Parser parser = this.createParser(source);
            try {
                BufferedReader reader = new BufferedReader(new FileReader(source));
                parser.parse(reader);
                includes = parser.getIncludes();
            }
            catch (IOException ex) {
                task.log("Error parsing " + source.toString() + ":" + ex.toString());
                includes = new String[]{};
            }
        }
        for (i = 0; i < includes.length; ++i) {
            String includeName = includes[i];
            if (this.resolveInclude(includeName, sourcePath, onIncludePath) || this.resolveInclude(includeName, includePath, onIncludePath) || this.resolveInclude(includeName, sysIncludePath, onSysIncludePath) || this.resolveInclude(includeName, envIncludePath, onSysIncludePath)) continue;
            sourceLastModified += 1000L;
        }
        for (i = 0; i < onIncludePath.size(); ++i) {
            relativeInclude = CUtil.getRelativePath(baseDirPath, (File)onIncludePath.elementAt(i));
            onIncludePath.setElementAt(relativeInclude, i);
        }
        for (i = 0; i < onSysIncludePath.size(); ++i) {
            relativeInclude = CUtil.getRelativePath(baseDirPath, (File)onSysIncludePath.elementAt(i));
            onSysIncludePath.setElementAt(relativeInclude, i);
        }
        return new DependencyInfo(includePathIdentifier, relativeSource, sourceLastModified, onIncludePath, onSysIncludePath);
    }

    protected boolean resolveInclude(String includeName, File[] includePath, Vector onThisPath) {
        for (int i = 0; i < includePath.length; ++i) {
            File includeFile = new File(includePath[i], includeName);
            if (!includeFile.exists()) continue;
            onThisPath.addElement(includeFile);
            return true;
        }
        return false;
    }
}

