/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.borland;

import com.github.maven_nar.cpptasks.OptimizationEnum;
import com.github.maven_nar.cpptasks.borland.BorlandLinker;
import com.github.maven_nar.cpptasks.borland.BorlandProcessor;
import com.github.maven_nar.cpptasks.compiler.CommandLineCompilerConfiguration;
import com.github.maven_nar.cpptasks.compiler.CompilerConfiguration;
import com.github.maven_nar.cpptasks.compiler.LinkType;
import com.github.maven_nar.cpptasks.compiler.Linker;
import com.github.maven_nar.cpptasks.compiler.PrecompilingCommandLineCCompiler;
import com.github.maven_nar.cpptasks.compiler.Processor;
import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.types.Environment;

public class BorlandCCompiler
extends PrecompilingCommandLineCCompiler {
    private static final String[] headerExtensions = new String[]{".h", ".hpp", ".inl"};
    private static final String[] sourceExtensions = new String[]{".c", ".cc", ".cpp", ".cxx", ".c++"};
    private static final BorlandCCompiler instance = new BorlandCCompiler(false, null);

    public static BorlandCCompiler getInstance() {
        return instance;
    }

    private BorlandCCompiler(boolean newEnvironment, Environment env) {
        super("bcc32", "--version", sourceExtensions, headerExtensions, ".obj", false, null, newEnvironment, env);
    }

    @Override
    protected void addImpliedArgs(Vector<String> args, boolean debug, boolean multithreaded, boolean exceptions, LinkType linkType, Boolean rtti, OptimizationEnum optimization) {
        args.addElement("-c");
        args.addElement("-X");
        if (exceptions) {
            args.addElement("-x");
        } else {
            args.addElement("-x-");
        }
        if (multithreaded) {
            args.addElement("-tWM");
        }
        if (debug) {
            args.addElement("-Od");
            args.addElement("-v");
        } else if (optimization != null) {
            if (optimization.isSpeed()) {
                args.addElement("-O1");
            } else if (optimization.isSpeed()) {
                args.addElement("-O2");
            } else if (optimization.isNoOptimization()) {
                args.addElement("-Od");
            }
        }
        if (rtti != null && !rtti.booleanValue()) {
            args.addElement("-RT-");
        }
    }

    @Override
    protected void addWarningSwitch(Vector<String> args, int level) {
        BorlandProcessor.addWarningSwitch(args, level);
    }

    @Override
    public Processor changeEnvironment(boolean newEnvironment, Environment env) {
        if (newEnvironment || env != null) {
            return new BorlandCCompiler(newEnvironment, env);
        }
        return this;
    }

    @Override
    protected CompilerConfiguration createPrecompileGeneratingConfig(CommandLineCompilerConfiguration baseConfig, File prototype, String lastInclude) {
        String[] additionalArgs = new String[]{"-H=" + lastInclude, "-Hc"};
        return new CommandLineCompilerConfiguration(baseConfig, additionalArgs, null, true);
    }

    @Override
    protected CompilerConfiguration createPrecompileUsingConfig(CommandLineCompilerConfiguration baseConfig, File prototype, String lastInclude, String[] exceptFiles) {
        String[] additionalArgs = new String[]{"-Hu"};
        return new CommandLineCompilerConfiguration(baseConfig, additionalArgs, exceptFiles, false);
    }

    @Override
    protected void getDefineSwitch(StringBuffer buffer, String define, String value) {
        BorlandProcessor.getDefineSwitch(buffer, define, value);
    }

    @Override
    protected File[] getEnvironmentIncludePath() {
        return BorlandProcessor.getEnvironmentPath("bcc32", 'I', new String[]{"..\\include"});
    }

    @Override
    protected String getIncludeDirSwitch(String includeDir) {
        return BorlandProcessor.getIncludeDirSwitch("-I", includeDir);
    }

    @Override
    public Linker getLinker(LinkType type) {
        return BorlandLinker.getInstance().getLinker(type);
    }

    @Override
    public int getMaximumCommandLength() {
        return 1024;
    }

    @Override
    protected void getUndefineSwitch(StringBuffer buffer, String define) {
        BorlandProcessor.getUndefineSwitch(buffer, define);
    }
}

