/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.deploy;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class Deployer {
    private static final int CMD_AMBIGUOUS = -2;
    private static final int CMD_UNKNOWN = -1;
    private static final int CMD_UNINSTALL = 0;
    private static final int CMD_INSTALL = 1;
    private static final int CMD_REINSTALL = 2;
    private static final int CMD_USER = 3;
    private static final int CMD_PASSWORD = 4;
    private static final int CMD_DATABASE = 5;
    private static final int CMD_HOSTNAME = 6;
    private static final int CMD_PORT = 7;
    private final Connection m_connection;
    private static final ArrayList s_commands = new ArrayList();

    private static final int getCommand(String arg) {
        int top = s_commands.size();
        int candidateCmd = -1;
        for (int idx = 0; idx < top; ++idx) {
            if (!((String)s_commands.get(idx)).startsWith(arg)) continue;
            if (candidateCmd != -1) {
                return -2;
            }
            candidateCmd = idx;
        }
        return candidateCmd;
    }

    public static void printUsage() {
        PrintStream out = System.err;
        out.println("usage: java org.postgresql.pljava.deploy.Deployer");
        out.println("    {-install | -uninstall | -reinstall}");
        out.println("    [ -host <hostName>     ]    # default is localhost");
        out.println("    [ -port <portNumber>   ]    # default is blank");
        out.println("    [ -database <database> ]    # default is name of current user");
        out.println("    [ -user <userName>     ]    # default is name of current user");
        out.println("    [ -password <password> ]    # default is no password");
    }

    public static void main(String[] argv) {
        String userName;
        String driverClass = "org.postgresql.Driver";
        String hostName = "localhost";
        String database = userName = System.getProperty("user.name", "postgres");
        String subsystem = "postgresql";
        String password = null;
        String portNumber = null;
        int cmd = -1;
        int top = argv.length;
        block10: for (int idx = 0; idx < top; ++idx) {
            String arg = argv[idx];
            if (arg.length() < 2) {
                Deployer.printUsage();
                return;
            }
            if (arg.charAt(0) != '-') continue;
            int optCmd = Deployer.getCommand(arg.substring(1));
            switch (optCmd) {
                case 0: 
                case 1: 
                case 2: {
                    if (cmd != -1) {
                        Deployer.printUsage();
                        return;
                    }
                    cmd = optCmd;
                    continue block10;
                }
                case 3: {
                    if (++idx < top && (userName = argv[idx]).length() > 0 && userName.charAt(0) != '-') continue block10;
                    Deployer.printUsage();
                    return;
                }
                case 4: {
                    if (++idx < top && (password = argv[idx]).length() > 0 && password.charAt(0) != '-') continue block10;
                    Deployer.printUsage();
                    return;
                }
                case 5: {
                    if (++idx < top && (database = argv[idx]).length() > 0 && database.charAt(0) != '-') continue block10;
                    Deployer.printUsage();
                    return;
                }
                case 6: {
                    if (++idx < top && (hostName = argv[idx]).length() > 0 && hostName.charAt(0) != '-') continue block10;
                    Deployer.printUsage();
                    return;
                }
                case 7: {
                    if (++idx < top && (portNumber = argv[idx]).length() > 0 && portNumber.charAt(0) != '-') continue block10;
                    Deployer.printUsage();
                    return;
                }
                default: {
                    Deployer.printUsage();
                    return;
                }
            }
        }
        if (cmd == -1) {
            Deployer.printUsage();
            return;
        }
        try {
            Class.forName(driverClass);
            StringBuffer cc = new StringBuffer();
            cc.append("jdbc:");
            cc.append(subsystem);
            cc.append("://");
            cc.append(hostName);
            if (portNumber != null) {
                cc.append(':');
                cc.append(portNumber);
            }
            cc.append('/');
            cc.append(database);
            Connection c = DriverManager.getConnection(cc.toString(), userName, password);
            Deployer.checkIfConnectedAsSuperuser(c);
            c.setAutoCommit(false);
            Deployer deployer = new Deployer(c);
            if (cmd == 0 || cmd == 2) {
                deployer.dropSQLJSchema();
            }
            if (cmd == 1 || cmd == 2) {
                deployer.createSQLJSchema();
                deployer.initJavaHandlers();
                deployer.initializeSQLJSchema();
            }
            c.commit();
            c.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Deployer(Connection c) {
        this.m_connection = c;
    }

    public static void checkIfConnectedAsSuperuser(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SHOW IS_SUPERUSER");
        try {
            if (rs.next() && rs.getString(1).equals("on")) {
                return;
            }
        }
        finally {
            rs.close();
            stmt.close();
        }
        throw new SQLException("You must be a superuser to deploy/undeploy pl/Java.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void dropSQLJSchema() throws SQLException {
        stmt = this.m_connection.createStatement();
        p = null;
        try {
            if (this.m_connection.getMetaData().supportsSavepoints()) {
                p = this.m_connection.setSavepoint();
            }
            stmt.execute("DROP LANGUAGE java CASCADE");
            stmt.execute("DROP LANGUAGE javaU CASCADE");
            ** if (p == null) goto lbl-1000
        }
        catch (SQLException e) {
            try {
                if (p != null) {
                    this.m_connection.rollback(p);
                } else {
                    this.m_connection.rollback();
                }
                ** if (p == null) goto lbl-1000
            }
            catch (Throwable var4_4) {
                if (p != null) {
                    this.m_connection.releaseSavepoint(p);
                }
                throw var4_4;
            }
lbl-1000:
            // 1 sources

            {
                this.m_connection.releaseSavepoint(p);
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            this.m_connection.releaseSavepoint(p);
        }
lbl-1000:
        // 2 sources

        {
        }
        stmt.execute("DROP SCHEMA sqlj CASCADE");
        stmt.close();
    }

    public void createSQLJSchema() throws SQLException {
        Statement stmt = this.m_connection.createStatement();
        stmt.execute("CREATE SCHEMA sqlj");
        stmt.execute("GRANT USAGE ON SCHEMA sqlj TO public");
        stmt.close();
    }

    public void initializeSQLJSchema() throws SQLException {
        Statement stmt = this.m_connection.createStatement();
        stmt.execute("CREATE TABLE sqlj.jar_repository(\tjarId\t\tSERIAL PRIMARY KEY,\tjarName\t\tVARCHAR(100) UNIQUE NOT NULL,\tjarOrigin   VARCHAR(500) NOT NULL,\tjarOwner\tNAME NOT NULL,\tjarManifest\tTEXT)");
        stmt.execute("GRANT SELECT ON sqlj.jar_repository TO public");
        stmt.execute("CREATE TABLE sqlj.jar_entry(   entryId     SERIAL PRIMARY KEY,\tentryName\tVARCHAR(200) NOT NULL,\tjarId\t\tINT NOT NULL REFERENCES sqlj.jar_repository ON DELETE CASCADE,   entryImage  BYTEA NOT NULL,   UNIQUE(jarId, entryName))");
        stmt.execute("GRANT SELECT ON sqlj.jar_entry TO public");
        stmt.execute("CREATE TABLE sqlj.jar_descriptor(   jarId\t\tINT REFERENCES sqlj.jar_repository ON DELETE CASCADE,   ordinal     INT2,   PRIMARY KEY (jarId, ordinal),   entryId     INT NOT NULL REFERENCES sqlj.jar_entry ON DELETE CASCADE)");
        stmt.execute("GRANT SELECT ON sqlj.jar_descriptor TO public");
        stmt.execute("CREATE TABLE sqlj.classpath_entry(\tschemaName\tVARCHAR(30) NOT NULL,\tordinal\t\tINT2 NOT NULL,\tjarId\t\tINT NOT NULL REFERENCES sqlj.jar_repository ON DELETE CASCADE,\tPRIMARY KEY(schemaName, ordinal))");
        stmt.execute("GRANT SELECT ON sqlj.classpath_entry TO public");
        stmt.execute("CREATE TABLE sqlj.typemap_entry(\tmapId\t\tSERIAL PRIMARY KEY,\tjavaName\tVARCHAR(200) NOT NULL,\tsqlName\t\tNAME NOT NULL)");
        stmt.execute("GRANT SELECT ON sqlj.typemap_entry TO public");
        stmt.execute("CREATE FUNCTION sqlj.install_jar(VARCHAR, VARCHAR, BOOLEAN) RETURNS void\tAS 'org.postgresql.pljava.management.Commands.installJar'\tLANGUAGE java SECURITY DEFINER");
        stmt.execute("CREATE FUNCTION sqlj.replace_jar(VARCHAR, VARCHAR, BOOLEAN) RETURNS void\tAS 'org.postgresql.pljava.management.Commands.replaceJar'\tLANGUAGE java SECURITY DEFINER");
        stmt.execute("CREATE FUNCTION sqlj.remove_jar(VARCHAR, BOOLEAN) RETURNS void\tAS 'org.postgresql.pljava.management.Commands.removeJar'\tLANGUAGE java SECURITY DEFINER");
        stmt.execute("CREATE FUNCTION sqlj.install_jar(BYTEA, VARCHAR, BOOLEAN) RETURNS void\tAS 'org.postgresql.pljava.management.Commands.installJar'\tLANGUAGE java SECURITY DEFINER");
        stmt.execute("CREATE FUNCTION sqlj.replace_jar(BYTEA, VARCHAR, BOOLEAN) RETURNS void\tAS 'org.postgresql.pljava.management.Commands.replaceJar'\tLANGUAGE java SECURITY DEFINER");
        stmt.execute("CREATE FUNCTION sqlj.set_classpath(VARCHAR, VARCHAR) RETURNS void\tAS 'org.postgresql.pljava.management.Commands.setClassPath'\tLANGUAGE java SECURITY DEFINER");
        stmt.execute("CREATE FUNCTION sqlj.get_classpath(VARCHAR) RETURNS VARCHAR\tAS 'org.postgresql.pljava.management.Commands.getClassPath'\tLANGUAGE java STABLE SECURITY DEFINER");
        stmt.execute("CREATE FUNCTION sqlj.add_type_mapping(VARCHAR, VARCHAR) RETURNS void\tAS 'org.postgresql.pljava.management.Commands.addTypeMapping'\tLANGUAGE java SECURITY DEFINER");
        stmt.execute("CREATE FUNCTION sqlj.drop_type_mapping(VARCHAR) RETURNS void\tAS 'org.postgresql.pljava.management.Commands.dropTypeMapping'\tLANGUAGE java SECURITY DEFINER");
        stmt.close();
    }

    public void initJavaHandlers() throws SQLException {
        Statement stmt = this.m_connection.createStatement();
        stmt.execute("CREATE FUNCTION sqlj.java_call_handler() RETURNS language_handler AS 'pljava' LANGUAGE C");
        stmt.execute("CREATE TRUSTED LANGUAGE java HANDLER sqlj.java_call_handler");
        stmt.execute("CREATE FUNCTION sqlj.javau_call_handler() RETURNS language_handler AS 'pljava' LANGUAGE C");
        stmt.execute("CREATE LANGUAGE javaU HANDLER sqlj.javau_call_handler");
        stmt.close();
    }

    static {
        s_commands.add(0, "uninstall");
        s_commands.add(1, "install");
        s_commands.add(2, "reinstall");
        s_commands.add(3, "user");
        s_commands.add(4, "password");
        s_commands.add(5, "database");
        s_commands.add(6, "host");
        s_commands.add(7, "port");
    }
}

