/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.example.annotation;

import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.util.logging.Logger;
import org.postgresql.pljava.annotation.Function;
import org.postgresql.pljava.annotation.MappedUDT;
import org.postgresql.pljava.annotation.SQLAction;
import org.postgresql.pljava.annotation.SQLType;

@SQLAction(requires={"point mirror type", "point assertHasValues"}, install={"SELECT javatest.assertHasValues(CAST('(1,2)' AS point), 1, 2)"})
@MappedUDT(name="point", provides={"point mirror type"})
public class Point
implements SQLData {
    private static Logger s_logger = Logger.getAnonymousLogger();
    private double m_x;
    private double m_y;
    private String m_typeName;

    @Function(schema="javatest", type="point", requires={"point mirror type"}, effects=Function.Effects.IMMUTABLE, onNullInput=Function.OnNullInput.RETURNS_NULL)
    public static Point logAndReturn(@SQLType(value="point") Point pt) {
        s_logger.info(pt.getSQLTypeName() + pt);
        return pt;
    }

    @Function(schema="javatest", requires={"point mirror type"}, provides={"point assertHasValues"}, effects=Function.Effects.IMMUTABLE, onNullInput=Function.OnNullInput.RETURNS_NULL)
    public static void assertHasValues(@SQLType(value="point") Point pt, double x, double y) throws SQLException {
        if (pt.m_x != x || pt.m_y != y) {
            throw new SQLException("assertHasValues fails");
        }
    }

    @Override
    public String getSQLTypeName() {
        return this.m_typeName;
    }

    @Override
    public void readSQL(SQLInput stream, String typeName) throws SQLException {
        s_logger.info(typeName + " from SQLInput");
        this.m_x = stream.readDouble();
        this.m_y = stream.readDouble();
        this.m_typeName = typeName;
    }

    @Override
    public void writeSQL(SQLOutput stream) throws SQLException {
        s_logger.info(this.m_typeName + " to SQLOutput");
        stream.writeDouble(this.m_x);
        stream.writeDouble(this.m_y);
    }

    public String toString() {
        return String.format("(%g,%g)", this.m_x, this.m_y);
    }
}

