/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.example;

import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Logger;
import org.postgresql.pljava.ObjectPool;
import org.postgresql.pljava.PooledObject;
import org.postgresql.pljava.ResultSetProvider;
import org.postgresql.pljava.SessionManager;

public class UsingProperties
implements ResultSetProvider,
PooledObject {
    private static Logger s_logger = Logger.getAnonymousLogger();
    private final Properties m_properties;
    private final ObjectPool m_pool;
    private Enumeration<?> m_propertyIterator;

    public static ResultSetProvider getProperties() throws SQLException {
        ObjectPool pool = SessionManager.current().getObjectPool(UsingProperties.class);
        return (ResultSetProvider)pool.activateInstance();
    }

    public UsingProperties(ObjectPool pool) throws IOException {
        this.m_pool = pool;
        this.m_properties = new Properties();
        s_logger.info("** UsingProperties()");
        InputStream propStream = this.getClass().getResourceAsStream("example.properties");
        if (propStream == null) {
            s_logger.info("example.properties was null");
        } else {
            this.m_properties.load(propStream);
            propStream.close();
            s_logger.info("example.properties has " + this.m_properties.size() + " entries");
        }
    }

    public void activate() {
        s_logger.info("** UsingProperties.activate()");
        this.m_propertyIterator = this.m_properties.propertyNames();
    }

    public boolean assignRowValues(ResultSet receiver, int currentRow) throws SQLException {
        if (this.m_propertyIterator == null || !this.m_propertyIterator.hasMoreElements()) {
            s_logger.fine("no more rows, returning false");
            return false;
        }
        String propName = (String)this.m_propertyIterator.nextElement();
        receiver.updateString(1, propName);
        receiver.updateString(2, this.m_properties.getProperty(propName));
        return true;
    }

    public void close() throws SQLException {
        this.m_pool.passivateInstance((PooledObject)this);
    }

    public void passivate() {
        s_logger.info("** UsingProperties.passivate()");
        this.m_propertyIterator = null;
    }

    public void remove() {
        s_logger.info("** UsingProperties.remove()");
        this.m_properties.clear();
    }
}

