/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import org.postgresql.pljava.internal.Oid;
import org.postgresql.pljava.jdbc.AbstractResultSetMetaData;
import org.postgresql.pljava.jdbc.ResultSetField;

public class SyntheticResultSetMetaData
extends AbstractResultSetMetaData {
    private final ResultSetField[] m_fields;

    public SyntheticResultSetMetaData(ResultSetField[] fields) {
        this.m_fields = fields;
    }

    @Override
    public final int getColumnCount() throws SQLException {
        return this.m_fields.length;
    }

    @Override
    public final boolean isAutoIncrement(int column) throws SQLException {
        this.checkColumnIndex(column);
        return false;
    }

    @Override
    public final String getColumnLabel(int column) throws SQLException {
        this.checkColumnIndex(column);
        return this.m_fields[column - 1].getColumnLabel();
    }

    @Override
    public final String getColumnClassName(int column) throws SQLException {
        this.checkColumnIndex(column);
        return this.m_fields[column - 1].getJavaClass().getName();
    }

    @Override
    protected final void checkColumnIndex(int column) throws SQLException {
        if (column < 1 || column > this.m_fields.length) {
            throw new SQLException("Invalid column index: " + column);
        }
    }

    @Override
    protected final Oid getOid(int column) throws SQLException {
        return this.m_fields[column - 1].getOID();
    }

    @Override
    protected final int getFieldLength(int column) throws SQLException {
        return this.m_fields[column - 1].getLength();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".isWrapperFor( Class<?> ) not implemented yet.", "0A000");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".unwrapClass( Class<?> ) not implemented yet.", "0A000");
    }
}

