/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLInput;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.JavaWrapper;
import org.postgresql.pljava.internal.TupleDesc;
import org.postgresql.pljava.jdbc.BlobValue;
import org.postgresql.pljava.jdbc.ClobValue;
import org.postgresql.pljava.jdbc.SPIConnection;

public class SQLInputFromTuple
extends JavaWrapper
implements SQLInput {
    private int m_index;
    private final TupleDesc m_tupleDesc;
    private boolean m_wasNull;

    public SQLInputFromTuple(long heapTupleHeaderPointer, TupleDesc tupleDesc) throws SQLException {
        super(heapTupleHeaderPointer);
        this.m_tupleDesc = tupleDesc;
        this.m_index = 0;
        this.m_wasNull = false;
    }

    @Override
    public Array readArray() throws SQLException {
        return (Array)this.readValue(Array.class);
    }

    @Override
    public InputStream readAsciiStream() throws SQLException {
        Clob c = this.readClob();
        return c == null ? null : c.getAsciiStream();
    }

    @Override
    public BigDecimal readBigDecimal() throws SQLException {
        return (BigDecimal)this.readValue(BigDecimal.class);
    }

    @Override
    public InputStream readBinaryStream() throws SQLException {
        Blob b = this.readBlob();
        return b == null ? null : b.getBinaryStream();
    }

    @Override
    public Blob readBlob() throws SQLException {
        byte[] bytes = this.readBytes();
        return bytes == null ? null : new BlobValue(bytes);
    }

    @Override
    public boolean readBoolean() throws SQLException {
        Boolean b = (Boolean)this.readValue(Boolean.class);
        return b == null ? false : b;
    }

    @Override
    public byte readByte() throws SQLException {
        Number b = this.readNumber(Byte.TYPE);
        return b == null ? (byte)0 : b.byteValue();
    }

    @Override
    public byte[] readBytes() throws SQLException {
        return (byte[])this.readValue(byte[].class);
    }

    @Override
    public Reader readCharacterStream() throws SQLException {
        Clob c = this.readClob();
        return c == null ? null : c.getCharacterStream();
    }

    @Override
    public Clob readClob() throws SQLException {
        String str = this.readString();
        return str == null ? null : new ClobValue(str);
    }

    @Override
    public Date readDate() throws SQLException {
        return (Date)this.readValue(Date.class);
    }

    @Override
    public double readDouble() throws SQLException {
        Number d = this.readNumber(Double.TYPE);
        return d == null ? 0.0 : d.doubleValue();
    }

    @Override
    public float readFloat() throws SQLException {
        Number f = this.readNumber(Float.TYPE);
        return f == null ? 0.0f : f.floatValue();
    }

    @Override
    public int readInt() throws SQLException {
        Number i = this.readNumber(Integer.TYPE);
        return i == null ? 0 : i.intValue();
    }

    @Override
    public long readLong() throws SQLException {
        Number l = this.readNumber(Long.TYPE);
        return l == null ? 0L : l.longValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object readObject() throws SQLException {
        if (this.m_index < this.m_tupleDesc.size()) {
            Object v;
            Object object = Backend.THREADLOCK;
            synchronized (object) {
                v = SQLInputFromTuple._getObject(this.getNativePointer(), this.m_tupleDesc.getNativePointer(), ++this.m_index);
            }
            this.m_wasNull = v == null;
            return v;
        }
        throw new SQLException("Tuple has no more columns");
    }

    @Override
    public Ref readRef() throws SQLException {
        return (Ref)this.readValue(Ref.class);
    }

    @Override
    public short readShort() throws SQLException {
        Number s = this.readNumber(Short.TYPE);
        return s == null ? (short)0 : s.shortValue();
    }

    @Override
    public String readString() throws SQLException {
        return (String)this.readValue(String.class);
    }

    @Override
    public Time readTime() throws SQLException {
        return (Time)this.readValue(Time.class);
    }

    @Override
    public Timestamp readTimestamp() throws SQLException {
        return (Timestamp)this.readValue(Timestamp.class);
    }

    @Override
    public URL readURL() throws SQLException {
        return (URL)this.readValue(URL.class);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.m_wasNull;
    }

    private Number readNumber(Class numberClass) throws SQLException {
        return SPIConnection.basicNumericCoersion(numberClass, this.readObject());
    }

    private Object readValue(Class valueClass) throws SQLException {
        return SPIConnection.basicCoersion(valueClass, this.readObject());
    }

    @Override
    public RowId readRowId() throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".readRowId() not implemented yet.", "0A000");
    }

    @Override
    public SQLXML readSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".readSQLXML() not implemented yet.", "0A000");
    }

    @Override
    public String readNString() throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".readNString() not implemented yet.", "0A000");
    }

    @Override
    public NClob readNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".readNClob() not implemented yet.", "0A000");
    }

    @Override
    protected native void _free(long var1);

    private static native Object _getObject(long var0, long var2, int var4) throws SQLException;
}

