/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.postgresql.pljava.ObjectPool;
import org.postgresql.pljava.SavepointListener;
import org.postgresql.pljava.TransactionListener;
import org.postgresql.pljava.internal.AclId;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.ELogHandler;
import org.postgresql.pljava.internal.ObjectPoolImpl;
import org.postgresql.pljava.internal.SubXactListener;
import org.postgresql.pljava.internal.TransactionalMap;
import org.postgresql.pljava.internal.XactListener;
import org.postgresql.pljava.jdbc.SQLUtils;

public class Session
implements org.postgresql.pljava.Session {
    private final TransactionalMap m_attributes = new TransactionalMap((Map)new HashMap());

    @Override
    public void addTransactionListener(TransactionListener listener) {
        XactListener.addListener(listener);
    }

    @Override
    public void addSavepointListener(SavepointListener listener) {
        SubXactListener.addListener(listener);
    }

    @Override
    public Object getAttribute(String attributeName) {
        return this.m_attributes.get(attributeName);
    }

    @Override
    public ObjectPool getObjectPool(Class cls) {
        return ObjectPoolImpl.getObjectPool(cls);
    }

    @Override
    public String getUserName() {
        return AclId.getUser().getName();
    }

    @Override
    public String getOuterUserName() {
        return AclId.getOuterUser().getName();
    }

    @Override
    public String getSessionUserName() {
        return this.getOuterUserName();
    }

    @Override
    public void removeAttribute(String attributeName) {
        this.m_attributes.remove(attributeName);
    }

    @Override
    public void setAttribute(String attributeName, Object value) {
        this.m_attributes.put(attributeName, value);
    }

    @Override
    public void removeTransactionListener(TransactionListener listener) {
        XactListener.removeListener(listener);
    }

    @Override
    public void removeSavepointListener(SavepointListener listener) {
        SubXactListener.removeListener(listener);
    }

    @Override
    public void executeAsSessionUser(Connection conn, String statement) throws SQLException {
        this.executeAsOuterUser(conn, statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeAsOuterUser(Connection conn, String statement) throws SQLException {
        Statement stmt = conn.createStatement();
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            ResultSet rs = null;
            AclId outerUser = AclId.getOuterUser();
            AclId effectiveUser = AclId.getUser();
            boolean wasLocalChange = false;
            boolean changeSucceeded = false;
            try {
                wasLocalChange = Session._setUser(outerUser, true);
                changeSucceeded = true;
                if (stmt.execute(statement)) {
                    rs = stmt.getResultSet();
                    rs.next();
                }
            }
            finally {
                SQLUtils.close(rs);
                SQLUtils.close(stmt);
                if (changeSucceeded) {
                    Session._setUser(effectiveUser, wasLocalChange);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getOuterUserSchema() throws SQLException {
        Statement stmt = SQLUtils.getDefaultConnection().createStatement();
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            block7: {
                String string;
                ResultSet rs = null;
                AclId sessionUser = AclId.getSessionUser();
                AclId effectiveUser = AclId.getUser();
                boolean wasLocalChange = false;
                boolean changeSucceeded = false;
                try {
                    wasLocalChange = Session._setUser(sessionUser, true);
                    changeSucceeded = true;
                    rs = stmt.executeQuery("SELECT current_schema()");
                    if (!rs.next()) break block7;
                    string = rs.getString(1);
                }
                catch (Throwable throwable) {
                    SQLUtils.close(rs);
                    SQLUtils.close(stmt);
                    if (changeSucceeded) {
                        Session._setUser(effectiveUser, wasLocalChange);
                    }
                    throw throwable;
                }
                SQLUtils.close(rs);
                SQLUtils.close(stmt);
                if (changeSucceeded) {
                    Session._setUser(effectiveUser, wasLocalChange);
                }
                return string;
            }
            throw new SQLException("Unable to obtain current schema");
        }
    }

    static long init() throws SQLException {
        ELogHandler.init();
        return System.identityHashCode(Thread.currentThread());
    }

    private static native boolean _setUser(AclId var0, boolean var1);
}

