/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.sql.SQLException;
import java.util.HashMap;
import org.postgresql.pljava.internal.Backend;

public class Oid
extends Number {
    private static final HashMap s_class2typeId = new HashMap();
    private static final HashMap s_typeId2class = new HashMap();
    private final int m_native;

    public static Oid forJavaClass(Class clazz) {
        return (Oid)s_class2typeId.get(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Oid forTypeName(String typeString) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return new Oid(Oid._forTypeName(typeString));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Oid forSqlType(int sqlType) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return new Oid(Oid._forSqlType(sqlType));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Oid getTypeId() {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return Oid._getTypeId();
        }
    }

    public static void registerType(Class clazz, Oid typeId) {
        s_class2typeId.put(clazz, typeId);
        if (!s_typeId2class.containsKey(typeId)) {
            s_typeId2class.put(typeId, clazz);
        }
    }

    public Oid(int value) {
        this.m_native = value;
    }

    @Override
    public double doubleValue() {
        return this.m_native;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof Oid && ((Oid)o).m_native == this.m_native;
    }

    @Override
    public float floatValue() {
        return this.m_native;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getJavaClass() throws SQLException {
        Class<?> c = (Class<?>)s_typeId2class.get(this);
        if (c == null) {
            String className;
            Object object = Backend.THREADLOCK;
            synchronized (object) {
                className = Oid._getJavaClassName(this.m_native);
            }
            try {
                c = Class.forName(Oid.getCanonicalClassName(className, 0));
            }
            catch (ClassNotFoundException e) {
                throw new SQLException(e.getMessage());
            }
            s_typeId2class.put(this, c);
            s_class2typeId.put(c, this);
        }
        return c;
    }

    public int hashCode() {
        return this.m_native;
    }

    @Override
    public int intValue() {
        return this.m_native;
    }

    @Override
    public long longValue() {
        return this.m_native;
    }

    public String toString() {
        return "OID(" + this.m_native + ')';
    }

    private static String getCanonicalClassName(String name, int nDims) {
        if (name.endsWith("[]")) {
            return Oid.getCanonicalClassName(name.substring(0, name.length() - 2), nDims + 1);
        }
        boolean primitive = true;
        if (name.equals("boolean")) {
            name = "Z";
        } else if (name.equals("byte")) {
            name = "B";
        } else if (name.equals("char")) {
            name = "C";
        } else if (name.equals("double")) {
            name = "D";
        } else if (name.equals("float")) {
            name = "F";
        } else if (name.equals("int")) {
            name = "I";
        } else if (name.equals("long")) {
            name = "J";
        } else if (name.equals("short")) {
            name = "S";
        } else {
            primitive = false;
        }
        if (nDims > 0) {
            StringBuffer bld = new StringBuffer();
            while (--nDims >= 0) {
                bld.append('[');
            }
            if (primitive) {
                bld.append(name);
            } else {
                bld.append('L');
                bld.append(name);
                bld.append(';');
            }
            name = bld.toString();
        }
        return name;
    }

    private static native int _forTypeName(String var0) throws SQLException;

    private static native int _forSqlType(int var0) throws SQLException;

    private static native Oid _getTypeId();

    private static native String _getJavaClassName(int var0) throws SQLException;

    static {
        try {
            Class.forName("org.postgresql.pljava.jdbc.SPIDriver");
        }
        catch (ClassNotFoundException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

