/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.report;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.maven.plugin.surefire.report.FileReporter;
import org.apache.maven.plugin.surefire.report.TestcycleConsoleOutputReceiver;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.util.NestedRuntimeException;

public class ConsoleOutputFileReporter
implements TestcycleConsoleOutputReceiver {
    private final File reportsDirectory;
    private final String reportNameSuffix;
    private PrintWriter printWriter = null;
    private String reportEntryName;

    public ConsoleOutputFileReporter(File reportsDirectory, String reportNameSuffix) {
        this.reportsDirectory = reportsDirectory;
        this.reportNameSuffix = reportNameSuffix;
    }

    public void testSetStarting(ReportEntry reportEntry) {
        this.close();
        this.reportEntryName = reportEntry.getName();
    }

    public void testSetCompleted(ReportEntry report) throws ReporterException {
    }

    public void close() {
        if (this.printWriter != null) {
            this.printWriter.close();
            this.printWriter = null;
        }
    }

    public void writeTestOutput(byte[] buf, int off, int len, boolean stdout) {
        try {
            if (this.printWriter == null) {
                if (!this.reportsDirectory.exists()) {
                    this.reportsDirectory.mkdirs();
                }
                File file = FileReporter.getReportFile(this.reportsDirectory, this.reportEntryName, this.reportNameSuffix, "-output.txt");
                this.printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            }
            this.printWriter.write(new String(buf, off, len));
        }
        catch (IOException e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }
}

