/* $Id: packet.h,v 1.2 2008/09/10 13:17:59 agcrooks Exp $ */

/*
 * Copyright (c) 2005 Manuel Freire.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _BPG_PACKET_H_
#define _BPG_PACKET_H_

#include <stdio.h>
#include <stdlib.h>

#include <openssl/dsa.h>

#include "bpg.h"
#include "data.h"

enum {
	PKTTYPE_PKESK = 1,
	PKTTYPE_SIG = 2,
	PKTTYPE_SKESK = 3,
	PKTTYPE_ONEPASS = 4,
	PKTTYPE_SECKEY = 5,
	PKTTYPE_PUBKEY = 6,
	PKTTYPE_SECSUBKEY = 7,
	PKTTYPE_COMPRESS = 8,
	PKTTYPE_SYMMENC = 9,
	PKTTYPE_MARKER = 10,
	PKTTYPE_LITERAL = 11,
	PKTTYPE_TRUST = 12,
	PKTTYPE_USERID = 13,
	PKTTYPE_PUBSUBKEY = 14
};

enum {
	BPG_BINARY_FORMAT	= 0x62
};

enum {
	PKTFORMAT_OLD = 1,
	PKTFORMAT_NEW
};

enum {
	PKTLENTYPE_ONE_OCT = 0,
	PKTLENTYPE_TWO_OCT = 1,
	PKTLENTYPE_FOUR_OCT = 2,
	PKTLENTYPE_INDETER = 3
};

enum {
	SIGTYPE_BINARY_DOC = 0x00,
	SIGTYPE_CANONICALTEXT_DOC = 0x01,
	SIGTYPE_STANDALONE = 0x02,
	SIGTYPE_GENERIC_CERT = 0x10,
	SIGTYPE_PERSONA_CERT = 0x11,
	SIGTYPE_CASUAL_CERT = 0x12,
	SIGTYPE_POSITIVE_CERT = 0x13,
	SIGTYPE_SUBKEY_BINDING = 0x18,
	SIGTYPE_SIG_DIRECTLY_ON_A_KEY = 0x1f,
	SIGTYPE_KEY_REVOCATION = 0x20,
	SIGTYPE_SUBKEY_REVOCATION = 0x28,
	SIGTYPE_CERT_REVOCATION = 0x30,
	SIGTYPE_TIMESTAMP = 0x40
};

enum {
	SIGVERSION_3 = 3,
	SIGVERSION_4 = 4
};

enum {
	KEYVERSION_2 = 2,
	KEYVERSION_3 = 3,
	KEYVERSION_4 = 4
};

typedef struct BPG_PKT {
	uint8_t format;
	uint8_t type;
	uint8_t length_type;	/* V3 only. */
	uint32_t length;
	uint32_t full_length;	/* length + header, i.e. total packet size */
	BPG_BUF *body;
} BPG_PKT;

typedef struct BPG_SIG {
	uint8_t version;
	uint8_t type;
	uint8_t pubkey_algo;
	uint8_t hash_algo;
	unsigned char hash_start[2];
	bpg_time_t creation_time;			/* V3 only */
	unsigned char key_id[8];			/* V3 only */
	uint16_t hashed_subpackets_length;		/* V4 only */
	uint16_t unhashed_subpackets_length;		/* V4 only */
	unsigned char *hashed_subpackets_data;		/* V4 only */
	unsigned char *unhashed_subpackets_data;	/* V4 only */
	DSA_SIG *dsa_sig;				/* DSA only */
} BPG_SIG;

typedef struct BPG_PUBKEY {
	uint8_t version;
	uint8_t pubkey_algo;
	uint16_t valid_days;		/* V3 only. */
	bpg_time_t creation_time;
	DSA *dsa;			/* DSA only. */
} BPG_PUBKEY;

typedef struct BPG_SECKEY {
	uint8_t checksum[2];
	uint8_t iv[8];
	uint8_t s2k_usage;
	uint8_t symm_algo;
	S2K *s2k;
	DSA *dsa;			/* DSA only, points pubkey->dsa. */
	BPG_PUBKEY *pubkey;
} BPG_SECKEY;

BPG_PKT * BPG_PKT_new(void);
void BPG_PKT_free(BPG_PKT *);
void BPG_PKT_print(BPG_PKT *, FILE *);
int BPG_PKT_read(BPG_PKT *, unsigned char *, size_t);
void BPG_PKT_write(BPG_PKT *, BPG_BUF *);
void BPG_PKT_build(BPG_PKT *, uint8_t, BPG_CTX *);

BPG_SIG * BPG_SIG_new(void);
void BPG_SIG_free(BPG_SIG *);
void BPG_SIG_print(BPG_SIG *, FILE *);
int BPG_SIG_read(BPG_SIG *, BPG_BUF *);
int BPG_SIG_read_packet(BPG_SIG *, unsigned char *, size_t);
int BPG_SIG_build(BPG_SIG *, BPG_BUF *, BPG_CTX *);
int BPG_SIG_build_packet(BPG_SIG *, BPG_BUF *, BPG_CTX *);

BPG_PUBKEY * BPG_PUBKEY_new(void);
void BPG_PUBKEY_free(BPG_PUBKEY *);
void BPG_PUBKEY_print(BPG_PUBKEY *, FILE *);
int BPG_PUBKEY_read(BPG_PUBKEY *, BPG_BUF *);
int BPG_PUBKEY_read_packet(BPG_PUBKEY *, unsigned char *, size_t);
int BPG_PUBKEY_build(BPG_PUBKEY *, BPG_BUF *, BPG_CTX *);
int BPG_PUBKEY_build_packet(BPG_PUBKEY *, BPG_BUF *, BPG_CTX *);

BPG_SECKEY * BPG_SECKEY_new(void);
void BPG_SECKEY_free(BPG_SECKEY *);
void BPG_SECKEY_print(BPG_SECKEY *, FILE *);
int BPG_SECKEY_read(BPG_SECKEY *, BPG_BUF *, BPG_CTX *);
int BPG_SECKEY_read_packet(BPG_SECKEY *, unsigned char *, size_t, BPG_CTX *);
int BPG_SECKEY_build(BPG_SECKEY *, BPG_BUF *, BPG_CTX *);
int BPG_SECKEY_build_packet(BPG_SECKEY *, BPG_BUF *, BPG_CTX *);

int BPG_LITERAL_read(BPG_BUF *, BPG_BUF *);
int BPG_LITERAL_build(BPG_BUF *, BPG_BUF *, char *);

int BPG_ONEPASS_build(BPG_BUF *, BPG_CTX *);

#endif /* !_BPG_PACKET_H_ */

