/*-
 * Copyright (c) 2008 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Alistair Crooks (agc@NetBSD.org)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <sys/types.h>
#include <sys/param.h>

#include <regex.h>
#include <stdio.h>
#include <string.h>
#include <stdio.h>
#include <unistd.h>

#include "bpg.h"

int
bpg_get_defaults(bpginfo_t *info, char *user)
{
	regmatch_t	matchv[10];
	regex_t		r;
	FILE		*fp;
	char		buf[BUFSIZ * 4];
	char		defkey[8 + 1];
	int		ret;

	(void) regcomp(&r, "^[ \t]*default-key[ \t]+(.*)", REG_EXTENDED);
	(void) snprintf(buf, sizeof(buf), "%s/.gnupg/gpg.conf", getenv("HOME"));
	if ((fp = fopen(buf, "r")) == NULL) {
		return 0;
	}
	for (ret = 0 ; fgets(buf, sizeof(buf), fp) != NULL ; ) {
		buf[strlen(buf) - 1] = 0x0;
		if (regexec(&r, buf, 10, matchv, 0) == 0) {
			(void) strlcpy(defkey, &buf[(int)matchv[1].rm_so], sizeof(defkey));
			ret = 1;
			BPG_set_id(info->opt, "public", defkey);
		}
	}
	(void) fclose(fp);
	(void) snprintf(buf, sizeof(buf), "%s/.gnupg/secring.gpg", getenv("HOME"));
	info->sec_file = strdup(buf);
	(void) snprintf(buf, sizeof(buf), "%s/.gnupg/pubring.gpg", getenv("HOME"));
	info->pub_file = strdup(buf);
	return ret;
}
