/* $Id: data.h,v 1.1.1.1 2008/09/10 09:32:57 agcrooks Exp $ */

/*
 * Copyright (c) 2005 Manuel Freire.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _BPG_DATA_H_
#define _BPG_DATA_H_

#include <stdio.h>
#include <stdlib.h>

#include <openssl/evp.h>

#include "bpg.h"

enum {
	S2KTYPE_SIMPLE = 0,
	S2KTYPE_SALTED = 1,
	S2KTYPE_ITERATED_SALTED = 3
};

typedef uint32_t bpg_time_t;

typedef struct S2K {
	uint8_t type;
	uint8_t hash_algo;
	uint8_t salt[8];	/* Salted and Iterated & Salted types only. */
	uint32_t count;		/* Iterated & Salted type only. */
} S2K;

bpg_time_t bpg_time_get(void);

S2K * S2K_new(void);
void S2K_free(S2K *);
int S2K_read(S2K *, unsigned char *, size_t);
int S2K_write(S2K *, BPG_BUF *);
void S2K_print(S2K *, FILE *);
int S2K_getkey(S2K *, char *, uint8_t, BPG_BUF *);

#endif /* !_BPG_DATA_H_ */

