
disk_avail=$DLSIZE
# disk_align=`expr $DLSIZE / $BCYL`
disk_align=`expr $DLSEC \* $DLHEAD`

# 30Mb
e2fs_size=31457280

two_gigs=2147483648
ten_gigs=10737418240
five_megs=524288000

slice_size=0
part_start=0

sector_size=512

printmsg()
{
	echo ""
	echo " ------------------------------------------------"
	echo "  $*..."
	echo " ------------------------------------------------"
	echo ""

	if [ -x $WRITELCD ]; then
		$WRITELCD "$*..."
	fi
}

align_size()
{
    sz=`expr "$1" / "$disk_align" \* "$disk_align"`

	if [ $1 -gt $sz ]; then
		align=`expr "$sz" + "$disk_align"`
	else
		align=$sz
	fi

	if [ $align -le 0 ]; then
		printmsg "PANIC: requested partition size <= 0"
		exit 1
	fi

	export align
}

get_slice_size()
{
	sz=`expr $1 / "$sector_size"`

	align_size $sz

	size=$align
	export size
}

update_avail()
{
	disk_avail=`expr $disk_avail - $1`
	part_start=`expr $part_start + $1`

	if [ $disk_avail -le 0 ]; then
		printmsg "PANIC: disk is too small"
		exit 1
	fi
}

create_lcddev()
{
	$MKNOD $1 c 34 0
}

# setup small ext2 partition
create_altroot()
{
	printmsg "Setting up the Ext2 partition"

	get_slice_size $e2fs_size

	$FDISK -0 -u -f -s $LINUX_PART/1/$size $DISK

	update_avail $size

	size=`expr $size - 1`
	echo " e: $size 1 Linux Ext2 0 0" >> $PTAB
}

# create swap partition
create_swap()
{
	printmsg "Setting up swap"

	req_size=`$SYSCTL -n hw.physmem`
	req_size=`expr $req_size \* 2`

	get_slice_size $req_size
	$FDISK -1 -u -f -s $LINUX_SWAP/$part_start/$size $DISK

	echo " b: $size $part_start swap" >> $PTAB

	update_avail $size
}

# create NetBSD partition
create_42bsd()
{
	printmsg "Setting up BSD partition"

	$FDISK -2 -u -f -s $NETBSD_PART/$part_start/$disk_avail $DISK

	echo " c: $disk_avail $part_start unused 0 0" >> $PTAB
	echo " d: $DLSIZE 0 unused 0 0" >> $PTAB

	bsd_size=$disk_avail
	export bsd_size
}

# create /var slice
create_var_slice()
{
	# try to take 20% of the available disk space (10% if disk size < 2G)
	get_slice_size $two_gigs
	if [ $DLSIZE -le $size ]; then
		div=10
	else
		div=5
	fi

	varsz=`expr $bsd_size / $div`

	# if it's more than 2G, stick to 2G
	get_slice_size $two_gigs
	if [ $varsz -gt $size ]; then
		varsz=$size
	fi

	align_size $varsz
	varsz=$align

	echo " f: $varsz $part_start 4.2BSD 0 0" >> $PTAB

	update_avail $varsz
}

# create /tmp slice
create_tmp_slice()
{
	# try to take 5% of the available disk space
	tmpsz=`expr $bsd_size / 10`

	# if it's more than 500m, stick to 500m
	get_slice_size $five_megs

	if [ $tmpsz -gt $size ]; then
		tmpsz=$size
	fi

	align_size $tmpsz
	tmpsz=$align

	echo " g: $tmpsz $part_start 4.2BSD 0 0" >> $PTAB

	update_avail $tmpsz
}

# create / slice
create_root_slice()
{
	# the rest is for the installation
	echo " a: $disk_avail $part_start 4.2BSD 0 0" >> $PTAB
}

# remove all partition tables
clear_disk()
{
	printmsg "Clearing partition information"
	$FDISK -0 -f -u -s 0/0/0 $DISK
	$FDISK -1 -f -u -s 0/0/0 $DISK
	$FDISK -2 -f -u -s 0/0/0 $DISK
	$FDISK -3 -f -u -s 0/0/0 $DISK
}

install_disklabel()
{
	$DISKLABEL $DISK | $SED '/^..:/d' >$INSTPTAB
	$CAT $PTAB >> $INSTPTAB

	$DISKLABEL -R -r $DISK $INSTPTAB
}

init_filesystems()
{
	printmsg "Setting up boot partition"
	$MKE2FS -r 0 -O none -m 0 $ALTROOT_DEV

	printmsg "Setting up /var"
	$NEWFS $VAR_DEV

	printmsg "Setting up /tmp"
	$NEWFS $TMP_DEV

	printmsg "Setting up root"
	$NEWFS $ROOT_DEV
}

install_boot()
{
	printmsg "Setting up boot partition..."

	$MOUNT $ALTROOT_DEV /mnt
	mkdir /mnt/boot

	# Copy boot loader and the kernels as a backup measure
	$CP /cobalt/binary/kernel/boot.gz /mnt/boot
	$CP /cobalt/binary/kernel/netbsd.gz /mnt/boot
	$CP /cobalt/binary/kernel/netbsd-GENERIC.gz /mnt/boot

	cd /mnt/boot
	for i in $RAQ_KERNELS; do
		$LN boot.gz $i
	done

	cd /
	$UMOUNT /mnt
}

install_files()
{
	printmsg "Copying files"

	$MOUNT $ROOT_DEV /mnt

	$MKDIR /mnt/var
	$MOUNT $VAR_DEV /mnt/var

	$MKDIR /mnt/tmp
	$MOUNT $TMP_DEV /mnt/tmp

	cd /mnt
	for i in $INST_TARBALLS; do
		printmsg "Unpacking $i"
		$GZIP -cd /cobalt/binary/sets/$i | $TAR xpf -
	done

	$GZIP -cd /cobalt/binary/kernel/netbsd.gz > /mnt/netbsd

	printmsg "Fixing up /dev"
	if [ -d /mnt/dev ]; then
		create_lcddev /mnt/dev/lcd
		cd /mnt/dev
		./MAKEDEV all
	else
		printmsg "WARNING: no /mnt/dev"
	fi

	printmsg "Fixing up /etc"

	# Backup original files
	curdir=`pwd`
	cd /install/files/etc
	for i in *; do
		if [ -f /mnt/etc/$i ]; then
			mv /mnt/etc/$i /mnt/etc/$i.orig
		fi
	done
	cd $curdir

	# Copy everything needed to complete the installation
	( cd /install/files && tar cpf - * ) | ( cd /mnt && tar xpf - )

	cd /

	# Fix permissions
	$CHMOD 755 /mnt/var
	$CHMOD 4777 /mnt/tmp

	$UMOUNT /mnt/tmp
	$UMOUNT /mnt/var
	$UMOUNT /mnt
}

do_reboot()
{
	printmsg "Rebooting"
	$REBOOT
}

install()
{
	# installation entry point
	printmsg "Setting up the disk"

	$RM -f $PTAB
	touch $PTAB

	# Create LCD device
	create_lcddev /dev/lcd

	# 1. Create partition table.
	clear_disk
	create_altroot
	create_swap
	create_42bsd

	# 2. Create slices within 4.2BSD partition.
	create_var_slice
	create_tmp_slice
	create_root_slice

	# 3. Install the disklabel and initialize filesystems.
	install_disklabel
	init_filesystems

	# 4. Install kernel(s) and files.
	install_boot
	install_files

	# 5. Finalize the installation and reboot.
	do_reboot
	printmsg "Installation complete"
}

install
