/*	$NetBSD: msg.mi.fr,v 1.47 2024/04/22 14:41:26 nia Exp $	*/

/*
 * Copyright 1997 Piermont Information Systems Inc.
 * All rights reserved.
 *
 * Written by Philip A. Nelson for Piermont Information Systems Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of Piermont Information Systems Inc. may not be used to endorse
 *    or promote products derived from this software without specific prior
 *    written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY PIERMONT INFORMATION SYSTEMS INC. ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL PIERMONT INFORMATION SYSTEMS INC. BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* MI Message catalog -- french, machine independent */

/*
 * We can not use non ascii characters in this message - it is displayed
 * before the locale is set up!
 */
message sysinst_message_language
{Messages d'installation en franais}

message sysinst_message_locale
{fr_FR.ISO8859-15}

message	out_of_memory	{Out of memory!}
message Yes {Oui}
message No {Non}
message All {Tous}
message Some {Une partie}
message None {Aucun}
message none {aucun}
message OK {OK}
message ok {ok}
message unchanged {non-modifi}
message On {On}
message Off {Off}
message Delete {Supprimer ?}

message install
{installer}

message reinstall
{rinstaller des composants de}

message upgrade
{mise  jour}

message hello
{Bienvenue dans Sysinst, l'outil d'installation de NetBSD-@@VERSION@@.
Cet utilitaire a t conu pour vous aider  installer ou mettre  jour
NetBSD sur votre disque dur avec un minimum de travail.
Dans les menus suivants, vous pourrez changer de slection, soit en tapant la
lettre en rfrence (a, b, c, d, ...) soit en utilisant les touches
flches du clavier.
La slection courante est active en appuyant sur la touche Entre.
}

message thanks
{Merci d'utiliser NetBSD !
}

message installusure
{Vous avez choisi d'installer NetBSD sur votre disque dur. Ceci va changer les
informations contenues sur ce dernier. Vous devriez faire une sauvegarde
complte de son contenu avant de poursuivre cette installation. Cette
procdure va effectuer les actions suivantes :
	a) Partitionner votre disque dur.
	b) Crer de nouveaux systmes de fichiers BSD.
	c) Installer les diffrents composants.

(Une fois le partitionnement configur, le systme d'installation vous
demandera de confirmer avant d'appliquer toute modification sur votre
disque dur.)

Souhaitez-vous continuer ?
}

message upgradeusure
{Mise  jour de NetBSD sur votre disque dur.
Cela implique des modifications aux informations contenues
sur votre disque dur.
Vous devriez faire une sauvegarde complte de celui-ci avant de
continuer la procdure de mise  jour.
Voulez-vous vraiment mettre  jour NetBSD ?
(Ceci est le dernier avertissement avant que cette
procdure ne modifie votre disque.)
}

message reinstallusure
{Les composants de NetBSD seront maintenant decompresss sur un disque dur
dmarrable. Cette procdure va rapatrier et dcompresser les composants
sur un disque dmarrable dj partitionnn. Elle n'inscrit pas de "label" sur
le disque, n'installe pas de nouveaux secteurs d'amorage et ne modifie
pas les fichiers de configuration existants. (Quittez et choisissez `installer'
ou `mettre  jour' si vous dsirez ces options.)
Vous devriez dj avoir fait une installation ou une mise  jour avant de
dmarrer cette procdure !

Voulez-vous rellement rinstaller les composants NetBSD ?
(Ceci est le dernier avertissement avant que cette procdure ne commence 
modifier vos disques.)
}

message mount_failed
{Le montage du systme de fichiers %s a chou.  Continuer ?
}

message nodisk
{Aucun disque utilisable par NetBSD n'a t trouv.
Retour au menu prcdent.
}

message onedisk
{Un seul disque a t trouv : %s. Nous supposons que vous souhaitez
%s NetBSD sur ce dernier.
}

message ask_disk
{Sur quel disque voulez-vous %s NetBSD ?}

message Available_disks
{Disques disponibles :}

message Available_wedges	{Existing "wedges"}

message heads
{ttes}

message sectors
{secteurs}

message mountpoint
{point de montage (ou '-')}

message cylname
{cyl}

message secname
{sec}

message megname
{Mo}

message gigname
{Go}

/* Called with:				Example
 *  $0 = device name			wd0
 *  $1 = partitioning scheme name	Guid Partition Table
 *  $2 = short version of $1		GPT
 *  $3 = disk size for NetBSD		3TB
 *  $4 = full install size min.		127M
 *  $5 = install with X min.		427M
 */
message	layout_prologue_none
{You can use a simple editor to set the sizes of the NetBSD partitions,
or apply the default partition sizes and contents.}

/* Called with:				Example
 *  $0 = device name			wd0
 *  $1 = partitioning scheme name	Guid Partition Table
 *  $2 = short version of $1		GPT
 *  $3 = disk size for NetBSD		3TB
 *  $4 = full install size min.		127M
 *  $5 = install with X min.		427M
 */

message	layout_prologue_existing
{If you do not want to use the existing partitions, you can
use a simple editor to set the sizes of the NetBSD partitions,
or remove existing ones and apply the default partition sizes.}

/* Called with:				Example
 *  $0 = device name			wd0
 *  $1 = partitioning scheme name	Guid Partition Table
 *  $2 = short version of $1		GPT
 *  $3 = disk size for NetBSD		3TB
 *  $4 = full install size min.		127M
 *  $5 = install with X min.		427M
 */
message layout_main
{
You will then be given the opportunity to change any of the partition
details.

The NetBSD (or free) part of your disk ($0) is $3.

A full installation requires at least $4 without X and
at least $5 if the X sets are included.}

message Choose_your_size_specifier
{Si vous choisissez "Mgaoctets" ou "Gigaoctets", la taille
sera le plus proche de votre choix possible, arrondi au
cylindre-prs. Si vous choisissez "Secteurs", vous pourrez
choisir prcisment les tailles.
Sur les disques modernes, la taille relle des cylindres est variable
et il y a peu d'intrt  aligner les partitions sur les cylindres.
Pour les disques plus anciens, il est recommand de choisir des tailles
de partitions arrondies au cylindre-prs, pour plus de performance.

Choisissez l'unit d'espace disque dsire}

message ptnsizes
{Vous pouvez dsormais modifier la taille des partitions systme.
Par dfaut, tout l'espace sera allou  la partition racine principale,
mais vous pouvez sous-diviser celle-ci en plusieurs
systmes de fichiers. Exemples : /usr (fichiers systme additionnels),
/var (fichiers des journaux, etc.)
et /home (regroupant les rpertoires utilisateurs).

L'espace libre restant sera ajout  la partition marque par un '+'.}

/* Called with: 			Example
 *  $0 = list of marker explanations	'=' existining, '@' external
 */
message ptnsizes_markers		{Other markers: $0 partition.}
message ptnsizes_mark_existing		{'=' existing}
message ptnsizes_mark_external		{'@' external}

message ptnheaders_size		{Taille}
message ptnheaders_filesystem	{Systme de fichiers}

message askfsmount
{Point de montage ?}

message askfssize
{Taille pour %s en %s ?}

message askunits
{Changer d'unit (secteurs/cylindres/Mo/Go)}

message NetBSD_partition_cant_change
{Partition de NetBSD}

message Whole_disk_cant_change
{Totalit du disque}

message Boot_partition_cant_change
{Partition de dmarrage}

message add_another_ptn
{Ajouter manuellement une nouvelle partition}

/* Called with: 			Example
 *  $0 = free space			1.4
 *  $1 = size unit			GB
 */
message fssizesok
{Valider. Espace libre $0 $1.}

/* Called with: 			Example
 *  $0 = missing space			1.4
 *  $1 = size unit			GB
 */
message fssizesbad
{Abort.  Not enough space, $0 $1 missing!}

message startoutsidedisk
{La valeur que vous avez spcifie dpasse les limites du disque.
}

message endoutsidedisk
{Avec cette valeur, la fin de la partition excde la limite du disque.
La taille de la partition a t tronque.}

/* Called with:				Example
 *  $0 = device name			wd0
 *  $1 = partitioning scheme name	Master Boot Record (MBR)
 *  $2 = short version of $1		MBR
 *  $3 = disk size			3TB
 *  $4 = size limit			2TB
 */
message toobigdisklabel
{
This disk ($0) is too large ($3) for a $2 partition table (max $4),
hence only the start of the disk is usable.
}

message cvtscheme_hdr		{What would you like to do to the existing partitions?}
message cvtscheme_keep		{keep (use only part of disk)}
message cvtscheme_delete	{delete (all data will be lost!)}
message cvtscheme_convert	{convert to another partitioning method}
message cvtscheme_abort		{abort}
message cvtscheme_error
{Could not convert all partitions}

/* Called with:				Example
 *  $0 = device name			wd0
 *  $1 = partitioning scheme name	BSD disklabel
 *  $2 = short version of $1		disklabel
 *  $3 = optional install flag		(I)nstall,
 *  $4 = additional flags description	(B)ootable
 *  $5 = total size			2TB
 *  $6 = free size			244MB
 */
message fspart
{Vos partitions sont les suivantes:

Flags: $3(N)ewfs$4.   Total: $5, free: $6}

message ptnheaders_start	{Dbut}
message ptnheaders_end		{Fin}
message ptnheaders_fstype	{Type}

message partition_sizes_ok
{Taille et options des partitions valides}

message edfspart
{Vous devez d'abord prciser le type de systme
de fichiers (FS), puis les autres valeurs.

Les valeurs actuelles pour la partition sont:}

message ptn_newfs		{formatage}
message ptn_mount		{montage}
message ptn_mount_options	{options de montage}
message ptn_mountpt		{Pt de montage}

message toggle
{Basculer}

message restore
{Restaurer les valeurs initiales}

message Select_the_type
{Slection du type de systme de fichiers}

message other_types
{autres types}

/* Called with:				Example
 *  $0 = valid partition shortcuts	a-e
 *  $1 = maximum allowed		4292098047
 *  $2 = size unit			MB
 */
message label_size_head
{Valeurs spciales pouvant tre utilises pour dfinir la taille de la partition :
    -1 : Utiliser jusqu' la fin du disque}

/* Called with:				Example
 *  $0 = valid partition shortcuts	a-e
 *  $1 = maximum allowed		4292098047
 *  $2 = size unit			MB
 */
message label_size_part_hint
{   $0 : Terminer cette partition o la partition X dbute}

/* Called with:				Example
 *  $0 = valid partition shortcuts	a-e
 *  $1 = maximum allowed		4292098047
 *  $2 = size unit			MB
 */
message label_size_tail			{Taille (max $1 $2)}

/* Called with:				Example
 *  $0 = valid partition shortcuts	a-e
 *  $1 = valid free space shortcuts	f-h
 *  $3 = size unit			MB
 */
message label_offset_head
{Valeurs spciales pouvant tre utilises pour dfinir le dbut de la partition :
    -1 : Commencer au dbut du disque}

/* Called with:				Example
 *  $0 = valid partition shortcuts	a-e
 *  $1 = valid free space shortcuts	f-h
 *  $3 = size unit			MB
 */
message label_offset_part_hint
{   $0 : Commencer  la suite de la partition prcdente}

/* Called with:				Example
 *  $0 = valid partition shortcuts	a-e
 *  $1 = valid free space shortcuts	f-h
 *  $3 = size unit			MB
 */
message label_offset_space_hint
{   $1:   start at the beginning of given free space}

/* Called with:				Example
 *  $0 = valid partition shortcuts	a-e
 *  $1 = valid free space shortcuts	f-h
 *  $3 = size unit			MB
 */
message label_offset_tail		{Dbut ($2)}

message invalid_sector_number
{nombre invalide}

message packname
{Veuillez donner un nom  votre disque.}

message lastchance
{Nous sommes prts  installer NetBSD sur votre disque (%s).
Aucune modification n'a t effectue pour l'instant.
Ceci est votre dernire opportunit pour quitter cette
procdure en laissant votre disque intact.

Souhaitez-vous vraiment continuer ?
}

message disksetupdone
{La premire partie de la procdure est termine.
Sysinst a crit vos nouvelles partitions sur votre disque,
puis a procd  la vrification de leur intgrit (via fsck).
}

message disksetupdoneupdate
{La premire partie de la procdure est termine.
Sysinst a crit vos nouvelles partitions sur votre disque,
puis a procd  la vrification de leur intgrit (via fsck).
}

message openfail
{Impossible d'ouvrir %s. Message d'erreur obtenu : %s.
}

/* Called with:				Example
 *  $0 = device name			/dev/wd0a
 *  $1 = mount path			/usr
 */
message mountfail
{Le montage de $0 sur $1 a chou.
}

message extractcomplete
{L'extraction des composants slectionns de NetBSD-@@VERSION@@
est complte.
Le systme peut dsormais dmarrer directement depuis le disque.
Pour complter l'installation, Sysinst va maintenant vous
permettre d'effectuer quelques rglages essentiels.
}

message instcomplete
{L'installation de NetBSD-@@VERSION@@ est termine. L'ordinateur va
redmarrer depuis le disque dur. Veuillez consulter le document
d'installation (INSTALL) pour apprendre  bien configurer votre
systme.

Nous vous recommandons au minimum de configurer le mot de passe
du compte root et de paramtrer /etc/rc.conf selon vos besoins.
Consultez les manuels rc.conf(5), afterboot(8) et security(7)
au besoin.
}

message unpackcomplete
{La mise  jour de NetBSD-@@VERSION@@ est termine.
Veuillez consulter le document d'installation (INSTALL) pour apprendre
 bien configurer votre systme.

Vous devez diter /etc/rc.conf et ajouter la ligne
"RC_CONFIGURED=yes" pour redmarrer en mode multi-utilisateur.
}

message upgrcomplete
{L'installation des composants supplmentaires de NetBSD-@@VERSION@@ est
termine.
Veuillez consulter le document d'installation (INSTALL) pour apprendre
 bien configurer votre systme.

Vous devez diter /etc/rc.conf et ajouter la ligne
"RC_CONFIGURED=yes" pour redmarrer en mode multi-utilisateur.
}

message distmedium
{Votre disque est maintenant prt  recevoir le coeur du systme
et ses diffrents composants annexes. Comme indiqu dans le document
d'installation, vous avez plusieurs possibilits. Pour une installation via
NFS ou FTP, vous devez tre connect  un rseau et avoir accs au serveur
requis.

Composant slectionn : %d, trait : %d. Prochain composant : %s.

}

message distset
{La distribution de NetBSD est divise en plusieurs composants.
Certains sont indispensables.
Trois types d'installations vous sont proposs : complte, minimale ou
personnalise.
}

/* Called with: 			Example
 *  $0 = sets suffix			.tgz
 *  $1 = URL protocol used		ftp
 */
message ftpsource
{Voici la configuration actuelle pour : nom du site ($1), rpertoire, nom
d'utilisateur et mot de passe.
Si vous utilisez le mode FTP, le mot de passe n'est pas requis.
Le rpertoire contenant les composants doit tre dfini par
rapport au rpertoire de base, et contenir chaque composant sous
la forme de fichiers $0

}

message email
{adresse de courriel}

message dev
{priphrique}

message nfssource
{Veuillez indiquer le nom du serveur NFS ainsi que le rpertoire contenant
les fichiers d'installation.
Ce rpertoire doit tre export via NFS, et contenir ces fichiers
 sa racine mme.

}

message floppysource
{Veuillez spcifier le nom du lecteur de disquette  utiliser.
Les fichiers d'installation devront se trouver  la racine
de chaque disquette.

}

message cdromsource
{Veuillez spcifier le nom du lecteur CD-ROM  utiliser,
ainsi que le nom du rpertoire contenant les fichiers d'installation.
Ils doivent tre placs  sa racine, sous la forme de fichiers
tgz.

}

message No_cd_found
{Could not locate a CD medium in any drive with the distribution sets! 
Enter the correct data manually, or insert a disk and retry. 
}

message abort_install
{Cancel installation}

message source_sel_retry
{Back to source selection & retry}

message Available_cds
{CD-ROM disponibles}

message ask_cd
{Plusieurs CD-ROM ont t trouvs.  Slectionnez celui contenant le systme
d'installation de NetBSD.}

message cd_path_not_found
{Les archives d'installation ne peuvent tre trouves  l'emplacement spcifi
sur ce CD-ROM.  Assurez-vous que le priphrique et le chemin sont les bons.}

message localfssource
{Veuillez spcifier le nom du priphrique local (qui ne doit pas
tre mont)  utiliser. Ce dernier doit contenir les fichiers
d'installation  sa racine, sous la forme de fichiers tgz.

}

message localdir
{Veuillez spcificer le nom du rpertoire local (dj mont)
o se trouvent les fichiers d'installation. Ils doivent se trouver
 la racine du rpertoire, sous la forme de fichiers tgz.

}

message filesys
{systme de fichiers}

message nonet
{Aucune interface rseau utilisable n'a t trouve.
Retour au menu prcdent.
}

message netup
{Les interfaces rseau suivantes sont utilisables : %s
Quelle interface souhaitez-vous utiliser ?
}

message asknetdev
{Quelle interface doit tre utilise ?}

message netdevs
{Interfaces disponibles}

message netinfo
{Veuillez rpondre aux points suivants afin de pouvoir utiliser
votre interface rseau :

}

message net_domain
{Votre nom de domaine}

message net_host
{Votre nom d'ordinateur}

message net_ip
{Votre adresse IPv4}

message net_srv_ip
{Adresse IPv4 du serveur}

message net_mask
{Votre masque de rseau (IPv4)}

message net_namesrv
{Adresse IPv4 de votre serveur de noms (DNS)}

message net_defroute
{Adresse IPv4 de votre passerelle}

message net_media
{Type de rseau (mdia)}

message net_ssid
{Wi-Fi SSID?}

message net_passphrase
{Wi-Fi passphrase?}

message netok
{Vous avez spcifi les valeurs suivantes :

Nom de domaine (DNS) :		%s 
Nom d'ordinateur :		%s 
Adresse du serveur de noms :	%s 
Interface rseau :		%s 
Type de rseau (mdia)		%s 
Adresse IPv4 :			%s 
Masque de sous-rseau :		%s 
Adresse IPv4 de la passerelle : %s 
}

message netok_slip
{Vous avez spcifi les valeurs suivantes. tes-vous d'accord ?

Nom de domaine (DNS) :		%s 
Nom d'ordinateur :		%s 
Adresse du serveur de noms :	%s 
Interface rseau :		%s 
Type de rseau (mdia) :	%s 
Adresse IPv4 :			%s 
Adresse IPv4 du serveur :	%s 
Masque de sous-rseau :		%s 
Adresse IPv4 de la passerelle :	%s 
}

message netokv6
{Auto-configuration IPv6 :	%s 
}

message netok_ok
{Les valeurs sont-elles correctes ?}

message slattach {
Entrez les "flags" slattach
}

message wait_network
{
Veuillez patienter pendant la configuration de l'interface...
}

message resolv
{
Impossible de crer le fichier /etc/resolv.conf
chec de l'installation.
}

/* Called with: 			Example
 *  $0 = target prefix			/target
 *  $1 = error message			No such file or directory
 */
message realdir
{
Impossible de dplacer le rpertoire $0: $1
chec de l'installation.}

message delete_xfer_file
{
Effacer aprs l'installation
}

/* Called with: 			Example
 *  $0 = set name			base
 */
message notarfile
{Le composant $0 n'existe pas.}

message endtarok
{
Tous les composants sont installs. Veuillez appuyer sur la touche
Entre pour continuer.
}

message endtar
{
L'installation des composants est termine. Toutefois, un ou plusieurs
problmes sont survenus au cours de leur extraction.

Vous avez slectionn %d composants. %d n'ont pu tre installs,
et %d ont t ignors  la suite d'erreurs.

Sur les %d composants traits, %d ont pu tre installs et
%d ont provoqu une erreur.

Veuillez vrifier l'intgrit des fichiers d'installation et leur
emplacement, puis essayez  nouveau via une rinstallation de composants,
depuis le menu principal.
}

message abort_inst {Annulation de l'installation.}
message abort_part {Install aborted.}

message abortinst
{
L'instalation des composants de NetBSD n'est pas complte.
Vous allez devoir recommencer, ou terminer  la main.
chec de l'installation.
}

message abortupgr
{
La mise  jour des composants de NetBSD n'est pas complte.
Vous allez devoir recommencer, ou terminer  la main.
chec de l'installation.
}

message abortunpack
{
L'installation des composants supplmentaires n'est pas complte.
Vous allez devoir recommencer, ou terminer  la main.
Essayez de choisir une source diffrente pour les fichiers
d'installation.
}

message createfstab
{
Impossible de crer /mnt/etc/fstab
Ceci est une erreur majeure : nous ne pouvons continuer.
chec de l'installation.
}

message noetcfstab
{
Le fichier /etc/fstab n'est pas prsent sur le disque cible %s
Ceci est une erreur majeure : nous ne pouvons continuer.
chec de l'installation.
}

message badetcfstab
{
Impossible de lire le contenu du fichier /etc/fstab prsent sur
le disque cible %s
Ceci est une erreur majeure : nous ne pouvons continuer.
chec de l'installation.
}

message X_oldexists
{
Impossible de sauvegarder %s/bin/X : le disque contient dj
un fichier %s/bin/X.old et nous devons renommer le fichier actuel
 ce nom. Veuillez supprimer ou renommer le fichier X.old avant de
recommencer.
Vous pouvez dmarrer un shell depuis le menu "Utilitaires" afin
de faire cette modification.
Ce fichier provient probablement d'une ancienne mise  jour et
il est possible de le supprimer. S'il provient d'une mise  jour
incomplte, vous pouvez effacer %s/bin/X et renommer
%s/bin/X.old jusqu' %s/bin/X.%0s%0s%0s%0s%0s%0s

Arrt de la mise  jour.
}


message netnotup
{
Un problme est survenu lors de la configuration de votre interface
rseau. Votre serveur de noms ou votre passerelle ne semblent pas
rpondre aux pings.
Souhaitez-vous configurer  nouveau les paramtres de votre
connexion rseau ?
(un refus provoquera l'arrt de la procdure d'installation)
}

message netnotup_continueanyway
{
Souhaitez-vous poursuivre malgr tout le processus d'installation
et supposer que le rseau fonctionne correctement ?
(un refus provoquera l'arrt de la procdure d'installation)
}

message makedev
{Cration des fichiers des priphriques ...
}

/* Called with:				Example
 *  $0 = device name			/dev/rwd0a
 *  $1 = file system type		ffs
 *  $2 = error return code form fsck	8
 */
message badfs
{
$0 ne semble pas tre un systme de fichiers $1, ou
la vrification de son intgrit par fsck a chou, code d'erreur $2.

Souhaitez-vous continuer mise  jour?
}

message rootmissing
{
Impossible de trouver la racine du disque cible %s.
}

message badroot
{
La vrification de l'intgrit du nouveau systme de fichiers a chou.
Avez-vous bien install tous les composants indispensables ?
}

message fd_type
{Systme de fichiers de la disquette}

message fdnotfound
{
Impossible de trouver un fichier requis sur la disquette.
}

message fdremount
{
Impossible de monter la disquette correctement.
}

message fdmount
{
Veuillez insrer la disquette contenant le fichier "%s.%s".

Si le jeu de disquettes ne comprend aucun autre disque, veuillez
choisir "Ensemble termin" pour mettre un terme  ce traitement.
Slectionnez "Annuler la rcupration" pour revenir au menu
de slection du mdia d'installation.
}

message mntnetconfig
{Souhaitez-vous conserver les rglages rseaux aprs le redmarrage
du systme que nous venons d'installer ? }

message cur_distsets
{
Slectionnez les composants dans la liste ci-dessous :
}

message cur_distsets_header
{      Composant                      Installer?
------------------------------------ ----------
}

message set_base
{Base}

message set_base32
{Base pour la compatibilit? 32 bits}

message set_base64
{Base pour la compatibilit? 64 bits}

message set_system
{Systme (/etc)}

message set_compiler
{Outils de dveloppement}

message set_dtb
{Devicetree hardware descriptions}

message set_games
{Jeux}

message set_gpufw
{Graphics driver firmware}

message set_man_pages
{Pages de manuel}

message set_man_pages_html
{Pages de manuel (HTML)}

message set_misc
{Divers}

message set_modules
{Modules du noyau}

message set_rescue
{Recovery tools}

message set_tests
{Programmes de test}

message set_text_tools
{Outils de manipulation de texte}

message set_X11
{X11}

message set_X11_base
{X11 base et clients}

message set_X11_etc
{X11 configuration}

message set_X11_fonts
{X11 polices}

message set_X11_servers
{X11 serveurs}

message set_X11_prog
{X11 dveloppement}

message set_source
{Code source et dbogage}

message set_syssrc
{Sources du noyeau}

message set_src
{Sources de la Base}

message set_sharesrc
{Sources de partage (Share)}

message set_gnusrc
{Sources des composants GNU}

message set_xsrc
{Sources X11}

message set_debug
{Symboles de dbogage}

message set_debug32
{Symboles de dbogage (32-bit)}

message set_debug64
{Symboles de dbogage (64-bit)}

message set_xdebug
{Symboles de dbogage X11}

message select_all
{Slectionner tous les composants}

message select_none
{Dselectionner tous les composants}

message install_selected_sets
{Installer les composants slectionns}


message tarerror
{
Une erreur est survenue lors de l'installation du fichier %s.
Certains fichiers n'ayant pu tre extraits correctement,
le systme n'est pas complet et pourrait ne pas fonctionner
correctement.

Souhaitez-vous continuer l'installation des composants ?
}

/* Called with: 			Example
 *  $0 = partitioning name		Master Boot Record (MBR)
 *  $1 = short version of $0		MBR
 */
message must_be_one_root
{
Une seule partition peut tre monte en tant que racine, dite "/".
}

/* Called with: 			Example
 *  $0 = first partition description	70 - 90 MB, MSDOS
 *  $1 = second partition description	80 - 1500 MB, 4.2BSD
 */
message partitions_overlap
{Les partitions $0 et $1 s'empitent l'une sur l'autre.}

message No_Bootcode
{Pas de programme de dmarrage trouv sur la partition racine}

message cannot_ufs2_root
{Le systme de fichiers de la partition racine ne peut pas tre FFSv2 car le
chargeur de dmarrage ne le supporte pas.}

message edit_partitions_again
{
Vous pouvez diter la table de partitions  la main, ou abandonner et
retourner au menu principal.

Souhaitez-vous diter  nouveau la table de partitions ?
}

/* Called with: 			Example
 *  $0 = missing file			/some/path
 */
message config_open_error
{
Impossible d'ouvrir le fichier de configuration $0.
}

message choose_timezone
{
Veuillez slectionner votre zone horaire dans la liste suivante.
Appuyez sur la touche Entre pour confirmer votre choix.
Appuyez sur "x" puis sur Entre pour valider la slection en cours.

 Par dfaut :		%s
 Slection actuelle :   %s
 Heure locale :		%s %s
}

message tz_back
{ Retour  la liste principale des fuseaux horaires}

message swapactive
{
Le disque slectionn dispose d'une partition d'change (swap) qui
est peut-tre en cours d'utilisation, en particulier si votre systme
dispose de peu de mmoire.
Le repartitionnement de votre disque requiert la dsactivation de cette
partition. Prenez garde ! Cette opration peut entraner des erreurs.
Si cela survient, vous devrez alors redmarrer et tenter  nouveau.
}

message swapdelfailed
{
Sysinst n'a pas pu dsactiver la partition d'change (swap) prsente
sur le disque cible pour l'installation. Vous devez redmarrer et tenter
 nouveau.
}

message rootpw
{
Aucun mot de passe pour le compte "root" n'a t dfini.
Nous vous recommandons de spcifier un mot de passe maintenant.

Le souhaitez-vous ?
}

message force_rootpw
{The root password of the newly installed system has not yet been
initialized. 
 
If you do not want to set a password, enter an empty line.}

message rootsh
{
Spcifiez le shell par dfaut qui sera utilis par l'utilisateur "root".
Par dfaut, il s'agit de /bin/sh
}

message no_root_fs
{
Aucune partition racine n'est actuellement dfinie. Vous devez au moins
dfinir le point de montage de cette partition racine, dite "/".

Appuyez sur la touche Entre pour continuer.
}

message Pick_an_option {Choisissez une option  activer/dsactiver}
message Scripting {Scripting}
message Logging {Journal}

message Status  {Statut : }
message Command {Commande : }
message Running {En cours d'excution}
message Finished {Termine}
message Command_failed {chec}
message Command_ended_on_signal {Commande termine par un signal}

message NetBSD_VERSION_Install_System {NetBSD-@@VERSION@@ Programme d'installation}
message Exit_Install_System {Quitter le programme d'installation}
message Install_NetBSD_to_hard_disk {Installation de NetBSD sur disque dur}
message Upgrade_NetBSD_on_a_hard_disk {Mise  jour de NetBSD sur disque dur}
message Re_install_sets_or_install_additional_sets {Rinstaller ou installer de nouveaux composants}
message Reboot_the_computer {Redmarrer l'ordinateur}
message Utility_menu {Utilitaires}
message Config_menu {Configuration}
message exit_utility_menu {Quitter}
message exit_menu_generic {Quitter}
message NetBSD_VERSION_Utilities {Utilitaires NetBSD-@@VERSION@@}
message Run_bin_sh {Excuter /bin/sh}
message Set_timezone {Configurer le fuseau horaire}
message Configure_network {Configurer le rseau}
message Partition_a_disk {Partitionner un disque}
message Logging_functions {Journaux}
message Halt_the_system {Arrter le systme}
message yes_or_no {Oui ou non?}
message Hit_enter_to_continue {Appuyez sur la touche Entre pour continuer}
message Choose_your_installation {Choisir le type d'installation dsir}

/* Called with:				Example
 *  $0 = partitioning name		Master Boot Record (MBR)
 *  $1 = short version of $0		MBR
 */
message Keep_existing_partitions
{Use existing $1 partitions}

/* Called with:				Example
 *  $0 = partitioning name		Master Boot Record (MBR)
 *  $1 = short version of $0		MBR
 */
message Set_Sizes {Spcifier les tailles des partitions NetBSD}

/* Called with:				Example
 *  $0 = partitioning name		Master Boot Record (MBR)
 *  $1 = short version of $0		MBR
 */
message Use_Default_Parts {Use default partition sizes}

/* Called with:				Example
 *  $0 = partitioning name		Master Boot Record (MBR)
 *  $1 = short version of $0		MBR
 */
message Use_Empty_Parts {Manually define partitions}

/* Called with:				Example
 *  $0 = current partitioning name	Master Boot Record (MBR)
 *  $1 = short version of $0		MBR
 */
message Use_Different_Part_Scheme
{Delete everything, use different partitions (not $1)}

message Gigabytes {Gigaoctets}
message Megabytes {Mgaoctets}
message Bytes {Octets}
message Cylinders {Cylindres}
message Sectors {Secteurs}
message Select_medium {Slection du mdia d'installation}
message ftp {FTP}
message http {HTTP}
message nfs {NFS}
.if HAVE_INSTALL_IMAGE
message cdrom {CD-ROM / DVD / install image media}	/* XXX translation */
.else
message cdrom {CD-ROM / DVD}
.endif
message floppy {Disquette}
message local_fs {Systme de fichiers non-mont}
message local_dir {Rpertoire local mont}
message Select_your_distribution {Slection de la distribution}
message Full_installation {Installation complte}
message Full_installation_nox {Installation sans X11}
message Minimal_installation {Installation minimale}
message Custom_installation {Installation personnalise}
message hidden {** cach **}
message Host {Serveur FTP}
message Base_dir {Rpertoire de base}
message Set_dir_bin {Rpertoire des composants binaire}
message Set_dir_src {Rpertoire des composants source}
message Dist_postfix {Extension de fichier}
message Xfer_dir {Rpertoire de transfert}
message transfer_method {Download via}
message User {Utilisateur}
message Password {Mot de passe}
message Proxy {Proxy}
message Get_Distribution {Rcuprer la distribution}
message Continue {Continuer}
message Prompt_Continue {Continuer?}
message What_do_you_want_to_do {Que voulez-vous faire ?}
message Try_again {Ressayer}
message Set_finished {Extraction termine}
message Skip_set {Sauter cet ensemble}
message Skip_group {Sauter ce groupe}
message Abandon {Abandonner l'installation}
message Abort_fetch {Annuler la rcupration}
message Device {Priphrique}
message File_system {Systme de fichiers}
message Select_DNS_server {  Choisissez un serveur de noms :}
message other {autre }
message Perform_autoconfiguration {Configurer automatiquement ?}
message Root_shell {Shell du compte "root"}
message Color_scheme {Jeu de couleurs}
message White_on_black {Blanc sur noir}
message Black_on_white {Noir sur blanc}
message White_on_blue {Blanc sur bleu}
message Green_on_black {Vert sur noir}
message User_shell {Shell du compte "user"}

.if AOUT2ELF
message aoutfail
{
Le rpertoire o se situent les anciennes librairies a.out doit tre
dplac. Veuillez suivre la procdure de mise  jour et bien
vrifier que tous les systmes de fichiers sont monts.
}

message emulbackup
{
Le rpertoire /emul/aout ou /emul est prsent sur le disque mais
pointe vers un rpertoire non mont. Nous l'avons renomm en lui ajoutant
l'extension ".old". Lorsque vous aurez termin l'installation ou la mise  jour,
vous devrez fusionner manuellement le nouveau rpertoire avec l'ancien
/emul/aout.
}
.endif

message oldsendmail
{
Sendmail n'est plus distribu dans cette version de NetBSD, le MTA par dfaut
tant maintenant postfix. Toutefois, le fichier /etc/mailer.conf est toujours
configur pour utiliser sendmail. Voulez-vous mettre  jour le fichier
/etc/mailer.conf automatiquement pour utiliser postfix  la place ? Si vous
choisissez "Non", vous devrez mettre  jour /etc/mailer.conf manuellement
afin que vos courriels soient traits correctement.
}

message license
{Afin d'utiliser l'interface rseau : %s, vous devez accepter la licence
contenue dans le fichier %s.
Pour afficher ce fichier, tapez ^Z (Ctrl-Z).
Aprs l'avoir lu, tapez "fg" pour continuer.}

message binpkg
{Afin de configurer le systme de paquetages binaires, choisissez
l'emplacement rseau o les paquetages se trouvent.  Une fois le systme
redmarr, vous pourrez utiliser 'pkgin' pour installer et amnager des
paquetages additionnels.}

message pkgpath
{Voici les configurations actuelles pour : protocole, serveur, rpertoire,
utilisateur et mot de passe qui seront utiliss.  Si "utilisateur" est "ftp",
un mot de passe n'est pas requis.

}
message rcconf_backup_failed {La copie de rc.conf a chou. Continuer ?}
message rcconf_backup_succeeded {La copie de rc.conf a t sauvegarde jusqu' %s.}
message rcconf_restore_failed {La restauration de la sauvegarde de rc.conf a chou.}
message rcconf_delete_failed {La suppression de l'ancien fichier %s a chou.}
message Pkg_dir {Dossier de paquetages}
message configure_prior {configurer une installation existante de}
message configure {configurer}
message change {changer}
message password_set {Dfinir le mot de passe}
message YES {OUI}
message NO {NON}
message DONE {TERMINER}
message abandoned {Abandonne}
message empty {***VIDE***}
message timezone {Fuseau horaire}
message change_rootpw {Changer le mot de passe "root"}
message enable_binpkg {Activer l'installation de paquetages binaires}
message enable_sshd {Activer sshd}
message enable_ntpd {Activer ntpd}
message run_ntpdate {Excuter ntpdate au dmarrage}
message enable_mdnsd {Activer mdnsd}
message enable_xdm {Activer xdm}
message enable_cgd {Activer cgd}
message enable_lvm {Activer lvm}
message enable_raid {Activer raidframe}
message add_a_user {Ajouter un utilisateur}
message configmenu {Configurer les items suivants si ncessaire.}
message doneconfig {Configuration termine}
message Install_pkgin {Installer pkgin et mettre  jour le sommaire des paquetages}
message binpkg_installed 
{Votre systme est maintenant configur pour utiliser pkgin afin d'installer
des paquetages binaires.  Pour installer un paquetage, utilisez :

pkgin install <packagename>

 partir d'un shell "root".  Consultez le manuel pkgin(1) pour plus de dtails.}
message Install_pkgsrc {Obtenir et extraire pkgsrc}
message pkgsrc
{L'installation de pkgsrc ncessite l'extraction d'une archive obtenue
par le rseau.
Voici les configurations actuelles pour : serveur, rpertoire, utilisateur et
mot de passe qui seront utiliss.  Si "utilisateur" est "ftp", un mot de passe
n'est pas requis.

}
message Pkgsrc_dir {Rpertoire pkgsrc}
message get_pkgsrc
{Obtenir et extraire pkgsrc}
message retry_pkgsrc_network {La configuration du rseau a chou. Ressayer ?}
message quit_pkgsrc {Quitter sans installer pkgsrc}
message quit_pkgs_install {Quitter sans installer bin pkg}
message pkgin_failed 
{L'installation de pkgin a chou, peut-tre parce que son paquetage binaire
n'existe pas.  Vrifiez le chemin et essayez  nouveau.}
message failed {chou}


message askfsmountadv {Point de montage ou de 'raid' ou 'cgd' ou 'lvm'?}
message partman {Partitionnement tendu}
message editpart {Modifier les partitions}
message selectwedge {Preconfigured "wedges" dk(4)}

message fremove {ENLEVER}
message remove {Supprimer}
message add {Ajouter}
message auto {auto}

message removepartswarn {Cette supprimer toutes les partitions sur le disque!}
message saveprompt {Enregistrer les modifications avant de terminer?}
message cantsave {Aucune modification ne peut tre sauv.}
message noroot {Aucune partition racine dfini, ne peut pas continuer \n continue\n}

message addusername {Nom d'utilisateur (8 caractres)}
message addusertowheel {Ajouter cet utilisateur au groupe "wheel" ?}
message Delete_partition
{Supprimer la partition}

message No_filesystem_newfs
{The selected partition does not seem to have a valid file system. 
Do you want to newfs (format) it?}

message swap_display	{swap}

/* Called with: 			Example
 *  $0 = parent device name		sd0
 *  $1 = swap partition name		my_swap
 */
message Auto_add_swap_part
{A swap partition (named $1) 
seems to exist on $0. 
Do you want to use that?}

message parttype_disklabel {BSD disklabel}
message parttype_disklabel_short {disklabel}
/*
 * This is used on architectures with MBR above disklabel when there is
 * no MBR on a disk.
 */
message parttype_only_disklabel {disklabel (NetBSD only)}

message select_part_scheme
{The disk seems not to have been partitioned before. Please select
a partitioning scheme from the available options below. }

message select_other_partscheme
{Please select a different partitioning scheme from the available
options below. }

message select_part_limit
{Some schemes have size limits and can only be used for the start
of huge disks. The limit is displayed below.}

/* Called with: 			Example
 *  $0 = device name			ld0
 *  $1 = size				3 TB
 */
message part_limit_disksize
{This device ($0) is $1 big.}

message size_limit	{Max:}

message	addpart		{Add a partition}
message	nopart		{      (no partition defined)}
message	custom_type	{Unknown}

message dl_type_invalid	{Invalid file system type code (0 .. 255)}

message	cancel		{Annuler}

message	out_of_range	{Invalid value}
message	invalid_guid	{Invalid GUID}

message	reedit_partitions	{Re-edit}
message abort_installation	{Abort installation}

message dl_get_custom_fstype {File system type code (upto 255)}

message err_too_many_partitions	{Too many partitions}

/* Called with: 			Example
 *  $0 = mount point			/home
 */
message	mp_already_exists	{$0 already defined!}

message ptnsize_replace_existing
{This is an already existing partition. 
To change its size, the partition will need to be deleted and later
recreated.  All data in this partition will be lost.

Would you like to delete this partition and continue?}

message part_not_deletable	{Non-deletable system partition}

message ptn_type		{systme de fichiers}
message ptn_start		{Dbut}
message ptn_size		{taille}
message ptn_end			{fin}

message ptn_bsize		{taille de bloc}
message ptn_fsize		{taille de fragment}
message ptn_isize		{taille moyenne de fichier}

/* Called with: 			Example
 *  $0 = avg file size in byte		1200
 */
message ptn_isize_bytes		{$0 bytes}
message ptn_isize_dflt		{4 fragments}

message Select_file_system_block_size
{Slectionnez la taille de bloc du systme de fichiers}

message Select_file_system_fragment_size
{Slectionnez la taille de fragment du systme de fichiers}

message ptn_isize_prompt
{taille moyenne de fichier (octets)}

message No_free_space {Pas d'espace libre}
message Invalid_numeric {Nombre invalide!}
message Too_large {Trop grand!}

/* Called with:				Example
 *  $0 = start of free space		500
 *  $1 = end of free space		599
 *  $2 = size of free space		100
 *  $3 = unit in use			MB
 */
message free_space_line {Espace  $0..$1 $3 (taille $2 $3)\n}

message	fs_type_ffsv2	{FFSv2}
message	fs_type_ffsv2ea	{FFSv2ea}
message	fs_type_ffs	{FFS}
message	fs_type_efi_sp	{EFI system partition}
message fs_type_ext2old	{Linux Ext2 (old)}
message	other_fs_type	{Other type}

message	editpack	{Changer le nom du disque}
message	edit_disk_pack_hdr
{The name of the disk is arbitrary. 
It is useful for distinguishing between multiple disks.
It may also be used when auto-creating dk(4) "wedges" for this disk.

Enter disk name}

/* Called with:				Example
 *  $0 = outer partitioning name	Master Boot Record (MBR)
 *  $1 = short version of $0		MBR
 */
message reeditpart
{Voulez-vous diter de nouveau la table des partitions}


/* Called with:				Example
 *  $0 = device name			wd0
 *  $1 = outer partitioning name	Master Boot Record (MBR)
 *  $2 = inner partitioning name	BSD disklabel
 *  $3 = short version of $1		MBR
 *  $4 = short version of $2		disklabel
 *  $5 = size needed for NetBSD		250M
 *  $6 = size needed to build NetBSD	15G
 */
message fullpart
{Nous allons maintenant installer NetBSD sur votre disque $0. Vous devez
choisir si vous voulez installer NetBSD sur la totalit du disque ou seulement
sur une partie de celui-ci.
Une installation sur une partie du disque cre une partition, ou `slice', pour
NetBSD dans le secteur de dmarrage ($1) de votre
disque. Une installation sur la totalit du disque est `dangereusement
ddie' : elle rinitialise compltement le $3, ce qui efface tout systme
d'exploitation ou donnes existants sur le disque. Cela rend galement
impossible l'installation ultrieure d'un deuxime systme d'exploitation,
sauf si vous rinstallez compltement NetBSD en utilisant uniquement une
partie du disque.}

message Select_your_choice
{Faites votre choix}

/* Called with:				Example
 *  $0 = partitioning name		Master Boot Record (MBR)
 *  $1 = short version of $0		MBR
 */
message Use_only_part_of_the_disk
{Utilisation d'une partie du disque}

message Use_the_entire_disk
{Utilisation de tout le disque}

/* Called with:				Example
 *  $0 = device name			wd0
 *  $1 = total disk size		3000 GB
 *  $2 = unallocated space		1.2 GB
 */
message part_header
{   Taille totale du disque $0: $1 - libre: $2}
message part_header_col_start	{Dbut}
message part_header_col_size	{Taille}
message part_header_col_flag	{Flg}

message Partition_table_ok
{Table des partitions OK}

message Dont_change
{Ne pas modifier}
message Other_kind
{Autre}

/* Called with:				Example
 *  $0 = outer partitioning name	Master Boot Record (MBR)
 *  $1 = short version of $0		MBR
 */
message nobsdpart
{Il n'y a pas actuellement de partition NetBSD dans la table de partitions.}

/* Called with:				Example
 *  $0 = outer partitioning name	Master Boot Record (MBR)
 *  $1 = short version of $0		MBR
 */
message multbsdpart
{Il y a plusieurs partitions NetBSD dans la table de partitions du secteur de
dmarrage.
Positionnez l'indicateur 'installation' sur celle  utiliser.}

message ovrwrite
{Votre disque a actuellement une partition autre que NetBSD. Voulez-vous
vraiment l'craser par une partition NetBSD ?
}

message Partition_OK
{Partition OK}

/* Called with:				Example
 *  $0 = device name			wd0
 *  $1 = outer partitioning name	Master Boot Record (MBR)
 *  $2 = short version of $1		MBR
 *  $3 = other flag options		d = bootselect default, a = active
 */
message editparttable
{ditez votre table de partitions $2. La table de partitions est :

}

message install_flag	{I}
message newfs_flag	{N}

message ptn_install	{installation}
message ptn_instflag_desc	{(I)nstallation, }

message clone_flag	{C}
message clone_flag_desc	{, (C)lone}

message parttype_gpt {Guid Partition Table (GPT)}
message parttype_gpt_short {GPT}

message	ptn_label	{Label}
message ptn_uuid	{UUID}
message	ptn_gpt_type	{GPT Type}
message	ptn_boot	{Boot}

/* Called with:				Example
 *  $0 = outer partitioning name	Master Boot Record (MBR)
 *  $1 = short version of $0		MBR
 */
message use_partitions_anyway
{Use this partitions anyway}

message	gpt_flags	{B}
message	gpt_flag_desc	{, (B)ootable}

/* Called with:				Example
 *  $0 = file system type		FFSv2
 */
message size_ptn_not_mounted		{(Other: $0)}

message running_system			{current system}

message clone_from_elsewhere		{Clone external partition(s)}
message select_foreign_part
{Please select an external source partition:}
message select_source_hdr
{Your currently selected source partitions are:}
message clone_with_data			{Clone with data}
message	select_source_add		{Add another partition}
message clone_target_end		{Add at end}
message clone_target_hdr
{Insert cloned partitions before:}
message clone_target_disp		{cloned partition(s)}
message clone_src_done
{Source selection OK, proceed to target selection}

message network_ok
{Your network seems to work fine. 
Should we skip the configuration 
and just use the network as-is?}
