/*
 * Copyright (C) 2015 The Qt Company Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 */
#include "config.h"
#include "QWebUndoCommand.h"

#include "UndoStepQt.h"

#ifndef QT_NO_UNDOCOMMAND
QWebUndoCommand::QWebUndoCommand(QSharedPointer<UndoStepQt> undoStep, QUndoCommand* parent)
    : QUndoCommand(parent)
    , m_step(undoStep)
{
    Q_ASSERT(undoStep);
    setText(m_step->text());
}

void QWebUndoCommand::undo()
{
    m_step->undo();
}

void QWebUndoCommand::redo()
{
    m_step->redo();
}

#endif // QT_NO_UNDOCOMMAND
