/* vim: set ts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

/* This file is generated from sources in nss/gtests/common/wycheproof
 * automatically and should not be touched manually.
 * Generation is trigged by calling python3 genTestVectors.py */

#ifndef rsa_oaep_2048_sha384_mgf1sha1_vectors_h__
#define rsa_oaep_2048_sha384_mgf1sha1_vectors_h__

#include "testvectors_base/test-structs.h"

static const std::vector<uint8_t> priv_key_2{
    0x30, 0x82, 0x04, 0xbd, 0x02, 0x01, 0x00, 0x30, 0x0d, 0x06, 0x09, 0x2a,
    0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01, 0x05, 0x00, 0x04, 0x82,
    0x04, 0xa7, 0x30, 0x82, 0x04, 0xa3, 0x02, 0x01, 0x00, 0x02, 0x82, 0x01,
    0x01, 0x00, 0xcd, 0xa6, 0xfa, 0x5c, 0xa7, 0x6b, 0xfe, 0x04, 0x92, 0xec,
    0x57, 0xe0, 0xa3, 0xbf, 0xff, 0x72, 0x72, 0xdc, 0x8d, 0x1e, 0x25, 0xad,
    0x1f, 0xb3, 0x38, 0xaa, 0x05, 0x0f, 0x02, 0xc1, 0x04, 0xe6, 0x31, 0x33,
    0xd6, 0xb5, 0xb7, 0xc4, 0x98, 0x5e, 0xbb, 0xae, 0x9a, 0xc0, 0x36, 0xa5,
    0xb9, 0xc0, 0x30, 0x74, 0xd6, 0x0a, 0xec, 0x8e, 0x25, 0xba, 0xf3, 0x92,
    0xa0, 0xc4, 0x30, 0xff, 0x05, 0xb8, 0x8e, 0x94, 0x88, 0x05, 0xd3, 0xdd,
    0x74, 0x51, 0x1d, 0x88, 0x85, 0x25, 0x0a, 0x7b, 0x57, 0x42, 0x15, 0xad,
    0xa0, 0x15, 0xc5, 0x59, 0x07, 0x66, 0x86, 0xe2, 0x53, 0xcc, 0xc9, 0x6c,
    0x08, 0x15, 0xb1, 0x29, 0x1e, 0xe7, 0x87, 0xcc, 0x33, 0x63, 0xb4, 0xf7,
    0x7d, 0x93, 0x0e, 0xb9, 0x98, 0xd7, 0xc5, 0x82, 0xb2, 0x4c, 0xea, 0x9c,
    0xe2, 0x1d, 0xe9, 0x72, 0x27, 0x91, 0x98, 0x98, 0x63, 0xa2, 0x7e, 0xbc,
    0x80, 0xa0, 0x0d, 0xe5, 0xbd, 0x2f, 0x92, 0x28, 0x77, 0x5e, 0x5a, 0x4c,
    0xeb, 0x05, 0x4d, 0x58, 0xc9, 0xbe, 0x36, 0xa0, 0x54, 0x33, 0x69, 0x71,
    0xa1, 0x36, 0x42, 0xdd, 0x95, 0x10, 0xdd, 0x69, 0x6a, 0xa2, 0x68, 0xdb,
    0x3a, 0xab, 0x22, 0x99, 0xd5, 0xd8, 0x8f, 0x8e, 0x56, 0x24, 0x34, 0xd1,
    0x42, 0x70, 0x94, 0xd3, 0xdf, 0x8e, 0x72, 0xd1, 0xef, 0x69, 0xb4, 0xed,
    0x34, 0xd1, 0x2b, 0xac, 0x37, 0x52, 0x23, 0xb2, 0xa2, 0x5c, 0xf2, 0x27,
    0xf7, 0x35, 0xf8, 0x16, 0xe8, 0x5e, 0x17, 0x23, 0x93, 0x04, 0x76, 0x9a,
    0x60, 0x82, 0x15, 0x4c, 0xd1, 0x58, 0x99, 0xfc, 0x1e, 0xae, 0xfb, 0x69,
    0xb7, 0x48, 0xa3, 0xe5, 0xed, 0x24, 0xd3, 0x83, 0x72, 0x59, 0x7d, 0xe3,
    0xe4, 0xe2, 0xa2, 0x7b, 0x95, 0x1d, 0x6a, 0xc7, 0xdb, 0x18, 0x2d, 0x68,
    0x09, 0xd8, 0xff, 0x51, 0x1b, 0x7f, 0x02, 0x03, 0x01, 0x00, 0x01, 0x02,
    0x82, 0x01, 0x00, 0x5a, 0x3d, 0xc9, 0x62, 0xda, 0xfc, 0xa2, 0x6c, 0xb3,
    0x64, 0x0e, 0x73, 0xbe, 0xa7, 0x43, 0x9a, 0x9f, 0x18, 0x74, 0xbc, 0x23,
    0xe0, 0x42, 0x26, 0xcc, 0xd8, 0x9e, 0x7b, 0xa5, 0xc3, 0xb9, 0x38, 0xa1,
    0xa2, 0x93, 0xb7, 0x0d, 0xba, 0xb0, 0xf9, 0xf0, 0xf5, 0x7f, 0x66, 0x95,
    0x14, 0x47, 0xdc, 0x33, 0xe7, 0x30, 0xfd, 0x7e, 0x2c, 0x2a, 0x16, 0x4d,
    0x47, 0xac, 0x50, 0x2b, 0x07, 0xdd, 0x24, 0xcd, 0x3c, 0x14, 0x2c, 0x2a,
    0x79, 0xe4, 0xce, 0xab, 0x5c, 0xfa, 0xbf, 0xf4, 0x47, 0x87, 0x54, 0xb2,
    0x5a, 0x8c, 0x02, 0xc1, 0xa4, 0x7d, 0x80, 0xd9, 0xf3, 0x7a, 0xbe, 0x44,
    0x2c, 0xa9, 0xa7, 0x8b, 0x23, 0xf6, 0x31, 0xb6, 0xff, 0x3e, 0x15, 0xa4,
    0x95, 0x6d, 0x7f, 0x18, 0x59, 0x0c, 0xde, 0xb2, 0x06, 0xd5, 0xe2, 0xb6,
    0x98, 0xbd, 0x08, 0x4f, 0x26, 0x0e, 0x82, 0xef, 0x28, 0xff, 0x9e, 0xc6,
    0xdb, 0xc8, 0x5a, 0x89, 0x5e, 0xc8, 0xa3, 0x86, 0x57, 0x50, 0xf5, 0x01,
    0xb9, 0x61, 0x25, 0xdb, 0x1b, 0xbd, 0xd9, 0x9a, 0x4a, 0xe4, 0x68, 0x8a,
    0xdb, 0x30, 0x4a, 0xab, 0xdf, 0xc4, 0xe0, 0xcf, 0xb9, 0xfe, 0x6b, 0x6b,
    0xc0, 0xdb, 0x74, 0xc8, 0x8a, 0xf8, 0x21, 0x7e, 0xed, 0x73, 0x8a, 0x0d,
    0x04, 0xfe, 0x8d, 0x32, 0xc1, 0xd1, 0x10, 0x37, 0x0c, 0xe1, 0xc1, 0xb2,
    0xf6, 0x30, 0x65, 0x73, 0x50, 0x69, 0x49, 0x42, 0x73, 0x08, 0x78, 0xe6,
    0xff, 0xf7, 0x7a, 0xda, 0x7e, 0x9a, 0x31, 0x7d, 0xf8, 0xbc, 0x05, 0x9e,
    0xa7, 0x08, 0x13, 0x25, 0x30, 0x6b, 0x8e, 0xb2, 0xfa, 0x0d, 0x3a, 0x3d,
    0x89, 0xfa, 0xe4, 0x76, 0xd9, 0x34, 0x48, 0x92, 0xbc, 0xd5, 0xa4, 0x2c,
    0xf8, 0x3b, 0x7b, 0xcf, 0x3e, 0x0e, 0x51, 0xb4, 0xc7, 0x8e, 0x72, 0xb3,
    0x20, 0x7a, 0x60, 0xa7, 0x01, 0xad, 0xb1, 0x02, 0x81, 0x81, 0x00, 0xef,
    0x88, 0x5b, 0x87, 0xe2, 0x5c, 0x29, 0xd1, 0xee, 0x43, 0x1d, 0x1f, 0x4a,
    0xce, 0x78, 0x7c, 0x4f, 0x88, 0x2e, 0x92, 0xd1, 0x2c, 0x4b, 0x27, 0x66,
    0xc8, 0x4f, 0x89, 0x26, 0x31, 0x06, 0xef, 0x0b, 0xe0, 0xdd, 0xc4, 0xde,
    0x3b, 0xf0, 0x61, 0xa2, 0xba, 0x46, 0xff, 0xe7, 0xc1, 0x32, 0xae, 0x67,
    0xd3, 0x37, 0xf0, 0x4d, 0xc6, 0x6d, 0xae, 0xb9, 0xde, 0x55, 0x37, 0x91,
    0xf4, 0x98, 0x9f, 0x50, 0xb2, 0x24, 0xc9, 0x81, 0x81, 0x2b, 0x53, 0x88,
    0xd1, 0xc2, 0xb5, 0xd5, 0x33, 0x49, 0xa6, 0x13, 0x93, 0xbf, 0x66, 0x11,
    0x99, 0x5b, 0x69, 0x88, 0xf1, 0x43, 0xc2, 0x78, 0xcc, 0xc2, 0x60, 0xcf,
    0xe8, 0x2a, 0x6a, 0xc4, 0xa6, 0x40, 0x98, 0x07, 0xea, 0xb3, 0x26, 0x64,
    0xb7, 0xee, 0x3f, 0x1c, 0x41, 0xdf, 0xe5, 0x67, 0xe0, 0x97, 0xfd, 0x7a,
    0xfe, 0x85, 0x20, 0x87, 0x1a, 0x1c, 0x53, 0x02, 0x81, 0x81, 0x00, 0xdb,
    0xca, 0x58, 0x22, 0x88, 0xc8, 0x1a, 0x30, 0xd6, 0x58, 0x1f, 0x27, 0x20,
    0x50, 0xa5, 0xfe, 0xa7, 0x73, 0xd7, 0x11, 0x30, 0x1b, 0xdd, 0x6e, 0xca,
    0xc7, 0x21, 0x4e, 0x00, 0xc0, 0xfc, 0xb9, 0x49, 0x8f, 0x1e, 0x58, 0x50,
    0x86, 0xb1, 0x44, 0x63, 0xcc, 0x89, 0xa0, 0x2c, 0x2e, 0x77, 0xa8, 0x92,
    0x71, 0xc0, 0x58, 0xc6, 0xf6, 0x9f, 0x3c, 0xd1, 0x35, 0x53, 0x99, 0x4d,
    0x8a, 0x76, 0xcf, 0x62, 0xad, 0x9e, 0x27, 0x52, 0x17, 0x72, 0x0d, 0x62,
    0xeb, 0x6e, 0x88, 0x8e, 0xc4, 0x50, 0x9c, 0xea, 0x47, 0x4b, 0x53, 0xf3,
    0x7b, 0x45, 0x8f, 0xc9, 0x56, 0xdd, 0x31, 0xdf, 0x3b, 0xb6, 0xec, 0x7d,
    0xe6, 0x59, 0xe8, 0x8e, 0x7e, 0x70, 0x9f, 0xe3, 0xbe, 0x6a, 0x8d, 0x37,
    0x26, 0x4c, 0x3d, 0x20, 0xe7, 0xd0, 0x88, 0x27, 0x6c, 0xe7, 0x65, 0x1a,
    0x40, 0x3c, 0x68, 0xd6, 0xc4, 0x7e, 0xa5, 0x02, 0x81, 0x81, 0x00, 0x9d,
    0x7e, 0x87, 0xc8, 0x51, 0xd2, 0x8d, 0x80, 0xc5, 0xeb, 0x84, 0xf3, 0x75,
    0x49, 0x4a, 0xb9, 0x59, 0xc5, 0xcd, 0xf1, 0xa4, 0xed, 0x3d, 0xc0, 0xfb,
    0x78, 0xcb, 0xaa, 0xfe, 0xdc, 0x8f, 0x95, 0x8f, 0xb6, 0xdb, 0xba, 0x3c,
    0xf1, 0x26, 0x3d, 0xdc, 0x34, 0x24, 0xc8, 0xd0, 0x46, 0x1c, 0x9f, 0xc6,
    0x0e, 0x80, 0x22, 0x55, 0xd1, 0x19, 0x7f, 0x20, 0x21, 0x0a, 0xe1, 0x0d,
    0xeb, 0xc8, 0x8a, 0x40, 0x11, 0xd1, 0xd4, 0x58, 0x7d, 0x68, 0xd2, 0x75,
    0x0c, 0x8e, 0xbc, 0xe6, 0x20, 0xe1, 0xd4, 0xfb, 0xdc, 0x52, 0xa5, 0xb6,
    0xfe, 0xa1, 0xb7, 0x43, 0x5e, 0x77, 0x52, 0x20, 0x01, 0x69, 0xf1, 0x23,
    0xe2, 0xa0, 0x39, 0x31, 0x71, 0xaa, 0xd9, 0x0b, 0xa3, 0x8b, 0x05, 0xbc,
    0x85, 0x9f, 0x76, 0x09, 0x8b, 0x5a, 0xbe, 0xc8, 0xcd, 0x48, 0xc2, 0x57,
    0x23, 0x90, 0xbe, 0xf1, 0x75, 0xfe, 0x97, 0x02, 0x81, 0x80, 0x0e, 0xed,
    0x60, 0x2d, 0x00, 0x43, 0x2e, 0xdc, 0x30, 0x42, 0x8d, 0xe3, 0x17, 0x63,
    0xc2, 0xd2, 0x57, 0xc7, 0x1b, 0x4d, 0x34, 0x8a, 0x3f, 0xf0, 0xbd, 0x5e,
    0xe6, 0xd9, 0x28, 0x5d, 0xf3, 0x0c, 0x16, 0x7d, 0xdc, 0xde, 0xbc, 0xa1,
    0x59, 0x3a, 0xbe, 0xd8, 0x6e, 0x64, 0x6d, 0x7b, 0xbe, 0x6e, 0xb9, 0x7b,
    0x76, 0x47, 0xd1, 0x43, 0x80, 0xaf, 0x1d, 0xba, 0x54, 0x72, 0x2d, 0xfd,
    0x00, 0x72, 0xb7, 0x4d, 0xf9, 0x56, 0xcc, 0x51, 0x81, 0x52, 0x7d, 0x6c,
    0x65, 0xf6, 0x6a, 0x53, 0xd4, 0xf1, 0xc3, 0x4b, 0x92, 0x47, 0x22, 0x5b,
    0x35, 0xef, 0x3d, 0x0a, 0x64, 0x3d, 0x75, 0xde, 0xd5, 0x5e, 0x9c, 0x72,
    0x5f, 0x9a, 0xd6, 0xca, 0xa9, 0x95, 0x82, 0x5f, 0x35, 0x57, 0x5f, 0xee,
    0x7e, 0xf1, 0x0b, 0xe2, 0x12, 0x9c, 0x9c, 0xa8, 0xdd, 0xd2, 0x55, 0x05,
    0x15, 0xd5, 0x3c, 0xf8, 0xdd, 0x6d, 0x02, 0x81, 0x80, 0x10, 0x1d, 0x1f,
    0x49, 0xaf, 0xb0, 0x4d, 0x06, 0x5b, 0xd8, 0xc2, 0x90, 0x01, 0xd2, 0x12,
    0xe7, 0x37, 0xbb, 0xa6, 0x96, 0x10, 0x85, 0x74, 0xa3, 0x30, 0xa9, 0xcb,
    0xac, 0xc5, 0x1b, 0xf6, 0xc9, 0x65, 0x94, 0xf3, 0x7f, 0xba, 0x9c, 0x8d,
    0xe1, 0x56, 0xc2, 0x26, 0x37, 0x1d, 0x49, 0x90, 0x21, 0x91, 0xe1, 0xf6,
    0x9d, 0x84, 0xa1, 0x35, 0x21, 0x93, 0xbf, 0xf2, 0x9e, 0x31, 0x8e, 0xb3,
    0x6e, 0xde, 0x6f, 0xfb, 0xab, 0x93, 0xb6, 0x55, 0x5e, 0xcf, 0x6a, 0xdd,
    0xca, 0x9e, 0x13, 0x4c, 0x20, 0x22, 0x0a, 0x2d, 0x24, 0xb0, 0x3a, 0x6d,
    0x23, 0xef, 0x8c, 0x60, 0x8a, 0x51, 0x86, 0x76, 0x9f, 0x66, 0xfe, 0x2f,
    0x6b, 0x21, 0xbc, 0x39, 0xf6, 0x27, 0x7a, 0xd7, 0x06, 0x03, 0x8b, 0x90,
    0x78, 0x72, 0xc4, 0x71, 0x66, 0x09, 0xc2, 0x23, 0x76, 0x21, 0x30, 0xef,
    0x03, 0x61, 0x64, 0x82, 0xf2};

const RsaOaepTestVector kRsaOaep2048Sha384Mgf1Sha1WycheproofVectors[] = {

    // Comment:
    // tcID: 1
    {SEC_OID_SHA384,
     CKG_MGF1_SHA1,
     1,
     {},
     {0x84, 0x02, 0xdb, 0xdc, 0xa0, 0xd3, 0xe9, 0xce, 0x70, 0xca, 0xcf, 0xdf,
      0xe3, 0xb2, 0xef, 0x26, 0xed, 0x92, 0xa6, 0xb8, 0xdc, 0x3c, 0x70, 0x64,
      0x0e, 0x06, 0xd0, 0x90, 0x02, 0x13, 0x82, 0x4a, 0x79, 0xd0, 0xcc, 0xe6,
      0xd0, 0xd7, 0x81, 0x30, 0x6e, 0xb2, 0x36, 0x38, 0x4d, 0x69, 0xf3, 0xed,
      0x9d, 0x92, 0x1d, 0xb8, 0x20, 0x3e, 0x82, 0xa0, 0xca, 0xb0, 0x4a, 0x51,
      0xc1, 0x2e, 0xb0, 0xa3, 0xfe, 0x66, 0x8a, 0xb0, 0xec, 0xfc, 0x41, 0x9d,
      0x35, 0x29, 0xf9, 0x97, 0x0d, 0x45, 0xd9, 0xba, 0xc4, 0x37, 0x3e, 0xc3,
      0x12, 0xb2, 0xa2, 0x4f, 0x0c, 0x82, 0x9a, 0xa0, 0xc0, 0x05, 0x1e, 0x44,
      0xa2, 0x5e, 0x6d, 0xa5, 0xbc, 0xcc, 0xf9, 0xed, 0xc6, 0xf1, 0xd8, 0x7f,
      0x15, 0x2b, 0x47, 0x70, 0xae, 0xdb, 0x8a, 0x36, 0x99, 0x3d, 0x57, 0x68,
      0xcd, 0x97, 0xc3, 0x02, 0xab, 0xbc, 0xfe, 0x93, 0x60, 0xba, 0xac, 0xf4,
      0x37, 0xd6, 0x8f, 0x59, 0x04, 0x82, 0x80, 0xb5, 0x60, 0xf5, 0x26, 0x5e,
      0x7f, 0x08, 0x76, 0x91, 0x03, 0x46, 0x83, 0x38, 0xbc, 0x93, 0x32, 0x56,
      0x8c, 0x20, 0xc7, 0xef, 0xbe, 0xdd, 0xca, 0x83, 0x50, 0x66, 0x2d, 0x64,
      0x96, 0x4a, 0xe5, 0x33, 0x81, 0x38, 0xce, 0x13, 0xc0, 0xcd, 0x0c, 0x9e,
      0xb6, 0xf0, 0xb2, 0x51, 0x6e, 0xf2, 0x27, 0xbd, 0xbb, 0xe5, 0x5d, 0x20,
      0x8f, 0x47, 0x0e, 0xc5, 0x97, 0x61, 0x16, 0x86, 0x5f, 0x42, 0x89, 0x7e,
      0x63, 0x29, 0x4d, 0x4f, 0xdb, 0xf3, 0x6f, 0x6f, 0x4f, 0xc4, 0x3d, 0xcb,
      0x79, 0xd2, 0xc8, 0x4d, 0x30, 0xc5, 0xf6, 0x9a, 0xce, 0x97, 0xab, 0xe7,
      0x7a, 0x1d, 0x82, 0xd3, 0xfd, 0x81, 0x52, 0x53, 0xd5, 0xb5, 0x73, 0xdd,
      0xe8, 0xeb, 0x01, 0xf9, 0x64, 0x16, 0x08, 0x55, 0x38, 0xe9, 0x4b, 0x8a,
      0x0d, 0x95, 0xde, 0x57},
     {},
     priv_key_2,
     true},

    // Comment:
    // tcID: 2
    {SEC_OID_SHA384,
     CKG_MGF1_SHA1,
     2,
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     {0x85, 0x84, 0x06, 0xb0, 0x1f, 0xa5, 0x6d, 0x4f, 0x21, 0x6e, 0x36, 0xfe,
      0x4f, 0xb2, 0xba, 0x99, 0x11, 0x30, 0xcd, 0x5e, 0xf5, 0x65, 0x42, 0xff,
      0x60, 0xbc, 0x5a, 0xc9, 0x5e, 0xcc, 0xda, 0xff, 0xc4, 0x0b, 0xed, 0xb3,
      0x73, 0xba, 0xbf, 0x08, 0xa7, 0x96, 0x20, 0xf8, 0x38, 0xd8, 0x74, 0xe5,
      0x74, 0x93, 0x56, 0x04, 0xcc, 0x15, 0xb2, 0xdc, 0x02, 0x20, 0xf8, 0x4e,
      0xce, 0x76, 0xb4, 0x3d, 0x52, 0x39, 0xc3, 0x01, 0x2f, 0x0c, 0xc6, 0xa4,
      0x46, 0xde, 0xce, 0x36, 0x16, 0x60, 0x6e, 0x36, 0x02, 0x6f, 0xb1, 0x54,
      0x4b, 0x26, 0xff, 0xb2, 0xd0, 0xdc, 0xbb, 0x95, 0x4e, 0xb8, 0x12, 0xe9,
      0x6a, 0xbd, 0xf2, 0x45, 0xdf, 0xba, 0x3e, 0xa3, 0x0a, 0xa5, 0xd5, 0xe7,
      0xb8, 0x19, 0x73, 0xf5, 0xc0, 0x0a, 0x9e, 0x18, 0xa5, 0x33, 0x7b, 0xdc,
      0xf0, 0x46, 0xc5, 0x5d, 0x7e, 0x5a, 0x60, 0x28, 0xb0, 0x93, 0xe6, 0xfe,
      0x5e, 0x82, 0x58, 0x07, 0x37, 0x6a, 0x27, 0x13, 0x49, 0x74, 0xbe, 0xd3,
      0x14, 0x22, 0x6c, 0xd6, 0x5e, 0x17, 0x07, 0x7d, 0x72, 0x1c, 0xb5, 0x2b,
      0xb0, 0x83, 0xe5, 0xe3, 0x79, 0xd2, 0xcb, 0xe8, 0x59, 0x46, 0x17, 0x90,
      0x8d, 0x9b, 0x90, 0xe0, 0x85, 0x12, 0x03, 0xce, 0x7d, 0x9d, 0xd8, 0xdf,
      0x66, 0x7e, 0x86, 0xc3, 0x85, 0x7c, 0x2b, 0xf9, 0xdb, 0xba, 0xc7, 0x0f,
      0x93, 0x9d, 0x82, 0x2c, 0x18, 0x8d, 0xe6, 0x7c, 0x60, 0xf3, 0xbf, 0xaa,
      0xed, 0x36, 0xad, 0x49, 0x32, 0xc2, 0xe2, 0x8b, 0xf9, 0xa5, 0x46, 0x0b,
      0xf5, 0x1f, 0x2a, 0xd3, 0x81, 0xe9, 0x63, 0x91, 0xc4, 0x02, 0x46, 0x43,
      0xc1, 0x91, 0x65, 0xe6, 0x3d, 0xb2, 0x9d, 0xe6, 0x23, 0x2c, 0x7b, 0xbf,
      0x95, 0x1d, 0x04, 0xd6, 0xfd, 0x67, 0xdf, 0x6d, 0x0d, 0xd0, 0x8c, 0x4d,
      0x16, 0x43, 0x86, 0xd0},
     {},
     priv_key_2,
     true},

    // Comment:
    // tcID: 3
    {SEC_OID_SHA384,
     CKG_MGF1_SHA1,
     3,
     {0x54, 0x65, 0x73, 0x74},
     {0xc5, 0x39, 0x05, 0x03, 0xbc, 0xc0, 0x89, 0x59, 0xab, 0x92, 0xc9, 0x2e,
      0xc9, 0xe0, 0x7a, 0x59, 0xcd, 0xdd, 0x2c, 0xa4, 0x92, 0x9b, 0xda, 0xec,
      0x89, 0xef, 0xde, 0x9c, 0x4d, 0xa1, 0x01, 0x1c, 0x1b, 0xe7, 0x48, 0x4e,
      0xb7, 0x6b, 0x64, 0x97, 0x69, 0xf3, 0xd2, 0x58, 0x21, 0x9a, 0x25, 0x03,
      0x46, 0x4c, 0x28, 0x4a, 0x1d, 0x3b, 0xf1, 0x2a, 0xf8, 0xe5, 0x84, 0xc4,
      0x5b, 0x71, 0x7d, 0xb7, 0xbe, 0xbe, 0x32, 0x55, 0xa1, 0xb8, 0xaf, 0xf1,
      0xf1, 0x9b, 0xc2, 0xae, 0x26, 0x67, 0x2d, 0x2b, 0xb1, 0xcc, 0x3d, 0x05,
      0xca, 0x6f, 0x4a, 0xf9, 0xbc, 0xa6, 0x96, 0x7f, 0x22, 0x59, 0x3e, 0x54,
      0xd7, 0xc4, 0x2b, 0x10, 0xe1, 0x97, 0x35, 0xd4, 0x83, 0x86, 0x28, 0x50,
      0xb7, 0xf1, 0x84, 0xfc, 0xd3, 0x8a, 0x3f, 0x89, 0x5c, 0xec, 0xce, 0x36,
      0x5b, 0x68, 0xf9, 0x22, 0x08, 0x3c, 0x47, 0x37, 0xc1, 0x6d, 0x15, 0x2d,
      0x70, 0xae, 0xee, 0x8e, 0xdf, 0xf5, 0xd3, 0xa3, 0xc0, 0x15, 0x3b, 0x33,
      0x52, 0x9b, 0x8f, 0xaa, 0x73, 0xbc, 0xcc, 0x4e, 0x23, 0x42, 0xb2, 0x3a,
      0xcc, 0x22, 0x70, 0x64, 0xd0, 0x9f, 0xa7, 0xb6, 0x65, 0x83, 0x06, 0x8d,
      0x9a, 0xe9, 0x97, 0x8c, 0x14, 0xf9, 0x69, 0x98, 0x36, 0x2d, 0xd9, 0xed,
      0x0f, 0x67, 0x29, 0x0b, 0x8e, 0xb2, 0x20, 0x55, 0x7e, 0x25, 0x7d, 0xae,
      0xf3, 0x8f, 0x11, 0x88, 0x73, 0x09, 0x4b, 0x87, 0x33, 0xc6, 0xd7, 0x2a,
      0x1a, 0xad, 0x6e, 0x40, 0x60, 0x1c, 0xbe, 0xc8, 0x47, 0x69, 0x08, 0x42,
      0xa3, 0x8d, 0xe4, 0xf8, 0x5e, 0x04, 0xe9, 0xd0, 0xed, 0xb3, 0x98, 0x34,
      0x57, 0x1a, 0xdb, 0x0d, 0xa4, 0xdd, 0x15, 0x8f, 0x8e, 0x22, 0xa6, 0x67,
      0x8d, 0xb4, 0x5a, 0xc8, 0x6c, 0xe7, 0x97, 0xd8, 0xb8, 0x6d, 0x4d, 0x6d,
      0xe8, 0x44, 0xc0, 0xdd},
     {},
     priv_key_2,
     true},

    // Comment:
    // tcID: 4
    {SEC_OID_SHA384,
     CKG_MGF1_SHA1,
     4,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x58, 0x14, 0xd6, 0xf2, 0xf3, 0xb2, 0x35, 0x45, 0xe0, 0x05, 0xa4, 0xf7,
      0x2e, 0xb0, 0xef, 0x65, 0x9f, 0xc0, 0x7a, 0x83, 0x74, 0x78, 0x0f, 0x8e,
      0xb9, 0x22, 0x3d, 0xad, 0x41, 0x7b, 0xff, 0x6c, 0x96, 0xa9, 0x1c, 0x60,
      0x71, 0xab, 0xd6, 0x78, 0xa8, 0xc9, 0xcb, 0xf0, 0xb4, 0x73, 0x5e, 0x4c,
      0x22, 0x5e, 0x98, 0x46, 0x69, 0x22, 0x4e, 0x88, 0x65, 0x5d, 0xd4, 0xf0,
      0x5a, 0xdf, 0x1c, 0xb1, 0xae, 0x96, 0xf7, 0xdc, 0x79, 0x32, 0xa0, 0xb3,
      0x87, 0x15, 0x8a, 0x91, 0x5f, 0x75, 0x63, 0x08, 0x5f, 0x44, 0xc7, 0x2a,
      0x41, 0xf3, 0x31, 0xe0, 0xe1, 0x7e, 0x68, 0x95, 0xe4, 0x42, 0xf7, 0x49,
      0x21, 0x51, 0x39, 0x71, 0x59, 0x63, 0x79, 0x68, 0xb1, 0x58, 0x88, 0xf8,
      0x51, 0x32, 0x31, 0x07, 0xbf, 0xdc, 0x1c, 0xd4, 0x19, 0xd6, 0xad, 0xe5,
      0x6b, 0x97, 0x4a, 0xff, 0x86, 0x5d, 0x58, 0x23, 0xda, 0xad, 0x3d, 0x0c,
      0xd8, 0xb1, 0xa9, 0x4e, 0xe1, 0x76, 0x7b, 0x70, 0xfe, 0x47, 0x7c, 0x64,
      0xa5, 0xbf, 0xa5, 0x93, 0x78, 0x3a, 0xa9, 0x08, 0x68, 0xd4, 0x45, 0x6f,
      0x09, 0x86, 0x30, 0xeb, 0x32, 0xae, 0x71, 0xad, 0x49, 0x14, 0xc1, 0x42,
      0xc8, 0x05, 0xa6, 0x9d, 0x2f, 0xd0, 0xe9, 0x35, 0x63, 0xfe, 0xca, 0x56,
      0x7e, 0xd9, 0x22, 0x51, 0x4c, 0x0c, 0x88, 0x67, 0x33, 0x2c, 0x05, 0x3d,
      0x49, 0x12, 0xcd, 0x17, 0xd2, 0x38, 0xeb, 0x46, 0x24, 0x5f, 0xbe, 0xb0,
      0x34, 0x39, 0xc6, 0xe6, 0xad, 0xc1, 0xca, 0xc0, 0x6d, 0x1e, 0xb4, 0x1d,
      0x9a, 0x18, 0x50, 0x57, 0x43, 0x1b, 0x25, 0xd4, 0x60, 0x06, 0x84, 0xe0,
      0x57, 0xe5, 0x71, 0xdf, 0xd1, 0xa5, 0x73, 0xdc, 0x60, 0x39, 0x5e, 0x7c,
      0x2e, 0x3d, 0x61, 0x2f, 0x9f, 0x66, 0x47, 0x2f, 0x4d, 0xff, 0x28, 0x4f,
      0x4c, 0xad, 0x4e, 0x6a},
     {},
     priv_key_2,
     true},

    // Comment:
    // tcID: 5
    {SEC_OID_SHA384,
     CKG_MGF1_SHA1,
     5,
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     {0x84, 0x72, 0x10, 0x5e, 0x08, 0x9a, 0xf3, 0x24, 0xcf, 0xcb, 0xad, 0x5e,
      0xb2, 0xce, 0x2f, 0x85, 0x18, 0x5f, 0x2e, 0x2f, 0x5a, 0x9e, 0x5e, 0x30,
      0x20, 0x22, 0xea, 0xae, 0x5e, 0x40, 0xb1, 0x50, 0x7d, 0xfd, 0x48, 0x01,
      0xac, 0x5d, 0x47, 0x43, 0xb1, 0x8b, 0x87, 0xd9, 0x16, 0xb2, 0xbb, 0x55,
      0xbb, 0xa8, 0x12, 0x73, 0x58, 0x31, 0x29, 0x6d, 0xfc, 0xdf, 0x40, 0x87,
      0xba, 0x4a, 0x4d, 0xbf, 0x85, 0x2f, 0x02, 0x74, 0xc7, 0xe3, 0x7d, 0xcf,
      0x26, 0x82, 0xc3, 0xaa, 0xc5, 0x0a, 0x70, 0xb6, 0xd0, 0x88, 0x35, 0xb0,
      0xc5, 0x9e, 0x90, 0xfe, 0x3c, 0xe2, 0xf3, 0xb6, 0x10, 0x08, 0x63, 0x93,
      0x6a, 0x67, 0xaf, 0x14, 0x12, 0x36, 0xda, 0xf5, 0xf5, 0x88, 0xf2, 0xea,
      0xa0, 0x9c, 0x39, 0x1f, 0x57, 0x28, 0xda, 0xc6, 0xa0, 0x07, 0xa0, 0x2d,
      0xde, 0x61, 0xbc, 0x69, 0xc6, 0x5d, 0x48, 0x85, 0x14, 0x9a, 0x34, 0x40,
      0x46, 0xd6, 0x6f, 0x1b, 0x91, 0x71, 0x1e, 0xec, 0xf5, 0x19, 0x60, 0x06,
      0xfb, 0x91, 0x6e, 0xc2, 0x09, 0xe5, 0xbd, 0x25, 0x1c, 0xcb, 0x97, 0xb0,
      0x8c, 0x31, 0xaa, 0x1e, 0xbb, 0x25, 0xb4, 0x40, 0x28, 0x04, 0x7a, 0xe4,
      0xf6, 0x1a, 0xda, 0xea, 0x52, 0x15, 0xe0, 0x32, 0x4a, 0xf6, 0xd0, 0x50,
      0x9d, 0xa3, 0xa3, 0x84, 0x3e, 0xed, 0x6a, 0xe5, 0x3f, 0xed, 0x3a, 0x1e,
      0x45, 0x9c, 0x7a, 0xac, 0x4d, 0x94, 0xf8, 0xc8, 0x56, 0x11, 0x35, 0x4e,
      0x0e, 0x24, 0xf7, 0x63, 0x0a, 0x42, 0xb1, 0x84, 0x80, 0x5f, 0x67, 0xaa,
      0x7e, 0xd0, 0xbf, 0xb5, 0x7e, 0x61, 0x36, 0xc4, 0x32, 0x61, 0xf8, 0x19,
      0x40, 0x33, 0x8f, 0xb4, 0xae, 0xb6, 0x62, 0xd2, 0x93, 0x01, 0xff, 0x3a,
      0x0a, 0x5a, 0x01, 0xaa, 0x20, 0xe5, 0x3f, 0x40, 0x41, 0xc2, 0x0f, 0x14,
      0x20, 0x7e, 0xbe, 0x96},
     {},
     priv_key_2,
     true},

    // Comment:
    // tcID: 6
    {SEC_OID_SHA384,
     CKG_MGF1_SHA1,
     6,
     {0x61},
     {0x36, 0x45, 0xe9, 0x2f, 0x0c, 0x46, 0xb7, 0xd6, 0xf6, 0x76, 0x55, 0x75,
      0xfa, 0x9a, 0xab, 0xde, 0x09, 0x51, 0x25, 0x64, 0xa2, 0xd2, 0xac, 0x80,
      0xaa, 0x8b, 0x43, 0x71, 0x0f, 0x34, 0xc4, 0xaf, 0xf7, 0x2d, 0x2d, 0xf0,
      0x24, 0x46, 0xcc, 0x54, 0x8a, 0xcf, 0x30, 0xe3, 0x49, 0x94, 0x02, 0x0e,
      0xd7, 0x30, 0x1b, 0xba, 0x6b, 0x69, 0xbb, 0x4e, 0x9a, 0xbc, 0xc7, 0x66,
      0xe3, 0xc9, 0x28, 0x4a, 0xbf, 0x82, 0x4a, 0xe8, 0x38, 0x9f, 0xba, 0x58,
      0xbd, 0x26, 0x33, 0xb0, 0x1e, 0xdc, 0x3a, 0xb6, 0x48, 0x78, 0x8d, 0x31,
      0xbc, 0x7b, 0x40, 0x4f, 0x6e, 0x07, 0x9a, 0x65, 0x0d, 0xd8, 0x22, 0x4b,
      0x06, 0x42, 0xfd, 0x58, 0x9b, 0x3f, 0x84, 0xcc, 0x39, 0x3d, 0x18, 0xbf,
      0x8b, 0x3a, 0x1f, 0x65, 0xfb, 0xe6, 0x68, 0x4f, 0x6a, 0x76, 0xb3, 0xe7,
      0x67, 0xd5, 0xf2, 0x95, 0x3d, 0xb5, 0x3e, 0x61, 0xdb, 0xfd, 0x69, 0x37,
      0x1b, 0x69, 0xb7, 0x11, 0x22, 0x84, 0xf2, 0x56, 0xff, 0x11, 0xbe, 0xed,
      0xed, 0x9f, 0x4d, 0xee, 0xa4, 0x73, 0x50, 0xc2, 0x83, 0xd8, 0x25, 0x38,
      0x79, 0x81, 0xc1, 0xd5, 0x1d, 0x62, 0xca, 0x03, 0x24, 0x85, 0xa1, 0xa6,
      0xf8, 0x58, 0x21, 0x48, 0xe7, 0xb8, 0x0d, 0x2c, 0x55, 0xda, 0xae, 0x46,
      0x75, 0x76, 0xef, 0x45, 0xbe, 0x6f, 0x00, 0xe6, 0x76, 0xeb, 0x5a, 0x40,
      0xda, 0x88, 0xc1, 0x85, 0x73, 0xff, 0x01, 0x22, 0x67, 0x85, 0x90, 0x30,
      0xcc, 0x61, 0x41, 0x35, 0xdc, 0xa8, 0x69, 0x4d, 0xc0, 0xa0, 0xef, 0x0d,
      0x00, 0xe6, 0x27, 0x61, 0x99, 0x9d, 0x93, 0xc3, 0xe8, 0x65, 0x1a, 0x11,
      0xfb, 0x43, 0xa0, 0x28, 0x37, 0x0b, 0x48, 0x1d, 0xda, 0xf6, 0xcd, 0x8c,
      0x4a, 0x08, 0x6a, 0xea, 0x2e, 0x65, 0x8d, 0x44, 0x55, 0x6a, 0x6e, 0xed,
      0xd6, 0x4d, 0xa5, 0xd4},
     {},
     priv_key_2,
     true},

    // Comment:
    // tcID: 7
    {SEC_OID_SHA384,
     CKG_MGF1_SHA1,
     7,
     {0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea,
      0xeb, 0xec, 0xed, 0xee, 0xef, 0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5,
      0xf6, 0xf7, 0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff},
     {0x4d, 0xca, 0xf6, 0xae, 0x82, 0x48, 0x13, 0x50, 0xb4, 0x9b, 0x34, 0x4e,
      0x2f, 0xf3, 0x34, 0x8d, 0x00, 0x64, 0xb6, 0x3d, 0x4a, 0x68, 0x62, 0x83,
      0xcf, 0xe7, 0xca, 0x8d, 0xed, 0x4d, 0x73, 0xc5, 0x5c, 0x9c, 0xd3, 0xdf,
      0xc6, 0x65, 0x6e, 0x3f, 0xd1, 0x8e, 0x45, 0xdc, 0x69, 0xdd, 0xdc, 0xc8,
      0x2a, 0x33, 0xb4, 0x65, 0x31, 0xf3, 0xb5, 0xb7, 0x68, 0x2e, 0xf1, 0xfa,
      0x00, 0x68, 0xec, 0x42, 0x58, 0x3a, 0x20, 0x21, 0xe7, 0xda, 0xe3, 0x90,
      0x8d, 0x92, 0x4a, 0x6b, 0xac, 0x3b, 0xca, 0xa1, 0x23, 0xc8, 0x8a, 0xfc,
      0xf1, 0xdc, 0x6e, 0x22, 0xac, 0x6b, 0xe9, 0x66, 0x72, 0x32, 0x23, 0xf5,
      0xf7, 0xaa, 0x46, 0xe2, 0x20, 0x5c, 0x6e, 0x6c, 0xc5, 0x94, 0xcd, 0xc5,
      0xcb, 0xf9, 0x31, 0x5c, 0x64, 0x1a, 0x84, 0x66, 0x5d, 0x66, 0x40, 0x8a,
      0x7b, 0x4f, 0x38, 0xba, 0x66, 0x72, 0xfe, 0x3c, 0x77, 0xc5, 0x3e, 0xd1,
      0x3f, 0xf5, 0xca, 0x5e, 0x3d, 0x78, 0xab, 0x51, 0xfd, 0x19, 0x18, 0x68,
      0x02, 0x70, 0x9a, 0x0f, 0x98, 0xd7, 0xde, 0x5e, 0xfc, 0x10, 0xec, 0x7a,
      0xa4, 0x44, 0x8c, 0x0e, 0x89, 0xd5, 0x06, 0x16, 0x8a, 0xcd, 0xa5, 0xc8,
      0x5a, 0x12, 0xba, 0xdb, 0x8b, 0x41, 0x04, 0xc6, 0xb6, 0xd4, 0x8a, 0xd4,
      0xcf, 0xaa, 0x4e, 0x05, 0x54, 0x84, 0xa8, 0xc4, 0x00, 0x9b, 0xd5, 0x79,
      0xe8, 0x9b, 0x81, 0xd7, 0x12, 0x1d, 0x4b, 0xb4, 0x0e, 0x94, 0xa3, 0x1f,
      0x35, 0xcc, 0xab, 0x0e, 0x71, 0xcf, 0x76, 0x71, 0x58, 0x13, 0x9e, 0x7b,
      0x41, 0x39, 0x12, 0xef, 0xc9, 0x71, 0x6d, 0x8d, 0xe8, 0xf0, 0x88, 0x46,
      0x7c, 0xb7, 0x7f, 0x8e, 0x06, 0x49, 0xaa, 0xed, 0x9e, 0xf9, 0xf4, 0x8d,
      0xf6, 0x4c, 0xdd, 0xd9, 0xb7, 0x5c, 0xa5, 0xf0, 0x77, 0xa0, 0x84, 0x68,
      0xa7, 0x68, 0xcd, 0xcb},
     {},
     priv_key_2,
     true},

    // Comment:
    // tcID: 8
    {SEC_OID_SHA384,
     CKG_MGF1_SHA1,
     8,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x8d, 0x31, 0xb6, 0xa8, 0x65, 0x82, 0xc2, 0xb3, 0x5e, 0x86, 0xfb, 0xa1,
      0xaf, 0x4d, 0x02, 0x48, 0x4e, 0xa8, 0x13, 0x26, 0xf9, 0x72, 0x8c, 0x22,
      0x76, 0x1c, 0xfe, 0x33, 0x7b, 0x7d, 0x0a, 0xdf, 0xf7, 0x87, 0xe2, 0xcd,
      0x68, 0xc3, 0xb7, 0x1f, 0x22, 0xcf, 0x9d, 0x0c, 0x14, 0x1e, 0x27, 0x3b,
      0xa9, 0xc6, 0x1c, 0xd6, 0xc6, 0xcb, 0x18, 0x05, 0x03, 0x91, 0x27, 0x94,
      0x56, 0xc3, 0xc9, 0x30, 0xcd, 0x6c, 0xb2, 0xdf, 0x70, 0xb2, 0x95, 0xe3,
      0xc0, 0x62, 0xc9, 0x3d, 0x60, 0xd8, 0x88, 0x4a, 0x2c, 0xff, 0x28, 0x39,
      0x36, 0x40, 0x86, 0x20, 0x8f, 0x1b, 0xe9, 0x00, 0x72, 0x47, 0x23, 0x3a,
      0x04, 0x80, 0x51, 0x51, 0xb4, 0x68, 0x54, 0xf9, 0xda, 0x2b, 0x9a, 0x9e,
      0x08, 0x03, 0x20, 0x0a, 0xfb, 0x31, 0x66, 0xdb, 0x99, 0x07, 0xc9, 0x40,
      0x6b, 0x00, 0x20, 0x13, 0xd5, 0xa5, 0x66, 0xe4, 0xce, 0x83, 0xb0, 0x57,
      0x26, 0x94, 0xbe, 0xa9, 0xd3, 0xcb, 0xed, 0xc7, 0x96, 0xfc, 0x45, 0x38,
      0xf0, 0x31, 0x5e, 0xb9, 0x20, 0xbe, 0xd4, 0x26, 0x7b, 0x12, 0xb9, 0x12,
      0x7c, 0x68, 0x3e, 0x83, 0x06, 0x9e, 0x8b, 0xae, 0xaa, 0xa9, 0x11, 0xc8,
      0xf0, 0x8d, 0x24, 0x57, 0x53, 0x9c, 0x73, 0x1c, 0x6a, 0x90, 0xc6, 0x27,
      0x68, 0xfc, 0xc7, 0x16, 0x90, 0x88, 0xb9, 0x8c, 0x13, 0xa2, 0x91, 0xbc,
      0x70, 0xbf, 0x6d, 0x10, 0x37, 0x24, 0x94, 0xf0, 0x72, 0xd0, 0x17, 0xca,
      0xb2, 0xf2, 0xab, 0x8e, 0xd6, 0x82, 0xb4, 0x51, 0x4f, 0x57, 0x6a, 0xf2,
      0xf8, 0x1b, 0x90, 0xcd, 0xc1, 0x3a, 0x26, 0x6e, 0xfe, 0xa3, 0xf9, 0x8f,
      0xec, 0xb4, 0xa2, 0xac, 0x10, 0x62, 0xab, 0xa3, 0x9e, 0x47, 0xe8, 0xb3,
      0xbc, 0x48, 0x71, 0x56, 0xbf, 0x7f, 0x41, 0xcb, 0x78, 0x72, 0xe4, 0x02,
      0xd5, 0x14, 0xdf, 0x86},
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     priv_key_2,
     true},

    // Comment:
    // tcID: 9
    {SEC_OID_SHA384,
     CKG_MGF1_SHA1,
     9,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0xa7, 0x8e, 0xef, 0xe1, 0x03, 0xfd, 0xfa, 0xd9, 0x98, 0x75, 0x35, 0xd1,
      0x0b, 0xe6, 0x54, 0x3a, 0x00, 0x92, 0xd1, 0xb4, 0x9a, 0xef, 0x20, 0xa8,
      0xc4, 0x0d, 0xf7, 0x1b, 0x64, 0x70, 0xb5, 0x60, 0xc6, 0x4d, 0x1c, 0xda,
      0x67, 0xb4, 0x73, 0x38, 0xa5, 0x72, 0xd6, 0x95, 0xb3, 0x14, 0xd4, 0xba,
      0x50, 0xf8, 0x36, 0xde, 0xb7, 0x46, 0xcc, 0x5a, 0x86, 0x2e, 0x50, 0xc7,
      0x6f, 0xac, 0x68, 0x97, 0x36, 0xc7, 0x91, 0x2d, 0x53, 0x24, 0xdb, 0x07,
      0x2f, 0x02, 0x9f, 0xba, 0x10, 0xc9, 0xcb, 0x87, 0x99, 0x73, 0x47, 0x3e,
      0x66, 0xf4, 0xa6, 0x17, 0xd6, 0xac, 0xa9, 0x40, 0x5f, 0x25, 0x56, 0xd4,
      0x4b, 0xf1, 0xd6, 0xfc, 0x3e, 0xde, 0x6a, 0x60, 0xa5, 0x23, 0x34, 0xcb,
      0x09, 0xcb, 0x06, 0x37, 0xf8, 0xf2, 0x47, 0x20, 0x0f, 0xc0, 0x06, 0x3a,
      0x0e, 0x8c, 0xc3, 0x4e, 0xf0, 0x1a, 0x66, 0x57, 0xa4, 0x14, 0x44, 0xa9,
      0x42, 0xa8, 0xc7, 0x22, 0x48, 0xf9, 0xdc, 0x2d, 0x15, 0xa2, 0x6e, 0x82,
      0x2e, 0x0e, 0xf7, 0x3e, 0xa5, 0xd9, 0xec, 0x03, 0x06, 0x0f, 0x90, 0x67,
      0x90, 0x51, 0x0d, 0x88, 0xf4, 0x6c, 0x38, 0xde, 0xf4, 0x03, 0x97, 0xa2,
      0xaf, 0xf2, 0xb7, 0x75, 0x40, 0xde, 0xe5, 0x96, 0x3a, 0x0e, 0xa5, 0x04,
      0x99, 0x04, 0x23, 0x5b, 0x5e, 0x74, 0xda, 0x53, 0x6c, 0x7a, 0x3f, 0x35,
      0x3d, 0x9c, 0xec, 0x5c, 0x50, 0xa5, 0xbc, 0xbf, 0xa0, 0x7b, 0x94, 0x76,
      0xaa, 0xbb, 0x8d, 0xe2, 0x97, 0x65, 0x36, 0x80, 0x82, 0x32, 0x65, 0xd7,
      0xaf, 0xd8, 0x81, 0x52, 0x67, 0xa7, 0x99, 0x53, 0x30, 0x1d, 0x70, 0x40,
      0xe0, 0x8d, 0x59, 0x81, 0xc1, 0xbb, 0x89, 0x58, 0xad, 0x5b, 0xb3, 0xbb,
      0x42, 0x0b, 0x02, 0x44, 0x9a, 0x25, 0xe8, 0xff, 0xf1, 0xd2, 0x16, 0xfd,
      0xc1, 0xf3, 0xcc, 0x2c},
     {0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09,
      0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13},
     priv_key_2,
     true},

    // Comment:
    // tcID: 10
    {SEC_OID_SHA384,
     CKG_MGF1_SHA1,
     10,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0xbd, 0x68, 0x2d, 0xdc, 0x52, 0x26, 0xf6, 0x12, 0x06, 0xb2, 0x46, 0x49,
      0x73, 0xdf, 0x91, 0x55, 0xf6, 0xc3, 0x47, 0x44, 0x12, 0x94, 0x3f, 0x51,
      0xdd, 0x8c, 0x8e, 0x1f, 0xd0, 0x0a, 0x31, 0xb6, 0xee, 0x2c, 0xca, 0x89,
      0x9d, 0xb0, 0xab, 0xa8, 0x3a, 0x91, 0x8b, 0xda, 0x52, 0x10, 0x14, 0x80,
      0x87, 0x90, 0xa0, 0x45, 0x5a, 0x32, 0xcc, 0x76, 0x5c, 0x19, 0xf0, 0x88,
      0xa0, 0xe1, 0x77, 0x33, 0x64, 0xe2, 0x57, 0x45, 0xea, 0xf0, 0x15, 0xb1,
      0x85, 0xce, 0x69, 0xc7, 0x88, 0x6e, 0xfc, 0x16, 0xb3, 0xd9, 0x5f, 0xb1,
      0x66, 0x80, 0x38, 0xeb, 0x9e, 0xe8, 0x12, 0x98, 0x5f, 0x96, 0x5e, 0x3b,
      0xd9, 0xbb, 0x84, 0xb8, 0xda, 0x9f, 0x1b, 0xfa, 0x32, 0x4d, 0x05, 0x0a,
      0xf3, 0x6d, 0x93, 0xbc, 0x79, 0x3f, 0xe5, 0x8d, 0x67, 0x62, 0xd9, 0x27,
      0x34, 0x01, 0x36, 0xdf, 0xac, 0x3b, 0xa1, 0x49, 0xbb, 0xc3, 0x8b, 0x4d,
      0x3e, 0x41, 0x77, 0xab, 0x95, 0xfc, 0x6f, 0xd5, 0x3a, 0xca, 0xa9, 0x25,
      0x18, 0x0b, 0x88, 0xb7, 0x1f, 0x60, 0x76, 0x20, 0x24, 0x3d, 0x45, 0xd3,
      0xba, 0xd1, 0xe9, 0x62, 0x97, 0xfd, 0xd3, 0x39, 0xa5, 0xa2, 0x5a, 0x37,
      0x43, 0x63, 0x20, 0xe5, 0x49, 0x74, 0x2a, 0x5b, 0x12, 0x66, 0xd0, 0x94,
      0x6e, 0x05, 0x69, 0x16, 0xcc, 0xe2, 0x4e, 0x00, 0x2f, 0x7c, 0xe5, 0xae,
      0x41, 0x20, 0x46, 0xbd, 0x0c, 0x51, 0x9e, 0xfc, 0x41, 0x73, 0x52, 0xbd,
      0x6d, 0x0e, 0x95, 0x92, 0x07, 0x12, 0xd1, 0x1a, 0x7a, 0xfe, 0x31, 0x90,
      0xaf, 0xdd, 0x3b, 0x5c, 0xe5, 0x10, 0xc0, 0xdf, 0x7f, 0xf1, 0x6c, 0x2e,
      0x80, 0x86, 0x9f, 0x69, 0xa2, 0xcb, 0x73, 0x5f, 0x34, 0xf9, 0xc2, 0x60,
      0xb4, 0x72, 0xed, 0x20, 0xc3, 0xe8, 0xe6, 0x1b, 0x2c, 0x38, 0xf5, 0x64,
      0xdf, 0xf6, 0x0f, 0xf2},
     {0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a,
      0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15,
      0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f},
     priv_key_2,
     true},

    // Comment: Longest valid message size
    // tcID: 11
    {SEC_OID_SHA384,
     CKG_MGF1_SHA1,
     11,
     {0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78},
     {0x67, 0x2d, 0x24, 0xc0, 0x76, 0x42, 0x92, 0x91, 0xe4, 0x10, 0x24, 0x5c,
      0x34, 0xe3, 0x5e, 0xda, 0x03, 0x56, 0xfb, 0x22, 0x07, 0x66, 0x01, 0xd5,
      0x5b, 0xea, 0x1b, 0xf3, 0x09, 0xa8, 0x73, 0x40, 0x62, 0xf4, 0x4e, 0xe6,
      0x61, 0x5d, 0xf4, 0xfa, 0x00, 0x67, 0xd4, 0x3e, 0x86, 0xcc, 0xa0, 0xa8,
      0x23, 0xbc, 0x40, 0x89, 0xcd, 0x50, 0x51, 0x7f, 0xb3, 0xb9, 0x21, 0x58,
      0x5b, 0xa0, 0xd1, 0xfb, 0xdb, 0x13, 0x1a, 0x24, 0x68, 0x5c, 0x02, 0xcf,
      0xb2, 0x5a, 0xb5, 0x6a, 0xde, 0x1d, 0xe0, 0xf6, 0xe7, 0x05, 0x51, 0x9b,
      0xd5, 0xae, 0x7e, 0x4e, 0xb2, 0xcf, 0x2a, 0x63, 0xba, 0x95, 0x37, 0xca,
      0x85, 0x00, 0x08, 0x71, 0x28, 0x25, 0xcb, 0x2a, 0x28, 0x73, 0xdc, 0x76,
      0x71, 0x5c, 0x99, 0x22, 0xfc, 0xfb, 0x3a, 0x3a, 0xcc, 0xa0, 0xa4, 0xf1,
      0x5a, 0xbf, 0xaf, 0x49, 0xfc, 0x29, 0x8b, 0x57, 0x88, 0xbc, 0x91, 0x22,
      0x66, 0x90, 0x0c, 0xb8, 0x27, 0x00, 0x40, 0x4c, 0x50, 0x2e, 0xd6, 0x6c,
      0x83, 0xb6, 0xa4, 0xe9, 0x38, 0x30, 0xbf, 0x9f, 0xf8, 0xe5, 0x47, 0xa6,
      0xc6, 0x23, 0xee, 0x99, 0x92, 0x7d, 0xca, 0x03, 0x44, 0x7f, 0xa1, 0xaf,
      0x89, 0x6d, 0x76, 0xe5, 0x9e, 0xcf, 0x3a, 0xb7, 0x3e, 0x04, 0x53, 0xfd,
      0x0d, 0x76, 0x8f, 0x5e, 0xa1, 0xf4, 0xc8, 0x25, 0x2f, 0x6a, 0x01, 0x84,
      0x9f, 0x80, 0x98, 0x46, 0x11, 0x47, 0xc8, 0xe1, 0x37, 0x53, 0x3a, 0x89,
      0x80, 0x79, 0x68, 0x52, 0x0c, 0x1d, 0x18, 0xb2, 0xcf, 0x62, 0x67, 0x7e,
      0xcd, 0xbb, 0xad, 0x1f, 0x09, 0x61, 0x5c, 0x6e, 0xcb, 0x49, 0x39, 0xc7,
      0xcd, 0xc1, 0x7a, 0x53, 0xdc, 0x46, 0xf8, 0x14, 0x3c, 0x36, 0xe3, 0xeb,
      0xc9, 0x9a, 0x21, 0xef, 0x93, 0x20, 0xe7, 0x70, 0x86, 0x7d, 0x90, 0xfa,
      0x3f, 0x08, 0x3f, 0x9b},
     {},
     priv_key_2,
     true},

    // Comment: first byte of l_hash modified
    // tcID: 12
    {SEC_OID_SHA384,
     CKG_MGF1_SHA1,
     12,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x17, 0x65, 0x2d, 0xc5, 0x45, 0x71, 0x63, 0xc0, 0xa6, 0x22, 0xe1, 0xa5,
      0x2d, 0x14, 0x97, 0x70, 0xaf, 0x1b, 0x53, 0x99, 0xb7, 0x5c, 0xc7, 0x79,
      0x7a, 0xec, 0x32, 0x38, 0xbf, 0x8d, 0x9a, 0x67, 0x06, 0x1e, 0x1d, 0x73,
      0x5e, 0x67, 0xf7, 0x6f, 0x4f, 0x6f, 0x69, 0x7c, 0x5c, 0x4f, 0x5e, 0xae,
      0xce, 0x14, 0xee, 0xe2, 0x88, 0x60, 0x9b, 0xa0, 0x43, 0x3f, 0xb1, 0x7d,
      0x0f, 0x7c, 0x54, 0xc9, 0xf5, 0x59, 0x3b, 0x00, 0x59, 0xaa, 0xb6, 0xe8,
      0xfa, 0x94, 0x23, 0x51, 0x74, 0xfa, 0xdf, 0x7e, 0x60, 0x1e, 0xa9, 0x96,
      0x82, 0x57, 0xbd, 0x9d, 0x9e, 0xe8, 0x56, 0x31, 0xe3, 0xb1, 0xce, 0x0d,
      0x7a, 0x66, 0x29, 0x4b, 0xfa, 0x68, 0xdd, 0x26, 0x5f, 0x92, 0x1d, 0xc7,
      0x80, 0x6b, 0xab, 0xc3, 0x1d, 0x40, 0x4c, 0x35, 0xe5, 0x1f, 0x4a, 0xe6,
      0x1c, 0x4b, 0x7b, 0x9e, 0x4d, 0x44, 0xf8, 0xc8, 0xde, 0xcc, 0x0b, 0xf9,
      0x9b, 0x4a, 0x43, 0x67, 0xb5, 0x3e, 0x3a, 0x61, 0xf8, 0x56, 0x83, 0xdd,
      0xc9, 0xc0, 0xf7, 0xf1, 0xd2, 0x18, 0x67, 0x27, 0x51, 0x7d, 0x1f, 0x9c,
      0xf2, 0x06, 0xe1, 0x00, 0x4b, 0x0f, 0x57, 0xa1, 0x9c, 0xf9, 0x78, 0x45,
      0x6d, 0x66, 0x9d, 0x9e, 0xe1, 0x33, 0x9a, 0xe3, 0x32, 0x9e, 0xcb, 0xac,
      0xf7, 0x17, 0xf1, 0x3c, 0x51, 0x38, 0x7b, 0x1b, 0xa0, 0xae, 0x81, 0x71,
      0x8e, 0xea, 0xba, 0x3e, 0x62, 0x27, 0x30, 0x1b, 0xa8, 0xff, 0x14, 0x9a,
      0x1c, 0x6d, 0x28, 0x6e, 0x1f, 0xb0, 0x16, 0x91, 0x9f, 0xa4, 0xc8, 0xc7,
      0xb7, 0x8a, 0xce, 0xba, 0xcb, 0x47, 0x60, 0x67, 0x13, 0xb5, 0x82, 0x05,
      0xd1, 0x5b, 0xaa, 0x11, 0x75, 0x5e, 0x76, 0x46, 0xb2, 0x0d, 0xab, 0x46,
      0x46, 0xa0, 0x2d, 0x37, 0x43, 0x46, 0xff, 0xc0, 0x9f, 0x6b, 0xed, 0xa7,
      0x2a, 0x7f, 0x67, 0x34},
     {},
     priv_key_2,
     false},

    // Comment: last byte of l_hash modified
    // tcID: 13
    {SEC_OID_SHA384,
     CKG_MGF1_SHA1,
     13,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x02, 0x77, 0x60, 0x46, 0xb5, 0x29, 0xdb, 0x8f, 0xf9, 0x0a, 0x31, 0x6f,
      0x91, 0xee, 0xe5, 0x80, 0x34, 0x6b, 0xc6, 0x26, 0xa6, 0x88, 0xc0, 0x97,
      0x8f, 0xe5, 0xd6, 0x6c, 0x14, 0xaa, 0x9a, 0xd9, 0xfc, 0xd2, 0xa8, 0x87,
      0xf9, 0x8b, 0x77, 0xc8, 0xf3, 0x03, 0x71, 0x26, 0xd3, 0x23, 0x82, 0xdb,
      0xf6, 0xa8, 0x10, 0x9f, 0x8c, 0x01, 0x20, 0xe9, 0x64, 0xa7, 0x51, 0x9f,
      0xe5, 0xbb, 0x9d, 0x1f, 0x4b, 0xcb, 0x3c, 0xdf, 0x76, 0x1a, 0x19, 0x58,
      0x7b, 0x49, 0x14, 0xcd, 0xe8, 0xd4, 0x3f, 0x6b, 0xf3, 0x1a, 0xb3, 0xd7,
      0x1f, 0xfe, 0x29, 0xed, 0x29, 0x3e, 0xa2, 0x20, 0x2e, 0x5d, 0x38, 0x30,
      0x75, 0xcc, 0xe7, 0xf9, 0xb8, 0x3e, 0x33, 0x66, 0x56, 0x3c, 0x14, 0x8c,
      0x72, 0x64, 0x8a, 0x0a, 0xde, 0x86, 0x3b, 0xe3, 0x61, 0x3d, 0x71, 0x5d,
      0xc9, 0x64, 0x9a, 0x44, 0x2c, 0xd2, 0x54, 0x47, 0x62, 0xf3, 0xd2, 0xf0,
      0xc0, 0xfa, 0xaf, 0x93, 0x84, 0xf3, 0xf5, 0xb0, 0x21, 0x20, 0x0a, 0x06,
      0x2e, 0xe7, 0x4d, 0x8b, 0x80, 0x9c, 0xd9, 0xd8, 0xbf, 0xbe, 0x98, 0x94,
      0x99, 0xd9, 0x87, 0x24, 0x02, 0xa0, 0xa4, 0x90, 0xb6, 0x54, 0xc1, 0xf8,
      0x56, 0x52, 0x63, 0x34, 0xdf, 0xb8, 0x4e, 0x73, 0xec, 0x37, 0xcd, 0x75,
      0xf6, 0x31, 0x51, 0xdb, 0xfd, 0xf7, 0x8d, 0x5e, 0x06, 0x29, 0x77, 0xba,
      0x70, 0x7c, 0x50, 0x4d, 0xca, 0x25, 0x09, 0xfa, 0xbd, 0xc8, 0x54, 0x80,
      0xfa, 0x2b, 0xea, 0xd8, 0x4f, 0x14, 0xc1, 0xa7, 0x19, 0x7e, 0x2f, 0x41,
      0xa6, 0x94, 0x0a, 0xb4, 0x76, 0x8f, 0xdc, 0xd6, 0xc7, 0x24, 0x39, 0xbe,
      0x6f, 0x25, 0xbc, 0x60, 0x0e, 0x0f, 0xc8, 0x82, 0x34, 0x8b, 0x73, 0x58,
      0x2a, 0xdc, 0x13, 0xc6, 0x74, 0x08, 0x0d, 0x9c, 0x92, 0x13, 0x67, 0x22,
      0x62, 0x30, 0x66, 0x5f},
     {},
     priv_key_2,
     false},

    // Comment: l_hash changed to all 0
    // tcID: 14
    {SEC_OID_SHA384,
     CKG_MGF1_SHA1,
     14,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x31, 0x02, 0xa7, 0x0e, 0x60, 0x1b, 0x92, 0x8a, 0x6b, 0x35, 0x03, 0x37,
      0xb6, 0xe4, 0x24, 0xd3, 0xce, 0x28, 0x50, 0xbb, 0xcc, 0xc6, 0xde, 0x82,
      0x1d, 0x67, 0x7f, 0x2c, 0x40, 0x66, 0x86, 0xc2, 0x4e, 0xf6, 0xf3, 0xdc,
      0x6f, 0xc4, 0x50, 0xf8, 0x73, 0xa7, 0xdc, 0x4c, 0xcc, 0x8a, 0x16, 0xec,
      0xd1, 0xc3, 0x5b, 0x93, 0x74, 0xee, 0x48, 0x04, 0x65, 0xb7, 0xb3, 0x12,
      0x14, 0x95, 0x38, 0xfe, 0x2e, 0x1d, 0x3a, 0x2a, 0x8b, 0x01, 0x7f, 0xc9,
      0x16, 0xd3, 0x31, 0x6e, 0xac, 0x60, 0x6b, 0xd6, 0x5b, 0x9a, 0xf6, 0xd6,
      0x17, 0x9f, 0xec, 0xbd, 0x8a, 0xc2, 0xef, 0x0f, 0x6f, 0x59, 0x08, 0x26,
      0x12, 0xdc, 0xf2, 0x47, 0x86, 0xb4, 0x68, 0x8a, 0x6a, 0x86, 0x59, 0xa4,
      0x6e, 0x5a, 0x8f, 0x94, 0x1a, 0xd7, 0xc1, 0x1a, 0x2e, 0x2e, 0x72, 0x75,
      0xb9, 0x00, 0xf0, 0xb8, 0xb0, 0xf6, 0xca, 0x4c, 0x21, 0x87, 0x8d, 0x96,
      0xe8, 0x76, 0xb0, 0x5b, 0x3b, 0x1b, 0xc8, 0xe0, 0xd5, 0x54, 0x8d, 0x43,
      0x3e, 0xe5, 0x6f, 0x37, 0x72, 0x22, 0x58, 0xd9, 0x88, 0x62, 0x4f, 0x0c,
      0xca, 0x3c, 0xb0, 0x97, 0x6c, 0x31, 0xc3, 0x95, 0xf0, 0x69, 0x31, 0xda,
      0x56, 0x3c, 0x3f, 0x2e, 0x13, 0x4e, 0x63, 0x6d, 0x5c, 0x50, 0xb4, 0xf4,
      0xc3, 0x2e, 0xb3, 0xa5, 0x96, 0xb3, 0x60, 0xba, 0x0d, 0xc5, 0xf7, 0xfa,
      0x2b, 0xeb, 0x8f, 0x83, 0x42, 0x78, 0x7d, 0x9f, 0x9e, 0x55, 0xec, 0x01,
      0x85, 0x56, 0xed, 0xb4, 0xce, 0x0f, 0x9d, 0x26, 0xb0, 0xf4, 0x10, 0xac,
      0x87, 0x70, 0x73, 0xca, 0x8d, 0x40, 0xee, 0xfa, 0x2a, 0x50, 0x0b, 0xf4,
      0x48, 0x9b, 0xad, 0x4f, 0xc6, 0x0c, 0x37, 0x3c, 0x57, 0x6a, 0xb0, 0x13,
      0x5a, 0x61, 0x2e, 0x27, 0x11, 0xc6, 0xfe, 0x04, 0xa0, 0x75, 0x66, 0xf4,
      0xc1, 0x7d, 0x02, 0x1d},
     {},
     priv_key_2,
     false},

    // Comment: l_hash changed to all 1
    // tcID: 15
    {SEC_OID_SHA384,
     CKG_MGF1_SHA1,
     15,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x23, 0x93, 0xef, 0x64, 0xf3, 0x32, 0x18, 0xe3, 0x8a, 0xc8, 0x0c, 0x30,
      0x93, 0x44, 0xfe, 0x33, 0xa1, 0xde, 0xba, 0x9f, 0x63, 0xaa, 0xb2, 0x9e,
      0x06, 0x52, 0x9f, 0x5f, 0xe5, 0x73, 0x67, 0x21, 0xab, 0xbb, 0x79, 0x2e,
      0x78, 0x7f, 0x2d, 0xf1, 0xec, 0x8d, 0xb8, 0x51, 0x38, 0x69, 0xc1, 0xfc,
      0x1f, 0x0a, 0x78, 0x64, 0x8f, 0x56, 0x13, 0xf7, 0x0e, 0x0b, 0x52, 0x2c,
      0xd5, 0xcd, 0x78, 0xc0, 0x1e, 0x12, 0x1d, 0x3e, 0x52, 0x7a, 0x49, 0xc2,
      0x48, 0x86, 0x1c, 0x47, 0xf7, 0xb1, 0x08, 0x22, 0x8a, 0x6c, 0x44, 0x81,
      0x45, 0x1e, 0x2a, 0xc8, 0x34, 0x02, 0x9a, 0x48, 0x40, 0x35, 0x98, 0x10,
      0x5f, 0xe9, 0x9b, 0x3f, 0x06, 0x02, 0x96, 0x04, 0x3f, 0xb6, 0x09, 0x27,
      0x7f, 0xff, 0x17, 0x46, 0x32, 0x57, 0x63, 0xa5, 0xfd, 0xe8, 0xd6, 0x5e,
      0x6f, 0x43, 0x79, 0x1a, 0xbd, 0x7b, 0x11, 0x3f, 0xd7, 0xa8, 0x28, 0x1d,
      0x26, 0x29, 0xca, 0xf7, 0xf7, 0x61, 0x58, 0x76, 0xdb, 0xc7, 0x02, 0xae,
      0xe7, 0xf2, 0xf0, 0x18, 0x29, 0xb5, 0x06, 0xdc, 0x33, 0x6e, 0x9e, 0xbb,
      0xc6, 0x14, 0x7d, 0x94, 0xd8, 0x53, 0xea, 0xd7, 0x96, 0x93, 0xc3, 0xc6,
      0xf9, 0x56, 0xa1, 0x8e, 0xc8, 0x25, 0xbe, 0x43, 0x08, 0x4e, 0x23, 0xa3,
      0xe1, 0x5d, 0x31, 0xa8, 0x88, 0xa8, 0x85, 0x15, 0x2b, 0xd7, 0xcf, 0xf3,
      0x4c, 0xf3, 0xde, 0x28, 0x48, 0x05, 0xe8, 0x35, 0x8c, 0x7f, 0xfd, 0xae,
      0xb5, 0x6b, 0x22, 0x57, 0xe3, 0xc7, 0xc1, 0xfe, 0x8c, 0x2c, 0xed, 0x18,
      0x3e, 0xe2, 0x7f, 0xdc, 0x99, 0xe4, 0xf7, 0x47, 0x58, 0xcd, 0x68, 0xd1,
      0x44, 0x2e, 0x1d, 0xcd, 0x05, 0xb6, 0x2c, 0xe4, 0x31, 0xc2, 0x6c, 0x0c,
      0x76, 0x85, 0x27, 0x50, 0x79, 0x13, 0x75, 0x34, 0x5e, 0xed, 0xf9, 0xc9,
      0x84, 0x8e, 0xb2, 0x72},
     {},
     priv_key_2,
     false},

    // Comment: first byte of ps modified
    // tcID: 16
    {SEC_OID_SHA384,
     CKG_MGF1_SHA1,
     16,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x61, 0x15, 0xfe, 0x66, 0xf9, 0x4a, 0xf6, 0xdc, 0x4f, 0x2c, 0xc4, 0x6e,
      0x55, 0x27, 0x10, 0x60, 0x3c, 0x27, 0x1e, 0xb2, 0x11, 0x26, 0x1f, 0x41,
      0x5b, 0xea, 0x92, 0x2a, 0xdb, 0x0d, 0xc2, 0x60, 0x85, 0xfc, 0x65, 0x07,
      0x58, 0xb7, 0x94, 0x03, 0xdd, 0x76, 0xe0, 0x35, 0x03, 0x1e, 0x5d, 0x7d,
      0x17, 0x7a, 0xbb, 0x75, 0x2f, 0x4b, 0x1f, 0xeb, 0x0b, 0xc4, 0x4e, 0x13,
      0xcf, 0x4b, 0x17, 0xb9, 0xb9, 0x5b, 0x55, 0x3c, 0x3e, 0xee, 0xff, 0x22,
      0x78, 0xf8, 0x27, 0x34, 0x5f, 0xdf, 0x33, 0x08, 0xb8, 0xd5, 0x34, 0xa1,
      0xe4, 0xa0, 0x7b, 0xe9, 0xeb, 0xd6, 0x0c, 0x96, 0xfa, 0x45, 0xa2, 0xa0,
      0x4d, 0x6c, 0x91, 0x29, 0x2f, 0x13, 0x22, 0x39, 0x50, 0x46, 0x6e, 0x44,
      0x15, 0x50, 0xc8, 0x90, 0x36, 0x77, 0xbe, 0x93, 0xf0, 0xc4, 0x05, 0x62,
      0xd8, 0xc5, 0x1f, 0x9d, 0x77, 0x2b, 0x7e, 0x2f, 0x72, 0x16, 0x24, 0x34,
      0x2d, 0x6b, 0xa2, 0x8d, 0x29, 0xb6, 0x28, 0xce, 0x8c, 0xcc, 0xdf, 0xa0,
      0x7e, 0x50, 0xcb, 0x37, 0x90, 0x63, 0x86, 0x1a, 0xbd, 0xb0, 0xd6, 0x87,
      0x64, 0x33, 0x24, 0x3b, 0xce, 0xbe, 0x75, 0xa3, 0x42, 0x43, 0x22, 0x25,
      0x5b, 0x5c, 0xbb, 0x44, 0xf2, 0xdf, 0xef, 0xaa, 0x9a, 0x93, 0x83, 0x29,
      0x6e, 0xbc, 0x44, 0xc6, 0x55, 0x2f, 0x87, 0xe7, 0x03, 0x36, 0x8f, 0xbb,
      0x33, 0xcc, 0x83, 0xde, 0x4f, 0x90, 0x27, 0xc5, 0x88, 0xae, 0x3d, 0x9e,
      0x56, 0x7b, 0xa2, 0x8b, 0xd8, 0xef, 0xc5, 0xa4, 0xb1, 0x73, 0xac, 0xcd,
      0xd0, 0xd0, 0x79, 0x3a, 0xba, 0xe5, 0xd2, 0xfb, 0x93, 0x30, 0x55, 0x55,
      0x3b, 0xe8, 0x2e, 0xed, 0xbb, 0x67, 0x11, 0xe2, 0xad, 0x64, 0x8b, 0x04,
      0x09, 0x8a, 0x17, 0xe8, 0x2a, 0x2a, 0x0e, 0xf4, 0xc6, 0x74, 0x5c, 0x15,
      0x63, 0x9b, 0x7c, 0x85},
     {},
     priv_key_2,
     false},

    // Comment: ps terminated by 0xff
    // tcID: 17
    {SEC_OID_SHA384,
     CKG_MGF1_SHA1,
     17,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x40, 0x54, 0x69, 0x2a, 0x94, 0x38, 0xbb, 0x21, 0x56, 0xdf, 0xf8, 0x05,
      0xa6, 0x0d, 0xde, 0x5e, 0xf1, 0x81, 0x2d, 0xf0, 0xeb, 0x8f, 0x7b, 0x4e,
      0xb2, 0xae, 0xf7, 0x49, 0x51, 0xbc, 0x2a, 0xd4, 0x48, 0x50, 0xb8, 0x30,
      0xf5, 0x58, 0x40, 0x7c, 0xf5, 0xbe, 0xc5, 0xca, 0xc2, 0x0a, 0x26, 0xba,
      0x54, 0x11, 0x28, 0x71, 0xa2, 0x4e, 0x13, 0x8e, 0xa4, 0x3e, 0x49, 0x9a,
      0x7f, 0xf6, 0x0e, 0x61, 0x21, 0x24, 0xd0, 0x6e, 0x0c, 0xd8, 0x85, 0x33,
      0xdd, 0x7b, 0x64, 0xea, 0x20, 0x27, 0x7f, 0xdb, 0xa3, 0xc2, 0x52, 0x2b,
      0xda, 0xc6, 0xf7, 0x9d, 0x98, 0x84, 0xca, 0x1f, 0x97, 0x1f, 0x1d, 0xb5,
      0x46, 0x98, 0xe4, 0xcd, 0x14, 0x9c, 0xca, 0x76, 0x74, 0x21, 0x0f, 0x3b,
      0xeb, 0x08, 0xe1, 0xba, 0x5b, 0xd1, 0x64, 0x74, 0x17, 0xb5, 0xeb, 0x25,
      0x11, 0x6b, 0x94, 0xb1, 0x65, 0xb8, 0x0b, 0xf6, 0x9c, 0xfa, 0xd6, 0x84,
      0x57, 0xcf, 0x79, 0xdd, 0x3b, 0xda, 0xb1, 0xec, 0x01, 0xb7, 0x57, 0xd5,
      0xf1, 0xa0, 0x28, 0x6d, 0x53, 0xd8, 0x34, 0x0a, 0xd5, 0xd5, 0x3b, 0x05,
      0x31, 0xa9, 0x4e, 0x91, 0xe1, 0xa7, 0xf0, 0xfc, 0x86, 0x4d, 0x7d, 0xb4,
      0xf9, 0xf0, 0xcc, 0x9e, 0xe0, 0xf9, 0xa6, 0xeb, 0x03, 0x30, 0x5d, 0x7e,
      0xbe, 0xc3, 0xfc, 0x99, 0x79, 0x23, 0xe7, 0xca, 0x87, 0x9d, 0x6f, 0x45,
      0x8d, 0xdc, 0x46, 0x18, 0xd2, 0xd8, 0xb7, 0xba, 0xa0, 0x58, 0xf2, 0x5c,
      0x6d, 0xc0, 0x92, 0xd6, 0x36, 0x0b, 0x7f, 0x27, 0x08, 0xa0, 0xf2, 0x8e,
      0xd4, 0x4c, 0x72, 0x2f, 0x39, 0xf1, 0xe4, 0x2b, 0x6a, 0xba, 0x4e, 0x4d,
      0xf8, 0xe5, 0x15, 0x45, 0xdf, 0x6c, 0xba, 0x4e, 0xd7, 0xb4, 0xfe, 0x8d,
      0x65, 0xa6, 0xc1, 0xad, 0x09, 0xff, 0xfd, 0xe8, 0x3e, 0x96, 0x2d, 0x72,
      0x8d, 0xe7, 0x3f, 0xa4},
     {},
     priv_key_2,
     false},

    // Comment: ps is all zero
    // tcID: 18
    {SEC_OID_SHA384,
     CKG_MGF1_SHA1,
     18,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x14, 0xc5, 0x6a, 0x1f, 0x06, 0x4e, 0xf7, 0x8e, 0xe6, 0xa2, 0x63, 0xc6,
      0xb5, 0x51, 0xd3, 0x55, 0xfb, 0xf6, 0xbe, 0xb7, 0xbd, 0xf6, 0x76, 0x99,
      0x99, 0xb8, 0x61, 0x82, 0xf8, 0x36, 0xa6, 0x3f, 0x1f, 0x53, 0xc6, 0x29,
      0x24, 0x3a, 0xb3, 0xda, 0xd5, 0x81, 0xe2, 0x21, 0xe8, 0xb5, 0x1c, 0xae,
      0x70, 0x66, 0x98, 0x97, 0x0d, 0x20, 0x5f, 0x4b, 0xfb, 0x38, 0x58, 0xd2,
      0x65, 0xd0, 0x5e, 0x0d, 0x5c, 0x9a, 0xd9, 0x73, 0xe0, 0xa3, 0x0f, 0x8f,
      0xa6, 0xb2, 0x49, 0xd1, 0x27, 0x1a, 0xe9, 0x31, 0x13, 0x2d, 0xdb, 0x7d,
      0x0b, 0x5a, 0x66, 0x5c, 0x4a, 0x4f, 0x17, 0x8a, 0xaf, 0x03, 0x6a, 0x25,
      0xff, 0xcd, 0x52, 0x25, 0xc6, 0xed, 0xec, 0x84, 0x7f, 0x9e, 0xcf, 0x94,
      0x9a, 0x93, 0xdb, 0xdb, 0x30, 0xcd, 0xcd, 0xa1, 0x98, 0xc9, 0x53, 0x53,
      0x03, 0x3d, 0x87, 0xb3, 0xcc, 0x16, 0xfc, 0xbd, 0xd9, 0x28, 0xdd, 0x13,
      0x1f, 0x48, 0x74, 0xdd, 0x4b, 0x50, 0xa8, 0xa6, 0x17, 0xd0, 0x49, 0xb4,
      0x75, 0x30, 0x8d, 0x64, 0x9c, 0x84, 0x44, 0x4c, 0xb4, 0x4e, 0x85, 0x44,
      0x07, 0x71, 0x66, 0x63, 0x6a, 0xe6, 0xb6, 0x4c, 0x46, 0x00, 0x02, 0x92,
      0x43, 0xf0, 0xac, 0xca, 0x71, 0x82, 0xa3, 0x2e, 0x55, 0x04, 0xd9, 0x8f,
      0xdd, 0x8a, 0xb9, 0xcc, 0x31, 0x36, 0xaa, 0x06, 0x01, 0xee, 0x63, 0xee,
      0x40, 0x22, 0xea, 0x40, 0xcc, 0x65, 0x25, 0xbf, 0xea, 0xaf, 0x3a, 0xfc,
      0xf6, 0x6b, 0x00, 0x87, 0x88, 0x5b, 0xad, 0xcb, 0xef, 0xcf, 0xa3, 0x1a,
      0x02, 0x62, 0x84, 0x0f, 0x09, 0x88, 0x00, 0xdb, 0xe2, 0x6b, 0xa9, 0x11,
      0x38, 0x60, 0x09, 0x78, 0xee, 0x73, 0x90, 0x54, 0xeb, 0xae, 0x9f, 0xd9,
      0xce, 0x85, 0x66, 0xaa, 0x2a, 0x24, 0x98, 0x96, 0x88, 0xb4, 0xf3, 0x24,
      0x5c, 0x7b, 0xe8, 0x32},
     {},
     priv_key_2,
     false},

    // Comment: ps replaced by 0xff's
    // tcID: 19
    {SEC_OID_SHA384,
     CKG_MGF1_SHA1,
     19,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x81, 0xea, 0x17, 0x0e, 0x37, 0xcf, 0x84, 0x4e, 0x0e, 0x35, 0x69, 0xcd,
      0x9a, 0x1c, 0x88, 0xfb, 0x35, 0xd8, 0x94, 0xc8, 0x20, 0xfa, 0x46, 0xea,
      0x6d, 0xe1, 0x45, 0x61, 0x3e, 0x51, 0xa6, 0x44, 0x44, 0x04, 0xb1, 0x83,
      0x13, 0xbb, 0x47, 0xfc, 0x27, 0xce, 0x81, 0xb9, 0x53, 0x41, 0x6b, 0xf4,
      0x0d, 0x9c, 0x86, 0x06, 0x2f, 0x50, 0xcb, 0x7d, 0x54, 0x7f, 0x0c, 0xae,
      0x06, 0x82, 0x40, 0x8f, 0xb6, 0xd1, 0xca, 0x31, 0x1a, 0xd6, 0x17, 0x43,
      0x52, 0x29, 0xc6, 0xc1, 0xcd, 0x11, 0x84, 0x76, 0xa1, 0x2c, 0xf1, 0xfc,
      0x96, 0x13, 0x02, 0x08, 0xab, 0xdf, 0xfe, 0x50, 0x10, 0x1c, 0xf0, 0x7a,
      0xd3, 0xa3, 0x18, 0xa8, 0x31, 0x2c, 0x6c, 0x23, 0xfe, 0x95, 0x45, 0xa2,
      0x12, 0x74, 0xa1, 0x69, 0xb1, 0xd7, 0xd4, 0xdb, 0xf1, 0x98, 0xa1, 0xa0,
      0x61, 0x97, 0xc4, 0xd7, 0x7c, 0x91, 0xbb, 0xc6, 0xb8, 0x59, 0x1f, 0x66,
      0xa3, 0x67, 0x3d, 0x1e, 0xae, 0x4f, 0xdb, 0x08, 0x39, 0xb5, 0x92, 0x58,
      0x68, 0xab, 0x8c, 0xd4, 0x1e, 0xf6, 0x70, 0xbb, 0xfa, 0xa7, 0x7d, 0x12,
      0xa9, 0x34, 0x76, 0x58, 0xa9, 0x69, 0xb7, 0xd0, 0xe4, 0xf5, 0x1a, 0x1e,
      0xfa, 0xeb, 0x33, 0x39, 0xc7, 0x61, 0xb8, 0x08, 0x7f, 0x86, 0x5d, 0x58,
      0x02, 0x63, 0x30, 0x64, 0x17, 0xa2, 0x75, 0xaa, 0x2a, 0x69, 0xa5, 0xb7,
      0xdb, 0x58, 0x1b, 0x09, 0xb6, 0x36, 0xf2, 0xdd, 0xe0, 0x22, 0xa7, 0xf9,
      0xd2, 0xb2, 0xd8, 0x8d, 0x64, 0xc0, 0x2b, 0xdc, 0x3c, 0xa9, 0x12, 0xae,
      0x89, 0xf1, 0x0a, 0x0d, 0xb8, 0x67, 0xe6, 0x1e, 0x79, 0x46, 0x05, 0x71,
      0x62, 0x25, 0x9f, 0x91, 0x05, 0xcc, 0x13, 0xba, 0x8d, 0x51, 0x25, 0xbc,
      0xb3, 0xc4, 0x9d, 0xdc, 0xed, 0x4f, 0xfa, 0x83, 0x34, 0x14, 0xb5, 0xf2,
      0x1d, 0x1e, 0x84, 0x46},
     {},
     priv_key_2,
     false},

    // Comment: seed is all 0
    // tcID: 20
    {SEC_OID_SHA384,
     CKG_MGF1_SHA1,
     20,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x8d, 0x86, 0xdc, 0x41, 0x48, 0xc4, 0xcd, 0xb2, 0xfc, 0x0f, 0xa7, 0xa9,
      0x2f, 0x48, 0xa1, 0xef, 0xd3, 0x38, 0x97, 0xa2, 0x30, 0x6f, 0x00, 0x2a,
      0xa3, 0x9b, 0xa3, 0x38, 0xcd, 0x20, 0xc4, 0x4b, 0xee, 0x1d, 0xfe, 0x7d,
      0xb0, 0x50, 0x14, 0x5d, 0x9d, 0xee, 0xba, 0xcf, 0x29, 0x6c, 0xfa, 0x65,
      0x1f, 0x5e, 0x2e, 0x0f, 0x1a, 0x2b, 0x9e, 0x09, 0xdf, 0x5d, 0x11, 0xdd,
      0x56, 0x4e, 0x28, 0x95, 0xf6, 0x4c, 0x35, 0x9c, 0x59, 0x0c, 0xe0, 0xf4,
      0x00, 0xdd, 0x77, 0x4f, 0x67, 0xc2, 0xe1, 0xee, 0x17, 0x8c, 0x0e, 0x51,
      0x27, 0xec, 0x30, 0xa2, 0x15, 0x4f, 0x74, 0xb4, 0xb7, 0x5b, 0x7f, 0x37,
      0x88, 0xe5, 0x1b, 0xfc, 0x6a, 0x54, 0x39, 0x7f, 0x28, 0xe8, 0x85, 0x87,
      0xff, 0xea, 0x82, 0x5e, 0xfd, 0x6c, 0xd1, 0xe5, 0xb6, 0xaa, 0x14, 0x64,
      0xcb, 0xd5, 0xee, 0x1a, 0xad, 0x24, 0xcf, 0xb8, 0x64, 0x46, 0x68, 0x7e,
      0x58, 0xa2, 0xe9, 0x60, 0x4f, 0x05, 0xa4, 0x0c, 0x23, 0x7b, 0xb9, 0x43,
      0x00, 0x67, 0x7c, 0xb6, 0x5a, 0x70, 0x50, 0x55, 0x81, 0xaf, 0x2f, 0xe5,
      0x1e, 0x0d, 0x7d, 0x82, 0xa0, 0x86, 0x29, 0xdb, 0x04, 0x99, 0xfb, 0x1d,
      0x36, 0x0f, 0x1f, 0x1a, 0x9a, 0xff, 0xbd, 0x75, 0x57, 0x9b, 0x98, 0xd6,
      0xd9, 0x76, 0xeb, 0xe2, 0xe4, 0x07, 0xda, 0x91, 0x21, 0xcf, 0xb3, 0xa8,
      0xb8, 0x84, 0x72, 0xfb, 0x86, 0x8d, 0x82, 0x88, 0x1b, 0xe8, 0x7c, 0xee,
      0x4d, 0x23, 0xc5, 0x8a, 0x27, 0xb3, 0x70, 0x7f, 0x27, 0x71, 0xdd, 0xa0,
      0x80, 0x0f, 0xf2, 0x69, 0x96, 0x8b, 0xf5, 0x39, 0x3a, 0x5d, 0x8c, 0x83,
      0xd5, 0xd4, 0x23, 0x5c, 0xc1, 0xea, 0xa8, 0xc9, 0xdb, 0x34, 0x2b, 0x29,
      0x29, 0xad, 0x0e, 0xd8, 0x63, 0x80, 0x44, 0x91, 0x5e, 0xfc, 0xec, 0xc5,
      0x07, 0xf6, 0x63, 0x50},
     {},
     priv_key_2,
     true},

    // Comment: seed is all 1
    // tcID: 21
    {SEC_OID_SHA384,
     CKG_MGF1_SHA1,
     21,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x3e, 0x97, 0x0d, 0xed, 0x41, 0x1d, 0xc9, 0xed, 0x2a, 0x18, 0xce, 0xad,
      0xbb, 0xd9, 0xd5, 0x47, 0x02, 0x09, 0xc1, 0xdf, 0xba, 0x22, 0xe7, 0xcc,
      0x32, 0x87, 0xdd, 0xcf, 0x10, 0xca, 0x0c, 0x28, 0xfe, 0xc6, 0xca, 0xd6,
      0x22, 0x27, 0xa1, 0x56, 0xa5, 0xee, 0x20, 0x66, 0xa9, 0x95, 0xab, 0x28,
      0xa1, 0x21, 0xca, 0x75, 0x99, 0x99, 0x2a, 0xbf, 0xb7, 0x5d, 0xbe, 0x98,
      0x7a, 0x4c, 0x19, 0x0b, 0x1c, 0x58, 0xaf, 0x8b, 0x13, 0xb1, 0x1e, 0xd2,
      0x47, 0x24, 0xba, 0x41, 0xe4, 0xa4, 0x84, 0xfb, 0x35, 0xa3, 0x89, 0x41,
      0xc6, 0x83, 0x8e, 0x40, 0x45, 0xfa, 0x8a, 0x04, 0x8e, 0xa3, 0xef, 0xb4,
      0x60, 0xb0, 0x1f, 0xb2, 0xd1, 0x1a, 0xab, 0xce, 0xdf, 0x4f, 0xf2, 0xdb,
      0x5e, 0x88, 0x91, 0x45, 0xbb, 0x2d, 0x72, 0x9c, 0x84, 0x56, 0xe5, 0x1f,
      0x29, 0x60, 0x8e, 0xb5, 0xaa, 0x65, 0xa1, 0x90, 0x8f, 0xb9, 0x4b, 0xeb,
      0x6c, 0x2a, 0x89, 0x77, 0x8a, 0x1f, 0x23, 0x89, 0x82, 0x1f, 0x15, 0xf8,
      0x18, 0x86, 0x5e, 0x38, 0x56, 0x8e, 0xea, 0x9a, 0xee, 0xba, 0x03, 0x66,
      0x19, 0x83, 0x79, 0xb1, 0x37, 0x23, 0xc6, 0xc3, 0x77, 0x45, 0xb7, 0xff,
      0x7e, 0x4f, 0x71, 0x64, 0xaf, 0xa5, 0x39, 0x40, 0x83, 0x59, 0x2e, 0x7d,
      0x10, 0x2f, 0xfa, 0x72, 0xa5, 0xae, 0x6b, 0x3d, 0xa8, 0xd9, 0x2b, 0x59,
      0x77, 0xfd, 0xef, 0x3a, 0x64, 0x49, 0x69, 0x6c, 0x9e, 0x5c, 0xd2, 0x02,
      0x4a, 0x9f, 0x79, 0x5e, 0x81, 0x63, 0x3c, 0x24, 0x3d, 0xb6, 0xe7, 0x4e,
      0x56, 0x6c, 0xc6, 0x8e, 0xc4, 0x04, 0x3a, 0x89, 0xcf, 0x69, 0xe0, 0x20,
      0xed, 0x10, 0xb6, 0x59, 0x00, 0x82, 0xe1, 0xa2, 0x01, 0x53, 0x69, 0x02,
      0x9a, 0xaa, 0x67, 0x3a, 0x92, 0xf4, 0x4d, 0x6e, 0x62, 0x60, 0x46, 0x72,
      0x55, 0x9f, 0xd9, 0x33},
     {},
     priv_key_2,
     true},

    // Comment: First byte is 1
    // tcID: 22
    {SEC_OID_SHA384,
     CKG_MGF1_SHA1,
     22,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x73, 0x1e, 0xaf, 0xf9, 0xf5, 0x4c, 0xe7, 0x2b, 0x05, 0x72, 0xeb, 0x6c,
      0xf3, 0xd5, 0x86, 0xb8, 0x98, 0xdd, 0x9d, 0x96, 0xba, 0x82, 0x20, 0x2c,
      0x77, 0xa6, 0x3f, 0x1d, 0x98, 0x64, 0x29, 0x20, 0x79, 0x0e, 0x09, 0x2e,
      0xd5, 0xa3, 0x8a, 0xbf, 0xf5, 0x4b, 0x6d, 0x12, 0xd7, 0x98, 0x5e, 0xfd,
      0xe0, 0xec, 0x8b, 0x63, 0x21, 0xa5, 0xb8, 0x18, 0x3a, 0x80, 0xad, 0xf3,
      0xc6, 0x89, 0x72, 0xe9, 0x0f, 0x00, 0x27, 0x65, 0x4e, 0x2c, 0x58, 0x5e,
      0xeb, 0x99, 0xe5, 0xed, 0xd7, 0xa9, 0xb5, 0x6b, 0x65, 0x2a, 0xcc, 0x00,
      0x51, 0xb9, 0x55, 0x07, 0xb3, 0xda, 0xed, 0xbc, 0x6b, 0x00, 0x20, 0x3f,
      0x50, 0x55, 0x3f, 0x43, 0x2e, 0x61, 0x2a, 0xfa, 0x74, 0x05, 0x6d, 0x0f,
      0xae, 0x70, 0x21, 0x15, 0x9e, 0xd9, 0x54, 0x77, 0xfd, 0xc5, 0x71, 0x96,
      0x27, 0xc7, 0x7a, 0xf1, 0xef, 0x2b, 0x2e, 0xe3, 0xb8, 0x04, 0x8d, 0xa4,
      0xef, 0x6d, 0xdb, 0x16, 0x62, 0xe3, 0x5a, 0xa5, 0x60, 0xca, 0xc6, 0xcb,
      0x0b, 0xea, 0xa7, 0xd8, 0x11, 0xea, 0xb4, 0x99, 0x39, 0xb6, 0xdc, 0xd3,
      0xcd, 0xbd, 0x1f, 0x00, 0xbe, 0xb8, 0x75, 0xbb, 0x60, 0xfc, 0xdf, 0x2a,
      0x00, 0x6e, 0xde, 0xd6, 0xf4, 0x49, 0xba, 0xe3, 0x38, 0x90, 0x8a, 0x0f,
      0xe1, 0x81, 0x03, 0x5f, 0x14, 0xe6, 0xfe, 0xc4, 0xf1, 0x62, 0x74, 0x34,
      0x38, 0xae, 0x2d, 0x9b, 0xdc, 0xdc, 0xc4, 0x9c, 0x7c, 0xd7, 0x78, 0xe7,
      0x62, 0x45, 0x8b, 0xf2, 0x66, 0x9b, 0x35, 0xed, 0x3d, 0x49, 0x8a, 0xda,
      0x60, 0x41, 0x34, 0x2d, 0x12, 0x62, 0x7f, 0x14, 0xce, 0xbb, 0xab, 0x2c,
      0x55, 0xda, 0xf2, 0xb9, 0xe4, 0xe6, 0x45, 0x64, 0x1c, 0xe0, 0x79, 0x61,
      0xb3, 0x90, 0x61, 0xf4, 0x32, 0xb6, 0xab, 0x78, 0x7a, 0x17, 0x5f, 0x8e,
      0x68, 0xf2, 0xc9, 0x8b},
     {},
     priv_key_2,
     false},

    // Comment: m is 0
    // tcID: 23
    {SEC_OID_SHA384,
     CKG_MGF1_SHA1,
     23,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00},
     {},
     priv_key_2,
     false},

    // Comment: m is 1
    // tcID: 24
    {SEC_OID_SHA384,
     CKG_MGF1_SHA1,
     24,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x01},
     {},
     priv_key_2,
     false},

    // Comment: m is n-1
    // tcID: 25
    {SEC_OID_SHA384,
     CKG_MGF1_SHA1,
     25,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0xcd, 0xa6, 0xfa, 0x5c, 0xa7, 0x6b, 0xfe, 0x04, 0x92, 0xec, 0x57, 0xe0,
      0xa3, 0xbf, 0xff, 0x72, 0x72, 0xdc, 0x8d, 0x1e, 0x25, 0xad, 0x1f, 0xb3,
      0x38, 0xaa, 0x05, 0x0f, 0x02, 0xc1, 0x04, 0xe6, 0x31, 0x33, 0xd6, 0xb5,
      0xb7, 0xc4, 0x98, 0x5e, 0xbb, 0xae, 0x9a, 0xc0, 0x36, 0xa5, 0xb9, 0xc0,
      0x30, 0x74, 0xd6, 0x0a, 0xec, 0x8e, 0x25, 0xba, 0xf3, 0x92, 0xa0, 0xc4,
      0x30, 0xff, 0x05, 0xb8, 0x8e, 0x94, 0x88, 0x05, 0xd3, 0xdd, 0x74, 0x51,
      0x1d, 0x88, 0x85, 0x25, 0x0a, 0x7b, 0x57, 0x42, 0x15, 0xad, 0xa0, 0x15,
      0xc5, 0x59, 0x07, 0x66, 0x86, 0xe2, 0x53, 0xcc, 0xc9, 0x6c, 0x08, 0x15,
      0xb1, 0x29, 0x1e, 0xe7, 0x87, 0xcc, 0x33, 0x63, 0xb4, 0xf7, 0x7d, 0x93,
      0x0e, 0xb9, 0x98, 0xd7, 0xc5, 0x82, 0xb2, 0x4c, 0xea, 0x9c, 0xe2, 0x1d,
      0xe9, 0x72, 0x27, 0x91, 0x98, 0x98, 0x63, 0xa2, 0x7e, 0xbc, 0x80, 0xa0,
      0x0d, 0xe5, 0xbd, 0x2f, 0x92, 0x28, 0x77, 0x5e, 0x5a, 0x4c, 0xeb, 0x05,
      0x4d, 0x58, 0xc9, 0xbe, 0x36, 0xa0, 0x54, 0x33, 0x69, 0x71, 0xa1, 0x36,
      0x42, 0xdd, 0x95, 0x10, 0xdd, 0x69, 0x6a, 0xa2, 0x68, 0xdb, 0x3a, 0xab,
      0x22, 0x99, 0xd5, 0xd8, 0x8f, 0x8e, 0x56, 0x24, 0x34, 0xd1, 0x42, 0x70,
      0x94, 0xd3, 0xdf, 0x8e, 0x72, 0xd1, 0xef, 0x69, 0xb4, 0xed, 0x34, 0xd1,
      0x2b, 0xac, 0x37, 0x52, 0x23, 0xb2, 0xa2, 0x5c, 0xf2, 0x27, 0xf7, 0x35,
      0xf8, 0x16, 0xe8, 0x5e, 0x17, 0x23, 0x93, 0x04, 0x76, 0x9a, 0x60, 0x82,
      0x15, 0x4c, 0xd1, 0x58, 0x99, 0xfc, 0x1e, 0xae, 0xfb, 0x69, 0xb7, 0x48,
      0xa3, 0xe5, 0xed, 0x24, 0xd3, 0x83, 0x72, 0x59, 0x7d, 0xe3, 0xe4, 0xe2,
      0xa2, 0x7b, 0x95, 0x1d, 0x6a, 0xc7, 0xdb, 0x18, 0x2d, 0x68, 0x09, 0xd8,
      0xff, 0x51, 0x1b, 0x7e},
     {},
     priv_key_2,
     false},

    // Comment: ciphertext is empty
    // tcID: 26
    {SEC_OID_SHA384,
     CKG_MGF1_SHA1,
     26,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {},
     {},
     priv_key_2,
     false},

    // Comment: prepended bytes to ciphertext
    // tcID: 27
    {SEC_OID_SHA384,
     CKG_MGF1_SHA1,
     27,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x00, 0x00, 0x58, 0x14, 0xd6, 0xf2, 0xf3, 0xb2, 0x35, 0x45, 0xe0, 0x05,
      0xa4, 0xf7, 0x2e, 0xb0, 0xef, 0x65, 0x9f, 0xc0, 0x7a, 0x83, 0x74, 0x78,
      0x0f, 0x8e, 0xb9, 0x22, 0x3d, 0xad, 0x41, 0x7b, 0xff, 0x6c, 0x96, 0xa9,
      0x1c, 0x60, 0x71, 0xab, 0xd6, 0x78, 0xa8, 0xc9, 0xcb, 0xf0, 0xb4, 0x73,
      0x5e, 0x4c, 0x22, 0x5e, 0x98, 0x46, 0x69, 0x22, 0x4e, 0x88, 0x65, 0x5d,
      0xd4, 0xf0, 0x5a, 0xdf, 0x1c, 0xb1, 0xae, 0x96, 0xf7, 0xdc, 0x79, 0x32,
      0xa0, 0xb3, 0x87, 0x15, 0x8a, 0x91, 0x5f, 0x75, 0x63, 0x08, 0x5f, 0x44,
      0xc7, 0x2a, 0x41, 0xf3, 0x31, 0xe0, 0xe1, 0x7e, 0x68, 0x95, 0xe4, 0x42,
      0xf7, 0x49, 0x21, 0x51, 0x39, 0x71, 0x59, 0x63, 0x79, 0x68, 0xb1, 0x58,
      0x88, 0xf8, 0x51, 0x32, 0x31, 0x07, 0xbf, 0xdc, 0x1c, 0xd4, 0x19, 0xd6,
      0xad, 0xe5, 0x6b, 0x97, 0x4a, 0xff, 0x86, 0x5d, 0x58, 0x23, 0xda, 0xad,
      0x3d, 0x0c, 0xd8, 0xb1, 0xa9, 0x4e, 0xe1, 0x76, 0x7b, 0x70, 0xfe, 0x47,
      0x7c, 0x64, 0xa5, 0xbf, 0xa5, 0x93, 0x78, 0x3a, 0xa9, 0x08, 0x68, 0xd4,
      0x45, 0x6f, 0x09, 0x86, 0x30, 0xeb, 0x32, 0xae, 0x71, 0xad, 0x49, 0x14,
      0xc1, 0x42, 0xc8, 0x05, 0xa6, 0x9d, 0x2f, 0xd0, 0xe9, 0x35, 0x63, 0xfe,
      0xca, 0x56, 0x7e, 0xd9, 0x22, 0x51, 0x4c, 0x0c, 0x88, 0x67, 0x33, 0x2c,
      0x05, 0x3d, 0x49, 0x12, 0xcd, 0x17, 0xd2, 0x38, 0xeb, 0x46, 0x24, 0x5f,
      0xbe, 0xb0, 0x34, 0x39, 0xc6, 0xe6, 0xad, 0xc1, 0xca, 0xc0, 0x6d, 0x1e,
      0xb4, 0x1d, 0x9a, 0x18, 0x50, 0x57, 0x43, 0x1b, 0x25, 0xd4, 0x60, 0x06,
      0x84, 0xe0, 0x57, 0xe5, 0x71, 0xdf, 0xd1, 0xa5, 0x73, 0xdc, 0x60, 0x39,
      0x5e, 0x7c, 0x2e, 0x3d, 0x61, 0x2f, 0x9f, 0x66, 0x47, 0x2f, 0x4d, 0xff,
      0x28, 0x4f, 0x4c, 0xad, 0x4e, 0x6a},
     {},
     priv_key_2,
     false},

    // Comment: appended bytes to ciphertext
    // tcID: 28
    {SEC_OID_SHA384,
     CKG_MGF1_SHA1,
     28,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x58, 0x14, 0xd6, 0xf2, 0xf3, 0xb2, 0x35, 0x45, 0xe0, 0x05, 0xa4, 0xf7,
      0x2e, 0xb0, 0xef, 0x65, 0x9f, 0xc0, 0x7a, 0x83, 0x74, 0x78, 0x0f, 0x8e,
      0xb9, 0x22, 0x3d, 0xad, 0x41, 0x7b, 0xff, 0x6c, 0x96, 0xa9, 0x1c, 0x60,
      0x71, 0xab, 0xd6, 0x78, 0xa8, 0xc9, 0xcb, 0xf0, 0xb4, 0x73, 0x5e, 0x4c,
      0x22, 0x5e, 0x98, 0x46, 0x69, 0x22, 0x4e, 0x88, 0x65, 0x5d, 0xd4, 0xf0,
      0x5a, 0xdf, 0x1c, 0xb1, 0xae, 0x96, 0xf7, 0xdc, 0x79, 0x32, 0xa0, 0xb3,
      0x87, 0x15, 0x8a, 0x91, 0x5f, 0x75, 0x63, 0x08, 0x5f, 0x44, 0xc7, 0x2a,
      0x41, 0xf3, 0x31, 0xe0, 0xe1, 0x7e, 0x68, 0x95, 0xe4, 0x42, 0xf7, 0x49,
      0x21, 0x51, 0x39, 0x71, 0x59, 0x63, 0x79, 0x68, 0xb1, 0x58, 0x88, 0xf8,
      0x51, 0x32, 0x31, 0x07, 0xbf, 0xdc, 0x1c, 0xd4, 0x19, 0xd6, 0xad, 0xe5,
      0x6b, 0x97, 0x4a, 0xff, 0x86, 0x5d, 0x58, 0x23, 0xda, 0xad, 0x3d, 0x0c,
      0xd8, 0xb1, 0xa9, 0x4e, 0xe1, 0x76, 0x7b, 0x70, 0xfe, 0x47, 0x7c, 0x64,
      0xa5, 0xbf, 0xa5, 0x93, 0x78, 0x3a, 0xa9, 0x08, 0x68, 0xd4, 0x45, 0x6f,
      0x09, 0x86, 0x30, 0xeb, 0x32, 0xae, 0x71, 0xad, 0x49, 0x14, 0xc1, 0x42,
      0xc8, 0x05, 0xa6, 0x9d, 0x2f, 0xd0, 0xe9, 0x35, 0x63, 0xfe, 0xca, 0x56,
      0x7e, 0xd9, 0x22, 0x51, 0x4c, 0x0c, 0x88, 0x67, 0x33, 0x2c, 0x05, 0x3d,
      0x49, 0x12, 0xcd, 0x17, 0xd2, 0x38, 0xeb, 0x46, 0x24, 0x5f, 0xbe, 0xb0,
      0x34, 0x39, 0xc6, 0xe6, 0xad, 0xc1, 0xca, 0xc0, 0x6d, 0x1e, 0xb4, 0x1d,
      0x9a, 0x18, 0x50, 0x57, 0x43, 0x1b, 0x25, 0xd4, 0x60, 0x06, 0x84, 0xe0,
      0x57, 0xe5, 0x71, 0xdf, 0xd1, 0xa5, 0x73, 0xdc, 0x60, 0x39, 0x5e, 0x7c,
      0x2e, 0x3d, 0x61, 0x2f, 0x9f, 0x66, 0x47, 0x2f, 0x4d, 0xff, 0x28, 0x4f,
      0x4c, 0xad, 0x4e, 0x6a, 0x00, 0x00},
     {},
     priv_key_2,
     false},

    // Comment: truncated ciphertext
    // tcID: 29
    {SEC_OID_SHA384,
     CKG_MGF1_SHA1,
     29,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x14, 0xd6, 0xf2, 0xf3, 0xb2, 0x35, 0x45, 0xe0, 0x05, 0xa4, 0xf7, 0x2e,
      0xb0, 0xef, 0x65, 0x9f, 0xc0, 0x7a, 0x83, 0x74, 0x78, 0x0f, 0x8e, 0xb9,
      0x22, 0x3d, 0xad, 0x41, 0x7b, 0xff, 0x6c, 0x96, 0xa9, 0x1c, 0x60, 0x71,
      0xab, 0xd6, 0x78, 0xa8, 0xc9, 0xcb, 0xf0, 0xb4, 0x73, 0x5e, 0x4c, 0x22,
      0x5e, 0x98, 0x46, 0x69, 0x22, 0x4e, 0x88, 0x65, 0x5d, 0xd4, 0xf0, 0x5a,
      0xdf, 0x1c, 0xb1, 0xae, 0x96, 0xf7, 0xdc, 0x79, 0x32, 0xa0, 0xb3, 0x87,
      0x15, 0x8a, 0x91, 0x5f, 0x75, 0x63, 0x08, 0x5f, 0x44, 0xc7, 0x2a, 0x41,
      0xf3, 0x31, 0xe0, 0xe1, 0x7e, 0x68, 0x95, 0xe4, 0x42, 0xf7, 0x49, 0x21,
      0x51, 0x39, 0x71, 0x59, 0x63, 0x79, 0x68, 0xb1, 0x58, 0x88, 0xf8, 0x51,
      0x32, 0x31, 0x07, 0xbf, 0xdc, 0x1c, 0xd4, 0x19, 0xd6, 0xad, 0xe5, 0x6b,
      0x97, 0x4a, 0xff, 0x86, 0x5d, 0x58, 0x23, 0xda, 0xad, 0x3d, 0x0c, 0xd8,
      0xb1, 0xa9, 0x4e, 0xe1, 0x76, 0x7b, 0x70, 0xfe, 0x47, 0x7c, 0x64, 0xa5,
      0xbf, 0xa5, 0x93, 0x78, 0x3a, 0xa9, 0x08, 0x68, 0xd4, 0x45, 0x6f, 0x09,
      0x86, 0x30, 0xeb, 0x32, 0xae, 0x71, 0xad, 0x49, 0x14, 0xc1, 0x42, 0xc8,
      0x05, 0xa6, 0x9d, 0x2f, 0xd0, 0xe9, 0x35, 0x63, 0xfe, 0xca, 0x56, 0x7e,
      0xd9, 0x22, 0x51, 0x4c, 0x0c, 0x88, 0x67, 0x33, 0x2c, 0x05, 0x3d, 0x49,
      0x12, 0xcd, 0x17, 0xd2, 0x38, 0xeb, 0x46, 0x24, 0x5f, 0xbe, 0xb0, 0x34,
      0x39, 0xc6, 0xe6, 0xad, 0xc1, 0xca, 0xc0, 0x6d, 0x1e, 0xb4, 0x1d, 0x9a,
      0x18, 0x50, 0x57, 0x43, 0x1b, 0x25, 0xd4, 0x60, 0x06, 0x84, 0xe0, 0x57,
      0xe5, 0x71, 0xdf, 0xd1, 0xa5, 0x73, 0xdc, 0x60, 0x39, 0x5e, 0x7c, 0x2e,
      0x3d, 0x61, 0x2f, 0x9f, 0x66, 0x47, 0x2f, 0x4d, 0xff, 0x28, 0x4f, 0x4c,
      0xad, 0x4e, 0x6a},
     {},
     priv_key_2,
     false}};

#endif  // rsa_oaep_2048_sha384_mgf1sha1_vectors_h__
