macro(ensure_link_version projectFile expected)
  if(NOT EXISTS "${projectFile}")
    set(RunCMake_TEST_FAILED "Project file ${projectFile} does not exist.")
    return()
  endif()

  file(STRINGS "${projectFile}" lines)
  set(version "")
  foreach(line IN LISTS lines)
    if(line MATCHES "<Link>")
      set(in_link TRUE)
    elseif(line MATCHES "</Link>")
      if(NOT version STREQUAL "${expected}")
        set(RunCMake_TEST_FAILED "<Version> not found or incorrect: ${version} vs ${expected}")
        return()
      endif()
      set(in_link FALSE)
      set(version "")
    elseif(in_link AND line MATCHES "<Version>([^<]+)</Version>")
      set(version ${CMAKE_MATCH_1})
    endif()
  endforeach()
endmacro()

ensure_link_version("${RunCMake_TEST_BINARY_DIR}/app-C.vcxproj" 0.1)
ensure_link_version("${RunCMake_TEST_BINARY_DIR}/app-CXX.vcxproj" 1.0)
ensure_link_version("${RunCMake_TEST_BINARY_DIR}/lib-C.vcxproj" 65535.65535)
ensure_link_version("${RunCMake_TEST_BINARY_DIR}/lib-CXX.vcxproj" "")
