/*
 * Decompiled with CFR 0.152.
 */
package com.robotium.solo;

import android.widget.CheckedTextView;
import android.widget.CompoundButton;
import android.widget.Spinner;
import android.widget.TextView;
import com.robotium.solo.Timeout;
import com.robotium.solo.ViewFetcher;
import com.robotium.solo.Waiter;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Checker {
    private final ViewFetcher viewFetcher;
    private final Waiter waiter;

    public Checker(ViewFetcher viewFetcher, Waiter waiter) {
        this.viewFetcher = viewFetcher;
        this.waiter = waiter;
    }

    public <T extends CompoundButton> boolean isButtonChecked(Class<T> expectedClass, int index) {
        return ((CompoundButton)this.waiter.waitForAndGetView(index, expectedClass)).isChecked();
    }

    public <T extends CompoundButton> boolean isButtonChecked(Class<T> expectedClass, String text) {
        CompoundButton button = (CompoundButton)this.waiter.waitForText(expectedClass, text, 0, Timeout.getSmallTimeout(), true);
        return button != null && button.isChecked();
    }

    public boolean isCheckedTextChecked(String text) {
        CheckedTextView checkedTextView = this.waiter.waitForText(CheckedTextView.class, text, 0, Timeout.getSmallTimeout(), true);
        return checkedTextView != null && checkedTextView.isChecked();
    }

    public boolean isSpinnerTextSelected(String text) {
        this.waiter.waitForAndGetView(0, Spinner.class);
        ArrayList<Spinner> spinnerList = this.viewFetcher.getCurrentViews(Spinner.class, true);
        for (int i = 0; i < spinnerList.size(); ++i) {
            if (!this.isSpinnerTextSelected(i, text)) continue;
            return true;
        }
        return false;
    }

    public boolean isSpinnerTextSelected(int spinnerIndex, String text) {
        Spinner spinner = this.waiter.waitForAndGetView(spinnerIndex, Spinner.class);
        TextView textView = (TextView)spinner.getChildAt(0);
        return textView.getText().equals(text);
    }
}

