; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefixes=SSE,SSE2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+ssse3 | FileCheck %s --check-prefixes=SSE,SSSE3
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse4.1 | FileCheck %s --check-prefixes=SSE,SSE41
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefixes=AVX,AVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefixes=AVX,AVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bw,+avx512vl,+fast-variable-shuffle | FileCheck %s --check-prefixes=AVX,AVX512

declare <1 x i8> @llvm.uadd.sat.v1i8(<1 x i8>, <1 x i8>)
declare <2 x i8> @llvm.uadd.sat.v2i8(<2 x i8>, <2 x i8>)
declare <4 x i8> @llvm.uadd.sat.v4i8(<4 x i8>, <4 x i8>)
declare <8 x i8> @llvm.uadd.sat.v8i8(<8 x i8>, <8 x i8>)
declare <12 x i8> @llvm.uadd.sat.v12i8(<12 x i8>, <12 x i8>)
declare <16 x i8> @llvm.uadd.sat.v16i8(<16 x i8>, <16 x i8>)
declare <32 x i8> @llvm.uadd.sat.v32i8(<32 x i8>, <32 x i8>)
declare <64 x i8> @llvm.uadd.sat.v64i8(<64 x i8>, <64 x i8>)

declare <1 x i16> @llvm.uadd.sat.v1i16(<1 x i16>, <1 x i16>)
declare <2 x i16> @llvm.uadd.sat.v2i16(<2 x i16>, <2 x i16>)
declare <4 x i16> @llvm.uadd.sat.v4i16(<4 x i16>, <4 x i16>)
declare <8 x i16> @llvm.uadd.sat.v8i16(<8 x i16>, <8 x i16>)
declare <12 x i16> @llvm.uadd.sat.v12i16(<12 x i16>, <12 x i16>)
declare <16 x i16> @llvm.uadd.sat.v16i16(<16 x i16>, <16 x i16>)
declare <32 x i16> @llvm.uadd.sat.v32i16(<32 x i16>, <32 x i16>)

declare <16 x i1> @llvm.uadd.sat.v16i1(<16 x i1>, <16 x i1>)
declare <16 x i4> @llvm.uadd.sat.v16i4(<16 x i4>, <16 x i4>)

declare <4 x i32> @llvm.uadd.sat.v4i32(<4 x i32>, <4 x i32>)
declare <2 x i32> @llvm.uadd.sat.v2i32(<2 x i32>, <2 x i32>)
declare <4 x i24> @llvm.uadd.sat.v4i24(<4 x i24>, <4 x i24>)
declare <2 x i128> @llvm.uadd.sat.v2i128(<2 x i128>, <2 x i128>)

; Legal types, depending on architecture.

define <16 x i8> @v16i8(<16 x i8> %x, <16 x i8> %y) nounwind {
; SSE-LABEL: v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    paddusb %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: v16i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddusb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %z = call <16 x i8> @llvm.uadd.sat.v16i8(<16 x i8> %x, <16 x i8> %y)
  ret <16 x i8> %z
}

define <32 x i8> @v32i8(<32 x i8> %x, <32 x i8> %y) nounwind {
; SSE-LABEL: v32i8:
; SSE:       # %bb.0:
; SSE-NEXT:    paddusb %xmm2, %xmm0
; SSE-NEXT:    paddusb %xmm3, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpaddusb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpaddusb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddusb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v32i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddusb %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
  %z = call <32 x i8> @llvm.uadd.sat.v32i8(<32 x i8> %x, <32 x i8> %y)
  ret <32 x i8> %z
}

define <64 x i8> @v64i8(<64 x i8> %x, <64 x i8> %y) nounwind {
; SSE-LABEL: v64i8:
; SSE:       # %bb.0:
; SSE-NEXT:    paddusb %xmm4, %xmm0
; SSE-NEXT:    paddusb %xmm5, %xmm1
; SSE-NEXT:    paddusb %xmm6, %xmm2
; SSE-NEXT:    paddusb %xmm7, %xmm3
; SSE-NEXT:    retq
;
; AVX1-LABEL: v64i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm5
; AVX1-NEXT:    vpaddusb %xmm4, %xmm5, %xmm4
; AVX1-NEXT:    vpaddusb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm4
; AVX1-NEXT:    vpaddusb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpaddusb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v64i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddusb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddusb %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v64i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddusb %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq
  %z = call <64 x i8> @llvm.uadd.sat.v64i8(<64 x i8> %x, <64 x i8> %y)
  ret <64 x i8> %z
}

define <8 x i16> @v8i16(<8 x i16> %x, <8 x i16> %y) nounwind {
; SSE-LABEL: v8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    paddusw %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: v8i16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddusw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %z = call <8 x i16> @llvm.uadd.sat.v8i16(<8 x i16> %x, <8 x i16> %y)
  ret <8 x i16> %z
}

define <16 x i16> @v16i16(<16 x i16> %x, <16 x i16> %y) nounwind {
; SSE-LABEL: v16i16:
; SSE:       # %bb.0:
; SSE-NEXT:    paddusw %xmm2, %xmm0
; SSE-NEXT:    paddusw %xmm3, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpaddusw %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpaddusw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddusw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v16i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddusw %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
  %z = call <16 x i16> @llvm.uadd.sat.v16i16(<16 x i16> %x, <16 x i16> %y)
  ret <16 x i16> %z
}

define <32 x i16> @v32i16(<32 x i16> %x, <32 x i16> %y) nounwind {
; SSE-LABEL: v32i16:
; SSE:       # %bb.0:
; SSE-NEXT:    paddusw %xmm4, %xmm0
; SSE-NEXT:    paddusw %xmm5, %xmm1
; SSE-NEXT:    paddusw %xmm6, %xmm2
; SSE-NEXT:    paddusw %xmm7, %xmm3
; SSE-NEXT:    retq
;
; AVX1-LABEL: v32i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm5
; AVX1-NEXT:    vpaddusw %xmm4, %xmm5, %xmm4
; AVX1-NEXT:    vpaddusw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm4
; AVX1-NEXT:    vpaddusw %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpaddusw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v32i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddusw %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddusw %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v32i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddusw %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq
  %z = call <32 x i16> @llvm.uadd.sat.v32i16(<32 x i16> %x, <32 x i16> %y)
  ret <32 x i16> %z
}

; Too narrow vectors, legalized by widening.

define void @v8i8(<8 x i8>* %px, <8 x i8>* %py, <8 x i8>* %pz) nounwind {
; SSE-LABEL: v8i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; SSE-NEXT:    paddusb %xmm0, %xmm1
; SSE-NEXT:    movq %xmm1, (%rdx)
; SSE-NEXT:    retq
;
; AVX1-LABEL: v8i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX1-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX1-NEXT:    vpaddusb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vmovq %xmm0, (%rdx)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v8i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX2-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-NEXT:    vpaddusb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vmovq %xmm0, (%rdx)
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v8i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512-NEXT:    vpaddusb %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vpmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX512-NEXT:    vpmovwb %xmm0, (%rdx)
; AVX512-NEXT:    retq
  %x = load <8 x i8>, <8 x i8>* %px
  %y = load <8 x i8>, <8 x i8>* %py
  %z = call <8 x i8> @llvm.uadd.sat.v8i8(<8 x i8> %x, <8 x i8> %y)
  store <8 x i8> %z, <8 x i8>* %pz
  ret void
}

define void @v4i8(<4 x i8>* %px, <4 x i8>* %py, <4 x i8>* %pz) nounwind {
; SSE-LABEL: v4i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE-NEXT:    movd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE-NEXT:    paddusb %xmm0, %xmm1
; SSE-NEXT:    movd %xmm1, (%rdx)
; SSE-NEXT:    retq
;
; AVX1-LABEL: v4i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX1-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX1-NEXT:    vpaddusb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vmovd %xmm0, (%rdx)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v4i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX2-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX2-NEXT:    vpaddusb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vmovd %xmm0, (%rdx)
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v4i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX512-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX512-NEXT:    vpaddusb %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vpmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; AVX512-NEXT:    vpmovdb %xmm0, (%rdx)
; AVX512-NEXT:    retq
  %x = load <4 x i8>, <4 x i8>* %px
  %y = load <4 x i8>, <4 x i8>* %py
  %z = call <4 x i8> @llvm.uadd.sat.v4i8(<4 x i8> %x, <4 x i8> %y)
  store <4 x i8> %z, <4 x i8>* %pz
  ret void
}

define void @v2i8(<2 x i8>* %px, <2 x i8>* %py, <2 x i8>* %pz) nounwind {
; SSE2-LABEL: v2i8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movzwl (%rdi), %eax
; SSE2-NEXT:    movd %eax, %xmm0
; SSE2-NEXT:    movzwl (%rsi), %eax
; SSE2-NEXT:    movd %eax, %xmm1
; SSE2-NEXT:    paddusb %xmm0, %xmm1
; SSE2-NEXT:    movd %xmm1, %eax
; SSE2-NEXT:    movw %ax, (%rdx)
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: v2i8:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movzwl (%rdi), %eax
; SSSE3-NEXT:    movd %eax, %xmm0
; SSSE3-NEXT:    movzwl (%rsi), %eax
; SSSE3-NEXT:    movd %eax, %xmm1
; SSSE3-NEXT:    paddusb %xmm0, %xmm1
; SSSE3-NEXT:    movd %xmm1, %eax
; SSSE3-NEXT:    movw %ax, (%rdx)
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: v2i8:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movzwl (%rdi), %eax
; SSE41-NEXT:    movd %eax, %xmm0
; SSE41-NEXT:    movzwl (%rsi), %eax
; SSE41-NEXT:    movd %eax, %xmm1
; SSE41-NEXT:    paddusb %xmm0, %xmm1
; SSE41-NEXT:    pextrw $0, %xmm1, (%rdx)
; SSE41-NEXT:    retq
;
; AVX1-LABEL: v2i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    movzwl (%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm0
; AVX1-NEXT:    movzwl (%rsi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm1
; AVX1-NEXT:    vpaddusb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpextrw $0, %xmm0, (%rdx)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v2i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    movzwl (%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm0
; AVX2-NEXT:    movzwl (%rsi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm1
; AVX2-NEXT:    vpaddusb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpextrw $0, %xmm0, (%rdx)
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v2i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movzwl (%rdi), %eax
; AVX512-NEXT:    vmovd %eax, %xmm0
; AVX512-NEXT:    movzwl (%rsi), %eax
; AVX512-NEXT:    vmovd %eax, %xmm1
; AVX512-NEXT:    vpaddusb %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vpmovzxbq {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,zero,zero,zero,zero,xmm0[1],zero,zero,zero,zero,zero,zero,zero
; AVX512-NEXT:    vpmovqb %xmm0, (%rdx)
; AVX512-NEXT:    retq
  %x = load <2 x i8>, <2 x i8>* %px
  %y = load <2 x i8>, <2 x i8>* %py
  %z = call <2 x i8> @llvm.uadd.sat.v2i8(<2 x i8> %x, <2 x i8> %y)
  store <2 x i8> %z, <2 x i8>* %pz
  ret void
}

define void @v4i16(<4 x i16>* %px, <4 x i16>* %py, <4 x i16>* %pz) nounwind {
; SSE-LABEL: v4i16:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; SSE-NEXT:    paddusw %xmm0, %xmm1
; SSE-NEXT:    movq %xmm1, (%rdx)
; SSE-NEXT:    retq
;
; AVX1-LABEL: v4i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX1-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX1-NEXT:    vpaddusw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vmovq %xmm0, (%rdx)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v4i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX2-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-NEXT:    vpaddusw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vmovq %xmm0, (%rdx)
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v4i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512-NEXT:    vpaddusw %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vpmovzxwd {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; AVX512-NEXT:    vpmovdw %xmm0, (%rdx)
; AVX512-NEXT:    retq
  %x = load <4 x i16>, <4 x i16>* %px
  %y = load <4 x i16>, <4 x i16>* %py
  %z = call <4 x i16> @llvm.uadd.sat.v4i16(<4 x i16> %x, <4 x i16> %y)
  store <4 x i16> %z, <4 x i16>* %pz
  ret void
}

define void @v2i16(<2 x i16>* %px, <2 x i16>* %py, <2 x i16>* %pz) nounwind {
; SSE-LABEL: v2i16:
; SSE:       # %bb.0:
; SSE-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE-NEXT:    movd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE-NEXT:    paddusw %xmm0, %xmm1
; SSE-NEXT:    movd %xmm1, (%rdx)
; SSE-NEXT:    retq
;
; AVX1-LABEL: v2i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX1-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX1-NEXT:    vpaddusw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vmovd %xmm0, (%rdx)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v2i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX2-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX2-NEXT:    vpaddusw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vmovd %xmm0, (%rdx)
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v2i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX512-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX512-NEXT:    vpaddusw %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vpmovzxwq {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero
; AVX512-NEXT:    vpmovqw %xmm0, (%rdx)
; AVX512-NEXT:    retq
  %x = load <2 x i16>, <2 x i16>* %px
  %y = load <2 x i16>, <2 x i16>* %py
  %z = call <2 x i16> @llvm.uadd.sat.v2i16(<2 x i16> %x, <2 x i16> %y)
  store <2 x i16> %z, <2 x i16>* %pz
  ret void
}

define <12 x i8> @v12i8(<12 x i8> %x, <12 x i8> %y) nounwind {
; SSE-LABEL: v12i8:
; SSE:       # %bb.0:
; SSE-NEXT:    paddusb %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: v12i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddusb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %z = call <12 x i8> @llvm.uadd.sat.v12i8(<12 x i8> %x, <12 x i8> %y)
  ret <12 x i8> %z
}

define void @v12i16(<12 x i16>* %px, <12 x i16>* %py, <12 x i16>* %pz) nounwind {
; SSE-LABEL: v12i16:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa (%rdi), %xmm0
; SSE-NEXT:    movdqa 16(%rdi), %xmm1
; SSE-NEXT:    paddusw (%rsi), %xmm0
; SSE-NEXT:    paddusw 16(%rsi), %xmm1
; SSE-NEXT:    movq %xmm1, 16(%rdx)
; SSE-NEXT:    movdqa %xmm0, (%rdx)
; SSE-NEXT:    retq
;
; AVX1-LABEL: v12i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX1-NEXT:    vpaddusw (%rsi), %xmm0, %xmm0
; AVX1-NEXT:    vpaddusw 16(%rsi), %xmm1, %xmm1
; AVX1-NEXT:    vmovq %xmm1, 16(%rdx)
; AVX1-NEXT:    vmovdqa %xmm0, (%rdx)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v12i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-NEXT:    vpaddusw (%rsi), %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vmovq %xmm1, 16(%rdx)
; AVX2-NEXT:    vmovdqa %xmm0, (%rdx)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v12i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512-NEXT:    vpaddusw (%rsi), %ymm0, %ymm0
; AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512-NEXT:    vmovq %xmm1, 16(%rdx)
; AVX512-NEXT:    vmovdqa %xmm0, (%rdx)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %x = load <12 x i16>, <12 x i16>* %px
  %y = load <12 x i16>, <12 x i16>* %py
  %z = call <12 x i16> @llvm.uadd.sat.v12i16(<12 x i16> %x, <12 x i16> %y)
  store <12 x i16> %z, <12 x i16>* %pz
  ret void
}

; Scalarization

define void @v1i8(<1 x i8>* %px, <1 x i8>* %py, <1 x i8>* %pz) nounwind {
; SSE-LABEL: v1i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movb (%rdi), %al
; SSE-NEXT:    addb (%rsi), %al
; SSE-NEXT:    movb $-1, %cl
; SSE-NEXT:    jb .LBB13_2
; SSE-NEXT:  # %bb.1:
; SSE-NEXT:    movl %eax, %ecx
; SSE-NEXT:  .LBB13_2:
; SSE-NEXT:    movb %cl, (%rdx)
; SSE-NEXT:    retq
;
; AVX-LABEL: v1i8:
; AVX:       # %bb.0:
; AVX-NEXT:    movb (%rdi), %al
; AVX-NEXT:    addb (%rsi), %al
; AVX-NEXT:    movb $-1, %cl
; AVX-NEXT:    jb .LBB13_2
; AVX-NEXT:  # %bb.1:
; AVX-NEXT:    movl %eax, %ecx
; AVX-NEXT:  .LBB13_2:
; AVX-NEXT:    movb %cl, (%rdx)
; AVX-NEXT:    retq
  %x = load <1 x i8>, <1 x i8>* %px
  %y = load <1 x i8>, <1 x i8>* %py
  %z = call <1 x i8> @llvm.uadd.sat.v1i8(<1 x i8> %x, <1 x i8> %y)
  store <1 x i8> %z, <1 x i8>* %pz
  ret void
}

define void @v1i16(<1 x i16>* %px, <1 x i16>* %py, <1 x i16>* %pz) nounwind {
; SSE-LABEL: v1i16:
; SSE:       # %bb.0:
; SSE-NEXT:    movzwl (%rdi), %eax
; SSE-NEXT:    addw (%rsi), %ax
; SSE-NEXT:    movl $65535, %ecx # imm = 0xFFFF
; SSE-NEXT:    cmovael %eax, %ecx
; SSE-NEXT:    movw %cx, (%rdx)
; SSE-NEXT:    retq
;
; AVX-LABEL: v1i16:
; AVX:       # %bb.0:
; AVX-NEXT:    movzwl (%rdi), %eax
; AVX-NEXT:    addw (%rsi), %ax
; AVX-NEXT:    movl $65535, %ecx # imm = 0xFFFF
; AVX-NEXT:    cmovael %eax, %ecx
; AVX-NEXT:    movw %cx, (%rdx)
; AVX-NEXT:    retq
  %x = load <1 x i16>, <1 x i16>* %px
  %y = load <1 x i16>, <1 x i16>* %py
  %z = call <1 x i16> @llvm.uadd.sat.v1i16(<1 x i16> %x, <1 x i16> %y)
  store <1 x i16> %z, <1 x i16>* %pz
  ret void
}

; Promotion

define <16 x i4> @v16i4(<16 x i4> %x, <16 x i4> %y) nounwind {
; SSE-LABEL: v16i4:
; SSE:       # %bb.0:
; SSE-NEXT:    psllw $4, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240]
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    psllw $4, %xmm0
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    paddusb %xmm1, %xmm0
; SSE-NEXT:    psrlw $4, %xmm0
; SSE-NEXT:    pand {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: v16i4:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsllw $4, %xmm1, %xmm1
; AVX-NEXT:    vmovdqa {{.*#+}} xmm2 = [240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240]
; AVX-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX-NEXT:    vpsllw $4, %xmm0, %xmm0
; AVX-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX-NEXT:    vpaddusb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX-NEXT:    vpand {{.*}}(%rip), %xmm0, %xmm0
; AVX-NEXT:    retq
  %z = call <16 x i4> @llvm.uadd.sat.v16i4(<16 x i4> %x, <16 x i4> %y)
  ret <16 x i4> %z
}

define <16 x i1> @v16i1(<16 x i1> %x, <16 x i1> %y) nounwind {
; SSE-LABEL: v16i1:
; SSE:       # %bb.0:
; SSE-NEXT:    psllw $7, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128]
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    psllw $7, %xmm0
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    paddusb %xmm1, %xmm0
; SSE-NEXT:    psrlw $7, %xmm0
; SSE-NEXT:    pand {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: v16i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpsllw $7, %xmm1, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpsllw $7, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpaddusb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpsrlw $7, %xmm0, %xmm0
; AVX1-NEXT:    vpand {{.*}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v16i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsllw $7, %xmm1, %xmm1
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm2 = [128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128]
; AVX2-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vpsllw $7, %xmm0, %xmm0
; AVX2-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpaddusb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpsrlw $7, %xmm0, %xmm0
; AVX2-NEXT:    vpand {{.*}}(%rip), %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v16i1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsllw $7, %xmm1, %xmm1
; AVX512-NEXT:    vpmovb2m %xmm1, %k0
; AVX512-NEXT:    vpsllw $7, %xmm0, %xmm0
; AVX512-NEXT:    vpmovb2m %xmm0, %k1
; AVX512-NEXT:    korw %k0, %k1, %k0
; AVX512-NEXT:    vpmovm2b %k0, %xmm0
; AVX512-NEXT:    retq
  %z = call <16 x i1> @llvm.uadd.sat.v16i1(<16 x i1> %x, <16 x i1> %y)
  ret <16 x i1> %z
}

; Expanded

define <4 x i32> @v4i32(<4 x i32> %x, <4 x i32> %y) nounwind {
; SSE2-LABEL: v4i32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[3,1,2,3]
; SSE2-NEXT:    movd %xmm2, %eax
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[3,1,2,3]
; SSE2-NEXT:    movd %xmm2, %ecx
; SSE2-NEXT:    addl %eax, %ecx
; SSE2-NEXT:    movl $-1, %eax
; SSE2-NEXT:    cmovbl %eax, %ecx
; SSE2-NEXT:    movd %ecx, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm1[2,3,0,1]
; SSE2-NEXT:    movd %xmm3, %ecx
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[2,3,0,1]
; SSE2-NEXT:    movd %xmm3, %edx
; SSE2-NEXT:    addl %ecx, %edx
; SSE2-NEXT:    cmovbl %eax, %edx
; SSE2-NEXT:    movd %edx, %xmm3
; SSE2-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; SSE2-NEXT:    movd %xmm1, %ecx
; SSE2-NEXT:    movd %xmm0, %edx
; SSE2-NEXT:    addl %ecx, %edx
; SSE2-NEXT:    cmovbl %eax, %edx
; SSE2-NEXT:    movd %edx, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,2,3]
; SSE2-NEXT:    movd %xmm1, %ecx
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,2,3]
; SSE2-NEXT:    movd %xmm0, %edx
; SSE2-NEXT:    addl %ecx, %edx
; SSE2-NEXT:    cmovbl %eax, %edx
; SSE2-NEXT:    movd %edx, %xmm0
; SSE2-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1]
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; SSE2-NEXT:    movdqa %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: v4i32:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[3,1,2,3]
; SSSE3-NEXT:    movd %xmm2, %eax
; SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[3,1,2,3]
; SSSE3-NEXT:    movd %xmm2, %ecx
; SSSE3-NEXT:    addl %eax, %ecx
; SSSE3-NEXT:    movl $-1, %eax
; SSSE3-NEXT:    cmovbl %eax, %ecx
; SSSE3-NEXT:    movd %ecx, %xmm2
; SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm1[2,3,0,1]
; SSSE3-NEXT:    movd %xmm3, %ecx
; SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[2,3,0,1]
; SSSE3-NEXT:    movd %xmm3, %edx
; SSSE3-NEXT:    addl %ecx, %edx
; SSSE3-NEXT:    cmovbl %eax, %edx
; SSSE3-NEXT:    movd %edx, %xmm3
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; SSSE3-NEXT:    movd %xmm1, %ecx
; SSSE3-NEXT:    movd %xmm0, %edx
; SSSE3-NEXT:    addl %ecx, %edx
; SSSE3-NEXT:    cmovbl %eax, %edx
; SSSE3-NEXT:    movd %edx, %xmm2
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,2,3]
; SSSE3-NEXT:    movd %xmm1, %ecx
; SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,2,3]
; SSSE3-NEXT:    movd %xmm0, %edx
; SSSE3-NEXT:    addl %ecx, %edx
; SSSE3-NEXT:    cmovbl %eax, %edx
; SSSE3-NEXT:    movd %edx, %xmm0
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1]
; SSSE3-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; SSSE3-NEXT:    movdqa %xmm2, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: v4i32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pextrd $1, %xmm1, %eax
; SSE41-NEXT:    pextrd $1, %xmm0, %ecx
; SSE41-NEXT:    addl %eax, %ecx
; SSE41-NEXT:    movl $-1, %eax
; SSE41-NEXT:    cmovbl %eax, %ecx
; SSE41-NEXT:    movd %xmm1, %edx
; SSE41-NEXT:    movd %xmm0, %esi
; SSE41-NEXT:    addl %edx, %esi
; SSE41-NEXT:    cmovbl %eax, %esi
; SSE41-NEXT:    movd %esi, %xmm2
; SSE41-NEXT:    pinsrd $1, %ecx, %xmm2
; SSE41-NEXT:    pextrd $2, %xmm1, %ecx
; SSE41-NEXT:    pextrd $2, %xmm0, %edx
; SSE41-NEXT:    addl %ecx, %edx
; SSE41-NEXT:    cmovbl %eax, %edx
; SSE41-NEXT:    pinsrd $2, %edx, %xmm2
; SSE41-NEXT:    pextrd $3, %xmm1, %ecx
; SSE41-NEXT:    pextrd $3, %xmm0, %edx
; SSE41-NEXT:    addl %ecx, %edx
; SSE41-NEXT:    cmovbl %eax, %edx
; SSE41-NEXT:    pinsrd $3, %edx, %xmm2
; SSE41-NEXT:    movdqa %xmm2, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: v4i32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpextrd $1, %xmm1, %eax
; AVX-NEXT:    vpextrd $1, %xmm0, %ecx
; AVX-NEXT:    addl %eax, %ecx
; AVX-NEXT:    movl $-1, %eax
; AVX-NEXT:    cmovbl %eax, %ecx
; AVX-NEXT:    vmovd %xmm1, %edx
; AVX-NEXT:    vmovd %xmm0, %esi
; AVX-NEXT:    addl %edx, %esi
; AVX-NEXT:    cmovbl %eax, %esi
; AVX-NEXT:    vmovd %esi, %xmm2
; AVX-NEXT:    vpinsrd $1, %ecx, %xmm2, %xmm2
; AVX-NEXT:    vpextrd $2, %xmm1, %ecx
; AVX-NEXT:    vpextrd $2, %xmm0, %edx
; AVX-NEXT:    addl %ecx, %edx
; AVX-NEXT:    cmovbl %eax, %edx
; AVX-NEXT:    vpinsrd $2, %edx, %xmm2, %xmm2
; AVX-NEXT:    vpextrd $3, %xmm1, %ecx
; AVX-NEXT:    vpextrd $3, %xmm0, %edx
; AVX-NEXT:    addl %ecx, %edx
; AVX-NEXT:    cmovbl %eax, %edx
; AVX-NEXT:    vpinsrd $3, %edx, %xmm2, %xmm0
; AVX-NEXT:    retq
  %z = call <4 x i32> @llvm.uadd.sat.v4i32(<4 x i32> %x, <4 x i32> %y)
  ret <4 x i32> %z
}

define <2 x i32> @v2i32(<2 x i32> %x, <2 x i32> %y) nounwind {
; SSE2-LABEL: v2i32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    psllq $32, %xmm1
; SSE2-NEXT:    movq %xmm1, %rax
; SSE2-NEXT:    psllq $32, %xmm0
; SSE2-NEXT:    movq %xmm0, %rcx
; SSE2-NEXT:    addq %rax, %rcx
; SSE2-NEXT:    movq $-1, %rax
; SSE2-NEXT:    cmovbq %rax, %rcx
; SSE2-NEXT:    movq %rcx, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,0,1]
; SSE2-NEXT:    movq %xmm1, %rcx
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,0,1]
; SSE2-NEXT:    movq %xmm0, %rdx
; SSE2-NEXT:    addq %rcx, %rdx
; SSE2-NEXT:    cmovbq %rax, %rdx
; SSE2-NEXT:    movq %rdx, %xmm0
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm0[0]
; SSE2-NEXT:    psrlq $32, %xmm2
; SSE2-NEXT:    movdqa %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: v2i32:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    psllq $32, %xmm1
; SSSE3-NEXT:    movq %xmm1, %rax
; SSSE3-NEXT:    psllq $32, %xmm0
; SSSE3-NEXT:    movq %xmm0, %rcx
; SSSE3-NEXT:    addq %rax, %rcx
; SSSE3-NEXT:    movq $-1, %rax
; SSSE3-NEXT:    cmovbq %rax, %rcx
; SSSE3-NEXT:    movq %rcx, %xmm2
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,0,1]
; SSSE3-NEXT:    movq %xmm1, %rcx
; SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,0,1]
; SSSE3-NEXT:    movq %xmm0, %rdx
; SSSE3-NEXT:    addq %rcx, %rdx
; SSSE3-NEXT:    cmovbq %rax, %rdx
; SSSE3-NEXT:    movq %rdx, %xmm0
; SSSE3-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm0[0]
; SSSE3-NEXT:    psrlq $32, %xmm2
; SSSE3-NEXT:    movdqa %xmm2, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: v2i32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    psllq $32, %xmm1
; SSE41-NEXT:    pextrq $1, %xmm1, %rax
; SSE41-NEXT:    psllq $32, %xmm0
; SSE41-NEXT:    pextrq $1, %xmm0, %rcx
; SSE41-NEXT:    addq %rax, %rcx
; SSE41-NEXT:    movq $-1, %rax
; SSE41-NEXT:    cmovbq %rax, %rcx
; SSE41-NEXT:    movq %rcx, %xmm2
; SSE41-NEXT:    movq %xmm1, %rcx
; SSE41-NEXT:    movq %xmm0, %rdx
; SSE41-NEXT:    addq %rcx, %rdx
; SSE41-NEXT:    cmovbq %rax, %rdx
; SSE41-NEXT:    movq %rdx, %xmm0
; SSE41-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; SSE41-NEXT:    psrlq $32, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: v2i32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsllq $32, %xmm1, %xmm1
; AVX-NEXT:    vpextrq $1, %xmm1, %rax
; AVX-NEXT:    vpsllq $32, %xmm0, %xmm0
; AVX-NEXT:    vpextrq $1, %xmm0, %rcx
; AVX-NEXT:    addq %rax, %rcx
; AVX-NEXT:    movq $-1, %rax
; AVX-NEXT:    cmovbq %rax, %rcx
; AVX-NEXT:    vmovq %rcx, %xmm2
; AVX-NEXT:    vmovq %xmm1, %rcx
; AVX-NEXT:    vmovq %xmm0, %rdx
; AVX-NEXT:    addq %rcx, %rdx
; AVX-NEXT:    cmovbq %rax, %rdx
; AVX-NEXT:    vmovq %rdx, %xmm0
; AVX-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; AVX-NEXT:    vpsrlq $32, %xmm0, %xmm0
; AVX-NEXT:    retq
  %z = call <2 x i32> @llvm.uadd.sat.v2i32(<2 x i32> %x, <2 x i32> %y)
  ret <2 x i32> %z
}

define <4 x i24> @v4i24(<4 x i24> %x, <4 x i24> %y) nounwind {
; SSE2-LABEL: v4i24:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pslld $8, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[3,1,2,3]
; SSE2-NEXT:    movd %xmm2, %eax
; SSE2-NEXT:    pslld $8, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[3,1,2,3]
; SSE2-NEXT:    movd %xmm2, %ecx
; SSE2-NEXT:    addl %eax, %ecx
; SSE2-NEXT:    movl $-1, %eax
; SSE2-NEXT:    cmovbl %eax, %ecx
; SSE2-NEXT:    movd %ecx, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm1[2,3,0,1]
; SSE2-NEXT:    movd %xmm3, %ecx
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[2,3,0,1]
; SSE2-NEXT:    movd %xmm3, %edx
; SSE2-NEXT:    addl %ecx, %edx
; SSE2-NEXT:    cmovbl %eax, %edx
; SSE2-NEXT:    movd %edx, %xmm3
; SSE2-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; SSE2-NEXT:    movd %xmm1, %ecx
; SSE2-NEXT:    movd %xmm0, %edx
; SSE2-NEXT:    addl %ecx, %edx
; SSE2-NEXT:    cmovbl %eax, %edx
; SSE2-NEXT:    movd %edx, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,2,3]
; SSE2-NEXT:    movd %xmm1, %ecx
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,2,3]
; SSE2-NEXT:    movd %xmm0, %edx
; SSE2-NEXT:    addl %ecx, %edx
; SSE2-NEXT:    cmovbl %eax, %edx
; SSE2-NEXT:    movd %edx, %xmm0
; SSE2-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1]
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; SSE2-NEXT:    psrld $8, %xmm2
; SSE2-NEXT:    movdqa %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: v4i24:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    pslld $8, %xmm1
; SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[3,1,2,3]
; SSSE3-NEXT:    movd %xmm2, %eax
; SSSE3-NEXT:    pslld $8, %xmm0
; SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[3,1,2,3]
; SSSE3-NEXT:    movd %xmm2, %ecx
; SSSE3-NEXT:    addl %eax, %ecx
; SSSE3-NEXT:    movl $-1, %eax
; SSSE3-NEXT:    cmovbl %eax, %ecx
; SSSE3-NEXT:    movd %ecx, %xmm2
; SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm1[2,3,0,1]
; SSSE3-NEXT:    movd %xmm3, %ecx
; SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[2,3,0,1]
; SSSE3-NEXT:    movd %xmm3, %edx
; SSSE3-NEXT:    addl %ecx, %edx
; SSSE3-NEXT:    cmovbl %eax, %edx
; SSSE3-NEXT:    movd %edx, %xmm3
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; SSSE3-NEXT:    movd %xmm1, %ecx
; SSSE3-NEXT:    movd %xmm0, %edx
; SSSE3-NEXT:    addl %ecx, %edx
; SSSE3-NEXT:    cmovbl %eax, %edx
; SSSE3-NEXT:    movd %edx, %xmm2
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,2,3]
; SSSE3-NEXT:    movd %xmm1, %ecx
; SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,2,3]
; SSSE3-NEXT:    movd %xmm0, %edx
; SSSE3-NEXT:    addl %ecx, %edx
; SSSE3-NEXT:    cmovbl %eax, %edx
; SSSE3-NEXT:    movd %edx, %xmm0
; SSSE3-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm0[0],xmm2[1],xmm0[1]
; SSSE3-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; SSSE3-NEXT:    psrld $8, %xmm2
; SSSE3-NEXT:    movdqa %xmm2, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: v4i24:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pslld $8, %xmm1
; SSE41-NEXT:    pextrd $1, %xmm1, %eax
; SSE41-NEXT:    pslld $8, %xmm0
; SSE41-NEXT:    pextrd $1, %xmm0, %ecx
; SSE41-NEXT:    addl %eax, %ecx
; SSE41-NEXT:    movl $-1, %eax
; SSE41-NEXT:    cmovbl %eax, %ecx
; SSE41-NEXT:    movd %xmm1, %edx
; SSE41-NEXT:    movd %xmm0, %esi
; SSE41-NEXT:    addl %edx, %esi
; SSE41-NEXT:    cmovbl %eax, %esi
; SSE41-NEXT:    movd %esi, %xmm2
; SSE41-NEXT:    pinsrd $1, %ecx, %xmm2
; SSE41-NEXT:    pextrd $2, %xmm1, %ecx
; SSE41-NEXT:    pextrd $2, %xmm0, %edx
; SSE41-NEXT:    addl %ecx, %edx
; SSE41-NEXT:    cmovbl %eax, %edx
; SSE41-NEXT:    pinsrd $2, %edx, %xmm2
; SSE41-NEXT:    pextrd $3, %xmm1, %ecx
; SSE41-NEXT:    pextrd $3, %xmm0, %edx
; SSE41-NEXT:    addl %ecx, %edx
; SSE41-NEXT:    cmovbl %eax, %edx
; SSE41-NEXT:    pinsrd $3, %edx, %xmm2
; SSE41-NEXT:    psrld $8, %xmm2
; SSE41-NEXT:    movdqa %xmm2, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: v4i24:
; AVX:       # %bb.0:
; AVX-NEXT:    vpslld $8, %xmm1, %xmm1
; AVX-NEXT:    vpextrd $1, %xmm1, %eax
; AVX-NEXT:    vpslld $8, %xmm0, %xmm0
; AVX-NEXT:    vpextrd $1, %xmm0, %ecx
; AVX-NEXT:    addl %eax, %ecx
; AVX-NEXT:    movl $-1, %eax
; AVX-NEXT:    cmovbl %eax, %ecx
; AVX-NEXT:    vmovd %xmm1, %edx
; AVX-NEXT:    vmovd %xmm0, %esi
; AVX-NEXT:    addl %edx, %esi
; AVX-NEXT:    cmovbl %eax, %esi
; AVX-NEXT:    vmovd %esi, %xmm2
; AVX-NEXT:    vpinsrd $1, %ecx, %xmm2, %xmm2
; AVX-NEXT:    vpextrd $2, %xmm1, %ecx
; AVX-NEXT:    vpextrd $2, %xmm0, %edx
; AVX-NEXT:    addl %ecx, %edx
; AVX-NEXT:    cmovbl %eax, %edx
; AVX-NEXT:    vpinsrd $2, %edx, %xmm2, %xmm2
; AVX-NEXT:    vpextrd $3, %xmm1, %ecx
; AVX-NEXT:    vpextrd $3, %xmm0, %edx
; AVX-NEXT:    addl %ecx, %edx
; AVX-NEXT:    cmovbl %eax, %edx
; AVX-NEXT:    vpinsrd $3, %edx, %xmm2, %xmm0
; AVX-NEXT:    vpsrld $8, %xmm0, %xmm0
; AVX-NEXT:    retq
  %z = call <4 x i24> @llvm.uadd.sat.v4i24(<4 x i24> %x, <4 x i24> %y)
  ret <4 x i24> %z
}

define <2 x i128> @v2i128(<2 x i128> %x, <2 x i128> %y) nounwind {
; SSE-LABEL: v2i128:
; SSE:       # %bb.0:
; SSE-NEXT:    movq %rdi, %rax
; SSE-NEXT:    addq %r9, %rsi
; SSE-NEXT:    adcq {{[0-9]+}}(%rsp), %rdx
; SSE-NEXT:    movq $-1, %rdi
; SSE-NEXT:    cmovbq %rdi, %rsi
; SSE-NEXT:    cmovbq %rdi, %rdx
; SSE-NEXT:    addq {{[0-9]+}}(%rsp), %rcx
; SSE-NEXT:    adcq {{[0-9]+}}(%rsp), %r8
; SSE-NEXT:    cmovbq %rdi, %r8
; SSE-NEXT:    cmovbq %rdi, %rcx
; SSE-NEXT:    movq %r8, 24(%rax)
; SSE-NEXT:    movq %rcx, 16(%rax)
; SSE-NEXT:    movq %rdx, 8(%rax)
; SSE-NEXT:    movq %rsi, (%rax)
; SSE-NEXT:    retq
;
; AVX-LABEL: v2i128:
; AVX:       # %bb.0:
; AVX-NEXT:    movq %rdi, %rax
; AVX-NEXT:    addq %r9, %rsi
; AVX-NEXT:    adcq {{[0-9]+}}(%rsp), %rdx
; AVX-NEXT:    movq $-1, %rdi
; AVX-NEXT:    cmovbq %rdi, %rsi
; AVX-NEXT:    cmovbq %rdi, %rdx
; AVX-NEXT:    addq {{[0-9]+}}(%rsp), %rcx
; AVX-NEXT:    adcq {{[0-9]+}}(%rsp), %r8
; AVX-NEXT:    cmovbq %rdi, %r8
; AVX-NEXT:    cmovbq %rdi, %rcx
; AVX-NEXT:    movq %r8, 24(%rax)
; AVX-NEXT:    movq %rcx, 16(%rax)
; AVX-NEXT:    movq %rdx, 8(%rax)
; AVX-NEXT:    movq %rsi, (%rax)
; AVX-NEXT:    retq
  %z = call <2 x i128> @llvm.uadd.sat.v2i128(<2 x i128> %x, <2 x i128> %y)
  ret <2 x i128> %z
}
