; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn-amd-amdhsa -verify-machineinstrs < %s | FileCheck -check-prefix=GCN %s

define i128 @v_shl_i128_vv(i128 %lhs, i128 %rhs) {
; GCN-LABEL: v_shl_i128_vv:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_lshl_b64 v[5:6], v[2:3], v4
; GCN-NEXT:    v_sub_i32_e32 v9, vcc, 64, v4
; GCN-NEXT:    v_subrev_i32_e32 v11, vcc, 64, v4
; GCN-NEXT:    v_lshl_b64 v[7:8], v[0:1], v4
; GCN-NEXT:    v_lshr_b64 v[9:10], v[0:1], v9
; GCN-NEXT:    v_lshl_b64 v[0:1], v[0:1], v11
; GCN-NEXT:    v_or_b32_e32 v6, v6, v10
; GCN-NEXT:    v_or_b32_e32 v5, v5, v9
; GCN-NEXT:    v_cmp_gt_u32_e32 vcc, 64, v4
; GCN-NEXT:    v_cndmask_b32_e32 v6, v1, v6, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v0, v0, v5, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v1, 0, v8, vcc
; GCN-NEXT:    v_cmp_eq_u32_e64 s[6:7], 0, v4
; GCN-NEXT:    v_cndmask_b32_e64 v3, v6, v3, s[6:7]
; GCN-NEXT:    v_cndmask_b32_e64 v2, v0, v2, s[6:7]
; GCN-NEXT:    v_cndmask_b32_e32 v0, 0, v7, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %shl = shl i128 %lhs, %rhs
  ret i128 %shl
}

define i128 @v_lshr_i128_vv(i128 %lhs, i128 %rhs) {
; GCN-LABEL: v_lshr_i128_vv:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_lshr_b64 v[5:6], v[0:1], v4
; GCN-NEXT:    v_sub_i32_e32 v9, vcc, 64, v4
; GCN-NEXT:    v_subrev_i32_e32 v11, vcc, 64, v4
; GCN-NEXT:    v_lshr_b64 v[7:8], v[2:3], v4
; GCN-NEXT:    v_lshl_b64 v[9:10], v[2:3], v9
; GCN-NEXT:    v_lshr_b64 v[2:3], v[2:3], v11
; GCN-NEXT:    v_or_b32_e32 v6, v6, v10
; GCN-NEXT:    v_or_b32_e32 v5, v5, v9
; GCN-NEXT:    v_cmp_gt_u32_e32 vcc, 64, v4
; GCN-NEXT:    v_cndmask_b32_e32 v6, v3, v6, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v2, v2, v5, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v3, 0, v8, vcc
; GCN-NEXT:    v_cmp_eq_u32_e64 s[6:7], 0, v4
; GCN-NEXT:    v_cndmask_b32_e64 v1, v6, v1, s[6:7]
; GCN-NEXT:    v_cndmask_b32_e64 v0, v2, v0, s[6:7]
; GCN-NEXT:    v_cndmask_b32_e32 v2, 0, v7, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]

  %shl = lshr i128 %lhs, %rhs
  ret i128 %shl
}

define i128 @v_ashr_i128_vv(i128 %lhs, i128 %rhs) {
; GCN-LABEL: v_ashr_i128_vv:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_ashrrev_i32_e32 v9, 31, v3
; GCN-NEXT:    v_ashr_i64 v[5:6], v[2:3], v4
; GCN-NEXT:    v_lshr_b64 v[7:8], v[0:1], v4
; GCN-NEXT:    v_sub_i32_e32 v10, vcc, 64, v4
; GCN-NEXT:    v_subrev_i32_e32 v11, vcc, 64, v4
; GCN-NEXT:    v_cmp_gt_u32_e32 vcc, 64, v4
; GCN-NEXT:    v_cndmask_b32_e32 v6, v9, v6, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v5, v9, v5, vcc
; GCN-NEXT:    v_lshl_b64 v[9:10], v[2:3], v10
; GCN-NEXT:    v_ashr_i64 v[2:3], v[2:3], v11
; GCN-NEXT:    v_or_b32_e32 v8, v8, v10
; GCN-NEXT:    v_or_b32_e32 v7, v7, v9
; GCN-NEXT:    v_cndmask_b32_e32 v3, v3, v8, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v2, v2, v7, vcc
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v4
; GCN-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GCN-NEXT:    v_mov_b32_e32 v2, v5
; GCN-NEXT:    v_mov_b32_e32 v3, v6
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %shl = ashr i128 %lhs, %rhs
  ret i128 %shl
}


define i128 @v_shl_i128_vk(i128 %lhs) {
; GCN-LABEL: v_shl_i128_vk:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_lshl_b64 v[2:3], v[2:3], 17
; GCN-NEXT:    v_lshrrev_b32_e32 v4, 15, v1
; GCN-NEXT:    v_or_b32_e32 v2, v2, v4
; GCN-NEXT:    v_lshl_b64 v[0:1], v[0:1], 17
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %shl = shl i128 %lhs, 17
  ret i128 %shl
}

define i128 @v_lshr_i128_vk(i128 %lhs) {
; GCN-LABEL: v_lshr_i128_vk:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_lshr_b64 v[0:1], v[2:3], 1
; GCN-NEXT:    v_mov_b32_e32 v2, 0
; GCN-NEXT:    v_mov_b32_e32 v3, 0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %shl = lshr i128 %lhs, 65
  ret i128 %shl
}

define i128 @v_ashr_i128_vk(i128 %lhs) {
; GCN-LABEL: v_ashr_i128_vk:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_lshl_b64 v[4:5], v[2:3], 31
; GCN-NEXT:    v_lshrrev_b32_e32 v0, 1, v1
; GCN-NEXT:    v_or_b32_e32 v4, v0, v4
; GCN-NEXT:    v_ashr_i64 v[2:3], v[2:3], 33
; GCN-NEXT:    v_mov_b32_e32 v0, v4
; GCN-NEXT:    v_mov_b32_e32 v1, v5
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %shl = ashr i128 %lhs, 33
  ret i128 %shl
}

define i128 @v_shl_i128_kv(i128 %rhs) {
; GCN-LABEL: v_shl_i128_kv:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_sub_i32_e32 v1, vcc, 64, v0
; GCN-NEXT:    v_subrev_i32_e32 v3, vcc, 64, v0
; GCN-NEXT:    v_lshl_b64 v[4:5], 17, v0
; GCN-NEXT:    v_lshr_b64 v[1:2], 17, v1
; GCN-NEXT:    v_lshl_b64 v[6:7], 17, v3
; GCN-NEXT:    v_cmp_gt_u32_e32 vcc, 64, v0
; GCN-NEXT:    v_cndmask_b32_e32 v2, v7, v2, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v6, v6, v1, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v1, 0, v5, vcc
; GCN-NEXT:    v_cmp_ne_u32_e64 s[6:7], 0, v0
; GCN-NEXT:    v_cndmask_b32_e64 v3, 0, v2, s[6:7]
; GCN-NEXT:    v_cndmask_b32_e64 v2, 0, v6, s[6:7]
; GCN-NEXT:    v_cndmask_b32_e32 v0, 0, v4, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %shl = shl i128 17, %rhs
  ret i128 %shl
}

define i128 @v_lshr_i128_kv(i128 %rhs) {
; GCN-LABEL: v_lshr_i128_kv:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_mov_b32 s7, 0
; GCN-NEXT:    s_movk_i32 s6, 0x41
; GCN-NEXT:    v_mov_b32_e32 v3, 0x41
; GCN-NEXT:    v_lshr_b64 v[1:2], s[6:7], v0
; GCN-NEXT:    v_cmp_gt_u32_e32 vcc, 64, v0
; GCN-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v4, 0, v1, vcc
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GCN-NEXT:    v_cndmask_b32_e32 v1, 0, v2, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v0, v3, v4, vcc
; GCN-NEXT:    v_mov_b32_e32 v2, 0
; GCN-NEXT:    v_mov_b32_e32 v3, 0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %shl = lshr i128 65, %rhs
  ret i128 %shl
}

define i128 @v_ashr_i128_kv(i128 %rhs) {
; GCN-LABEL: v_ashr_i128_kv:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_lshr_b64 v[1:2], 33, v0
; GCN-NEXT:    v_cmp_gt_u32_e32 vcc, 64, v0
; GCN-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v3, 0, v1, vcc
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GCN-NEXT:    v_cndmask_b32_e32 v1, 0, v2, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v0, 33, v3, vcc
; GCN-NEXT:    v_mov_b32_e32 v2, 0
; GCN-NEXT:    v_mov_b32_e32 v3, 0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %shl = ashr i128 33, %rhs
  ret i128 %shl
}

define amdgpu_kernel void @s_shl_i128_ss(i128 %lhs, i128 %rhs) {
; GCN-LABEL: s_shl_i128_ss:
; GCN:         .amd_kernel_code_t
; GCN-NEXT:     amd_code_version_major = 1
; GCN-NEXT:     amd_code_version_minor = 2
; GCN-NEXT:     amd_machine_kind = 1
; GCN-NEXT:     amd_machine_version_major = 7
; GCN-NEXT:     amd_machine_version_minor = 0
; GCN-NEXT:     amd_machine_version_stepping = 0
; GCN-NEXT:     kernel_code_entry_byte_offset = 256
; GCN-NEXT:     kernel_code_prefetch_byte_size = 0
; GCN-NEXT:     granulated_workitem_vgpr_count = 1
; GCN-NEXT:     granulated_wavefront_sgpr_count = 1
; GCN-NEXT:     priority = 0
; GCN-NEXT:     float_mode = 192
; GCN-NEXT:     priv = 0
; GCN-NEXT:     enable_dx10_clamp = 1
; GCN-NEXT:     debug_mode = 0
; GCN-NEXT:     enable_ieee_mode = 1
; GCN-NEXT:     enable_sgpr_private_segment_wave_byte_offset = 0
; GCN-NEXT:     user_sgpr_count = 6
; GCN-NEXT:     enable_trap_handler = 0
; GCN-NEXT:     enable_sgpr_workgroup_id_x = 1
; GCN-NEXT:     enable_sgpr_workgroup_id_y = 0
; GCN-NEXT:     enable_sgpr_workgroup_id_z = 0
; GCN-NEXT:     enable_sgpr_workgroup_info = 0
; GCN-NEXT:     enable_vgpr_workitem_id = 0
; GCN-NEXT:     enable_exception_msb = 0
; GCN-NEXT:     granulated_lds_size = 0
; GCN-NEXT:     enable_exception = 0
; GCN-NEXT:     enable_sgpr_private_segment_buffer = 1
; GCN-NEXT:     enable_sgpr_dispatch_ptr = 0
; GCN-NEXT:     enable_sgpr_queue_ptr = 0
; GCN-NEXT:     enable_sgpr_kernarg_segment_ptr = 1
; GCN-NEXT:     enable_sgpr_dispatch_id = 0
; GCN-NEXT:     enable_sgpr_flat_scratch_init = 0
; GCN-NEXT:     enable_sgpr_private_segment_size = 0
; GCN-NEXT:     enable_sgpr_grid_workgroup_count_x = 0
; GCN-NEXT:     enable_sgpr_grid_workgroup_count_y = 0
; GCN-NEXT:     enable_sgpr_grid_workgroup_count_z = 0
; GCN-NEXT:     enable_ordered_append_gds = 0
; GCN-NEXT:     private_element_size = 1
; GCN-NEXT:     is_ptr64 = 1
; GCN-NEXT:     is_dynamic_callstack = 0
; GCN-NEXT:     is_debug_enabled = 0
; GCN-NEXT:     is_xnack_enabled = 0
; GCN-NEXT:     workitem_private_segment_byte_size = 0
; GCN-NEXT:     workgroup_group_segment_byte_size = 0
; GCN-NEXT:     gds_segment_byte_size = 0
; GCN-NEXT:     kernarg_segment_byte_size = 32
; GCN-NEXT:     workgroup_fbarrier_count = 0
; GCN-NEXT:     wavefront_sgpr_count = 15
; GCN-NEXT:     workitem_vgpr_count = 8
; GCN-NEXT:     reserved_vgpr_first = 0
; GCN-NEXT:     reserved_vgpr_count = 0
; GCN-NEXT:     reserved_sgpr_first = 0
; GCN-NEXT:     reserved_sgpr_count = 0
; GCN-NEXT:     debug_wavefront_private_segment_offset_sgpr = 0
; GCN-NEXT:     debug_private_segment_buffer_sgpr = 0
; GCN-NEXT:     kernarg_segment_alignment = 4
; GCN-NEXT:     group_segment_alignment = 4
; GCN-NEXT:     private_segment_alignment = 4
; GCN-NEXT:     wavefront_size = 6
; GCN-NEXT:     call_convention = -1
; GCN-NEXT:     runtime_loader_kernel_symbol = 0
; GCN-NEXT:    .end_amd_kernel_code_t
; GCN-NEXT:  ; %bb.0:
; GCN-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_lshl_b64 s[6:7], s[2:3], s4
; GCN-NEXT:    s_sub_i32 s5, 64, s4
; GCN-NEXT:    s_sub_i32 s12, s4, 64
; GCN-NEXT:    s_lshl_b64 s[8:9], s[0:1], s4
; GCN-NEXT:    s_lshr_b64 s[10:11], s[0:1], s5
; GCN-NEXT:    s_lshl_b64 s[0:1], s[0:1], s12
; GCN-NEXT:    s_or_b64 s[6:7], s[6:7], s[10:11]
; GCN-NEXT:    v_mov_b32_e32 v0, s3
; GCN-NEXT:    v_mov_b32_e32 v2, s2
; GCN-NEXT:    v_mov_b32_e32 v1, s9
; GCN-NEXT:    v_mov_b32_e32 v4, s8
; GCN-NEXT:    v_mov_b32_e32 v3, s1
; GCN-NEXT:    v_mov_b32_e32 v5, s0
; GCN-NEXT:    v_mov_b32_e32 v6, s7
; GCN-NEXT:    v_cmp_lt_u32_e64 vcc, s4, 64
; GCN-NEXT:    v_cndmask_b32_e32 v3, v3, v6, vcc
; GCN-NEXT:    v_mov_b32_e32 v6, s6
; GCN-NEXT:    v_cmp_eq_u32_e64 s[0:1], s4, 0
; GCN-NEXT:    v_cndmask_b32_e64 v3, v3, v0, s[0:1]
; GCN-NEXT:    v_cndmask_b32_e32 v5, v5, v6, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v0, 0, v4, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v2, v5, v2, s[0:1]
; GCN-NEXT:    v_mov_b32_e32 v4, 0
; GCN-NEXT:    v_mov_b32_e32 v5, 0
; GCN-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GCN-NEXT:    s_endpgm
  %shift = shl i128 %lhs, %rhs
  store i128 %shift, i128 addrspace(1)* null
  ret void
}

define amdgpu_kernel void @s_lshr_i128_ss(i128 %lhs, i128 %rhs) {
; GCN-LABEL: s_lshr_i128_ss:
; GCN:         .amd_kernel_code_t
; GCN-NEXT:     amd_code_version_major = 1
; GCN-NEXT:     amd_code_version_minor = 2
; GCN-NEXT:     amd_machine_kind = 1
; GCN-NEXT:     amd_machine_version_major = 7
; GCN-NEXT:     amd_machine_version_minor = 0
; GCN-NEXT:     amd_machine_version_stepping = 0
; GCN-NEXT:     kernel_code_entry_byte_offset = 256
; GCN-NEXT:     kernel_code_prefetch_byte_size = 0
; GCN-NEXT:     granulated_workitem_vgpr_count = 1
; GCN-NEXT:     granulated_wavefront_sgpr_count = 1
; GCN-NEXT:     priority = 0
; GCN-NEXT:     float_mode = 192
; GCN-NEXT:     priv = 0
; GCN-NEXT:     enable_dx10_clamp = 1
; GCN-NEXT:     debug_mode = 0
; GCN-NEXT:     enable_ieee_mode = 1
; GCN-NEXT:     enable_sgpr_private_segment_wave_byte_offset = 0
; GCN-NEXT:     user_sgpr_count = 6
; GCN-NEXT:     enable_trap_handler = 0
; GCN-NEXT:     enable_sgpr_workgroup_id_x = 1
; GCN-NEXT:     enable_sgpr_workgroup_id_y = 0
; GCN-NEXT:     enable_sgpr_workgroup_id_z = 0
; GCN-NEXT:     enable_sgpr_workgroup_info = 0
; GCN-NEXT:     enable_vgpr_workitem_id = 0
; GCN-NEXT:     enable_exception_msb = 0
; GCN-NEXT:     granulated_lds_size = 0
; GCN-NEXT:     enable_exception = 0
; GCN-NEXT:     enable_sgpr_private_segment_buffer = 1
; GCN-NEXT:     enable_sgpr_dispatch_ptr = 0
; GCN-NEXT:     enable_sgpr_queue_ptr = 0
; GCN-NEXT:     enable_sgpr_kernarg_segment_ptr = 1
; GCN-NEXT:     enable_sgpr_dispatch_id = 0
; GCN-NEXT:     enable_sgpr_flat_scratch_init = 0
; GCN-NEXT:     enable_sgpr_private_segment_size = 0
; GCN-NEXT:     enable_sgpr_grid_workgroup_count_x = 0
; GCN-NEXT:     enable_sgpr_grid_workgroup_count_y = 0
; GCN-NEXT:     enable_sgpr_grid_workgroup_count_z = 0
; GCN-NEXT:     enable_ordered_append_gds = 0
; GCN-NEXT:     private_element_size = 1
; GCN-NEXT:     is_ptr64 = 1
; GCN-NEXT:     is_dynamic_callstack = 0
; GCN-NEXT:     is_debug_enabled = 0
; GCN-NEXT:     is_xnack_enabled = 0
; GCN-NEXT:     workitem_private_segment_byte_size = 0
; GCN-NEXT:     workgroup_group_segment_byte_size = 0
; GCN-NEXT:     gds_segment_byte_size = 0
; GCN-NEXT:     kernarg_segment_byte_size = 32
; GCN-NEXT:     workgroup_fbarrier_count = 0
; GCN-NEXT:     wavefront_sgpr_count = 15
; GCN-NEXT:     workitem_vgpr_count = 8
; GCN-NEXT:     reserved_vgpr_first = 0
; GCN-NEXT:     reserved_vgpr_count = 0
; GCN-NEXT:     reserved_sgpr_first = 0
; GCN-NEXT:     reserved_sgpr_count = 0
; GCN-NEXT:     debug_wavefront_private_segment_offset_sgpr = 0
; GCN-NEXT:     debug_private_segment_buffer_sgpr = 0
; GCN-NEXT:     kernarg_segment_alignment = 4
; GCN-NEXT:     group_segment_alignment = 4
; GCN-NEXT:     private_segment_alignment = 4
; GCN-NEXT:     wavefront_size = 6
; GCN-NEXT:     call_convention = -1
; GCN-NEXT:     runtime_loader_kernel_symbol = 0
; GCN-NEXT:    .end_amd_kernel_code_t
; GCN-NEXT:  ; %bb.0:
; GCN-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_lshr_b64 s[6:7], s[0:1], s4
; GCN-NEXT:    s_sub_i32 s5, 64, s4
; GCN-NEXT:    s_sub_i32 s12, s4, 64
; GCN-NEXT:    s_lshr_b64 s[8:9], s[2:3], s4
; GCN-NEXT:    s_lshl_b64 s[10:11], s[2:3], s5
; GCN-NEXT:    s_lshr_b64 s[2:3], s[2:3], s12
; GCN-NEXT:    s_or_b64 s[6:7], s[6:7], s[10:11]
; GCN-NEXT:    v_mov_b32_e32 v0, s1
; GCN-NEXT:    v_mov_b32_e32 v4, s0
; GCN-NEXT:    v_mov_b32_e32 v2, s9
; GCN-NEXT:    v_mov_b32_e32 v5, s8
; GCN-NEXT:    v_mov_b32_e32 v1, s3
; GCN-NEXT:    v_mov_b32_e32 v3, s2
; GCN-NEXT:    v_mov_b32_e32 v6, s7
; GCN-NEXT:    v_cmp_lt_u32_e64 vcc, s4, 64
; GCN-NEXT:    v_cndmask_b32_e32 v1, v1, v6, vcc
; GCN-NEXT:    v_mov_b32_e32 v6, s6
; GCN-NEXT:    v_cmp_eq_u32_e64 s[0:1], s4, 0
; GCN-NEXT:    v_cndmask_b32_e64 v1, v1, v0, s[0:1]
; GCN-NEXT:    v_cndmask_b32_e32 v0, v3, v6, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v3, 0, v2, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v2, 0, v5, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v0, v0, v4, s[0:1]
; GCN-NEXT:    v_mov_b32_e32 v4, 0
; GCN-NEXT:    v_mov_b32_e32 v5, 0
; GCN-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GCN-NEXT:    s_endpgm
  %shift = lshr i128 %lhs, %rhs
  store i128 %shift, i128 addrspace(1)* null
  ret void
}

define amdgpu_kernel void @s_ashr_i128_ss(i128 %lhs, i128 %rhs) {
; GCN-LABEL: s_ashr_i128_ss:
; GCN:         .amd_kernel_code_t
; GCN-NEXT:     amd_code_version_major = 1
; GCN-NEXT:     amd_code_version_minor = 2
; GCN-NEXT:     amd_machine_kind = 1
; GCN-NEXT:     amd_machine_version_major = 7
; GCN-NEXT:     amd_machine_version_minor = 0
; GCN-NEXT:     amd_machine_version_stepping = 0
; GCN-NEXT:     kernel_code_entry_byte_offset = 256
; GCN-NEXT:     kernel_code_prefetch_byte_size = 0
; GCN-NEXT:     granulated_workitem_vgpr_count = 1
; GCN-NEXT:     granulated_wavefront_sgpr_count = 1
; GCN-NEXT:     priority = 0
; GCN-NEXT:     float_mode = 192
; GCN-NEXT:     priv = 0
; GCN-NEXT:     enable_dx10_clamp = 1
; GCN-NEXT:     debug_mode = 0
; GCN-NEXT:     enable_ieee_mode = 1
; GCN-NEXT:     enable_sgpr_private_segment_wave_byte_offset = 0
; GCN-NEXT:     user_sgpr_count = 6
; GCN-NEXT:     enable_trap_handler = 0
; GCN-NEXT:     enable_sgpr_workgroup_id_x = 1
; GCN-NEXT:     enable_sgpr_workgroup_id_y = 0
; GCN-NEXT:     enable_sgpr_workgroup_id_z = 0
; GCN-NEXT:     enable_sgpr_workgroup_info = 0
; GCN-NEXT:     enable_vgpr_workitem_id = 0
; GCN-NEXT:     enable_exception_msb = 0
; GCN-NEXT:     granulated_lds_size = 0
; GCN-NEXT:     enable_exception = 0
; GCN-NEXT:     enable_sgpr_private_segment_buffer = 1
; GCN-NEXT:     enable_sgpr_dispatch_ptr = 0
; GCN-NEXT:     enable_sgpr_queue_ptr = 0
; GCN-NEXT:     enable_sgpr_kernarg_segment_ptr = 1
; GCN-NEXT:     enable_sgpr_dispatch_id = 0
; GCN-NEXT:     enable_sgpr_flat_scratch_init = 0
; GCN-NEXT:     enable_sgpr_private_segment_size = 0
; GCN-NEXT:     enable_sgpr_grid_workgroup_count_x = 0
; GCN-NEXT:     enable_sgpr_grid_workgroup_count_y = 0
; GCN-NEXT:     enable_sgpr_grid_workgroup_count_z = 0
; GCN-NEXT:     enable_ordered_append_gds = 0
; GCN-NEXT:     private_element_size = 1
; GCN-NEXT:     is_ptr64 = 1
; GCN-NEXT:     is_dynamic_callstack = 0
; GCN-NEXT:     is_debug_enabled = 0
; GCN-NEXT:     is_xnack_enabled = 0
; GCN-NEXT:     workitem_private_segment_byte_size = 0
; GCN-NEXT:     workgroup_group_segment_byte_size = 0
; GCN-NEXT:     gds_segment_byte_size = 0
; GCN-NEXT:     kernarg_segment_byte_size = 32
; GCN-NEXT:     workgroup_fbarrier_count = 0
; GCN-NEXT:     wavefront_sgpr_count = 16
; GCN-NEXT:     workitem_vgpr_count = 8
; GCN-NEXT:     reserved_vgpr_first = 0
; GCN-NEXT:     reserved_vgpr_count = 0
; GCN-NEXT:     reserved_sgpr_first = 0
; GCN-NEXT:     reserved_sgpr_count = 0
; GCN-NEXT:     debug_wavefront_private_segment_offset_sgpr = 0
; GCN-NEXT:     debug_private_segment_buffer_sgpr = 0
; GCN-NEXT:     kernarg_segment_alignment = 4
; GCN-NEXT:     group_segment_alignment = 4
; GCN-NEXT:     private_segment_alignment = 4
; GCN-NEXT:     wavefront_size = 6
; GCN-NEXT:     call_convention = -1
; GCN-NEXT:     runtime_loader_kernel_symbol = 0
; GCN-NEXT:    .end_amd_kernel_code_t
; GCN-NEXT:  ; %bb.0:
; GCN-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_lshr_b64 s[6:7], s[0:1], s4
; GCN-NEXT:    s_sub_i32 s5, 64, s4
; GCN-NEXT:    s_sub_i32 s12, s4, 64
; GCN-NEXT:    s_ashr_i64 s[8:9], s[2:3], s4
; GCN-NEXT:    s_ashr_i32 s13, s3, 31
; GCN-NEXT:    s_lshl_b64 s[10:11], s[2:3], s5
; GCN-NEXT:    s_ashr_i64 s[2:3], s[2:3], s12
; GCN-NEXT:    s_or_b64 s[6:7], s[6:7], s[10:11]
; GCN-NEXT:    v_mov_b32_e32 v0, s1
; GCN-NEXT:    v_mov_b32_e32 v4, s0
; GCN-NEXT:    v_mov_b32_e32 v2, s13
; GCN-NEXT:    v_mov_b32_e32 v3, s9
; GCN-NEXT:    v_mov_b32_e32 v5, s8
; GCN-NEXT:    v_mov_b32_e32 v1, s3
; GCN-NEXT:    v_mov_b32_e32 v6, s2
; GCN-NEXT:    v_mov_b32_e32 v7, s7
; GCN-NEXT:    v_cmp_lt_u32_e64 vcc, s4, 64
; GCN-NEXT:    v_cndmask_b32_e32 v1, v1, v7, vcc
; GCN-NEXT:    v_mov_b32_e32 v7, s6
; GCN-NEXT:    v_cmp_eq_u32_e64 s[0:1], s4, 0
; GCN-NEXT:    v_cndmask_b32_e64 v1, v1, v0, s[0:1]
; GCN-NEXT:    v_cndmask_b32_e32 v0, v6, v7, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v3, v2, v3, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v2, v2, v5, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v0, v0, v4, s[0:1]
; GCN-NEXT:    v_mov_b32_e32 v4, 0
; GCN-NEXT:    v_mov_b32_e32 v5, 0
; GCN-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GCN-NEXT:    s_endpgm
  %shift = ashr i128 %lhs, %rhs
  store i128 %shift, i128 addrspace(1)* null
  ret void
}

define <2 x i128> @v_shl_v2i128_vv(<2 x i128> %lhs, <2 x i128> %rhs) {
; GCN-LABEL: v_shl_v2i128_vv:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_lshl_b64 v[16:17], v[2:3], v8
; GCN-NEXT:    v_sub_i32_e32 v18, vcc, 64, v8
; GCN-NEXT:    v_lshr_b64 v[18:19], v[0:1], v18
; GCN-NEXT:    v_or_b32_e32 v20, v17, v19
; GCN-NEXT:    v_or_b32_e32 v21, v16, v18
; GCN-NEXT:    v_sub_i32_e32 v16, vcc, 64, v12
; GCN-NEXT:    v_lshr_b64 v[16:17], v[4:5], v16
; GCN-NEXT:    v_lshl_b64 v[18:19], v[6:7], v12
; GCN-NEXT:    v_or_b32_e32 v17, v19, v17
; GCN-NEXT:    v_or_b32_e32 v16, v18, v16
; GCN-NEXT:    v_cmp_eq_u64_e64 s[6:7], 0, v[10:11]
; GCN-NEXT:    v_or_b32_e32 v11, v9, v11
; GCN-NEXT:    v_or_b32_e32 v10, v8, v10
; GCN-NEXT:    v_cmp_eq_u64_e64 s[8:9], 0, v[14:15]
; GCN-NEXT:    v_or_b32_e32 v15, v13, v15
; GCN-NEXT:    v_or_b32_e32 v14, v12, v14
; GCN-NEXT:    v_cmp_gt_u64_e64 s[10:11], 64, v[8:9]
; GCN-NEXT:    v_subrev_i32_e32 v18, vcc, 64, v8
; GCN-NEXT:    v_lshl_b64 v[8:9], v[0:1], v8
; GCN-NEXT:    v_lshl_b64 v[0:1], v[0:1], v18
; GCN-NEXT:    v_cmp_gt_u64_e64 s[12:13], 64, v[12:13]
; GCN-NEXT:    v_subrev_i32_e32 v18, vcc, 64, v12
; GCN-NEXT:    v_lshl_b64 v[12:13], v[4:5], v12
; GCN-NEXT:    v_lshl_b64 v[4:5], v[4:5], v18
; GCN-NEXT:    s_and_b64 vcc, s[6:7], s[10:11]
; GCN-NEXT:    v_cndmask_b32_e32 v18, v1, v20, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v19, v0, v21, vcc
; GCN-NEXT:    s_and_b64 s[6:7], s[8:9], s[12:13]
; GCN-NEXT:    v_cndmask_b32_e64 v17, v5, v17, s[6:7]
; GCN-NEXT:    v_cndmask_b32_e64 v4, v4, v16, s[6:7]
; GCN-NEXT:    v_cndmask_b32_e32 v1, 0, v9, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v0, 0, v8, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v5, 0, v13, s[6:7]
; GCN-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[10:11]
; GCN-NEXT:    v_cndmask_b32_e32 v3, v18, v3, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v2, v19, v2, vcc
; GCN-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[14:15]
; GCN-NEXT:    v_cndmask_b32_e32 v7, v17, v7, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v6, v4, v6, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v4, 0, v12, s[6:7]
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %shl = shl <2 x i128> %lhs, %rhs
  ret <2 x i128> %shl
}

define <2 x i128> @v_lshr_v2i128_vv(<2 x i128> %lhs, <2 x i128> %rhs) {
; GCN-LABEL: v_lshr_v2i128_vv:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_lshr_b64 v[16:17], v[0:1], v8
; GCN-NEXT:    v_sub_i32_e32 v18, vcc, 64, v8
; GCN-NEXT:    v_lshl_b64 v[18:19], v[2:3], v18
; GCN-NEXT:    v_or_b32_e32 v20, v17, v19
; GCN-NEXT:    v_or_b32_e32 v21, v16, v18
; GCN-NEXT:    v_sub_i32_e32 v16, vcc, 64, v12
; GCN-NEXT:    v_lshl_b64 v[16:17], v[6:7], v16
; GCN-NEXT:    v_lshr_b64 v[18:19], v[4:5], v12
; GCN-NEXT:    v_or_b32_e32 v17, v19, v17
; GCN-NEXT:    v_or_b32_e32 v16, v18, v16
; GCN-NEXT:    v_cmp_eq_u64_e64 s[6:7], 0, v[10:11]
; GCN-NEXT:    v_or_b32_e32 v11, v9, v11
; GCN-NEXT:    v_or_b32_e32 v10, v8, v10
; GCN-NEXT:    v_cmp_eq_u64_e64 s[8:9], 0, v[14:15]
; GCN-NEXT:    v_or_b32_e32 v15, v13, v15
; GCN-NEXT:    v_or_b32_e32 v14, v12, v14
; GCN-NEXT:    v_cmp_gt_u64_e64 s[10:11], 64, v[8:9]
; GCN-NEXT:    v_subrev_i32_e32 v18, vcc, 64, v8
; GCN-NEXT:    v_lshr_b64 v[8:9], v[2:3], v8
; GCN-NEXT:    v_lshr_b64 v[2:3], v[2:3], v18
; GCN-NEXT:    v_cmp_gt_u64_e64 s[12:13], 64, v[12:13]
; GCN-NEXT:    v_subrev_i32_e32 v18, vcc, 64, v12
; GCN-NEXT:    v_lshr_b64 v[12:13], v[6:7], v12
; GCN-NEXT:    v_lshr_b64 v[6:7], v[6:7], v18
; GCN-NEXT:    s_and_b64 vcc, s[6:7], s[10:11]
; GCN-NEXT:    v_cndmask_b32_e32 v18, v3, v20, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v19, v2, v21, vcc
; GCN-NEXT:    s_and_b64 s[6:7], s[8:9], s[12:13]
; GCN-NEXT:    v_cndmask_b32_e64 v17, v7, v17, s[6:7]
; GCN-NEXT:    v_cndmask_b32_e64 v6, v6, v16, s[6:7]
; GCN-NEXT:    v_cndmask_b32_e32 v3, 0, v9, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v2, 0, v8, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v7, 0, v13, s[6:7]
; GCN-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[10:11]
; GCN-NEXT:    v_cndmask_b32_e32 v1, v18, v1, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v0, v19, v0, vcc
; GCN-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[14:15]
; GCN-NEXT:    v_cndmask_b32_e32 v5, v17, v5, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v6, 0, v12, s[6:7]
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %shl = lshr <2 x i128> %lhs, %rhs
  ret <2 x i128> %shl
}

define <2 x i128> @v_ashr_v2i128_vv(<2 x i128> %lhs, <2 x i128> %rhs) {
; GCN-LABEL: v_ashr_v2i128_vv:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_lshr_b64 v[16:17], v[0:1], v8
; GCN-NEXT:    v_sub_i32_e32 v18, vcc, 64, v8
; GCN-NEXT:    v_lshl_b64 v[18:19], v[2:3], v18
; GCN-NEXT:    v_or_b32_e32 v20, v17, v19
; GCN-NEXT:    v_or_b32_e32 v21, v16, v18
; GCN-NEXT:    v_sub_i32_e32 v16, vcc, 64, v12
; GCN-NEXT:    v_lshl_b64 v[16:17], v[6:7], v16
; GCN-NEXT:    v_lshr_b64 v[18:19], v[4:5], v12
; GCN-NEXT:    v_or_b32_e32 v19, v19, v17
; GCN-NEXT:    v_or_b32_e32 v18, v18, v16
; GCN-NEXT:    v_cmp_eq_u64_e64 s[6:7], 0, v[10:11]
; GCN-NEXT:    v_or_b32_e32 v11, v9, v11
; GCN-NEXT:    v_or_b32_e32 v10, v8, v10
; GCN-NEXT:    v_cmp_eq_u64_e64 s[8:9], 0, v[14:15]
; GCN-NEXT:    v_or_b32_e32 v15, v13, v15
; GCN-NEXT:    v_or_b32_e32 v14, v12, v14
; GCN-NEXT:    v_cmp_gt_u64_e64 s[10:11], 64, v[8:9]
; GCN-NEXT:    v_subrev_i32_e32 v9, vcc, 64, v8
; GCN-NEXT:    v_ashr_i64 v[16:17], v[2:3], v9
; GCN-NEXT:    s_and_b64 s[6:7], s[6:7], s[10:11]
; GCN-NEXT:    v_cndmask_b32_e64 v17, v17, v20, s[6:7]
; GCN-NEXT:    v_cndmask_b32_e64 v16, v16, v21, s[6:7]
; GCN-NEXT:    v_cmp_gt_u64_e64 s[10:11], 64, v[12:13]
; GCN-NEXT:    v_ashr_i64 v[8:9], v[2:3], v8
; GCN-NEXT:    v_ashrrev_i32_e32 v20, 31, v3
; GCN-NEXT:    v_subrev_i32_e32 v2, vcc, 64, v12
; GCN-NEXT:    v_ashr_i64 v[12:13], v[6:7], v12
; GCN-NEXT:    v_ashrrev_i32_e32 v21, 31, v7
; GCN-NEXT:    v_ashr_i64 v[2:3], v[6:7], v2
; GCN-NEXT:    s_and_b64 vcc, s[8:9], s[10:11]
; GCN-NEXT:    v_cndmask_b32_e32 v6, v3, v19, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v18, v2, v18, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v3, v20, v9, s[6:7]
; GCN-NEXT:    v_cndmask_b32_e64 v2, v20, v8, s[6:7]
; GCN-NEXT:    v_cndmask_b32_e32 v7, v21, v13, vcc
; GCN-NEXT:    v_cmp_eq_u64_e64 s[6:7], 0, v[10:11]
; GCN-NEXT:    v_cndmask_b32_e64 v1, v17, v1, s[6:7]
; GCN-NEXT:    v_cndmask_b32_e64 v0, v16, v0, s[6:7]
; GCN-NEXT:    v_cmp_eq_u64_e64 s[6:7], 0, v[14:15]
; GCN-NEXT:    v_cndmask_b32_e64 v5, v6, v5, s[6:7]
; GCN-NEXT:    v_cndmask_b32_e64 v4, v18, v4, s[6:7]
; GCN-NEXT:    v_cndmask_b32_e32 v6, v21, v12, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %shl = ashr <2 x i128> %lhs, %rhs
  ret <2 x i128> %shl
}

define amdgpu_kernel void @s_shl_v2i128ss(<2 x i128> %lhs, <2 x i128> %rhs) {
; GCN-LABEL: s_shl_v2i128ss:
; GCN:         .amd_kernel_code_t
; GCN-NEXT:     amd_code_version_major = 1
; GCN-NEXT:     amd_code_version_minor = 2
; GCN-NEXT:     amd_machine_kind = 1
; GCN-NEXT:     amd_machine_version_major = 7
; GCN-NEXT:     amd_machine_version_minor = 0
; GCN-NEXT:     amd_machine_version_stepping = 0
; GCN-NEXT:     kernel_code_entry_byte_offset = 256
; GCN-NEXT:     kernel_code_prefetch_byte_size = 0
; GCN-NEXT:     granulated_workitem_vgpr_count = 3
; GCN-NEXT:     granulated_wavefront_sgpr_count = 4
; GCN-NEXT:     priority = 0
; GCN-NEXT:     float_mode = 192
; GCN-NEXT:     priv = 0
; GCN-NEXT:     enable_dx10_clamp = 1
; GCN-NEXT:     debug_mode = 0
; GCN-NEXT:     enable_ieee_mode = 1
; GCN-NEXT:     enable_sgpr_private_segment_wave_byte_offset = 0
; GCN-NEXT:     user_sgpr_count = 6
; GCN-NEXT:     enable_trap_handler = 0
; GCN-NEXT:     enable_sgpr_workgroup_id_x = 1
; GCN-NEXT:     enable_sgpr_workgroup_id_y = 0
; GCN-NEXT:     enable_sgpr_workgroup_id_z = 0
; GCN-NEXT:     enable_sgpr_workgroup_info = 0
; GCN-NEXT:     enable_vgpr_workitem_id = 0
; GCN-NEXT:     enable_exception_msb = 0
; GCN-NEXT:     granulated_lds_size = 0
; GCN-NEXT:     enable_exception = 0
; GCN-NEXT:     enable_sgpr_private_segment_buffer = 1
; GCN-NEXT:     enable_sgpr_dispatch_ptr = 0
; GCN-NEXT:     enable_sgpr_queue_ptr = 0
; GCN-NEXT:     enable_sgpr_kernarg_segment_ptr = 1
; GCN-NEXT:     enable_sgpr_dispatch_id = 0
; GCN-NEXT:     enable_sgpr_flat_scratch_init = 0
; GCN-NEXT:     enable_sgpr_private_segment_size = 0
; GCN-NEXT:     enable_sgpr_grid_workgroup_count_x = 0
; GCN-NEXT:     enable_sgpr_grid_workgroup_count_y = 0
; GCN-NEXT:     enable_sgpr_grid_workgroup_count_z = 0
; GCN-NEXT:     enable_ordered_append_gds = 0
; GCN-NEXT:     private_element_size = 1
; GCN-NEXT:     is_ptr64 = 1
; GCN-NEXT:     is_dynamic_callstack = 0
; GCN-NEXT:     is_debug_enabled = 0
; GCN-NEXT:     is_xnack_enabled = 0
; GCN-NEXT:     workitem_private_segment_byte_size = 0
; GCN-NEXT:     workgroup_group_segment_byte_size = 0
; GCN-NEXT:     gds_segment_byte_size = 0
; GCN-NEXT:     kernarg_segment_byte_size = 64
; GCN-NEXT:     workgroup_fbarrier_count = 0
; GCN-NEXT:     wavefront_sgpr_count = 36
; GCN-NEXT:     workitem_vgpr_count = 16
; GCN-NEXT:     reserved_vgpr_first = 0
; GCN-NEXT:     reserved_vgpr_count = 0
; GCN-NEXT:     reserved_sgpr_first = 0
; GCN-NEXT:     reserved_sgpr_count = 0
; GCN-NEXT:     debug_wavefront_private_segment_offset_sgpr = 0
; GCN-NEXT:     debug_private_segment_buffer_sgpr = 0
; GCN-NEXT:     kernarg_segment_alignment = 5
; GCN-NEXT:     group_segment_alignment = 4
; GCN-NEXT:     private_segment_alignment = 4
; GCN-NEXT:     wavefront_size = 6
; GCN-NEXT:     call_convention = -1
; GCN-NEXT:     runtime_loader_kernel_symbol = 0
; GCN-NEXT:    .end_amd_kernel_code_t
; GCN-NEXT:  ; %bb.0:
; GCN-NEXT:    s_load_dwordx8 s[12:19], s[4:5], 0x8
; GCN-NEXT:    s_load_dwordx8 s[4:11], s[4:5], 0x0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_cmp_lt_u64_e64 s[0:1], s[12:13], 64
; GCN-NEXT:    v_cmp_eq_u64_e64 s[2:3], s[14:15], 0
; GCN-NEXT:    s_lshl_b64 s[20:21], s[4:5], s12
; GCN-NEXT:    s_lshl_b64 s[22:23], s[6:7], s12
; GCN-NEXT:    s_sub_i32 s30, 64, s12
; GCN-NEXT:    s_sub_i32 s31, s12, 64
; GCN-NEXT:    s_sub_i32 s32, 64, s16
; GCN-NEXT:    s_sub_i32 s33, s16, 64
; GCN-NEXT:    s_or_b64 s[12:13], s[12:13], s[14:15]
; GCN-NEXT:    v_cmp_lt_u64_e64 s[14:15], s[16:17], 64
; GCN-NEXT:    v_cmp_eq_u64_e64 s[24:25], s[18:19], 0
; GCN-NEXT:    s_lshl_b64 s[26:27], s[8:9], s16
; GCN-NEXT:    s_lshl_b64 s[28:29], s[10:11], s16
; GCN-NEXT:    s_or_b64 s[16:17], s[16:17], s[18:19]
; GCN-NEXT:    v_mov_b32_e32 v0, s21
; GCN-NEXT:    v_mov_b32_e32 v2, s20
; GCN-NEXT:    s_and_b64 vcc, s[2:3], s[0:1]
; GCN-NEXT:    v_mov_b32_e32 v8, 0
; GCN-NEXT:    v_mov_b32_e32 v9, 0
; GCN-NEXT:    v_mov_b32_e32 v10, 16
; GCN-NEXT:    v_mov_b32_e32 v11, 0
; GCN-NEXT:    v_mov_b32_e32 v3, s7
; GCN-NEXT:    v_mov_b32_e32 v6, s6
; GCN-NEXT:    v_mov_b32_e32 v7, s11
; GCN-NEXT:    v_cndmask_b32_e32 v1, 0, v0, vcc
; GCN-NEXT:    v_mov_b32_e32 v0, s27
; GCN-NEXT:    s_and_b64 s[0:1], s[24:25], s[14:15]
; GCN-NEXT:    s_lshr_b64 s[2:3], s[4:5], s30
; GCN-NEXT:    s_lshl_b64 s[4:5], s[4:5], s31
; GCN-NEXT:    v_cndmask_b32_e64 v5, 0, v0, s[0:1]
; GCN-NEXT:    v_mov_b32_e32 v4, s26
; GCN-NEXT:    s_lshr_b64 s[6:7], s[8:9], s32
; GCN-NEXT:    s_lshl_b64 s[8:9], s[8:9], s33
; GCN-NEXT:    v_cndmask_b32_e32 v0, 0, v2, vcc
; GCN-NEXT:    s_or_b64 s[2:3], s[22:23], s[2:3]
; GCN-NEXT:    v_mov_b32_e32 v2, s5
; GCN-NEXT:    v_mov_b32_e32 v12, s4
; GCN-NEXT:    v_cndmask_b32_e64 v4, 0, v4, s[0:1]
; GCN-NEXT:    s_or_b64 s[4:5], s[28:29], s[6:7]
; GCN-NEXT:    v_mov_b32_e32 v13, s9
; GCN-NEXT:    v_mov_b32_e32 v14, s8
; GCN-NEXT:    v_mov_b32_e32 v15, s3
; GCN-NEXT:    v_cndmask_b32_e32 v2, v2, v15, vcc
; GCN-NEXT:    v_mov_b32_e32 v15, s2
; GCN-NEXT:    v_cndmask_b32_e32 v12, v12, v15, vcc
; GCN-NEXT:    v_mov_b32_e32 v15, s5
; GCN-NEXT:    v_cndmask_b32_e64 v13, v13, v15, s[0:1]
; GCN-NEXT:    v_mov_b32_e32 v15, s4
; GCN-NEXT:    v_cndmask_b32_e64 v14, v14, v15, s[0:1]
; GCN-NEXT:    v_mov_b32_e32 v15, s10
; GCN-NEXT:    v_cmp_eq_u64_e64 vcc, s[12:13], 0
; GCN-NEXT:    v_cndmask_b32_e32 v3, v2, v3, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v2, v12, v6, vcc
; GCN-NEXT:    v_cmp_eq_u64_e64 vcc, s[16:17], 0
; GCN-NEXT:    v_cndmask_b32_e32 v7, v13, v7, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v6, v14, v15, vcc
; GCN-NEXT:    flat_store_dwordx4 v[8:9], v[0:3]
; GCN-NEXT:    flat_store_dwordx4 v[10:11], v[4:7]
; GCN-NEXT:    s_endpgm
  %shift = shl <2 x i128> %lhs, %rhs
  store <2 x i128> %shift, <2 x i128> addrspace(1)* null
  ret void
}

define amdgpu_kernel void @s_lshr_v2i128_ss(<2 x i128> %lhs, <2 x i128> %rhs) {
; GCN-LABEL: s_lshr_v2i128_ss:
; GCN:         .amd_kernel_code_t
; GCN-NEXT:     amd_code_version_major = 1
; GCN-NEXT:     amd_code_version_minor = 2
; GCN-NEXT:     amd_machine_kind = 1
; GCN-NEXT:     amd_machine_version_major = 7
; GCN-NEXT:     amd_machine_version_minor = 0
; GCN-NEXT:     amd_machine_version_stepping = 0
; GCN-NEXT:     kernel_code_entry_byte_offset = 256
; GCN-NEXT:     kernel_code_prefetch_byte_size = 0
; GCN-NEXT:     granulated_workitem_vgpr_count = 4
; GCN-NEXT:     granulated_wavefront_sgpr_count = 4
; GCN-NEXT:     priority = 0
; GCN-NEXT:     float_mode = 192
; GCN-NEXT:     priv = 0
; GCN-NEXT:     enable_dx10_clamp = 1
; GCN-NEXT:     debug_mode = 0
; GCN-NEXT:     enable_ieee_mode = 1
; GCN-NEXT:     enable_sgpr_private_segment_wave_byte_offset = 0
; GCN-NEXT:     user_sgpr_count = 6
; GCN-NEXT:     enable_trap_handler = 0
; GCN-NEXT:     enable_sgpr_workgroup_id_x = 1
; GCN-NEXT:     enable_sgpr_workgroup_id_y = 0
; GCN-NEXT:     enable_sgpr_workgroup_id_z = 0
; GCN-NEXT:     enable_sgpr_workgroup_info = 0
; GCN-NEXT:     enable_vgpr_workitem_id = 0
; GCN-NEXT:     enable_exception_msb = 0
; GCN-NEXT:     granulated_lds_size = 0
; GCN-NEXT:     enable_exception = 0
; GCN-NEXT:     enable_sgpr_private_segment_buffer = 1
; GCN-NEXT:     enable_sgpr_dispatch_ptr = 0
; GCN-NEXT:     enable_sgpr_queue_ptr = 0
; GCN-NEXT:     enable_sgpr_kernarg_segment_ptr = 1
; GCN-NEXT:     enable_sgpr_dispatch_id = 0
; GCN-NEXT:     enable_sgpr_flat_scratch_init = 0
; GCN-NEXT:     enable_sgpr_private_segment_size = 0
; GCN-NEXT:     enable_sgpr_grid_workgroup_count_x = 0
; GCN-NEXT:     enable_sgpr_grid_workgroup_count_y = 0
; GCN-NEXT:     enable_sgpr_grid_workgroup_count_z = 0
; GCN-NEXT:     enable_ordered_append_gds = 0
; GCN-NEXT:     private_element_size = 1
; GCN-NEXT:     is_ptr64 = 1
; GCN-NEXT:     is_dynamic_callstack = 0
; GCN-NEXT:     is_debug_enabled = 0
; GCN-NEXT:     is_xnack_enabled = 0
; GCN-NEXT:     workitem_private_segment_byte_size = 0
; GCN-NEXT:     workgroup_group_segment_byte_size = 0
; GCN-NEXT:     gds_segment_byte_size = 0
; GCN-NEXT:     kernarg_segment_byte_size = 64
; GCN-NEXT:     workgroup_fbarrier_count = 0
; GCN-NEXT:     wavefront_sgpr_count = 36
; GCN-NEXT:     workitem_vgpr_count = 17
; GCN-NEXT:     reserved_vgpr_first = 0
; GCN-NEXT:     reserved_vgpr_count = 0
; GCN-NEXT:     reserved_sgpr_first = 0
; GCN-NEXT:     reserved_sgpr_count = 0
; GCN-NEXT:     debug_wavefront_private_segment_offset_sgpr = 0
; GCN-NEXT:     debug_private_segment_buffer_sgpr = 0
; GCN-NEXT:     kernarg_segment_alignment = 5
; GCN-NEXT:     group_segment_alignment = 4
; GCN-NEXT:     private_segment_alignment = 4
; GCN-NEXT:     wavefront_size = 6
; GCN-NEXT:     call_convention = -1
; GCN-NEXT:     runtime_loader_kernel_symbol = 0
; GCN-NEXT:    .end_amd_kernel_code_t
; GCN-NEXT:  ; %bb.0:
; GCN-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x8
; GCN-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_cmp_lt_u64_e64 s[16:17], s[8:9], 64
; GCN-NEXT:    v_cmp_eq_u64_e64 s[18:19], s[10:11], 0
; GCN-NEXT:    s_lshr_b64 s[20:21], s[2:3], s8
; GCN-NEXT:    s_lshr_b64 s[22:23], s[0:1], s8
; GCN-NEXT:    s_sub_i32 s30, 64, s8
; GCN-NEXT:    s_sub_i32 s31, s8, 64
; GCN-NEXT:    s_sub_i32 s32, 64, s12
; GCN-NEXT:    s_sub_i32 s33, s12, 64
; GCN-NEXT:    s_or_b64 s[8:9], s[8:9], s[10:11]
; GCN-NEXT:    v_cmp_lt_u64_e64 s[10:11], s[12:13], 64
; GCN-NEXT:    v_cmp_eq_u64_e64 s[24:25], s[14:15], 0
; GCN-NEXT:    s_lshr_b64 s[26:27], s[6:7], s12
; GCN-NEXT:    s_lshr_b64 s[28:29], s[4:5], s12
; GCN-NEXT:    s_or_b64 s[12:13], s[12:13], s[14:15]
; GCN-NEXT:    v_mov_b32_e32 v0, s21
; GCN-NEXT:    v_mov_b32_e32 v1, s20
; GCN-NEXT:    s_and_b64 vcc, s[18:19], s[16:17]
; GCN-NEXT:    v_mov_b32_e32 v8, 0
; GCN-NEXT:    v_mov_b32_e32 v9, 0
; GCN-NEXT:    v_mov_b32_e32 v10, 16
; GCN-NEXT:    v_mov_b32_e32 v11, 0
; GCN-NEXT:    v_mov_b32_e32 v4, s1
; GCN-NEXT:    v_mov_b32_e32 v5, s0
; GCN-NEXT:    v_mov_b32_e32 v12, s5
; GCN-NEXT:    v_cndmask_b32_e32 v3, 0, v0, vcc
; GCN-NEXT:    v_mov_b32_e32 v0, s27
; GCN-NEXT:    s_and_b64 s[0:1], s[24:25], s[10:11]
; GCN-NEXT:    s_lshl_b64 s[10:11], s[2:3], s30
; GCN-NEXT:    s_lshr_b64 s[2:3], s[2:3], s31
; GCN-NEXT:    v_cndmask_b32_e64 v7, 0, v0, s[0:1]
; GCN-NEXT:    v_mov_b32_e32 v0, s26
; GCN-NEXT:    s_lshl_b64 s[14:15], s[6:7], s32
; GCN-NEXT:    s_lshr_b64 s[6:7], s[6:7], s33
; GCN-NEXT:    v_cndmask_b32_e32 v2, 0, v1, vcc
; GCN-NEXT:    s_or_b64 s[10:11], s[22:23], s[10:11]
; GCN-NEXT:    v_mov_b32_e32 v1, s3
; GCN-NEXT:    v_mov_b32_e32 v13, s2
; GCN-NEXT:    v_cndmask_b32_e64 v6, 0, v0, s[0:1]
; GCN-NEXT:    s_or_b64 s[2:3], s[28:29], s[14:15]
; GCN-NEXT:    v_mov_b32_e32 v0, s7
; GCN-NEXT:    v_mov_b32_e32 v14, s6
; GCN-NEXT:    v_mov_b32_e32 v15, s11
; GCN-NEXT:    v_cndmask_b32_e32 v1, v1, v15, vcc
; GCN-NEXT:    v_mov_b32_e32 v15, s10
; GCN-NEXT:    v_cndmask_b32_e32 v13, v13, v15, vcc
; GCN-NEXT:    v_mov_b32_e32 v15, s3
; GCN-NEXT:    v_cndmask_b32_e64 v15, v0, v15, s[0:1]
; GCN-NEXT:    v_mov_b32_e32 v0, s2
; GCN-NEXT:    v_cndmask_b32_e64 v14, v14, v0, s[0:1]
; GCN-NEXT:    v_mov_b32_e32 v16, s4
; GCN-NEXT:    v_cmp_eq_u64_e64 vcc, s[8:9], 0
; GCN-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v0, v13, v5, vcc
; GCN-NEXT:    v_cmp_eq_u64_e64 vcc, s[12:13], 0
; GCN-NEXT:    v_cndmask_b32_e32 v5, v15, v12, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v4, v14, v16, vcc
; GCN-NEXT:    flat_store_dwordx4 v[8:9], v[0:3]
; GCN-NEXT:    flat_store_dwordx4 v[10:11], v[4:7]
; GCN-NEXT:    s_endpgm
  %shift = lshr <2 x i128> %lhs, %rhs
  store <2 x i128> %shift, <2 x i128> addrspace(1)* null
  ret void
}

define amdgpu_kernel void @s_ashr_v2i128_ss(<2 x i128> %lhs, <2 x i128> %rhs) {
; GCN-LABEL: s_ashr_v2i128_ss:
; GCN:         .amd_kernel_code_t
; GCN-NEXT:     amd_code_version_major = 1
; GCN-NEXT:     amd_code_version_minor = 2
; GCN-NEXT:     amd_machine_kind = 1
; GCN-NEXT:     amd_machine_version_major = 7
; GCN-NEXT:     amd_machine_version_minor = 0
; GCN-NEXT:     amd_machine_version_stepping = 0
; GCN-NEXT:     kernel_code_entry_byte_offset = 256
; GCN-NEXT:     kernel_code_prefetch_byte_size = 0
; GCN-NEXT:     granulated_workitem_vgpr_count = 4
; GCN-NEXT:     granulated_wavefront_sgpr_count = 4
; GCN-NEXT:     priority = 0
; GCN-NEXT:     float_mode = 192
; GCN-NEXT:     priv = 0
; GCN-NEXT:     enable_dx10_clamp = 1
; GCN-NEXT:     debug_mode = 0
; GCN-NEXT:     enable_ieee_mode = 1
; GCN-NEXT:     enable_sgpr_private_segment_wave_byte_offset = 0
; GCN-NEXT:     user_sgpr_count = 6
; GCN-NEXT:     enable_trap_handler = 0
; GCN-NEXT:     enable_sgpr_workgroup_id_x = 1
; GCN-NEXT:     enable_sgpr_workgroup_id_y = 0
; GCN-NEXT:     enable_sgpr_workgroup_id_z = 0
; GCN-NEXT:     enable_sgpr_workgroup_info = 0
; GCN-NEXT:     enable_vgpr_workitem_id = 0
; GCN-NEXT:     enable_exception_msb = 0
; GCN-NEXT:     granulated_lds_size = 0
; GCN-NEXT:     enable_exception = 0
; GCN-NEXT:     enable_sgpr_private_segment_buffer = 1
; GCN-NEXT:     enable_sgpr_dispatch_ptr = 0
; GCN-NEXT:     enable_sgpr_queue_ptr = 0
; GCN-NEXT:     enable_sgpr_kernarg_segment_ptr = 1
; GCN-NEXT:     enable_sgpr_dispatch_id = 0
; GCN-NEXT:     enable_sgpr_flat_scratch_init = 0
; GCN-NEXT:     enable_sgpr_private_segment_size = 0
; GCN-NEXT:     enable_sgpr_grid_workgroup_count_x = 0
; GCN-NEXT:     enable_sgpr_grid_workgroup_count_y = 0
; GCN-NEXT:     enable_sgpr_grid_workgroup_count_z = 0
; GCN-NEXT:     enable_ordered_append_gds = 0
; GCN-NEXT:     private_element_size = 1
; GCN-NEXT:     is_ptr64 = 1
; GCN-NEXT:     is_dynamic_callstack = 0
; GCN-NEXT:     is_debug_enabled = 0
; GCN-NEXT:     is_xnack_enabled = 0
; GCN-NEXT:     workitem_private_segment_byte_size = 0
; GCN-NEXT:     workgroup_group_segment_byte_size = 0
; GCN-NEXT:     gds_segment_byte_size = 0
; GCN-NEXT:     kernarg_segment_byte_size = 64
; GCN-NEXT:     workgroup_fbarrier_count = 0
; GCN-NEXT:     wavefront_sgpr_count = 37
; GCN-NEXT:     workitem_vgpr_count = 17
; GCN-NEXT:     reserved_vgpr_first = 0
; GCN-NEXT:     reserved_vgpr_count = 0
; GCN-NEXT:     reserved_sgpr_first = 0
; GCN-NEXT:     reserved_sgpr_count = 0
; GCN-NEXT:     debug_wavefront_private_segment_offset_sgpr = 0
; GCN-NEXT:     debug_private_segment_buffer_sgpr = 0
; GCN-NEXT:     kernarg_segment_alignment = 5
; GCN-NEXT:     group_segment_alignment = 4
; GCN-NEXT:     private_segment_alignment = 4
; GCN-NEXT:     wavefront_size = 6
; GCN-NEXT:     call_convention = -1
; GCN-NEXT:     runtime_loader_kernel_symbol = 0
; GCN-NEXT:    .end_amd_kernel_code_t
; GCN-NEXT:  ; %bb.0:
; GCN-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x8
; GCN-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_cmp_lt_u64_e64 s[16:17], s[8:9], 64
; GCN-NEXT:    v_cmp_eq_u64_e64 s[18:19], s[10:11], 0
; GCN-NEXT:    s_ashr_i64 s[20:21], s[2:3], s8
; GCN-NEXT:    s_ashr_i32 s30, s3, 31
; GCN-NEXT:    s_lshr_b64 s[22:23], s[0:1], s8
; GCN-NEXT:    s_sub_i32 s31, 64, s8
; GCN-NEXT:    s_sub_i32 s32, s8, 64
; GCN-NEXT:    s_sub_i32 s33, 64, s12
; GCN-NEXT:    s_sub_i32 s34, s12, 64
; GCN-NEXT:    s_or_b64 s[8:9], s[8:9], s[10:11]
; GCN-NEXT:    v_cmp_lt_u64_e64 s[10:11], s[12:13], 64
; GCN-NEXT:    v_cmp_eq_u64_e64 s[24:25], s[14:15], 0
; GCN-NEXT:    s_ashr_i64 s[26:27], s[6:7], s12
; GCN-NEXT:    s_lshr_b64 s[28:29], s[4:5], s12
; GCN-NEXT:    s_or_b64 s[12:13], s[12:13], s[14:15]
; GCN-NEXT:    v_mov_b32_e32 v0, s21
; GCN-NEXT:    v_mov_b32_e32 v1, s20
; GCN-NEXT:    v_mov_b32_e32 v2, s30
; GCN-NEXT:    s_ashr_i32 s14, s7, 31
; GCN-NEXT:    s_and_b64 vcc, s[18:19], s[16:17]
; GCN-NEXT:    v_mov_b32_e32 v4, s14
; GCN-NEXT:    v_mov_b32_e32 v8, 0
; GCN-NEXT:    v_mov_b32_e32 v9, 0
; GCN-NEXT:    v_mov_b32_e32 v10, 16
; GCN-NEXT:    v_mov_b32_e32 v11, 0
; GCN-NEXT:    v_mov_b32_e32 v5, s1
; GCN-NEXT:    v_mov_b32_e32 v12, s0
; GCN-NEXT:    v_mov_b32_e32 v13, s5
; GCN-NEXT:    v_cndmask_b32_e32 v3, v2, v0, vcc
; GCN-NEXT:    v_mov_b32_e32 v0, s27
; GCN-NEXT:    s_and_b64 s[0:1], s[24:25], s[10:11]
; GCN-NEXT:    s_lshl_b64 s[10:11], s[2:3], s31
; GCN-NEXT:    s_ashr_i64 s[2:3], s[2:3], s32
; GCN-NEXT:    v_cndmask_b32_e64 v7, v4, v0, s[0:1]
; GCN-NEXT:    v_mov_b32_e32 v0, s26
; GCN-NEXT:    s_lshl_b64 s[14:15], s[6:7], s33
; GCN-NEXT:    s_ashr_i64 s[6:7], s[6:7], s34
; GCN-NEXT:    v_cndmask_b32_e32 v2, v2, v1, vcc
; GCN-NEXT:    s_or_b64 s[10:11], s[22:23], s[10:11]
; GCN-NEXT:    v_mov_b32_e32 v1, s3
; GCN-NEXT:    v_mov_b32_e32 v14, s2
; GCN-NEXT:    v_cndmask_b32_e64 v6, v4, v0, s[0:1]
; GCN-NEXT:    s_or_b64 s[2:3], s[28:29], s[14:15]
; GCN-NEXT:    v_mov_b32_e32 v0, s7
; GCN-NEXT:    v_mov_b32_e32 v4, s6
; GCN-NEXT:    v_mov_b32_e32 v15, s11
; GCN-NEXT:    v_cndmask_b32_e32 v1, v1, v15, vcc
; GCN-NEXT:    v_mov_b32_e32 v15, s10
; GCN-NEXT:    v_cndmask_b32_e32 v14, v14, v15, vcc
; GCN-NEXT:    v_mov_b32_e32 v15, s3
; GCN-NEXT:    v_cndmask_b32_e64 v15, v0, v15, s[0:1]
; GCN-NEXT:    v_mov_b32_e32 v0, s2
; GCN-NEXT:    v_cndmask_b32_e64 v4, v4, v0, s[0:1]
; GCN-NEXT:    v_mov_b32_e32 v16, s4
; GCN-NEXT:    v_cmp_eq_u64_e64 vcc, s[8:9], 0
; GCN-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v0, v14, v12, vcc
; GCN-NEXT:    v_cmp_eq_u64_e64 vcc, s[12:13], 0
; GCN-NEXT:    v_cndmask_b32_e32 v5, v15, v13, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v4, v4, v16, vcc
; GCN-NEXT:    flat_store_dwordx4 v[8:9], v[0:3]
; GCN-NEXT:    flat_store_dwordx4 v[10:11], v[4:7]
; GCN-NEXT:    s_endpgm
  %shift = ashr <2 x i128> %lhs, %rhs
  store <2 x i128> %shift, <2 x i128> addrspace(1)* null
  ret void
}

