/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSInt8Array.h"

#include "ExceptionCode.h"
#include "Int8Array.h"
#include "JSDOMBinding.h"
#include "JSInt8Array.h"
#include <runtime/Error.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSInt8Array);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSInt8ArrayTableValues[3] =
{
    { "length", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInt8ArrayLength), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInt8ArrayConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSInt8ArrayTable = { 5, 3, JSInt8ArrayTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSInt8ArrayConstructorTableValues[2] =
{
    { "BYTES_PER_ELEMENT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInt8ArrayBYTES_PER_ELEMENT), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSInt8ArrayConstructorTable = { 2, 1, JSInt8ArrayConstructorTableValues, 0 };
const ClassInfo JSInt8ArrayConstructor::s_info = { "Int8ArrayConstructor", &DOMConstructorObject::s_info, &JSInt8ArrayConstructorTable, 0 };

JSInt8ArrayConstructor::JSInt8ArrayConstructor(ExecState* exec, Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSInt8ArrayPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSInt8ArrayConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSInt8ArrayConstructor, JSDOMWrapper>(exec, &JSInt8ArrayConstructorTable, this, propertyName, slot);
}

bool JSInt8ArrayConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSInt8ArrayConstructor, JSDOMWrapper>(exec, &JSInt8ArrayConstructorTable, this, propertyName, descriptor);
}

ConstructType JSInt8ArrayConstructor::getConstructData(ConstructData& constructData)
{
    constructData.native.function = constructJSInt8Array;
    return ConstructTypeHost;
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSInt8ArrayPrototypeTableValues[4] =
{
    { "BYTES_PER_ELEMENT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInt8ArrayBYTES_PER_ELEMENT), (intptr_t)0 THUNK_GENERATOR(0) },
    { "subarray", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInt8ArrayPrototypeFunctionSubarray), (intptr_t)2 THUNK_GENERATOR(0) },
    { "set", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsInt8ArrayPrototypeFunctionSet), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSInt8ArrayPrototypeTable = { 8, 7, JSInt8ArrayPrototypeTableValues, 0 };
static const HashTable* getJSInt8ArrayPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSInt8ArrayPrototypeTable);
}

const ClassInfo JSInt8ArrayPrototype::s_info = { "Int8ArrayPrototype", &JSC::JSObjectWithGlobalObject::s_info, 0, getJSInt8ArrayPrototypeTable };

JSObject* JSInt8ArrayPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSInt8Array>(exec, globalObject);
}

bool JSInt8ArrayPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSInt8ArrayPrototype, JSObject>(exec, getJSInt8ArrayPrototypeTable(exec), this, propertyName, slot);
}

bool JSInt8ArrayPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticPropertyDescriptor<JSInt8ArrayPrototype, JSObject>(exec, getJSInt8ArrayPrototypeTable(exec), this, propertyName, descriptor);
}

static const HashTable* getJSInt8ArrayTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSInt8ArrayTable);
}

const ClassInfo JSInt8Array::s_info = { "Int8Array", &JSArrayBufferView::s_info, 0, getJSInt8ArrayTable };

JSInt8Array::JSInt8Array(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<Int8Array> impl)
    : JSArrayBufferView(structure, globalObject, impl)
{
    ASSERT(inherits(&s_info));
}

JSObject* JSInt8Array::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSInt8ArrayPrototype(exec->globalData(), globalObject, JSInt8ArrayPrototype::createStructure(exec->globalData(), JSArrayBufferViewPrototype::self(exec, globalObject)));
}

bool JSInt8Array::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    bool ok;
    unsigned index = propertyName.toUInt32(ok);
    if (ok && index < static_cast<Int8Array*>(impl())->length()) {
        slot.setValue(getByIndex(exec, index));
        return true;
    }
    return getStaticValueSlot<JSInt8Array, Base>(exec, getJSInt8ArrayTable(exec), this, propertyName, slot);
}

bool JSInt8Array::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    bool ok;
    unsigned index = propertyName.toUInt32(ok);
    if (ok && index < static_cast<Int8Array*>(impl())->length()) {
        descriptor.setDescriptor(getByIndex(exec, index), DontDelete);
        return true;
    }
    return getStaticValueDescriptor<JSInt8Array, Base>(exec, getJSInt8ArrayTable(exec), this, propertyName, descriptor);
}

bool JSInt8Array::getOwnPropertySlot(ExecState* exec, unsigned propertyName, PropertySlot& slot)
{
    if (propertyName < static_cast<Int8Array*>(impl())->length()) {
        slot.setValue(getByIndex(exec, propertyName));
        return true;
    }
    return getOwnPropertySlot(exec, Identifier::from(exec, propertyName), slot);
}

JSValue jsInt8ArrayLength(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSInt8Array* castedThis = static_cast<JSInt8Array*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Int8Array* imp = static_cast<Int8Array*>(castedThis->impl());
    JSValue result = jsNumber(imp->length());
    return result;
}


JSValue jsInt8ArrayConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSInt8Array* domObject = static_cast<JSInt8Array*>(asObject(slotBase));
    return JSInt8Array::getConstructor(exec, domObject->globalObject());
}

void JSInt8Array::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    bool ok;
    unsigned index = propertyName.toUInt32(ok);
    if (ok) {
        indexSetter(exec, index, value);
        return;
    }
    Base::put(exec, propertyName, value, slot);
}

void JSInt8Array::put(ExecState* exec, unsigned propertyName, JSValue value)
{
    indexSetter(exec, propertyName, value);
    return;
}

void JSInt8Array::getOwnPropertyNames(ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    for (unsigned i = 0; i < static_cast<Int8Array*>(impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(exec, propertyNames, mode);
}

JSValue JSInt8Array::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSInt8ArrayConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsInt8ArrayPrototypeFunctionSubarray(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInt8Array::s_info))
        return throwVMTypeError(exec);
    JSInt8Array* castedThis = static_cast<JSInt8Array*>(asObject(thisValue));
    Int8Array* imp = static_cast<Int8Array*>(castedThis->impl());
    int start(exec->argument(0).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    int argsCount = exec->argumentCount();
    if (argsCount <= 1) {

        JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->subarray(start)));
        return JSValue::encode(result);
    }

    int end(exec->argument(1).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->subarray(start, end)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInt8ArrayPrototypeFunctionSet(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInt8Array::s_info))
        return throwVMTypeError(exec);
    JSInt8Array* castedThis = static_cast<JSInt8Array*>(asObject(thisValue));
    return JSValue::encode(castedThis->set(exec));
}

// Constant getters

JSValue jsInt8ArrayBYTES_PER_ELEMENT(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}


JSValue JSInt8Array::getByIndex(ExecState*, unsigned index)
{
    return jsNumber(static_cast<Int8Array*>(impl())->item(index));
}

Int8Array* toInt8Array(JSC::JSValue value)
{
    return value.inherits(&JSInt8Array::s_info) ? static_cast<JSInt8Array*>(asObject(value))->impl() : 0;
}

}
