/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.server.repository.namespaces;

import info.aduna.io.IOUtil;
import info.aduna.webapp.views.EmptySuccessView;
import info.aduna.webapp.views.SimpleResponseView;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openrdf.http.server.ClientHTTPException;
import org.openrdf.http.server.ServerHTTPException;
import org.openrdf.http.server.repository.RepositoryInterceptor;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractController;

public class NamespaceController
extends AbstractController {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public NamespaceController() throws ApplicationContextException {
        this.setSupportedMethods(new String[]{"GET", "PUT", "DELETE"});
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String pathInfoStr = request.getPathInfo();
        String[] pathInfo = pathInfoStr.substring(1).split("/");
        String prefix = pathInfo[pathInfo.length - 1];
        RepositoryConnection repositoryCon = RepositoryInterceptor.getRepositoryConnection(request);
        String reqMethod = request.getMethod();
        if ("GET".equals(reqMethod)) {
            this.logger.info("GET namespace for prefix {}", (Object)prefix);
            return this.getExportNamespaceResult(repositoryCon, prefix);
        }
        if ("PUT".equals(reqMethod)) {
            this.logger.info("PUT prefix {}", (Object)prefix);
            return this.getUpdateNamespaceResult(repositoryCon, prefix, request);
        }
        if ("DELETE".equals(reqMethod)) {
            this.logger.info("DELETE prefix {}", (Object)prefix);
            return this.getRemoveNamespaceResult(repositoryCon, prefix);
        }
        throw new ServerHTTPException("Unexpected request method: " + reqMethod);
    }

    private ModelAndView getExportNamespaceResult(RepositoryConnection repositoryCon, String prefix) throws ServerHTTPException, ClientHTTPException {
        try {
            String namespace = repositoryCon.getNamespace(prefix);
            if (namespace == null) {
                throw new ClientHTTPException(404, "Undefined prefix: " + prefix);
            }
            HashMap<String, String> model = new HashMap<String, String>();
            model.put("content", namespace);
            return new ModelAndView((View)SimpleResponseView.getInstance(), model);
        }
        catch (RepositoryException e) {
            throw new ServerHTTPException("Repository error: " + e.getMessage(), (Throwable)e);
        }
    }

    private ModelAndView getUpdateNamespaceResult(RepositoryConnection repositoryCon, String prefix, HttpServletRequest request) throws IOException, ClientHTTPException, ServerHTTPException {
        String namespace = IOUtil.readString(request.getReader());
        if ((namespace = namespace.trim()).length() == 0) {
            throw new ClientHTTPException(400, "No namespace name found in request body");
        }
        try {
            repositoryCon.setNamespace(prefix, namespace);
        }
        catch (RepositoryException e) {
            throw new ServerHTTPException("Repository error: " + e.getMessage(), (Throwable)e);
        }
        return new ModelAndView((View)EmptySuccessView.getInstance());
    }

    private ModelAndView getRemoveNamespaceResult(RepositoryConnection repositoryCon, String prefix) throws ServerHTTPException {
        try {
            repositoryCon.removeNamespace(prefix);
        }
        catch (RepositoryException e) {
            throw new ServerHTTPException("Repository error: " + e.getMessage(), (Throwable)e);
        }
        return new ModelAndView((View)EmptySuccessView.getInstance());
    }
}

