/*
 * Header file for hardcoded AAC cube-root table
 *
 * Copyright (c) 2010 Reimar Döffinger <Reimar.Doeffinger@gmx.de>
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef AVCODEC_CBRT_TABLEGEN_H
#define AVCODEC_CBRT_TABLEGEN_H

#include <stdint.h>
#include <math.h>
#include "libavutil/attributes.h"
#include "libavcodec/aac_defines.h"

#if USE_FIXED
#define CBRT(x) (int)floor((x).f * 8192 + 0.5)
#else
#define CBRT(x) x.i
#endif

#if CONFIG_HARDCODED_TABLES
#if USE_FIXED
#define cbrt_tableinit_fixed()
#include "libavcodec/cbrt_fixed_tables.h"
#else
#define cbrt_tableinit()
#include "libavcodec/cbrt_tables.h"
#endif
#else
static uint32_t cbrt_tab[1 << 13];

static av_cold void AAC_RENAME(cbrt_tableinit)(void)
{
    if (!cbrt_tab[(1<<13) - 1]) {
        int i;
        /* cbrtf() isn't available on all systems, so we use powf(). */
        for (i = 0; i < 1<<13; i++) {
            union {
                float f;
                uint32_t i;
            } f;
            f.f = pow(i, 1.0 / 3.0) * i;
            cbrt_tab[i] = CBRT(f);
        }
    }
}
#endif /* CONFIG_HARDCODED_TABLES */

#endif /* AVCODEC_CBRT_TABLEGEN_H */
