/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSXMLHttpRequest.h"

#include "Document.h"
#include "Event.h"
#include "EventListener.h"
#include "JSDocument.h"
#include "JSEvent.h"
#include "JSEventListener.h"
#include "JSXMLHttpRequestUpload.h"
#include "KURL.h"
#include "RegisteredEventListener.h"
#include "XMLHttpRequest.h"
#include "XMLHttpRequestUpload.h"
#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSXMLHttpRequest);

/* Hash table */

static const HashTableValue JSXMLHttpRequestTableValues[14] =
{
    { "onabort", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestOnabort), (intptr_t)setJSXMLHttpRequestOnabort },
    { "onerror", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestOnerror), (intptr_t)setJSXMLHttpRequestOnerror },
    { "onload", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestOnload), (intptr_t)setJSXMLHttpRequestOnload },
    { "onloadstart", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestOnloadstart), (intptr_t)setJSXMLHttpRequestOnloadstart },
    { "onprogress", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestOnprogress), (intptr_t)setJSXMLHttpRequestOnprogress },
    { "onreadystatechange", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestOnreadystatechange), (intptr_t)setJSXMLHttpRequestOnreadystatechange },
    { "readyState", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestReadyState), (intptr_t)0 },
    { "withCredentials", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestWithCredentials), (intptr_t)setJSXMLHttpRequestWithCredentials },
    { "upload", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestUpload), (intptr_t)0 },
    { "responseText", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestResponseText), (intptr_t)0 },
    { "responseXML", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestResponseXML), (intptr_t)0 },
    { "status", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestStatus), (intptr_t)0 },
    { "statusText", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestStatusText), (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSXMLHttpRequestTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 127, JSXMLHttpRequestTableValues, 0 };
#else
    { 35, 31, JSXMLHttpRequestTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSXMLHttpRequestPrototypeTableValues[16] =
{
    { "UNSENT", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestUNSENT), (intptr_t)0 },
    { "OPENED", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestOPENED), (intptr_t)0 },
    { "HEADERS_RECEIVED", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestHEADERS_RECEIVED), (intptr_t)0 },
    { "LOADING", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestLOADING), (intptr_t)0 },
    { "DONE", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXMLHttpRequestDONE), (intptr_t)0 },
    { "open", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsXMLHttpRequestPrototypeFunctionOpen), (intptr_t)5 },
    { "setRequestHeader", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsXMLHttpRequestPrototypeFunctionSetRequestHeader), (intptr_t)2 },
    { "send", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsXMLHttpRequestPrototypeFunctionSend), (intptr_t)1 },
    { "abort", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsXMLHttpRequestPrototypeFunctionAbort), (intptr_t)0 },
    { "getAllResponseHeaders", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsXMLHttpRequestPrototypeFunctionGetAllResponseHeaders), (intptr_t)0 },
    { "getResponseHeader", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsXMLHttpRequestPrototypeFunctionGetResponseHeader), (intptr_t)1 },
    { "overrideMimeType", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsXMLHttpRequestPrototypeFunctionOverrideMimeType), (intptr_t)1 },
    { "addEventListener", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsXMLHttpRequestPrototypeFunctionAddEventListener), (intptr_t)3 },
    { "removeEventListener", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsXMLHttpRequestPrototypeFunctionRemoveEventListener), (intptr_t)3 },
    { "dispatchEvent", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsXMLHttpRequestPrototypeFunctionDispatchEvent), (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSXMLHttpRequestPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 1023, JSXMLHttpRequestPrototypeTableValues, 0 };
#else
    { 37, 31, JSXMLHttpRequestPrototypeTableValues, 0 };
#endif

static const HashTable* getJSXMLHttpRequestPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSXMLHttpRequestPrototypeTable);
}
const ClassInfo JSXMLHttpRequestPrototype::s_info = { "XMLHttpRequestPrototype", 0, 0, getJSXMLHttpRequestPrototypeTable };

JSObject* JSXMLHttpRequestPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSXMLHttpRequest>(exec, globalObject);
}

bool JSXMLHttpRequestPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSXMLHttpRequestPrototype, JSObject>(exec, getJSXMLHttpRequestPrototypeTable(exec), this, propertyName, slot);
}

bool JSXMLHttpRequestPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticPropertyDescriptor<JSXMLHttpRequestPrototype, JSObject>(exec, getJSXMLHttpRequestPrototypeTable(exec), this, propertyName, descriptor);
}

static const HashTable* getJSXMLHttpRequestTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSXMLHttpRequestTable);
}
const ClassInfo JSXMLHttpRequest::s_info = { "XMLHttpRequest", 0, 0, getJSXMLHttpRequestTable };

JSXMLHttpRequest::JSXMLHttpRequest(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<XMLHttpRequest> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSXMLHttpRequest::~JSXMLHttpRequest()
{
    impl()->invalidateJSEventListeners(this);
    forgetDOMObject(this, impl());
}

JSObject* JSXMLHttpRequest::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSXMLHttpRequestPrototype(JSXMLHttpRequestPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSXMLHttpRequest::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSXMLHttpRequest, Base>(exec, getJSXMLHttpRequestTable(exec), this, propertyName, slot);
}

bool JSXMLHttpRequest::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSXMLHttpRequest, Base>(exec, getJSXMLHttpRequestTable(exec), this, propertyName, descriptor);
}

JSValue jsXMLHttpRequestOnabort(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSXMLHttpRequest* castedThis = static_cast<JSXMLHttpRequest*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    XMLHttpRequest* imp = static_cast<XMLHttpRequest*>(castedThis->impl());
    if (EventListener* listener = imp->onabort()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsXMLHttpRequestOnerror(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSXMLHttpRequest* castedThis = static_cast<JSXMLHttpRequest*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    XMLHttpRequest* imp = static_cast<XMLHttpRequest*>(castedThis->impl());
    if (EventListener* listener = imp->onerror()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsXMLHttpRequestOnload(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSXMLHttpRequest* castedThis = static_cast<JSXMLHttpRequest*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    XMLHttpRequest* imp = static_cast<XMLHttpRequest*>(castedThis->impl());
    if (EventListener* listener = imp->onload()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsXMLHttpRequestOnloadstart(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSXMLHttpRequest* castedThis = static_cast<JSXMLHttpRequest*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    XMLHttpRequest* imp = static_cast<XMLHttpRequest*>(castedThis->impl());
    if (EventListener* listener = imp->onloadstart()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsXMLHttpRequestOnprogress(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSXMLHttpRequest* castedThis = static_cast<JSXMLHttpRequest*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    XMLHttpRequest* imp = static_cast<XMLHttpRequest*>(castedThis->impl());
    if (EventListener* listener = imp->onprogress()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsXMLHttpRequestOnreadystatechange(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSXMLHttpRequest* castedThis = static_cast<JSXMLHttpRequest*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    XMLHttpRequest* imp = static_cast<XMLHttpRequest*>(castedThis->impl());
    if (EventListener* listener = imp->onreadystatechange()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsXMLHttpRequestReadyState(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSXMLHttpRequest* castedThis = static_cast<JSXMLHttpRequest*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    XMLHttpRequest* imp = static_cast<XMLHttpRequest*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->readyState());
    return result;
}

JSValue jsXMLHttpRequestWithCredentials(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSXMLHttpRequest* castedThis = static_cast<JSXMLHttpRequest*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    XMLHttpRequest* imp = static_cast<XMLHttpRequest*>(castedThis->impl());
    JSValue result = jsBoolean(imp->withCredentials());
    return result;
}

JSValue jsXMLHttpRequestUpload(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSXMLHttpRequest* castedThis = static_cast<JSXMLHttpRequest*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    XMLHttpRequest* imp = static_cast<XMLHttpRequest*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->upload()));
    return result;
}

JSValue jsXMLHttpRequestResponseText(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSXMLHttpRequest* castedThis = static_cast<JSXMLHttpRequest*>(asObject(slotBase));
    return castedThis->responseText(exec);
}

JSValue jsXMLHttpRequestResponseXML(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSXMLHttpRequest* castedThis = static_cast<JSXMLHttpRequest*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    XMLHttpRequest* imp = static_cast<XMLHttpRequest*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->responseXML()));
    return result;
}

JSValue jsXMLHttpRequestStatus(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSXMLHttpRequest* castedThis = static_cast<JSXMLHttpRequest*>(asObject(slotBase));
    ExceptionCode ec = 0;
    XMLHttpRequest* imp = static_cast<XMLHttpRequest*>(castedThis->impl());
    JSC::JSValue result = jsNumber(exec, imp->status(ec));
    setDOMException(exec, ec);
    return result;
}

JSValue jsXMLHttpRequestStatusText(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSXMLHttpRequest* castedThis = static_cast<JSXMLHttpRequest*>(asObject(slotBase));
    ExceptionCode ec = 0;
    XMLHttpRequest* imp = static_cast<XMLHttpRequest*>(castedThis->impl());
    JSC::JSValue result = jsString(exec, imp->statusText(ec));
    setDOMException(exec, ec);
    return result;
}

void JSXMLHttpRequest::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSXMLHttpRequest, Base>(exec, propertyName, value, getJSXMLHttpRequestTable(exec), this, slot);
}

void setJSXMLHttpRequestOnabort(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    XMLHttpRequest* imp = static_cast<XMLHttpRequest*>(static_cast<JSXMLHttpRequest*>(thisObject)->impl());
    imp->setOnabort(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSXMLHttpRequestOnerror(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    XMLHttpRequest* imp = static_cast<XMLHttpRequest*>(static_cast<JSXMLHttpRequest*>(thisObject)->impl());
    imp->setOnerror(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSXMLHttpRequestOnload(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    XMLHttpRequest* imp = static_cast<XMLHttpRequest*>(static_cast<JSXMLHttpRequest*>(thisObject)->impl());
    imp->setOnload(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSXMLHttpRequestOnloadstart(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    XMLHttpRequest* imp = static_cast<XMLHttpRequest*>(static_cast<JSXMLHttpRequest*>(thisObject)->impl());
    imp->setOnloadstart(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSXMLHttpRequestOnprogress(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    XMLHttpRequest* imp = static_cast<XMLHttpRequest*>(static_cast<JSXMLHttpRequest*>(thisObject)->impl());
    imp->setOnprogress(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSXMLHttpRequestOnreadystatechange(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    XMLHttpRequest* imp = static_cast<XMLHttpRequest*>(static_cast<JSXMLHttpRequest*>(thisObject)->impl());
    imp->setOnreadystatechange(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSXMLHttpRequestWithCredentials(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSXMLHttpRequest* castedThisObj = static_cast<JSXMLHttpRequest*>(thisObject);
    XMLHttpRequest* imp = static_cast<XMLHttpRequest*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    imp->setWithCredentials(value.toBoolean(exec), ec);
    setDOMException(exec, ec);
}

JSValue JSC_HOST_CALL jsXMLHttpRequestPrototypeFunctionOpen(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSXMLHttpRequest::s_info))
        return throwError(exec, TypeError);
    JSXMLHttpRequest* castedThisObj = static_cast<JSXMLHttpRequest*>(asObject(thisValue));
    return castedThisObj->open(exec, args);
}

JSValue JSC_HOST_CALL jsXMLHttpRequestPrototypeFunctionSetRequestHeader(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSXMLHttpRequest::s_info))
        return throwError(exec, TypeError);
    JSXMLHttpRequest* castedThisObj = static_cast<JSXMLHttpRequest*>(asObject(thisValue));
    return castedThisObj->setRequestHeader(exec, args);
}

JSValue JSC_HOST_CALL jsXMLHttpRequestPrototypeFunctionSend(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSXMLHttpRequest::s_info))
        return throwError(exec, TypeError);
    JSXMLHttpRequest* castedThisObj = static_cast<JSXMLHttpRequest*>(asObject(thisValue));
    return castedThisObj->send(exec, args);
}

JSValue JSC_HOST_CALL jsXMLHttpRequestPrototypeFunctionAbort(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSXMLHttpRequest::s_info))
        return throwError(exec, TypeError);
    JSXMLHttpRequest* castedThisObj = static_cast<JSXMLHttpRequest*>(asObject(thisValue));
    XMLHttpRequest* imp = static_cast<XMLHttpRequest*>(castedThisObj->impl());

    imp->abort();
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsXMLHttpRequestPrototypeFunctionGetAllResponseHeaders(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSXMLHttpRequest::s_info))
        return throwError(exec, TypeError);
    JSXMLHttpRequest* castedThisObj = static_cast<JSXMLHttpRequest*>(asObject(thisValue));
    XMLHttpRequest* imp = static_cast<XMLHttpRequest*>(castedThisObj->impl());
    ExceptionCode ec = 0;


    JSC::JSValue result = jsStringOrUndefined(exec, imp->getAllResponseHeaders(ec));
    setDOMException(exec, ec);
    return result;
}

JSValue JSC_HOST_CALL jsXMLHttpRequestPrototypeFunctionGetResponseHeader(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSXMLHttpRequest::s_info))
        return throwError(exec, TypeError);
    JSXMLHttpRequest* castedThisObj = static_cast<JSXMLHttpRequest*>(asObject(thisValue));
    return castedThisObj->getResponseHeader(exec, args);
}

JSValue JSC_HOST_CALL jsXMLHttpRequestPrototypeFunctionOverrideMimeType(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSXMLHttpRequest::s_info))
        return throwError(exec, TypeError);
    JSXMLHttpRequest* castedThisObj = static_cast<JSXMLHttpRequest*>(asObject(thisValue));
    return castedThisObj->overrideMimeType(exec, args);
}

JSValue JSC_HOST_CALL jsXMLHttpRequestPrototypeFunctionAddEventListener(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSXMLHttpRequest::s_info))
        return throwError(exec, TypeError);
    JSXMLHttpRequest* castedThisObj = static_cast<JSXMLHttpRequest*>(asObject(thisValue));
    return castedThisObj->addEventListener(exec, args);
}

JSValue JSC_HOST_CALL jsXMLHttpRequestPrototypeFunctionRemoveEventListener(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSXMLHttpRequest::s_info))
        return throwError(exec, TypeError);
    JSXMLHttpRequest* castedThisObj = static_cast<JSXMLHttpRequest*>(asObject(thisValue));
    return castedThisObj->removeEventListener(exec, args);
}

JSValue JSC_HOST_CALL jsXMLHttpRequestPrototypeFunctionDispatchEvent(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSXMLHttpRequest::s_info))
        return throwError(exec, TypeError);
    JSXMLHttpRequest* castedThisObj = static_cast<JSXMLHttpRequest*>(asObject(thisValue));
    XMLHttpRequest* imp = static_cast<XMLHttpRequest*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Event* evt = toEvent(args.at(0));


    JSC::JSValue result = jsBoolean(imp->dispatchEvent(evt, ec));
    setDOMException(exec, ec);
    return result;
}

// Constant getters

JSValue jsXMLHttpRequestUNSENT(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(0));
}

JSValue jsXMLHttpRequestOPENED(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(1));
}

JSValue jsXMLHttpRequestHEADERS_RECEIVED(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(2));
}

JSValue jsXMLHttpRequestLOADING(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(3));
}

JSValue jsXMLHttpRequestDONE(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(4));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, XMLHttpRequest* object)
{
    return getDOMObjectWrapper<JSXMLHttpRequest>(exec, globalObject, object);
}
XMLHttpRequest* toXMLHttpRequest(JSC::JSValue value)
{
    return value.inherits(&JSXMLHttpRequest::s_info) ? static_cast<JSXMLHttpRequest*>(asObject(value))->impl() : 0;
}

}
