/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

function initMenus()
{    
    function onMenuCommand (event, window)
    {
        var params;
        var commandName = event.originalTarget.getAttribute("commandname");
        if ("cx" in console.menuManager && console.menuManager.cx)
        {
            console.menuManager.cx.sourceWindow = window;
            params = console.menuManager.cx;
        }
        else
        {
            params = { sourceWindow: window };
        }
            
        dispatch (commandName, params);

        delete console.menuManager.cx;
    };
    
    console.onMenuCommand = onMenuCommand;
    console.menuSpecs = new Object();
    var menuManager = 
        console.menuManager = new MenuManager(console.commandManager,
                                              console.menuSpecs,
                                              getCommandContext,
                                              "console.onMenuCommand(event, " +
                                              "window);");

    console.menuSpecs["maintoolbar"] = {
        items:
        [
         ["stop"],
         ["-"],
         ["cont"],
         ["next"],
         ["step"],
         ["finish"],
         ["-"],
         ["profile-tb"],
         ["toggle-pprint"]
        ]
    };

    console.menuSpecs["mainmenu:file"] = {
        label: MSG_MNU_FILE,
        accesskey: getAccessKeyForMenu('MSG_MNU_FILE'),
        items:
        [
         ["open-url"],
         ["find-file"],
         ["close-source-tab",
                 {enabledif: "console.views.source2.currentContent && " +
                             "console.views.source2.sourceTabList.length"}],
         ["close"],
         ["-"],
         ["save-source-tab", { enabledif: "console.views.source2.canSave()" }],
         ["save-profile"],
         ["-"],
         ["save-settings"],
         ["restore-settings"],
         ["toggle-save-settings",
                 {type: "checkbox",
                  checkedif: "console.prefs['saveSettingsOnExit']"}],
         ["-"],
         [navigator.platform.search(/win/i) == -1 ? "quit" : "exit"]
        ]
    };

    var Mozilla = "(console.host == 'Mozilla')";

    console.menuSpecs["mainmenu:edit"] = {
        label: MSG_MNU_EDIT,
        accesskey: getAccessKeyForMenu('MSG_MNU_EDIT'),
        items:
        [
         ["cmd-undo",      {enabledif: "getCommandEnabled('cmd_undo')"}],
         ["cmd-redo",      {enabledif: "getCommandEnabled('cmd_redo')"}],
         ["-"],
         ["cmd-cut",       {enabledif: "getCommandEnabled('cmd_cut')"}],
         ["cmd-copy",      {enabledif: "getCommandEnabled('cmd_copy')"}],
         ["cmd-paste",     {enabledif: "getCommandEnabled('cmd_paste')"}],
         ["cmd-delete",    {enabledif: "getCommandEnabled('cmd_delete')"}],
         ["-"],
         ["cmd-selectall", {enabledif: "getCommandEnabled('cmd_selectAll')"}],
         ["-",                 {visibleif: Mozilla}],
         ["cmd-mozilla-prefs", {visibleif: Mozilla}]
        ]
    };

    console.menuSpecs["mainmenu:view"] = {
        label: MSG_MNU_VIEW,
        accesskey: getAccessKeyForMenu('MSG_MNU_VIEW'),
        items:
        [
         [">popup:showhide"],
         ["-"],
         ["reload-source-tab"],
         ["toggle-source-coloring",
                 {type: "checkbox",
                  checkedif: "console.prefs['services.source.colorize']"} ],
         ["toggle-pprint",
                 {type: "checkbox",
                  checkedif: "console.prefs['prettyprint']"}],
         ["-"],
         ["clear-session"],
         [">session:colors"],
         ["-"],
         ["save-default-layout"],
         ["toggle-save-layout",
                 {type: "checkbox",
                  checkedif: "console.prefs['saveLayoutOnExit']"}]
        ]
    };
    
    console.menuSpecs["mainmenu:debug"] = {
        label: MSG_MNU_DEBUG,
        accesskey: getAccessKeyForMenu('MSG_MNU_DEBUG'),
        items:
        [
         ["stop",
                 {type: "checkbox",
                  checkedif: "console.jsds.interruptHook"}],
         ["cont"],
         ["next"],
         ["step"],
         ["finish"],
         ["-"],
         [">popup:emode"],
         [">popup:tmode"],
         ["-"],
         ["toggle-chrome",
                 {type: "checkbox",
                  checkedif: "console.prefs['enableChromeFilter']"}]
         /*
         ["toggle-ias",
                 {type: "checkbox",
                  checkedif: "console.jsds.initAtStartup"}]
         */
        ]
    };

    console.menuSpecs["mainmenu:profile"] = {
        label: MSG_MNU_PROFILE,
        accesskey: getAccessKeyForMenu('MSG_MNU_PROFILE'),
        items:
        [
         ["toggle-profile",
                 {type: "checkbox",
                  checkedif: "console.jsds.flags & COLLECT_PROFILE_DATA"}],
         ["toggle-forcescriptload",
                 {type: "checkbox",
                  checkedif: "console.prefs['profile.forceScriptLoad']"}],
         ["-"],
         ["clear-profile"],
         ["save-profile"],
         ["show-profile"]
        ]
    };

    /* Mac expects a help menu with this ID, and there is nothing we can do
     * about it. */
    console.menuSpecs["mainmenu:help"] = {
        label: MSG_MNU_HELP,
        accesskey: getAccessKeyForMenu('MSG_MNU_HELP'),
        domID: "menu_Help",
        items:
        [
         ["version"],
         ["-"],
         ["help"]
        ]
    };
    
    console.menuSpecs["popup:emode"] = {
        label: MSG_MNU_EMODE,
        accesskey: getAccessKeyForMenu('MSG_MNU_EMODE'),
        items:
        [
         ["em-ignore",
                 {type: "radio", name: "em",
                  checkedif: "console.errorMode == EMODE_IGNORE"}],
         ["em-trace",
                 {type: "radio", name: "em",
                  checkedif: "console.errorMode == EMODE_TRACE"}],
         ["em-break",
                 {type: "radio", name: "em",
                  checkedif: "console.errorMode == EMODE_BREAK"}]
        ]
    };
    
    console.menuSpecs["popup:tmode"] = {
        label: MSG_MNU_TMODE,
        accesskey: getAccessKeyForMenu('MSG_MNU_TMODE'),
        items:
        [
         ["tm-ignore",
                 {type: "radio", name: "tm",
                  checkedif: "console.throwMode == TMODE_IGNORE"}],
         ["tm-trace",
                 {type: "radio", name: "tm",
                  checkedif: "console.throwMode == TMODE_TRACE"}],
         ["tm-break",
                 {type: "radio", name: "tm",
                  checkedif: "console.throwMode == TMODE_BREAK"}]
        ]
    };

    console.menuSpecs["popup:showhide"] = {
        label: MSG_MNU_SHOWHIDE,
        accesskey: getAccessKeyForMenu('MSG_MNU_SHOWHIDE'),
        items: [ /* filled by initViews() */ ]
    };
}

console.createMainMenu = createMainMenu;
function createMainMenu(document)
{
    var mainmenu = document.getElementById("mainmenu");
    var menuManager = console.menuManager;
    for (var id in console.menuSpecs)
    {
        var domID;
        if ("domID" in console.menuSpecs[id])
            domID = console.menuSpecs[id].domID;
        else
            domID = id;
        
        if (id.indexOf("mainmenu:") == 0)
            menuManager.createMenu (mainmenu, null, id, domID);
    }

    mainmenu.removeAttribute ("collapsed");
    var toolbox = document.getElementById("main-toolbox");
    toolbox.removeAttribute ("collapsed");
}

console.createMainToolbar = createMainToolbar;
function createMainToolbar(document)
{
    var maintoolbar = document.getElementById("maintoolbar");
    var menuManager = console.menuManager;
    var spec = console.menuSpecs["maintoolbar"];
    for (var i in spec.items)
    {
        menuManager.appendToolbarItem (maintoolbar, null, spec.items[i][0]);
    }

    maintoolbar = document.getElementById("maintoolbar-outer");
    maintoolbar.removeAttribute ("collapsed");
    maintoolbar.className = "toolbar-primary chromeclass-toolbar";
    var toolbox = document.getElementById("main-toolbox");
    toolbox.removeAttribute ("collapsed");
}

function getCommandContext (id, event)
{
    var cx = { originalEvent: event };
    
    if (id in console.menuSpecs)
    {
        if ("getContext" in console.menuSpecs[id])
            cx = console.menuSpecs[id].getContext(cx);
        else if ("cx" in console.menuManager) 
        {
            //dd ("using existing context");
            cx = console.menuManager.cx;
        }
        else
        {
            //dd ("no context at all");
        }
    }
    else
    {
        dd ("getCommandContext: unknown menu id " + id);
    }

    if (typeof cx == "object")
    {
        if (!("menuManager" in cx))
            cx.menuManager = console.menuManager;
        if (!("contextSource" in cx))
            cx.contextSource = id;
        if ("dbgContexts" in console && console.dbgContexts)
            dd ("context '" + id + "'\n" + dumpObjectTree(cx));
    }

    return cx;
}

/**
 * Gets an accesskey for the menu with label string ID labelString.
 * At first, we attempt to extract it from the label string, otherwise
 * we fall back to using a separate string.
 *
 * @param labelString   the id for the locale string corresponding to the label
 * @return              the accesskey for the menu.
 */
function getAccessKeyForMenu(labelString)
{
    var rv = getAccessKey(window[labelString]);
    if (!rv)
        rv = window[labelString + "_ACCESSKEY"] || "";
    return rv;
}


