/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

var dialog = new Object();
var breakpoint;

function onLoad()
{
    function cacheElement(id)
    {
        dialog[id] = document.getElementById(id);
    };
    
    breakpoint = window.arguments[0];
    cacheElement("url-textbox");
    cacheElement("line-textbox");
    cacheElement("function-textbox");
    cacheElement("pc-textbox");
    cacheElement("condition-checkbox");
    cacheElement("trigger-textbox");
    cacheElement("enabled-checkbox");
    cacheElement("onetime-checkbox");
    cacheElement("condition-textbox");
    cacheElement("result-radio");
    cacheElement("exception-checkbox");
    cacheElement("log-checkbox");

    cacheElement("apply-button");
    cacheElement("revert-button");
    cacheElement("close-button");
    
    populateFromBreakpoint();
}

function onUnload()
{
    delete breakpoint.propsWindow;
}

function onBreakpointTriggered()
{
    dialog["trigger-textbox"].value = breakpoint.triggerCount;
}

function onConditionKeyPress(event)
{
    if (event.keyCode == 9)
    {
        opener.dd(dialog["condition-textbox"].selectionStart);
        event.preventDefault();
    }
}

function populateFromBreakpoint()
{
    dialog["url-textbox"].value = breakpoint.url;
    dialog["line-textbox"].value = breakpoint.lineNumber;

    dialog["condition-checkbox"].checked = breakpoint.conditionEnabled;
    if ("scriptWrapper" in breakpoint)
    {
        document.title = opener.MSG_BPPROPS_TITLE;
        dialog["enabled-checkbox"].setAttribute("label",
                                                opener.MSG_BPPROPS_ENABLED);
        dialog["function-textbox"].value = breakpoint.scriptWrapper.functionName;
        dialog["pc-textbox"].value = breakpoint.pc;
        dialog["onetime-checkbox"].checked = breakpoint.oneTime;
        dialog["trigger-textbox"].value = breakpoint.triggerCount;
    }
    else
    {
        document.title = opener.MSG_FBPPROPS_TITLE;
        dialog["enabled-checkbox"].setAttribute("label",
                                                opener.MSG_FBPPROPS_ENABLED);
        dialog["function-textbox"].value = opener.MSG_VAL_NA;
        dialog["pc-textbox"].value = opener.MSG_VAL_NONE;
        dialog["onetime-checkbox"].disabled = true;
        dialog["trigger-textbox"].disabled = true;
    }

    dialog["enabled-checkbox"].checked = breakpoint.enabled;
    dialog["condition-textbox"].value = breakpoint.condition;
    dialog["result-radio"].selectedItem =
        dialog["result-radio"].childNodes[breakpoint.resultAction];
    dialog["exception-checkbox"].checked = breakpoint.passExceptions;
    dialog["log-checkbox"].checked = breakpoint.logResult;
    updateConditionGroup();
    makeClean();
}

function copyToBreakpoint()
{
    breakpoint.conditionEnabled = dialog["condition-checkbox"].checked;
    if ("scriptWrapper" in breakpoint)
    {
        breakpoint.oneTime = dialog["onetime-checkbox"].checked;
        breakpoint.triggerCount = dialog["trigger-textbox"].value;
    }

    breakpoint.enabled = dialog["enabled-checkbox"].checked;
    for (var i = 0; i < 4; ++i)
    {
        if (dialog["result-radio"].childNodes[i] ==
            dialog["result-radio"].selectedItem)
        {
            breakpoint.resultAction = i;
            break;
        }
    }
    breakpoint.condition = dialog["condition-textbox"].value;
    breakpoint.passExceptions = dialog["exception-checkbox"].checked;
    breakpoint.logResult = dialog["log-checkbox"].checked;
    makeClean();
}

function updateConditionGroup()
{
    function ableNode (node)
    {
        node.disabled = !state;
        if (node.childNodes.length > 0)
        {
            for (var i = 0; i < node.childNodes.length; ++i)
                ableNode(node.childNodes[i]);
        }
    };

    var state = dialog["condition-checkbox"].checked;

    var kid = dialog["condition-checkbox"].parentNode.nextSibling;
    
    while (kid)
    {
        ableNode(kid);
        kid = kid.nextSibling;
    }
}

function makeDirty()
{
    dialog["apply-button"].disabled  = false;
    dialog["revert-button"].disabled = false;
    dialog["close-button"].disabled  = true;
}

function makeClean()
{
    dialog["apply-button"].disabled  = true;
    dialog["revert-button"].disabled = true;
    dialog["close-button"].disabled  = false;
}

    
    
